;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Globalize/new-body.scm       */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Jan 30 09:25:08 1995                          */
;*    Last change :  Fri Mar 22 15:47:18 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    For each globalized function, we set its new body.               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_new-body
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    tools_speek
	    globalize_ast
	    type_cache
	    ast_sexp
	    ast_dump
	    ast_global
	    ast_local)
   (export  (set-globalized-new-bodies! <global> <local>*)))

;*---------------------------------------------------------------------*/
;*    set-globalized-new-bodies! ...                                   */
;*---------------------------------------------------------------------*/
(define (set-globalized-new-bodies! global locals)
   (set! *round* (+fx *round* 1))
   ;; we remove globalized or integrated functions from global
   (let ((fun (global-value global)))
      (function-body-set! fun (remove-globalized-fun! (function-body fun)
                                                      global
						      global)))
   ;; then we compute the globalized functions bodies
   (for-each set-globalized-new-body! locals))

;*---------------------------------------------------------------------*/
;*    set-globalized-new-body! ...                                     */
;*---------------------------------------------------------------------*/
(define (set-globalized-new-body! local)
   (trace (globalize loop) "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
	  #\Newline 
	  "set-globalized-new-body!: " (shape local)
	  #\Newline)
   (set! *round* (+fx *round* 1))
   ;; we remove globalized or integrated functions from local
   (let* ((fun       (local-value local))
	  (info      (local-info local))
	  (old-body  (function-body fun))
	  (obindings (fun-Ginfo-integrated info))
	  (new-body  (remove-globalized-fun! old-body local local)))
      ;; then, we scan all the integrate functions in order to
      ;; remove nested functions in added functions
      ;; (same problem as in integrate_let-fun)
      (for-each (lambda (f)
		   (trace (globalize loop) "scanning: " (shape f) #\Newline)
		   (if (not (=fx (fun-Ginfo-bmark (local-info f)) *round*))
		       (let* ((fun  (local-value f))
			      (body (function-body fun)))
			  (function-body-set! fun
					      (remove-globalized-fun!
					       body
					       local
					       f)))))
		obindings)
      ;; and we peek really integrated functions.
      (let ((nbindings (let loop ((nbdings '())
				  (obdings obindings))
			  (cond
			     ((null? obdings)
			      nbdings)
			     ((=fx (fun-Ginfo-bmark (local-info (car obdings)))
				   *round*)
			      ;; this function _is_ already in local
			      (loop nbdings (cdr obdings)))
			     (else
			      (loop (cons (car obdings) nbdings)
				    (cdr obdings)))))))
	 (let ((new2-body  (if (null? nbindings)
			       new-body
			       (ast-let-fun (ast-location old-body)
					    #f
					    #f
					    nbindings
					    new-body))))
	    ;; during the computation of the captured variable, we will compute
	    ;; the set of free variables from the new-body but, we have to
	    ;; ajust the field `cto' of local.
	    (let loop ((ncto      (fun-Ginfo-cto info))
		       (nbindings nbindings))
	       (if (null? nbindings)
		   (fun-Ginfo-cto-set! info ncto)
		   (let liip ((ncto ncto)
			      (lcto (fun-Ginfo-cto (local-info
						    (car nbindings)))))
		      (cond
			 ((null? lcto)
			  (loop ncto (cdr nbindings)))
			 ((memq (car lcto) ncto)
			  (liip ncto (cdr lcto)))
			 (else
			  (liip (cons (car lcto) ncto) (cdr lcto)))))))
	    (trace (loop globalize) "new-body( " (local-shape local) " ): "
		   (ast->sexp new2-body)
		   #\Newline
		   "     obindings: " (shape obindings)
		   #\Newline
		   "     nbindings: " (shape nbindings)
		   #\Newline
		   "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~"
		   #\Newline
		   #\Newline)
	  (fun-Ginfo-new-body-set! info new2-body)))))

;*---------------------------------------------------------------------*/
;*    is-in? ...                                                       */
;*    -------------------------------------------------------------    */
;*    Is f1 in the body of f2 ?                                        */
;*---------------------------------------------------------------------*/
(define (is-in? f1 f2)
   (let ((info (local-info f1)))
      (cond
	 ((fun-Ginfo-G? info)
	  #f)
	 ((not (local? (fun-Ginfo-integrator info)))
	  #t)
	 ((eq? (fun-Ginfo-integrator info) f2)
	  #t)
	 (else
	  #f))))

;*---------------------------------------------------------------------*/
;*    *round* ...                                                      */
;*---------------------------------------------------------------------*/
(define *round* 0)

;*---------------------------------------------------------------------*/
;*    remove-globalized-fun! ...                                       */
;*    -------------------------------------------------------------    */
;*    We walk across <ast> to remove local definitions which           */
;*    are globalized or integrated into another function.              */
;*---------------------------------------------------------------------*/
(define (remove-globalized-fun! ast owner current)
   (trace (globalize loop) "remove-globalized-fun!: [" (shape owner) "] "
	  (ast->sexp ast)
	  #\Newline)
   (let loop ((ast     ast)
	      (current current))
      (trace (globalize other loop)
	     "[remove-globalized-fun!: [" (shape owner) "]] "
	     (ast->sexp ast)
	     #\Newline)
      (ast-case ast
	 ((atom)
	  ast)
	 ((kwote)
	  ast)
	 ((var)
	  ast)
	 ((make-box)
	  (make-box-value-set! ast (loop (make-box-value ast) current))
	  ast)
	 ((box-ref)
	  (box-ref-var-set! ast (loop (box-ref-var ast) current))
	  ast)
	 ((box-set!)
	  (box-set!-var-set! ast (loop (box-set!-var ast) current))
	  (box-set!-value-set! ast (loop (box-set!-value ast) current))
	  ast)
	 ((fun)
	  ast)
	 ((prag-ma)
	  (let liip ((values (prag-ma-values ast)))
	     (if (null? values)
		 ast
		 (begin
		    (set-car! values (loop (car values) current))
		    (liip (cdr values))))))
	 ((fail)
	  (fail-proc-set! ast (loop (fail-proc ast) current))
	  (fail-msg-set! ast (loop (fail-msg ast) current))
	  (fail-obj-set! ast (loop (fail-obj ast) current))
	  ast)
	 ((sequence)
	  (let liip ((sexp (sequence-exp ast)))
	     (if (null? sexp)
		 ast
		 (begin
		    (set-car! sexp (loop (car sexp) current))
		    (liip (cdr sexp))))))
	 ((conditional)
	  (conditional-test-set! ast (loop (conditional-test ast) current))
	  (conditional-then-set! ast (loop (conditional-then ast) current))
	  (conditional-else-set! ast (loop (conditional-else ast) current))
	  ast)
	 ((setq)
	  (setq-val-set! ast (loop (setq-val ast) current))
	  ast)
	 ((let-var)
	  (let-var-body-set! ast (loop (let-var-body ast) current))
	  (for-each (lambda (binding)
		       (set-cdr! binding (loop (cdr binding) current)))
		    (let-var-bindings ast))
	  ast)
	 ((let-fun)
	  (let-fun-body-set! ast (loop (let-fun-body ast) current))
	  (let liip ((obindings (let-fun-locals ast))
		     (nbindings '()))
	     (cond
		((null? obindings)
		 (let-fun-locals-set! ast nbindings)
		 ast)
		((=fx (fun-Ginfo-bmark (local-info (car obindings))) *round*)
		 (trace (globalize loop) " ### already: "
			(shape (car obindings)) #\Newline
			"    plugged: " (shape (fun-Ginfo-plugged-in
						(local-info (car obindings))))
			"    current: " (shape current)
			#\Newline)
		 (if (eq? current
			  (fun-Ginfo-plugged-in (local-info (car obindings))))
		     ;; ok, we keep this function
		     (liip (cdr obindings) (cons (car obindings) nbindings))
		     ;; this function is already in host
		     (liip (cdr obindings)
			   nbindings)))
		((is-in? (car obindings) owner)
		 (trace (globalize loop) " ### is-in?: "
			(shape (car obindings))
			"  [current: " (shape current) "]"
			#\Newline)
		 ;; we mark that the function is definied
		 (fun-Ginfo-bmark-set! (local-info (car obindings)) *round*)
		 ;; we plug the function
		 (fun-Ginfo-plugged-in-set! (local-info (car obindings))
					    current)
		 (let* ((fun  (local-value (car obindings)))
			(body (function-body fun)))
		    (function-body-set! fun (loop body (car obindings)))
		    (liip (cdr obindings)
			  (cons (car obindings) nbindings))))
		((function-escape? (local-value (car obindings)))
		 (trace (globalize loop) " ### escaping: " 
			(shape (car obindings)) #\Newline)
		 ;; we don't remove now the escaping functions
		 (liip (cdr obindings)
		       (cons (car obindings) nbindings)))
		(else
		 (trace (globalize loop) " ### removing:"
			(shape (car obindings)) #\Newline)
		 (liip (cdr obindings)
		       nbindings)))))
	 ((set-ex-it)
	  (set-ex-it-body-set! ast (loop (set-ex-it-body ast) current))
	  ast)
	 ((jump-ex-it)
	  (jump-ex-it-exit-set! ast (loop (jump-ex-it-exit ast) current))
	  (jump-ex-it-value-set! ast (loop (jump-ex-it-value ast) current))
	  ast)
	 ((funcall)
	  (funcall-fun-set! ast (loop (funcall-fun ast) current))
	  (let liip ((asts (funcall-actuals ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts) current))
		    (liip (cdr asts))))))
	 ((app-ly)
	  (app-ly-fun-set! ast (loop (app-ly-fun ast) current))
	  (app-ly-value-set! ast (loop (app-ly-value ast) current))
	  ast)
	 ((app)
	  (let liip ((asts (app-actuals ast)))
	     (if (null? asts)
		 ast
		 (begin
		    (set-car! asts (loop (car asts) current))
		    (liip (cdr asts))))))
	 ((switch)
	  (switch-test-set! ast (loop (switch-test ast) current))
	  (for-each (lambda (clause)
		       (set-cdr! clause (loop (cdr clause) current)))
		    (switch-clauses ast))
	  ast))))


    
      


