;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    .../prgm/project/bigloo/comptime1.8/Globalize/globalize.scm      */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Jan 26 14:45:58 1995                          */
;*    Last change :  Fri Mar 22 15:46:51 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `globalization' process                                      */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module globalize_globalize
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Globalize/globalize.sch")
   (import  tools_shape
	    tools_speek
	    ast_global
	    ast_local
	    ast_dump
	    globalize_ast
	    globalize_free
	    globalize_kapture
	    globalize_gn
	    globalize_integration
	    globalize_new-body
	    globalize_local->global
	    globalize_global-closure)
   (export  (globalize! ast)
	    *E*
	    *G0*
	    *G1*))

;*---------------------------------------------------------------------*/
;*    The global pass registers                                        */
;*---------------------------------------------------------------------*/
(define *E*  '())
(define *G0* '())
(define *G1* '())

;*---------------------------------------------------------------------*/
;*    globalize! ...                                                   */
;*---------------------------------------------------------------------*/
(define (globalize! global)
   (trace globalize
	  #\Newline
	  "========================================" #\newline
	  (global-shape global) " "
	  (if (function-escape? (global-value global))
	      "[escaping]"
	      "[non escaping]")
	  #\Newline
	  "----------------------------------------" #\newline
	  #\Newline)
   (verbose 2 "        " (global-shape global) " : " #\Newline)
   (let ((fun  (global-value global)))
      (set! *E*  '())
      (set! *G0* '())
      (set! *G1* '())
      (Gn! (function-args fun) (function-body fun) global '())
      (trace globalize
	     "   E  : " (shape *E*)
	     #\Newline
	     "   G0 : " (shape *G0*)
	     #\Newline
	     "   G1 : " (shape *G1*)
	     #\Newline)
      ;; we compute the integration property
      (set-integration!)
      ;; we computed the really globalised functions.
      (let ((G (let loop ((G1 *G1*)
			  (G  *E*))
		  (cond
		     ((null? G1)
		      (trace globalize "   G  : " (shape G) #\Newline)
		      G)
		     ((local? (fun-Ginfo-integrator (local-info (car G1))))
		      (loop (cdr G1) G))
		     (else
		      (loop (cdr G1) (cons (car G1) G)))))))
	 ;; we print the globalization result
	 (verb-globalization)
	 ;; for each globalized function, we computed its new body
	 (set-globalized-new-bodies! global G)
	 ;; for each globalized function, we computes its set of
	 ;; kaptured variables.
	 (set-kaptured! G)
	 ;; then, we compute new global definitions
	 (let loop ((G     G)
		    (new-G (if (function-escape? fun)
			       (list (global-closure global
						     (ast-location
						      (function-body fun)))
				     global)
			       (list global))))
	    (if (null? G)
		;; we still have, to globalize the global function
		(let* ((body  (ast-globalize! (function-body fun)
					      global
					      '())))
		   (function-body-set! fun body)
		   (trace globalize #a012 #\Newline)
		   new-G)
		(loop (cdr G)
		      (cons (local->global (car G)) new-G)))))))

;*---------------------------------------------------------------------*/
;*    verb-globalization ...                                           */
;*---------------------------------------------------------------------*/
(define (verb-globalization)
   (for-each (lambda (local)
		(verbose 2 "           "
			 (local-shape local) " ==>"
			 #\Newline))
	     *E*)
   (for-each (lambda (local)
		(if (local? (fun-Ginfo-integrator (local-info local)))
		    (verbose 2 "           "
			     (local-shape local)
			     " --> "
			     (local-shape
			      (fun-Ginfo-integrator (local-info local)))
			     #\Newline)
		    (verbose 2 "           "
			     (local-shape local) " -->"
			       #\Newline)))
	     *G1*))
