;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Expand/eps.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 14:56:58 1994                          */
;*    Last change :  Wed Nov  1 16:42:09 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The macro expanser taken from:                                   */
;*    << Expansion-Passing Style: Beyond Conventional Macro >>,        */
;*    Dybvig, Friedman & Haynes  -- ACM 1986 (LFP) page 143            */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module expand_eps
   (include "Expand/expander.sch"
	    "Tools/trace.sch"
	    "Tools/pass.sch"
	    "Ast/ast.sch")
   (import  tools_speek
	    tools_error
	    tools_progn
	    ast_env
	    expand_expander)
   (export  (with-lexical          <symbol> <thunk>)
	    (add-macro-definition! <s-exp>)
	    (comptime-expand       <s-exp>)
	    (comptime-expand-once  <s-exp>)
	    (expand-code           <s-exp>*)))

;*---------------------------------------------------------------------*/
;*    The user macro list.                                             */
;*---------------------------------------------------------------------*/
(define *macro* '())

;*---------------------------------------------------------------------*/
;*    add-macro! ...                                                   */
;*---------------------------------------------------------------------*/
(define (add-macro-definition! form)
   (set! *macro* (cons form *macro*)))

;*---------------------------------------------------------------------*/
;*    *lexical-stack* ...                                              */
;*    -------------------------------------------------------------    */
;*    This global variable allow us to simulate a stack to know        */
;*    when a variable `over-define' a `O-macro'. It is not so          */
;*    beautiful as a extra parameter to `expand' but it is             */
;*    easier to implement.                                             */
;*---------------------------------------------------------------------*/
(define *lexical-stack* '())

;*---------------------------------------------------------------------*/
;*    with-lexical ...                                                 */
;*---------------------------------------------------------------------*/
(define (with-lexical new thunk)
   (let ((old-lexical-stack *lexical-stack*))
      (set! *lexical-stack* (append new *lexical-stack*))
      (let ((res (thunk)))
	 (set! *lexical-stack* old-lexical-stack)
	 res)))
    
;*---------------------------------------------------------------------*/
;*    expand-code ...                                                  */
;*    -------------------------------------------------------------    */
;*    We expand the user code *and* the body of inline imported        */
;*    functions.                                                       */
;*---------------------------------------------------------------------*/
(define (expand-code schemes)
   (pass-prelude "Expand")
   ;; We set all macros definitions seen in include files.
   (for-each comptime-expand (reverse! *macro*))
   ;; imported inlined functions which are not coming from library
   ;; have to be expanded. It is not obliged to perform macro-expansion
   ;; on library functions because they have alredy been expanded.
   (define handler (lambda (escape proc mes obj)
		      (user-error proc mes obj ''())))
   (for-each-global!
    (lambda (var)
       (if (and (eq?              (global-class var)  'procedure)
		(eq?              (global-import var) 'import)
		(null?            (global-library? var))
		(function-inline? (global-value var)))
	   (begin
	      (enter-function (global-name var)) 
	      (trace eps "J'expanse le code de: " (global-name var)
		     " " (function-body (global-value var))
		     #\Newline)
	      (let ((new-body (try
			       (normalize-progn
				(comptime-expand
				 (function-body
				  (global-value var))))
			       handler)))
		 (function-body-set! (global-value var) new-body))
	      (trace eps " ==> " (function-body (global-value var))
		     #\Newline)
	      (leave-function)))))
   ;; the module user-code
   (let ((res (let loop ((schemes schemes)
			 (res     '()))
		 (if (null? schemes)
		     res
		     (match-case (car schemes)
			((define-macro . ?-)
			 (try (comptime-expand (car schemes)) handler)
			 (loop (cdr schemes)
			       res))
			((define-expander . ?-)
			 (try (comptime-expand (car schemes)) handler)
			 (loop (cdr schemes)
			       res))
			(else
			 (let ((new-body (try (comptime-expand (car schemes))
					      handler)))
			    (loop (cdr schemes)
				  (cons new-body
					res)))))))))
      (pass-postlude (reverse! res))))
      
;*---------------------------------------------------------------------*/
;*    comptime-expand ...                                              */
;*---------------------------------------------------------------------*/
(define (comptime-expand x)
   (initial-expander x initial-expander))

;*---------------------------------------------------------------------*/
;*    initial-expander ...                                             */
;*---------------------------------------------------------------------*/
(define (initial-expander x e)
   (trace eps "initial-expander: " x #\Newline)
   (let ((e1 (cond
		((symbol? x)
		 *identifier-expander*)
		((null? x)
		 (error #f "Illegal form" '()))
		((not (pair? x))
		 (lambda (x e) x))
		((symbol? (car x))
		 (let (b)
		    (cond
		       ((begin
			   (set! b (get-compiler-expander (car x)))
			   b)
			b)
		       ((begin
			   (set! b (get-eval-expander (car x)))
			   b)
			b)
		       ((memq (car x) *lexical-stack*)
			*application-expander*)
		       ((begin
			   (set! b (find-O-expander (car x)))
			   b)
			(expander-expander b))
		       (else
			*application-expander*))))
		(else
		 *application-expander*))))
      (e1 x e)))

;*---------------------------------------------------------------------*/
;*    (comptime-expand-once ...                                        */
;*---------------------------------------------------------------------*/
(define (comptime-expand-once x)
   (initial-expander x (lambda (x e) x)))

;*---------------------------------------------------------------------*/
;*    *identifier-expander* ...                                        */
;*---------------------------------------------------------------------*/
(define (*identifier-expander* x e)
   x)

;*---------------------------------------------------------------------*/
;*    *application-expander* ...                                       */
;*---------------------------------------------------------------------*/
(define (*application-expander* x e)
   (let loop ((x* x))
      (cond
	 ((pair? x*)
	  (set-car! x* (e (car x*) e))
	  (set-cdr! x* (loop (cdr x*)))
	  x*)
	 ((null? x*)
	  '())
	 (else
	  (error #f "Illegal form" x)))))
