;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Expand/define.scm        */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Dec 28 15:56:53 1994                          */
;*    Last change :  Sun Apr 23 15:27:01 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `define' forms                                               */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module expand_define
   (include "Expand/expander.sch"
	    "Tools/trace.sch")
   (import  tools_progn
	    tools_args
	    tools_error
	    tools_speek
	    tools_misc
	    expand_expander
	    expand_eps
	    expand_lambda
	    engine_param)
   (export  (expand-define x e)
	    (expand-inline x e)
	    (expand-set!   x e)))

;*---------------------------------------------------------------------*/
;*    expand-define ...                                                */
;*    -------------------------------------------------------------    */
;*    on divise en deux sous:                                          */
;*       1- on define une lambda.                                      */
;*       2- on define une valeur (autre qu'un lambda).                 */
;*---------------------------------------------------------------------*/
(define (expand-define x e)
   (trace eps "expand-define: " x
	  " " (if internal-definition? "[internal]" "[external]")
	  #\Newline)
   (if internal-definition?
       (expand-internal-define x e)
       (expand-external-define x e)))

;*---------------------------------------------------------------------*/
;*    expand-external-define ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-external-define x e)
   (set! internal-definition? #t)
   (let ((res (match-case x
		 ;; 1- on definit une lambda 
		 ((or (?- ((and (? symbol?) ?name) . ?args) .
			  (and ?body (not ())))
		      (?- (and (? symbol?) ?name)
			  (lambda ?args . (and ?body (not ())))))
		  (do-external-define-lambda e name args body))
		 ;; 3- on definit une valeur non typee
		 ((?-  (and (? symbol?) ?name). (and ?value (not ())))
		  (do-external-define-value e name value))
		 ;; 3b- on definit une valeur typee
		 (else
		  (error #f "Illegal `define' form" x)))))
      (set! internal-definition? #f)
      (replace! x res)))

;*---------------------------------------------------------------------*/
;*    expand-internal-define ...                                       */
;*---------------------------------------------------------------------*/
(define (expand-internal-define x e)
   (let ((e (internal-begin-expander e)))
      (match-case x
	 ((or (?- (?name . ?args) . (and ?body (not ())))
	      (?- (and (? symbol?) ?name)
		  (lambda ?args . (and ?body (not ())))))
	  (if (not (symbol? name))
	      (error "define" "Illegal `define' form" x)
	      (with-lexical
	       (args*->args-list args)
	       (lambda ()
		  (replace! x
			    `(define ,name
				(lambda ,args
				   ,(e (normalize-progn body) e))))))))
	 ;; 2- on definit une valeur non typee
	 ((?- (and (? symbol?) ?name) . (and ?value (not ())))
	  (replace! x
		    `(define ,name ,(e (normalize-progn value) e))))
	 ;; 2b- on definit une valeur typee
	 (else
	  (error #f "Illegal `define' form" x)))))

;*---------------------------------------------------------------------*/
;*    expand-set! ...                                                  */
;*---------------------------------------------------------------------*/
(define (expand-set! x e)
   (define (internal-expand-set! x e)
      (match-case x
	 ((?- (and (? symbol?) ?var) ?value)
	  ;; on test si la variable est liee quelque part
	  (enter-function var)
	  (let ((ev (e value e)))
	     (leave-function)
	     (replace! x `(set! ,var ,ev))))
	 (else
	  (error #f "Illegal `set!' form" x))))
   (if internal-definition?
       (internal-expand-set! x e)
       (begin
	  (set! internal-definition? #t)
	  (let ((res (internal-expand-set! x (internal-begin-expander e))))
	     (set! internal-definition? #f)
	     (replace! x res)))))

;*---------------------------------------------------------------------*/
;*    expand-inline ...                                                */
;*---------------------------------------------------------------------*/
(define (expand-inline x e)
   (match-case x
	 ((?- ((and (? symbol?) ?name) . ?args) . (and ?body (not ())))
	  (with-lexical
	   (args*->args-list args)
	   (lambda ()
	      (replace! x (do-inline e name args body)))))
	 (else
	  (error #f "Illegal `define-inline' form" x))))

;*---------------------------------------------------------------------*/
;*    do-external-define-lambda ...                                    */
;*---------------------------------------------------------------------*/
(define (do-external-define-lambda e name args body)
   (enter-function name)
   (let* ((symbol name)
	  (O-exp  (find-O-expander symbol))
	  (e      (internal-begin-expander e)))
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "top-level" "Redefinition of library function -- " name)
	     (unbind-O-expander! symbol)))
      (let ((ebody  (with-lexical
		     (args*->args-list args)
		     (lambda ()
			(e (normalize-progn body) e)))))
	 (leave-function)
	 `(define ,(cons name args) ,ebody))))

;*---------------------------------------------------------------------*/
;*    do-external-define-value ...                                     */
;*---------------------------------------------------------------------*/
(define (do-external-define-value e name value)
   (let* ((symbol name)
	  (O-exp  (find-O-expander symbol))
	  (e      (internal-begin-expander e)))
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "Redefinition of library function -- " name)
	     (unbind-O-expander! symbol)))
      (let ((evalue (e (normalize-progn value) e)))
	 `(define ,name ,evalue))))

;*---------------------------------------------------------------------*/
;*    do-inline ...                                                    */
;*---------------------------------------------------------------------*/
(define (do-inline e name args body)
   (enter-function name)
   (let* ((symbol (if (symbol? name)
		      name
		      (string->symbol (string-upcase name))))
	  (O-exp  (find-O-expander name))
	  (e      (internal-begin-expander e))
	  (body   (with-lexical
		   (args*->args-list args)
		   (lambda ()
		      (e (normalize-progn body) e)))))
      (leave-function)
      ;; est-ce qu'on n'est pas en train de redefinir une fonction
      ;; librairie qui, pour etre optimisee, etait aussi une macro ?
      (if (and (expander? O-exp) (not *lib-mode*))
	  (begin
	     (warning "Redefinition of library function -- " name)
	     (unbind-O-expander! name)))
      `(define-inline ,(cons name args) ,body)))

