;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9/Cgen/walk.scm            */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Tue Feb 21 08:37:48 1995                          */
;*    Last change :  Sat Apr  6 11:18:23 1996 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `integration' pass.                                          */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_walk
   (include "Tools/pass.sch"
	    "Tools/trace.sch"
	    "Ast/ast.sch")
   (import  tools_shape
	    engine_param
	    ast_global
	    cgen_main
	    cgen_generate
	    cgen_a2c
	    cgen_roots
	    cgen_count)
   (export  (cgen-walk <global>*)))

;*---------------------------------------------------------------------*/
;*    cgen-walk ...                                                    */
;*---------------------------------------------------------------------*/
(define (cgen-walk globals)
   (pass-prelude "Cgen")
   ;; we count the reference of global variables and global functions
   (count! globals)
   ;; we declare the global variable as gc roots.
   (if (eq? *garbage-collector* 'bumpy)
       (declare-gc-global-variables!))
   (let loop ((globals (if (or *main*
			       (eq? *pass* 'ld)
			       (eq? *pass* 'distrib))
			   (cons (make-bigloo-main) globals)
			   globals))
	      (c-defs   '()))
      (if (null? globals)
	  (pass-postlude (generate-c-file c-defs))
	  (let ((var (car globals)))
	     (let ((def (cgen-definition! var)))
		(loop (cdr globals)
		      (cons def c-defs)))))))

