;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cgen/count.scm           */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri Jul  7 13:55:18 1995                          */
;*    Last change :  Wed Oct 11 11:20:15 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    We recount the number of occurrence of all global variables.     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cgen_count
   (include "Ast/node.sch"
	    "Tools/trace.sch")
   (import  tools_shape
	    tools_module
	    ast_dump
	    ast_env
	    ast_module)
   (export  (count! globals)))

;*---------------------------------------------------------------------*/
;*    reset-occ! ...                                                   */
;*---------------------------------------------------------------------*/
(define (reset-occ! global)
   (global-occurrence-set! global 0))

;*---------------------------------------------------------------------*/
;*    inc-occ! ...                                                     */
;*---------------------------------------------------------------------*/
(define (inc-occ! global)
   (trace cgen "J'increment: " (shape global) " --> "
	  (global-occurrence global) #\Newline)
   ;; when encoutering imported variable we remember to initialize
   ;;the module
   (if (and (eq? (global-import global) 'import)
	    (global-library? global))
       (mark-library-module! (global-module global)))
   ;; we increment its reference counter
   (global-occurrence-set! global (+fx 1 (global-occurrence global))))

;*---------------------------------------------------------------------*/
;*    count! ...                                                       */
;*    -------------------------------------------------------------    */
;*    This function counts the number of occurrences of all globals    */
;*    variables and after this count, it produces the fill the         */
;*    `initialize-imported-modules!' functions.                        */
;*---------------------------------------------------------------------*/
(define (count! globals)
   (for-each-global! reset-occ!)
   (for-each (lambda (global)
		(inc-occ! global)
		(ast-count! (function-body (global-value global))))
	     globals)
   (fill-initialize-imported-modules!))

;*---------------------------------------------------------------------*/
;*    ast-count! ...                                                   */
;*---------------------------------------------------------------------*/
(define (ast-count! ast)
   (trace (loop cgen) "Ast-count!: " (shape ast) #\Newline)
   (ast-case ast
      ((atom)
       #unspecified)
      ((kwote)
       (internal-error "ast-count!"
		       "Illegal node (see Cnst pass)"
		       (ast->sexp ast)))
      ((var)
       (let ((var (var-variable ast)))
	  (if (global? var)
	      (inc-occ! var))))
      ((make-box)
       (ast-count! (make-box-value ast)))
      ((box-ref)
       (ast-count! (box-ref-var ast)))
      ((box-set!)
       (ast-count! (box-set!-value ast)))
      ((prag-ma)
       (for-each ast-count! (prag-ma-values ast))
       #unspecified)
      ((fail)
       (ast-count! (fail-proc ast))
       (ast-count! (fail-msg ast))
       (ast-count! (fail-obj ast)))
      ((sequence)
       (for-each ast-count! (sequence-exp ast)))
      ((conditional)
       (ast-count! (conditional-test ast))
       (ast-count! (conditional-then ast))
       (ast-count! (conditional-else ast)))
      ((switch)
       (ast-count! (switch-test ast))
       (for-each (lambda (clause)
		    (ast-count! (cdr clause)))
		 (switch-clauses ast)))
      ((setq)
       (let ((var (var-variable (setq-var ast)))
	     (val (setq-val ast)))
	  (if (global? var)
	      (inc-occ! var))
	  (ast-count! val)))
      ((let-var)
       (for-each (lambda (binding)
		    (ast-count! (cdr binding)))
		 (let-var-bindings ast))
       (ast-count! (let-var-body ast)))
      ((let-fun)
       (for-each (lambda (local)
		    (ast-count! (function-body (local-value local))))
		 (let-fun-locals ast))
       (ast-count! (let-fun-body ast)))
      ((set-ex-it)
       (ast-count! (set-ex-it-body ast)))
      ((jump-ex-it)
       (ast-count! (jump-ex-it-exit ast))
       (ast-count! (jump-ex-it-value ast)))
      ((fun)
       (internal-error "ast-count!"
		       "Illegal node (see Globalize)"
		       (ast->sexp ast)))
      ((app-ly)
       (ast-count! (app-ly-fun ast))
       (ast-count! (app-ly-value ast)))
      ((funcall)
       (ast-count! (funcall-fun ast))
       (for-each ast-count! (funcall-actuals ast)))
      ((app)
       (ast-count! (app-fun ast))
       (for-each ast-count! (app-actuals ast)))))
       

