;*---------------------------------------------------------------------*/
;*    Copyright (c) 1996 by Manuel Serrano. All rights reserved.       */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \    /  '                              */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome Send them to                                           */
;*        <Manuel.Serrano@inria.fr>                                    */
;*        Manuel Serrano                                               */
;*        INRIA -- Rocquencourt                                        */
;*        Domaine de Voluceau, BP 105                                  */
;*        78153 Le Chesnay Cedex                                       */
;*        France                                                       */
;*---------------------------------------------------------------------*/


;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.8/Cfa/pair.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Wed Apr  5 16:19:47 1995                          */
;*    Last change :  Fri Oct 27 15:15:38 1995 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The `pair' special treatment                                     */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module cfa_pair
   (include "Tools/trace.sch"
	    "Ast/node.sch"
	    "Type/type.sch"
	    "Cfa/approx.sch"
	    "Cfa/stack.sch")
   (import  cfa_ast
	    cfa_approx
	    cfa_cfa
	    cfa_collect
	    cfa_cache
	    cfa_top
	    cfa_stack
	    cfa_special
	    engine_param
	    type_cache
	    tools_shape
	    tools_set
	    ast_typeof
	    ast_dump)
   (export  (start-cfa-pair!)
	    (stop-cfa-pair!)))

;*---------------------------------------------------------------------*/
;*    start-cfa-pair! ...                                              */
;*---------------------------------------------------------------------*/
(define (start-cfa-pair!)
   (if (>=fx *optim* 4)
       (begin
	  [assert check (*cons*) (global? *cons*)]
	  [assert check (*car*) (global? *car*)]
	  [assert check (*cdr*) (global? *cdr*)]
	  [assert check (*set-car!*) (global? *set-car!*)]
	  [assert check (*set-cdr!*) (global? *set-cdr!*)]
	  (ffunction-cfa-info-set! (global-value *cons*)
				   (ispecial cons-approx
					     #t
					     spread-cadr-top!
					     spread-cadr-unstackable!
					     cons-app!))
	  (ffunction-cfa-info-set! (global-value *car*)
				   (ispecial std-init
					     #f
					     #unspecified
					     #unspecified
					     (make-cadr-app! car)))
	  (ffunction-cfa-info-set! (global-value *cdr*)
				   (ispecial std-init
					     #f
					     #unspecified
					     #unspecified
					     (make-cadr-app! cdr)))
	  (ffunction-cfa-info-set! (global-value *set-car!*)
				   (ispecial typed-init
					     #f
					     #unspecified
					     #unspecified
					     (make-set-cadr-app car)))
	  (ffunction-cfa-info-set! (global-value *set-cdr!*)
				   (ispecial std-init
					     #f
					     #unspecified
					     #unspecified
					     (make-set-cadr-app cdr)))))
   #t)
       
;*---------------------------------------------------------------------*/
;*    stop-cfa-pair! ...                                               */
;*---------------------------------------------------------------------*/
(define (stop-cfa-pair!)
   (if (>=fx *optim* 4)
       (begin
	  (ffunction-cfa-info-set! (global-value *cons*)     #unspecified)
	  (ffunction-cfa-info-set! (global-value *car*)      #unspecified)
	  (ffunction-cfa-info-set! (global-value *cdr*)      #unspecified)
	  (ffunction-cfa-info-set! (global-value *set-car!*) #unspecified)
	  (ffunction-cfa-info-set! (global-value *set-cdr!*) #unspecified)))
   #t)
   
;*---------------------------------------------------------------------*/
;*    cons-approx ...                                                  */
;*    -------------------------------------------------------------    */
;*    List are heterogeneous and only contains wrapped object. We      */
;*    enforce this by adding `obj' in the approximation of the `car'   */
;*    and the `cdr'.                                                   */
;*---------------------------------------------------------------------*/
(define (cons-approx ast)
   (set-special-approx! ast (cons (create-approx (list *obj*) '())
				  (create-approx (list *obj*) '())))
   (let ((approx (create-approx (list (typeof ast)) (list ast))))
      (type-lock-approx! approx)
      (top-lock-approx! approx)
      approx))

;*---------------------------------------------------------------------*/
;*    std-init ...                                                     */
;*---------------------------------------------------------------------*/
(define (std-init ast)
   (create-approx '() '()))

;*---------------------------------------------------------------------*/
;*    typed-init ...                                                   */
;*---------------------------------------------------------------------*/
(define (typed-init ast)
   (create-approx (list (typeof ast)) '()))

;*---------------------------------------------------------------------*/
;*    cons-app! ...                                                    */
;*---------------------------------------------------------------------*/
(define (cons-app! call-ast fun actuals-approx)
   [assert check (fun) (global? fun)]
   (trace (cfa loop)
	  "~ ~ >        cons-app: " (shape fun) " " (ast->sexp call-ast)
	  #\Newline)
   (let ((p-approx (get-special-approx call-ast)))
      (union-approx! (car p-approx) (car actuals-approx))
      (union-approx! (cdr p-approx) (cadr actuals-approx)))
   (let ((A (get-approx call-ast)))
      (trace (cfa loop) "< ~ ~                : " (approx-shape A) #\Newline)
      A))

;*---------------------------------------------------------------------*/
;*    spread-cadr-top! ...                                             */
;*---------------------------------------------------------------------*/
(define (spread-cadr-top! app)
   (let ((approx (get-approx app)))
      (approx-exported?-set! approx #t)
      (trace (cfa loop)
	     "!!! spread-cadr-top!: " (ast->sexp app) #\Newline
	     "              approx: " (approx-shape approx) #\Newline)
      (let ((p-approx (get-special-approx app)))
	 (if (or (not (pair? p-approx))
		 (not (approx? (car p-approx)))
		 (not (approx? (cdr p-approx))))
	     (internal-error "spread-cadr-top!"
			     "`cfa-info-aux' is not an approximation for"
			     (ast->sexp app))
	     (begin
		(spread-top! (car p-approx))
		(add-top! (car p-approx))
		(add-obj! (car p-approx))
		(spread-top! (cdr p-approx))
		(add-top! (cdr p-approx))
		(add-obj! (cdr p-approx)))))))
   
;*---------------------------------------------------------------------*/
;*    spread-cadr-unstackable! ...                                     */
;*---------------------------------------------------------------------*/
(define (spread-cadr-unstackable! app min max mark age)
   (let* ((sinfo  (app-stack-info app))
	  (smark  (sinfo-mark sinfo))
	  (approx (get-approx app)))
      (trace (stack loop)
	     "!!! spread-cadr-unstackable!: " (ast->sexp app) #\Newline
	     "                      approx: " (approx-shape approx) #\Newline
	     "                         min: " min #\Newline
	     "                         max: " max #\Newline
	     "                         age: " age #\Newline
	     "                        mark: " smark #\Newline)
      (let ((p-approx (get-special-approx app)))
	 (if (or (not (pair? p-approx))
		 (not (approx? (car p-approx)))
		 (not (approx? (cdr p-approx))))
	     (internal-error "spread-cadr-unstackable!"
			     "`cfa-info-aux' is not an approximation for"
			     (ast->sexp app))
	     (let ((astamp (sinfo-stamp sinfo)))
		(if (case age
		       ((all)
			#t)
		       ((between)
			(and (>fx astamp min) (<=fx astamp max)))
		       (else
			(not (=fx astamp min))))
		    (mark-unstackable! app))
		(for-each-set (lambda (a)
				 (spread-unstackable/mark! a
							   min
							   max
							   mark
							   age))
			      (approx-alloc (car p-approx)))
		(for-each-set (lambda (a)
				 (spread-unstackable/mark! a
							   min
							   max
							   mark
							   age))
			      (approx-alloc (cdr p-approx))))))))
   
;*---------------------------------------------------------------------*/
;*    is-cons-alloc? ...                                               */
;*---------------------------------------------------------------------*/
(define (is-cons-alloc? app)
   (and (>=fx *optim* 4)
	(let ((var (var-variable (app-fun app))))
	   (eq? var *cons*))))

;*---------------------------------------------------------------------*/
;*    make-cadr-app! ...                                               */
;*    -------------------------------------------------------------    */
;*    getter is car for `car' approximations and `cadr'                */
;*    (to get the second actuals) for the `cdr' approximations.        */
;*---------------------------------------------------------------------*/
(define (make-cadr-app! getter)
   [assert check (getter) (or (eq? getter car) (eq? getter cdr))]
   (lambda (call-ast fun actuals-approx)
      [assert check (fun) (global? fun)]
      (trace (cfa loop)
	     "~ ~ >   make-cadr-app: " (shape fun) " " (ast->sexp call-ast)
	     #\Newline)
      (trace (cfa loop)
	     "                 pair: " (approx-shape (car actuals-approx))
	     #\Newline)
      ;; we do nothing with the actuals, we just returns a union.
      (let* ((A           (get-approx call-ast))
	     (pair-approx (car actuals-approx)))
	 (if (approx-top? pair-approx)
	     (begin
		(add-obj! A)
		(add-top! A)))
	 (for-each-set
	  (lambda (alloc)
	     (cond
		((not (is-cons-alloc? alloc))
		 #unspecified)
		((or (not (pair? (get-special-approx alloc)))
		     (not (approx? (car (get-special-approx alloc))))
		     (not (approx? (cdr (get-special-approx alloc)))))
		 (internal-error "car/cdr"
				 "`cfa-info-aux' is not an approximation for"
				 (ast->sexp call-ast)))
		(else
		 (union-approx! A (getter (get-special-approx alloc))))))
	  (approx-alloc pair-approx))
	 (trace (cfa loop) "< ~ ~                : " (approx-shape A)
		#\Newline)
	 A)))
   
;*---------------------------------------------------------------------*/
;*    make-set-cadr-app! ...                                           */
;*    -------------------------------------------------------------    */
;*    getter is car for `car' approximations and `cadr'                */
;*    (to get the second actuals) for the `cdr' approximations.        */
;*---------------------------------------------------------------------*/
(define (make-set-cadr-app getter)
   [assert check (getter) (or (eq? getter car) (eq? getter cdr))]
   (lambda (call-ast fun actuals-approx)
      [assert check (fun) (global? fun)]
      (trace (cfa loop)
	     "~ ~ > make-set-cadr-a: " (shape fun) " " (ast->sexp call-ast)
	     #\Newline)
      (trace (cfa loop)
	     "                 pair: " (approx-shape (car actuals-approx))
	     #\Newline)
      ;; we do nothing with the actuals, we just returns a union.
      (let* ((pair-approx  (car actuals-approx))
	     (val-approx   (cadr actuals-approx)))
	 (if (approx-top? pair-approx)
	     (spread-top! val-approx))
	 ;; now we add values as the old conses
	 (for-each-set
	  (lambda (alloc)
	     (cond
		((not (is-cons-alloc? alloc))
		 #unspecified)
		((or (not (pair? (get-special-approx alloc)))
		     (not (approx? (car (get-special-approx alloc))))
		     (not (approx? (cdr (get-special-approx alloc)))))
		 (internal-error "set-car!/set-cdr!"
				 "`cfa-info-aux' is not an approximation for"
				 (ast->sexp call-ast)))
		(else
		 (union-approx! (getter (get-special-approx alloc))
				val-approx))))
	  (approx-alloc pair-approx))
	 (let ((A (get-approx call-ast)))
	    (trace (cfa loop) "< ~ ~                : " (approx-shape A)
		   #\Newline)
	    A))))
   
