;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  keyboard.asm
;* Purpose: Some keyboard related functions
;* Entries: _getkey, _chkkey
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Include assembler macros:
;
include ..\..\headers\asm\macros.inc
include ..\..\headers\asm\layout.inc
include ..\..\headers\asm\memory.inc
include .\libpriv.inc


;
;**************************************************************************
;
; Start code segment.
;
text_start

	public	_getkey			; define entry points
	public	_chkkey

	extrn	_pktpoll:near
	extrn	_set_timeout:near
	extrn	_chk_timeout:near


;
;**************************************************************************
;
; Wait for keyboard input, and return the key pressed. This routine
; does not print anything.
; Input:  1. arg  -  timeout value (0 if no timeout)
; Output: character representing pressed key, or -1 if timeout reached
;
_getkey		proc	near

	penter				; setup standard stack frame
	getarg	ax,0			; get timeout value
	or	ax,ax
	jz	short getk2		; don't set a timeout if none given
	push	ax
	call	_set_timeout		; set the timeout
	pop	ax

getk1:	getarg	ax,0			; check if timeout given
	or	ax,ax
	jz	short getk2		; no timeout
	call	_chk_timeout		; check for timeout - does polling also
	or	ax,ax
	jz	short getk3		; timeout not reached, so check keyboard
	mov	ax,-1
	jmp	short getk9		; got timeout

getk2:	call	_pktpoll		; care for polling events
getk3:	mov	ah,06h
	mov	dl,0FFh			; check DOS keyboard status
	int	21h
	jz	short getk1		; no key pressed
	xor	ah,ah			; prepare return value
getk9:	pleave
	ret

_getkey		endp


;
;**************************************************************************
;
; Check if a key pressed. This routine is destructive.
; Input:  none
; Output: Character, or -1 if no key pressed
;
_chkkey		proc	near

	mov	ah,06h
	mov	dl,0FFh			; check DOS keyboard status
	int	21h
	jnz	short chkk8
	mov	ax,-1			; no key pressed
	jmp	short chkk9
chkk8:	xor	ah,ah			; prepare return value
chkk9:	ret

_chkkey		endp


;
;**************************************************************************
;
text_end

	end

