;**************************************************************************
;*
;* Boot-ROM-Code to load an operating system across a TCP/IP network.
;*
;* Module:  layout.inc
;* Purpose: Assembler include file to define the segment layout
;* Entries: None
;*
;**************************************************************************
;*
;* Copyright (C) 1995,1996 Gero Kuhlmann <gero@gkminix.han.de>
;*
;*  This program is free software; you can redistribute it and/or modify
;*  it under the terms of the GNU General Public License as published by
;*  the Free Software Foundation; either version 2 of the License, or
;*  any later version.
;*
;*  This program is distributed in the hope that it will be useful,
;*  but WITHOUT ANY WARRANTY; without even the implied warranty of
;*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;*  GNU General Public License for more details.
;*
;*  You should have received a copy of the GNU General Public License
;*  along with this program; if not, write to the Free Software
;*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
;*


;
;**************************************************************************
;
; Definitions for the loader segment. This segment can optionally contain
; a program which loads the rest of the boot rom code, like a floppy boot
; sector. It has to be completely independent of the rest of the segments
; and groups. However, it should be class "CODE", so that it gets ordered
; before all the other code segments.
;
% load_text	segment	para seguse public 'CODE'
  load_text	ends


;
;**************************************************************************
;
; Definitions for the code section:
;
% _text		segment	byte seguse public 'CODE'
  _text		ends

% end_of_code	segment	byte seguse public 'END_OF_CODE'
ifdef INITSEG
		public	_end_of_code
_end_of_code	label	byte
else
		extrn	_end_of_code:byte
endif
end_of_code	ends

cgroup		group	_text, end_of_code


;
;**************************************************************************
;
; Definitions for the data section:
;
% _const	segment	word seguse public 'CONST'
  _const	ends

% _data		segment word seguse public 'DATA'
  _data		ends

% end_of_data	segment	byte seguse public 'END_OF_DATA'
ifdef INITSEG
		public	_end_of_data
_end_of_data	label	byte
else
		extrn	_end_of_data:byte
endif
end_of_data	ends

dgroup		group	_const, _data, end_of_data


;
;**************************************************************************
;
; Definitions for the stack section. Do not define a seperate stack
; segment, because exe2bin won't like it.
;
% _bss		segment	word seguse public 'BSS'
  _bss		ends

% _bssend	segment	byte seguse public 'BSSEND'
  _bssend	ends

% end_of_bss	segment	byte seguse public 'BSS'
ifdef INITSEG
		public	_end_of_bss
_end_of_bss	label	byte
else
		extrn	_end_of_bss:byte
endif
end_of_bss	ends

dgroup		group	_bss, _bssend, end_of_bss

