/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	This file includes the math transformation routines
	
        -------------------------------------------------------------------*/

#include "xldlas.h"


extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void inhibit_input();
extern void reenable_input();
extern int check_variable_name(char proposed[XLDLASMAX_INPUT]);
extern void say_status(char the_status[XLDLASMAX_INPUT]);
extern int check_variable_name(char proposed[XLDLASMAX_INPUT]);
extern void rip_ends();
extern void sync_graph_browsers(int type);

void show_math_construct()
{
	char string_one[XLDLASMAX_INPUT];
	fl_clear_browser(gen_operator_browser);
	fl_clear_browser(gen_argument_browser);
	if(math_construct.operator == 1) fl_addto_browser(gen_operator_browser,"+");
	if(math_construct.operator == 2) fl_addto_browser(gen_operator_browser,"-");
	if(math_construct.operator == 3) fl_addto_browser(gen_operator_browser,"x");
	if(math_construct.operator == 4) fl_addto_browser(gen_operator_browser,"/");
	if(math_construct.argument_type == 0) fl_addto_browser(gen_argument_browser, math_construct.float_argument);
	if(math_construct.argument_type == 1)
	{
		if(math_construct.variable_argument == - 1)
		{
			sprintf(string_one,"(current)[%d]", math_construct.variable_lag);
		}
		else
		{			
			sprintf(string_one,"%s[%d]",data_matrix[math_construct.variable_argument].name, math_construct.variable_lag);
		}
		fl_addto_browser(gen_argument_browser, string_one);
	}
}

void gen_write_variable()
{
	int choice, i, writenumber, write_type;
	char string_one[XLDLASMAX_INPUT];
	strcpy(string_one, fl_get_input(gen_name_input));
	i = 0;
	writenumber = 0;
	gen_exists = FALSE;
	write_type = 3;
	while(strlen(string_one) < 1)
	{
		strncpy(string_one,fl_show_input("Please supply a Variable Name:",
		  					""),NAME_LENGTH-1);
	}
	if(check_variable_name(string_one) == FALSE)
	{
		choice = fl_show_choice("Variable Name already Exists","Overwrite exisiting values?",
					"",3,"Yes","No","Cancel");
		if(choice == 1)
		{
			for(i = 0; i < numb_variables; i++)
			{
				if(strcmp(string_one,data_matrix[i].name) == 0)
				{
					writenumber = i;
					strcpy(data_matrix[i].description,fl_get_input(gen_desc_input));
					write_type  = 1;	
					i = numb_variables;
				}
			}		
			for(i = fl_get_counter_value(gen_from_counter) - 1; i <  fl_get_counter_value(gen_to_counter); i++)
			{
				*(fvector[writenumber] + i) = atof(fl_get_browser_line(gen_data_browser, i - fl_get_counter_value(gen_from_counter) + 2));
			}
			if(i > data_matrix[writenumber].obs) data_matrix[writenumber].obs = i;
			data_exists = TRUE;
			oktoquit = FALSE;
		}
		if(choice == 2 || choice == 3)
		{
			return;
		}
	}
	else
	{
		writenumber = numb_variables;
		write_type = 0;
		numb_variables++;
		strcpy(data_matrix[writenumber].name, string_one);
		strcpy(data_matrix[writenumber].description,fl_get_input(gen_desc_input));
 		fvector[writenumber] = (float *) malloc (MAX_OBS * sizeof(float));
 		for(i = 0; i < fl_get_counter_value(gen_from_counter) - 1; i++)
 		{
 			*(fvector[writenumber] + i) = missing_value;
 		}
 		for(i = fl_get_counter_value(gen_from_counter) - 1; i <  fl_get_counter_value(gen_to_counter); i++)
		{
			*(fvector[writenumber] + i) = atof(fl_get_browser_line(gen_data_browser, i - fl_get_counter_value(gen_from_counter) + 2));
		}
		data_matrix[writenumber].obs = i;
	}
	sprintf(string_one,"Read %d observation(s) into %s between %d and %d", i, data_matrix[writenumber].name, all_start, all_stop);
	simple_line_output("gen",string_one);
	data_exists = TRUE;
	oktoquit = FALSE;
	rip_ends();
	fl_clear_choice(gen_var_choice);
	fl_addto_choice(gen_var_choice,"(current)");
	for(i = 0; i < numb_variables; i++)
	{
		fl_addto_choice(gen_var_choice,data_matrix[i].name);
	}
	sync_graph_browsers(write_type);
}



void done_gen(FL_OBJECT *obj, long arg)
{
	int choice, i, writenumber;
	char string_one[XLDLASMAX_INPUT];
	strcpy(string_one, fl_get_input(gen_name_input));
	i = 0;
	writenumber = 0;
	if(gen_exists == TRUE)
	{
		while(strlen(string_one) < 1)
		{
			strncpy(string_one,fl_show_input("Please supply a Variable Name:",
		  					""),NAME_LENGTH-1);
		}
		if(check_variable_name(string_one) == FALSE)
		{
			choice = fl_show_choice("Variable Name already Exists","Overwrite exisiting values?",
						"",3,"Yes","No","Cancel");
			if(choice == 1)
			{
				for(i = 0; i < numb_variables; i++)
				{
					if(strcmp(string_one,data_matrix[i].name) == 0)
					{
						writenumber = i;
						strcpy(data_matrix[i].description,fl_get_input(gen_desc_input));
						i = numb_variables;
					}
				}		
				for(i = fl_get_counter_value(gen_from_counter) - 1; i <  fl_get_counter_value(gen_to_counter); i++)
				{
					*(fvector[writenumber] + i) = atof(fl_get_browser_line(gen_data_browser, i - fl_get_counter_value(gen_from_counter) + 2));
				}
				if(i > data_matrix[writenumber].obs) data_matrix[writenumber].obs = i;
			}
			if(choice == 2 || choice == 3)
			{
				return;
			}
		}
		else
		{
			writenumber = numb_variables;
			numb_variables++;
			strcpy(data_matrix[writenumber].name, string_one);
			strcpy(data_matrix[writenumber].description,fl_get_input(gen_desc_input));
	 		fvector[writenumber] = (float *) malloc (MAX_OBS * sizeof(float));
	 		for(i = 0; i < fl_get_counter_value(gen_from_counter) - 1; i++)
	 		{
	 			*(fvector[writenumber] + i) = missing_value;
	 		}
	 		for(i = fl_get_counter_value(gen_from_counter) - 1; i <  fl_get_counter_value(gen_to_counter); i++)
			{
				*(fvector[writenumber] + i) = atof(fl_get_browser_line(gen_data_browser, i - fl_get_counter_value(gen_from_counter) + 2));
			}
			data_matrix[writenumber].obs = i;
		}
		sprintf(string_one,"Read %d observation(s) into %s between %d and %d", i, data_matrix[writenumber].name, all_start, all_stop);
		simple_line_output("gen",string_one);
		data_exists = TRUE;
		oktoquit = FALSE;
		rip_ends();
	}
	window_geometry[XLDLAS_GENERATE][0] = obj->form->x;
	window_geometry[XLDLAS_GENERATE][1] = obj->form->y;
	window_geometry[XLDLAS_GENERATE][2] = obj->form->w;
	window_geometry[XLDLAS_GENERATE][3] = obj->form->h;
	fl_hide_form(gen_window);
	say_status("Ready");
	reenable_input();	
}

int click_done_gen(FL_FORM *form, void *arg)
{
	int choice;
	if(gen_exists == TRUE)
	{
		choice = fl_show_choice("Exit generate/replace (Data not saved!)?",
						"","", 3,
						"Yes","No","Cancel");
	
		if(choice == 1)
		{
			say_status("Ready");
			reenable_input();
			return(FL_OK);
		}
		return(FL_IGNORE);
	}
	window_geometry[XLDLAS_GENERATE][0] = form->x;
	window_geometry[XLDLAS_GENERATE][1] = form->y;
	window_geometry[XLDLAS_GENERATE][2] = form->w;
	window_geometry[XLDLAS_GENERATE][3] = form->h;
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}

void read_into_working()
{
	int i;
	worksize = 0;
	for(i = fl_get_counter_value(gen_from_counter) - 1; i < fl_get_counter_value(gen_to_counter); i++)	
	{
		working[worksize] = atof(fl_get_browser_line(gen_data_browser,i+1));
		worksize++;
	}
}

void write_from_working()
{
	int i;
	char string_one[XLDLASMAX_INPUT];
	fl_clear_browser(gen_data_browser);
	for(i = 0; i < worksize; i++)	
	{
		sprintf(string_one,"%f", working[i]);
		fl_addto_browser(gen_data_browser,string_one);
	}
}

void number_pad(int the_number)
{
	char small_string[3];
	sprintf(small_string,"%d", the_number);
	if(math_construct.argument_type == 1)
	{
		strcpy(math_construct.float_argument,"");
	}
	strcat(math_construct.float_argument,small_string);
	math_construct.argument_type = 0;
	show_math_construct();
}


void do_simple_math()
{
	int i;
	float scratch;
	fl_freeze_form(gen_window);
	read_into_working();
	scratch = atof(math_construct.float_argument);
	for(i = 0; i < worksize; i++)
	{
		if(working[i] != missing_value)
		{
			if(math_construct.operator == 1) working[i] = working[i] + scratch;
			if(math_construct.operator == 2) working[i] = working[i] - scratch;
			if(math_construct.operator == 3) working[i] = working[i] * scratch;
			if(math_construct.operator == 4 && scratch != 0.0) working[i] = working[i] / scratch;
		}
	}
	write_from_working();
	strcpy(math_construct.float_argument,"");
	fl_unfreeze_form(gen_window);
}


void do_variable_math()
{
	int i;
	fl_freeze_form(gen_window);
	read_into_working();
	if(math_construct.variable_argument == -1)
	{
		for(i = 0; i < worksize; i++)
		{
			working_two[i] = working[i];
		}
		for(i = 0; i < worksize; i++)
		{
			if(	i + math_construct.variable_lag >= 0
			     &&	i + math_construct.variable_lag < worksize
			     && working_two[i + math_construct.variable_lag] != missing_value
			     && working[i] != missing_value)
			{
				if(math_construct.operator == 1) working[i] = working[i] + working_two[i+math_construct.variable_lag];
				if(math_construct.operator == 2) working[i] = working[i] - working_two[i+math_construct.variable_lag];
				if(math_construct.operator == 3) working[i] = working[i] * working_two[i+math_construct.variable_lag];
				if(math_construct.operator == 4 && working_two[i+math_construct.variable_lag] != 0.0) working[i] = working[i] / working_two[i+math_construct.variable_lag];
			}
		}
	}
	else
	{
		for(i = 0; i < worksize; i++)
		{
			if(	i + math_construct.variable_lag >= 0
			     &&	i + math_construct.variable_lag < worksize
			     && *(fvector[math_construct.variable_argument] + i + math_construct.variable_lag) != missing_value
			     && working[i] != missing_value
			     && i + math_construct.variable_lag < data_matrix[math_construct.variable_argument].obs)
			{
				if(math_construct.operator == 1) working[i] = working[i] + *(fvector[math_construct.variable_argument] + i + math_construct.variable_lag);
				if(math_construct.operator == 2) working[i] = working[i] - *(fvector[math_construct.variable_argument] + i + math_construct.variable_lag);
				if(math_construct.operator == 3) working[i] = working[i] * *(fvector[math_construct.variable_argument] + i + math_construct.variable_lag);
				if(math_construct.operator == 4 && *(fvector[math_construct.variable_argument] + i + math_construct.variable_lag) != 0.0) working[i] = working[i] / *(fvector[math_construct.variable_argument] + i + math_construct.variable_lag);
			}
			else
			{
				working[i] = missing_value;
			} 
		
		}
	}
	write_from_working();
	math_construct.argument_type = 0;
	strcpy(math_construct.float_argument,"");
	fl_unfreeze_form(gen_window);
}

void handle_gen_buttons(FL_OBJECT *obj, long arg)
{
	int i, choice, flag;
	char string_one[XLDLASMAX_INPUT];
	float scratch;
	if(arg == -1)
	{
		if(gen_exists == TRUE)
		{
			choice = fl_show_choice("Exit generate/replace (Data not saved!)?",
							"","", 3,
							"Yes","No","Cancel");
	
			if(choice == 1)
			{
				window_geometry[XLDLAS_GENERATE][0] = obj->form->x;
				window_geometry[XLDLAS_GENERATE][1] = obj->form->y;
				window_geometry[XLDLAS_GENERATE][2] = obj->form->w;
				window_geometry[XLDLAS_GENERATE][3] = obj->form->h;
				fl_hide_form(gen_window);
				say_status("Ready");
				reenable_input();
			}
		}
		else
		{
				window_geometry[XLDLAS_GENERATE][0] = obj->form->x;
				window_geometry[XLDLAS_GENERATE][1] = obj->form->y;
				window_geometry[XLDLAS_GENERATE][2] = obj->form->w;
				window_geometry[XLDLAS_GENERATE][3] = obj->form->h;
				fl_hide_form(gen_window);
				say_status("Ready");
				reenable_input();
		}
	}
	if(arg == 1)
	{
		gen_write_variable();
	}
	if(arg == 2)
	{
		fl_freeze_form(gen_window);
		if(fl_get_counter_value(gen_from_counter) < all_start)
		{
			for(i = 0; i < all_start - fl_get_counter_value(gen_from_counter); i++)
			{
				fl_insert_browser_line(gen_data_browser,1,"0.000000");
			}
		}
		if(fl_get_counter_value(gen_from_counter) > all_start)
		{
			if(fl_get_counter_value(gen_from_counter) > all_stop)
			{
				strcpy(string_one,fl_get_browser_line(gen_data_browser,all_stop - (all_start - 1)));
				all_start = all_stop;
				fl_set_counter_value(gen_from_counter, all_start);
				fl_clear_browser(gen_data_browser);
				fl_addto_browser(gen_data_browser,string_one);
			}
			else
			{
				for(i = 0; i < fl_get_counter_value(gen_from_counter) - all_start; i++)
				{
					fl_delete_browser_line(gen_data_browser, 1);
				}
			}
		}
		all_start = fl_get_counter_value(gen_from_counter);
		fl_set_counter_value(gen_from_counter, all_start);
		fl_unfreeze_form(gen_window);
	}
	if(arg == 3)
	{
		fl_freeze_form(gen_window);
		if(fl_get_counter_value(gen_to_counter) < all_stop)
		{
			if(fl_get_counter_value(gen_to_counter) < all_start)
			{
				strcpy(string_one,fl_get_browser_line(gen_data_browser,1));
				all_start = all_stop;
				fl_set_counter_value(gen_to_counter, all_start);
				fl_clear_browser(gen_data_browser);
				fl_addto_browser(gen_data_browser,string_one);
			}
			else
			{
				for(i = 0; i < all_stop - fl_get_counter_value(gen_to_counter); i++)
				{
					fl_delete_browser_line(gen_data_browser,fl_get_browser_maxline(gen_data_browser));
				}
			}
		}
		if(fl_get_counter_value(gen_to_counter) > all_stop)
		{
			for(i = 0; i < fl_get_counter_value(gen_to_counter) - all_stop; i++)
			{
				fl_addto_browser(gen_data_browser, "0.000000");
			}
		}
		all_stop = fl_get_counter_value(gen_to_counter);
		fl_set_counter_value(gen_to_counter, all_stop);
		fl_unfreeze_form(gen_window);
	}
	if(arg > 9 && arg < 20)
	{
		number_pad(arg - 10);
	}
	if(arg == 20)
	{
		flag = TRUE;
		for(i = 0; i < strlen(math_construct.float_argument); i++)
		{
			if(math_construct.float_argument[i] == '.') flag = FALSE;
		}
		if(flag == TRUE)
		{
			math_construct.argument_type = 0;
			strcat(math_construct.float_argument,".");
		}
		show_math_construct();
	}
	if(arg > 20 && arg < 25)
	{
		math_construct.operator = arg - 20;
		show_math_construct();
	}
	if(arg == 25)
	{
		if(strlen(math_construct.float_argument) > 0)
		{
			for(i = 0; i < strlen(math_construct.float_argument) - 1; i++)
			{
				string_one[i] = math_construct.float_argument[i];
			}
			string_one[i] = '\0';
			strcpy(math_construct.float_argument, string_one);
			show_math_construct();
		}
	}
	if(arg == 30)
	{
		if(math_construct.argument_type == 0 && strlen(math_construct.float_argument) > 0) do_simple_math();
		else do_variable_math();
		gen_exists = TRUE;
		show_math_construct();
	}
	if(arg == 31)
	{
		math_construct.variable_lag--;
		show_math_construct();
	}
	if(arg == 32)
	{
		math_construct.variable_lag++;
		show_math_construct();
	}
	if(arg == 33)
	{
		if(math_construct.argument_type == 0)
		{
			math_construct.argument_type = 1;
			math_construct.variable_lag = 0;
		}
		math_construct.variable_argument = fl_get_choice(obj) - 2;
		show_math_construct();
	}
	if(arg == 51)
	{
		fl_freeze_form(gen_window);
		read_into_working();
		for(i = 0; i < worksize; i++)
		{
			if(working[i] != missing_value && working[i] > 0.0) working[i] = log(working[i]);
		}
		write_from_working();
		fl_unfreeze_form(gen_window);			
	}
	if(arg == 52)
	{
		fl_freeze_form(gen_window);
		read_into_working();
		for(i = worksize - 1; i > 0; i--)
		{
			working[i] = working[i-1];
		}
		working[0] = missing_value;
		write_from_working();
		fl_unfreeze_form(gen_window);			
	}
	if(arg == 53)
	{
		fl_freeze_form(gen_window);
		fl_clear_browser(gen_data_browser);
		for(i = fl_get_counter_value(gen_from_counter) - 1; i < fl_get_counter_value(gen_to_counter); i++)	
		{
			scratch = rand() % 1000;
			scratch = scratch / 1000;
			sprintf(string_one,"%f", scratch);
			fl_addto_browser(gen_data_browser, string_one);
		}
		fl_unfreeze_form(gen_window);
	}
	if(arg == 54)
	{
		fl_freeze_form(gen_window);
		fl_clear_browser(gen_data_browser);
		for(i = fl_get_counter_value(gen_from_counter) - 1; i < fl_get_counter_value(gen_to_counter); i++)	
		{
			sprintf(string_one,"%f", missing_value);
			fl_addto_browser(gen_data_browser, string_one);
		}
		fl_unfreeze_form(gen_window);
		gen_exists = FALSE;
	}
	if(arg == 55)
	{
		fl_freeze_form(gen_window);
		scratch = 0;
		worksize = 0;
		for(i = fl_get_counter_value(gen_from_counter) - 1; i < fl_get_counter_value(gen_to_counter); i++)	
		{
			working[worksize] = atof(fl_get_browser_line(gen_data_browser,i+1));
			if(working[worksize] != missing_value) scratch = scratch + working[worksize];
			worksize++;

		}
		if(scratch != 0.0)
		{
			fl_clear_browser(gen_data_browser);
			worksize = 0;
			for(i = fl_get_counter_value(gen_from_counter) - 1; i < fl_get_counter_value(gen_to_counter); i++)	
			{
				if(working[worksize] != missing_value) sprintf(string_one,"%f", (working[worksize] / scratch) * 100);
				else sprintf(string_one,"%f", working[worksize]);
				fl_addto_browser(gen_data_browser, string_one);
				worksize++;
			}
		}
		fl_unfreeze_form(gen_window);
	}
	if(arg == 56)
	{
		fl_freeze_form(gen_window);
		worksize = 0;
		for(i = fl_get_counter_value(gen_from_counter) - 1; i < fl_get_counter_value(gen_to_counter); i++)	
		{
			working[worksize] = i+1;
			worksize++;
		}
		write_from_working();
		fl_unfreeze_form(gen_window);			
	}
	if(arg == 57)
	{
		fl_freeze_form(gen_window);
		worksize = 0;
		read_into_working();
		for(i = worksize - 1; i > 0; i--)
		{
			
			if(working[i] != missing_value && working[i-1] != missing_value) working[i] = working[i] - working[i-1];
			else working[i] = missing_value;
		}
		working[0] = missing_value;
		write_from_working();
		fl_unfreeze_form(gen_window);			
	}
	if(arg == 58)
	{
		fl_freeze_form(gen_window);
		fl_clear_browser(gen_data_browser);
		for(i = fl_get_counter_value(gen_from_counter) - 1; i < fl_get_counter_value(gen_to_counter); i++)	
		{
			sprintf(string_one,"%f", 0.0);
			fl_addto_browser(gen_data_browser, string_one);
		}
		fl_unfreeze_form(gen_window);
		gen_exists = FALSE;
	}
	if(arg == 59)
	{
		fl_freeze_form(gen_window);
		read_into_working();
		for(i = 0; i < worksize; i++)
		{
			if(working[i] != missing_value && working[i] > 0.0) working[i] = pow(working[i], 0.5);
		}
		write_from_working();
		fl_unfreeze_form(gen_window);
	}
	if(arg == 60)
	{
		fl_freeze_form(gen_window);
		read_into_working();
		for(i = 0; i < worksize; i++)
		{
			if(working[i] != missing_value) working[i] = pow(working[i], 2.0);
		}
		write_from_working();
		fl_unfreeze_form(gen_window);			
	}
}

void start_gen()
{
	int i;
	int largest;
	say_status("Doing Math");
	inhibit_input();
	largest = 0;
	fl_clear_choice(gen_var_choice);
	fl_addto_choice(gen_var_choice,"(current)");
	for(i = 0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_choice(gen_var_choice,data_matrix[i].name);
	}
	if(largest == 0) largest = 1;
	fl_set_counter_value(gen_from_counter, 1);
	all_start = 1;
	fl_set_counter_value(gen_to_counter, largest);
	all_stop = largest;
	fl_clear_browser(gen_data_browser);
	for(i = 0; i < largest; i++)
	{
		fl_addto_browser(gen_data_browser,"0.000000");
	}
	math_construct.operator = 1;
	math_construct.argument_type = 0;
	strcpy(math_construct.float_argument,"");
	math_construct.variable_argument = -1;
	math_construct.variable_lag = 0;
	gen_exists = FALSE;
	if(window_geometry[XLDLAS_GENERATE][0] != -1)
	{
		fl_set_form_geometry(gen_window, 
					window_geometry[XLDLAS_GENERATE][0],
					window_geometry[XLDLAS_GENERATE][1],
					window_geometry[XLDLAS_GENERATE][2],
					window_geometry[XLDLAS_GENERATE][3]);
	}	
	fl_show_form(gen_window,FL_PLACE_FREE,FL_FULLBORDER,"Do Some Math");
	show_math_construct();
}