/*      -------------------------------------------------------------------
	xldlas -- A Stastics Package

	Copyright (C) 1996 Thor Sigvaldason

	This file includes all the routines accessed from the 
	analysis menu, including regress, GA fit, and NN fit.
	
        -------------------------------------------------------------------*/

#include "xldlas.h"

/*
	Need the following for XFree86/2 as M_E is not defined
	in math.h
*/
#ifdef __EMX__
#include <float.h>
#endif
 

extern void simple_line_output(char which_routine[XLDLASMAX_INPUT], char the_output[XLDLASMAX_INPUT]);
extern void begin_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void add_column_output(char the_output[XLDLASMAX_INPUT], int justify);
extern void end_column_output();
extern void seperator_output(int how_many);
extern void begin_table_output(int how_many, char title[XLDLASMAX_INPUT]);
extern void end_table_output(int how_many);
extern void filter_tex_specials(char input_string[XLDLASMAX_INPUT]);

extern void inhibit_input();
extern void reenable_input();

extern int check_variable_name(char proposed[XLDLASMAX_INPUT]);

extern void say_status(char the_status[XLDLASMAX_INPUT]);

extern void sync_graph_browsers(int type);

void inhibit_nn_input()
{
	fl_deactivate_object(nnet_input_browser);
	fl_set_object_lcol(nnet_input_browser, FL_INACTIVE);
	fl_deactivate_object(nnet_hidden_counter);
	fl_set_object_lcol(nnet_hidden_counter, FL_INACTIVE);
	fl_deactivate_object(nnet_output_browser);
	fl_set_object_lcol(nnet_output_browser, FL_INACTIVE);
	fl_deactivate_object(nnet_from_counter);
	fl_set_object_lcol(nnet_from_counter, FL_INACTIVE);
	fl_deactivate_object(nnet_to_counter);
	fl_set_object_lcol(nnet_to_counter, FL_INACTIVE);
	fl_deactivate_object(nnet_variable_input);
	fl_set_object_lcol(nnet_variable_input, FL_INACTIVE);
	fl_deactivate_object(nnet_overwrite_button);
	fl_set_object_lcol(nnet_overwrite_button, FL_INACTIVE);
	fl_deactivate_object(nnet_go_button);
	fl_set_object_lcol(nnet_go_button, FL_INACTIVE);
	fl_deactivate_object(nnet_done_button);
	fl_set_object_lcol(nnet_done_button, FL_INACTIVE);

}

void reenable_nn_input()
{
	fl_activate_object(nnet_input_browser);
	fl_set_object_lcol(nnet_input_browser, FL_BLACK);
	fl_activate_object(nnet_hidden_counter);
	fl_set_object_lcol(nnet_hidden_counter, FL_BLACK);
	fl_activate_object(nnet_output_browser);
	fl_set_object_lcol(nnet_output_browser, FL_BLACK);
	fl_activate_object(nnet_from_counter);
	fl_set_object_lcol(nnet_from_counter, FL_BLACK);
	fl_activate_object(nnet_to_counter);
	fl_set_object_lcol(nnet_to_counter, FL_BLACK);
	fl_activate_object(nnet_variable_input);
	fl_set_object_lcol(nnet_variable_input, FL_BLACK);
	fl_activate_object(nnet_overwrite_button);
	fl_set_object_lcol(nnet_overwrite_button, FL_BLACK);
	fl_activate_object(nnet_go_button);
	fl_set_object_lcol(nnet_go_button, FL_BLACK);
	fl_activate_object(nnet_done_button);
	fl_set_object_lcol(nnet_done_button, FL_BLACK);

}

float squasher_function(float the_input)
{
	if(nn_squash == 1)
	{
		if(the_input < 0.0) return(0.0);
		return(1.0);
	}
	if(nn_squash == 2)
	{
		if(the_input < -1.0) return(0.0);
		if(the_input < 1.0) return((the_input + 1.0) / 2.0);
		return(1.0);
	}
	if(nn_squash == 3)
	{
		return(1.0/(1.0 + pow(M_E,(-1.0 * the_input))));
	}
	fl_show_alert("Reached Somewhere we weren't supposed to", "Please tell the author how you did that!","", TRUE);
	return(1.0);
}

float simulated_annealing(float the_input, int current_cycle, int total_cycles)
{
	float scratch;
	if(nn_annealing == FALSE)
	{
		return(the_input);
	}
	scratch = rand() % 2000;
	scratch = scratch / 1000 - 1.0;
	scratch = (scratch / (total_cycles - current_cycle)) * nn_learn;
	return(the_input + scratch);
}

int do_nnet()
{
	int output_variable;
	int to_nnet[MAX_VARS], input_number;
	int i,j,k,l;
	int length;
	float scratch;
	float largest, smallest;
	float input_smallest[MAX_VARS];
	float input_largest[MAX_VARS];
	float *bigmatrix[MAX_VARS];
	char string_one[XLDLASMAX_INPUT];
	float hidden_layer[MAX_VARS];
	float output_layer;
	float output_bias;
	float in_to_hid_weights[MAX_VARS][MAX_VARS];
	float in_to_out_weights[MAX_VARS];
	float hid_to_out_weights[MAX_VARS];
	float hidden_bias[MAX_VARS];
	float error_signal;
	float hidden_errors[MAX_VARS];
	float average_error;
	int to_write, fit_type;
	int ok_to_write;
	inhibit_nn_input();
	output_variable = -1;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(nnet_output_browser, i+1))
		{
			output_variable = i;
			i = numb_variables;
		}
	}
	if(output_variable == -1)
	{
		fl_show_alert("No Output Variable Selected","","",TRUE);
		return(-1);
	}
	input_number = 0;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(nnet_input_browser, i+1) && i != output_variable)
		{
			to_nnet[input_number] = i;
			input_number++;
		}
	}
	if(input_number == 0)
	{
		fl_show_alert("No Input Variable(s) Selected","","",TRUE);
		return(-1);
	}
	all_start = fl_get_counter_value(nnet_from_counter);
	all_stop = fl_get_counter_value(nnet_to_counter);
	if(all_stop < all_start)
	{
		fl_show_alert("From Value greater than To Value","","",TRUE);
		return(-1);
	}
	for(i = all_start - 1; i < all_stop; i++)
	{
		if(i < data_matrix[output_variable].obs)
		{
			working[i - (all_start - 1)] = *(fvector[output_variable] + i);
		}
		else
		{
			working[i - (all_start - 1)] = missing_value;
		}
	}
	length = all_stop - (all_start - 1);
	for(i = 0; i < input_number; i++)
	{
		bigmatrix[i] = (float *) malloc (length * sizeof (float));
		if(!bigmatrix[i])
		{
			fl_show_alert("Not Enough Memory to Build Neural Net Matrix", "Man, that sounds like something from Star Trek!","", TRUE);
			return(-1);
		}
	}
	say_status("Building Neural Net Matrix..");
	for(i = 0; i < input_number; i++)
	{
		for(j = all_start - 1; j < all_stop; j++)
		{
			if(j < data_matrix[to_nnet[i]].obs)
			{
				*(bigmatrix[i] + j - (all_start - 1)) = *(fvector[to_nnet[i]] + j);
			}
			else
			{
				*(bigmatrix[i] + j - (all_start - 1)) = missing_value;
			}
		}
	}
	say_status("Zapping Missing Elements");
	for(i = 0; i < length; i++)
	{
		if(working[i] == missing_value)
		{
			for(j = i; j < length - 1; j++)
			{
				working[j] = working[j+1];
			}
			for(j = 0; j < input_number; j++)
			{
				for(k = i; k < length - 1; k++)
				{
					*(bigmatrix[j] + k) = *(bigmatrix[j] + k + 1);
				}
			}
			length--;
			if(length < 1)
			{
				fl_show_alert("No set of observations without missing values!","","",TRUE);
				for(j = 0; j < input_number; j++)
				{
					free(bigmatrix[j]);
				}
				return(-1);
			}
			i--;
		}
	}
	for(i = 0; i < input_number; i++)
	{
		for(j = 0; j < length; j++)
		{
			if(*(bigmatrix[i] + j) == missing_value)
			{
				for(k = 0; k < input_number; k++)
				{
					for(l = j; l < length - 1; l++)
					{
						*(bigmatrix[k] + l) = *(bigmatrix[k] + l + 1);
					}
				}
				for(k = j; k < length - 1; k++)
				{
					working[k] = working[k+1];
				}
				length--;
				if(length < 1)
				{
					fl_show_alert("No set of observations without missing values!","","",TRUE);
					for(j = 0; j < input_number; j++)
					{
						free(bigmatrix[j]);
					}
					return(-1);
				}
				j--;
			}
			
		}
	}
	smallest = working[0];
	largest = working[0];


	say_status("Converting to 0-1");
	for(i = 0; i < input_number; i++)
	{
		input_smallest[i] = *(bigmatrix[i]);
		input_largest[i] = *(bigmatrix[i]);
		for(j = 0; j < length; j++)
		{
			if(input_smallest[i] > *(bigmatrix[i] + j)) input_smallest[i] = *(bigmatrix[i] + j);
			if(input_largest[i] < *(bigmatrix[i] + j)) input_largest[i] = *(bigmatrix[i] + j);
		}
		if(input_smallest[i] < input_largest[i])
		{
			for(j = 0; j < length; j++)
			{
				*(bigmatrix[i] + j) = (*(bigmatrix[i] + j) - input_smallest[i]) / (input_largest[i] - input_smallest[i]);
			}
		}
		else
		{
			sprintf(string_one,"%s", data_matrix[to_nnet[i]].name);
			fl_show_alert("Warning: No variation in the following variable", string_one,"", TRUE);
			return(-1);
		}
	}
	for(i = 0; i < length; i++)
	{
		if(smallest > working[i]) smallest = working[i];
		if(largest < working[i]) largest = working[i];
	}
	if(smallest < largest)
	{
		for(i = 0; i < length; i++)
		{
			working[i] = (working[i] - smallest) / (largest - smallest);
		}
	}
	else
	{
		fl_show_alert("No Variation in Output Variable","","",TRUE);
		return(-1);
	}
		
	for(i = 0; i < input_number; i++)
	{
		for(j = 0; j < nn_hidden; j++)
		{
			in_to_hid_weights[i][j] = rand() % 2000;
			in_to_hid_weights[i][j] = in_to_hid_weights[i][j] / 1000.0 - 1.0;
		}
		in_to_out_weights[i] = rand() % 2000;
		in_to_out_weights[i] = in_to_out_weights[i] / 1000.0 - 1.0;
	}
	for(i = 0; i < nn_hidden; i++)
	{
		hid_to_out_weights[i] = rand() % 2000;
		hid_to_out_weights[i] = hid_to_out_weights[i] / 1000.0 - 1.0;
		hidden_bias[i] = rand() % 2000;
		hidden_bias[i] = hidden_bias[i] / 1000.0 - 1.0;
	}
	output_layer = 0.0;
	average_error = 0.0;
	output_bias = rand() % 2000;
	output_bias = output_bias / 1000.0 - 1.0;
	fl_clear_chart(do_nnet_chart);
	fl_set_chart_maxnumb(do_nnet_chart,50);
	say_status("Fitting Neural Network...");
	fl_show_form(do_nnet_window,FL_PLACE_FREE,FL_FULLBORDER,"Fitting Neural Network");
	general_abort = FALSE;
	for(i = 0; i < nn_cycles; i++)
	{
		average_error = 0.0;
		for(j = 0; j < length; j++)
		{
			for(k = 0; k < nn_hidden; k++)
			{
				hidden_layer[k] = hidden_bias[k];
				for(l = 0; l < input_number; l++)
				{
					hidden_layer[k] = hidden_layer[k] + (in_to_hid_weights[l][k] * (*(bigmatrix[l] + j)));
				}
				hidden_layer[k] = squasher_function(hidden_layer[k]);
			}
			output_layer = output_bias;
			for(k = 0; k < input_number; k++)
			{
				output_layer = output_layer + (in_to_out_weights[k] * (*(bigmatrix[k] + j)));
			}
			for(k = 0; k < nn_hidden; k++)
			{
				output_layer = output_layer + (hid_to_out_weights[k] * hidden_layer[k]);
			}
			output_layer = squasher_function(output_layer);
			error_signal = (working[j] - output_layer) * output_layer * (1.0 - output_layer);
			for(k = 0; k < input_number; k++)
			{
				in_to_out_weights[k] = in_to_out_weights[k] + (error_signal * nn_learn * (*(bigmatrix[k] + j)));
				in_to_out_weights[k] = simulated_annealing(in_to_out_weights[k], i, nn_cycles);
			}
			output_bias = output_bias + (error_signal * nn_learn);
			output_bias = simulated_annealing(output_bias, i, nn_cycles);
			for(k = 0; k < nn_hidden; k++)
			{
				hidden_errors[k] = hidden_layer[k] * (1.0 - hidden_layer[k]) * error_signal * hid_to_out_weights[k];
				hid_to_out_weights[k] = hid_to_out_weights[k] + (error_signal * nn_learn * hidden_layer[k]);
				hid_to_out_weights[k] = simulated_annealing(hid_to_out_weights[k], i, nn_cycles);
			}
			for(k = 0; k < input_number; k++)
			{
				for(l = 0; l < nn_hidden; l++)
				{
					in_to_hid_weights[k][l] = in_to_hid_weights[k][l] + (nn_learn * hidden_errors[l] * (*(bigmatrix[k] + l)));
					in_to_hid_weights[k][l] = simulated_annealing(in_to_hid_weights[k][l], i, nn_cycles);
				}
			}
			for(k = 0; k < nn_hidden; k++)
			{
				hidden_bias[k] = hidden_bias[k] + (nn_learn * hidden_errors[k]);
				hidden_bias[k] = simulated_annealing(hidden_bias[k],i,nn_cycles);
			}
			average_error = average_error + fabs(output_layer - working[j]);
		}
		average_error = average_error / length;
		sprintf(string_one,"%d,%16.14f",i,average_error);
		fl_clear_browser(do_nnet_browser);
		fl_addto_browser(do_nnet_browser,string_one);
		fl_add_chart_value(do_nnet_chart, average_error,"",FL_RED);
		fl_check_forms();
		if(general_abort == TRUE) return(0);
	}
	sprintf(string_one, "Output Variable: %s",data_matrix[output_variable].name);
	simple_line_output("nnfit", string_one);
	strcpy(string_one,"Input Variable(s): ");
	for(i = 0; i < input_number; i++)
	{
		strcat(string_one, data_matrix[to_nnet[i]].name);
		if(i < input_number - 1)
		{
			strcat(string_one,", ");
		}
	}
	simple_line_output("nnfit",string_one);	
	begin_table_output(2, "NN Fit: Settings Used");
	begin_column_output("Squasher Function   ", XLDLAS_JUST_CENTER);
	if(nn_squash == 1) add_column_output("step", XLDLAS_JUST_CENTER);
	if(nn_squash == 2) add_column_output("straight", XLDLAS_JUST_CENTER);
	if(nn_squash == 3) add_column_output("sigmoid", XLDLAS_JUST_CENTER);
	end_column_output();
	begin_column_output("Simulated Annealing ", XLDLAS_JUST_CENTER);
	if(nn_annealing == TRUE) add_column_output("On", XLDLAS_JUST_CENTER);
	if(nn_annealing == FALSE) add_column_output("Off", XLDLAS_JUST_CENTER);
	end_column_output();
	begin_column_output("Number of Cycles    ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%d", nn_cycles);
	add_column_output(string_one,XLDLAS_JUST_CENTER);
	end_column_output();
	begin_column_output("Observations        ", XLDLAS_JUST_CENTER);
	sprintf(string_one, "%d", length);
	add_column_output(string_one, XLDLAS_JUST_CENTER);
	end_column_output();
	begin_column_output("Input Layer Nodes   ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%d", input_number);
	add_column_output(string_one, XLDLAS_JUST_CENTER);
	end_column_output();
	begin_column_output("Hidden Layer Nodes  ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%d", nn_hidden);
	add_column_output(string_one, XLDLAS_JUST_CENTER);
	end_column_output();
	begin_column_output("Final Error         ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%f", average_error);
	add_column_output(string_one, XLDLAS_JUST_CENTER);
	end_column_output();
	end_table_output(2);


	begin_table_output(nn_hidden+2,"NN Fit: Weights");
	begin_column_output("              ", XLDLAS_JUST_CENTER);
	for(i = 0; i < nn_hidden; i++)
	{
		sprintf(string_one,"           H%2d", i+1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
	}
	sprintf(string_one,"%14s", data_matrix[output_variable].name);
	add_column_output(string_one, XLDLAS_JUST_CENTER);
	end_column_output();
	seperator_output(nn_hidden+2);
	begin_column_output("          BIAS", XLDLAS_JUST_RIGHT);
	for(i = 0; i < nn_hidden; i++)
	{
		sprintf(string_one,"%14f", hidden_bias[i]);
		add_column_output(string_one,XLDLAS_JUST_RIGHT);
	}
	sprintf(string_one,"%14f", output_bias);
	add_column_output(string_one,XLDLAS_JUST_RIGHT);
	end_column_output();
	seperator_output(nn_hidden+2);
	for(i = 0; i < input_number; i++)
	{
		sprintf(string_one,"%14s", data_matrix[to_nnet[i]].name);
		begin_column_output(string_one, XLDLAS_JUST_RIGHT);
		for(j = 0; j < nn_hidden; j++)
		{
			sprintf(string_one,"%14f", in_to_hid_weights[i][j]);
			add_column_output(string_one, XLDLAS_JUST_RIGHT);
		}
		sprintf(string_one,"%14f", in_to_out_weights[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
	}
	seperator_output(nn_hidden+2);
	sprintf(string_one,"%14s", data_matrix[output_variable].name);
	begin_column_output(string_one, XLDLAS_JUST_RIGHT);
	for(i = 0; i < nn_hidden; i++)
	{
		sprintf(string_one,"%14f", hid_to_out_weights[i]);
		add_column_output(string_one,XLDLAS_JUST_CENTER);
	}
	add_column_output("  ", XLDLAS_JUST_CENTER);
	end_column_output();
	end_table_output(2+nn_hidden);

	strcpy(string_one,fl_get_input(nnet_variable_input));
	to_write = -1;
	fit_type = 3;
	if(strlen(string_one) > 0)
	{
		if(check_variable_name(string_one) == FALSE && fl_get_button(nnet_overwrite_button) == FALSE)
		{
			fl_show_alert("Variable Already Exists","","",TRUE);
			return(0);
		}
		if(check_variable_name(string_one) == FALSE)
		{
			
			for(i = 0; i < numb_variables; i++)
			{
				if(strcmp(data_matrix[i].name,string_one) == 0)
				{
					to_write = i;
					free(fvector[i]);
				}
			}
			fit_type = 1;
		}
		else
		{
			if(numb_variables == MAX_VARS)
			{
				fl_show_alert("No more Space left to Add Variables","","",TRUE);
				return(0);
			}
			to_write = numb_variables;
			numb_variables++;
			fit_type = 0;
		}
		fvector[to_write] = (float *) malloc (MAX_OBS * sizeof (float));
		if(!fvector[to_write])
		{
			fl_show_alert("Not enough Memory to Save Fitted Values","","",TRUE);
			return(0);
		}
		strcpy(data_matrix[to_write].name, string_one);
		strcpy(data_matrix[to_write].description, "Fitted Values from NN Fit");
		data_matrix[to_write].obs = all_stop;
		for(i = 0; i < all_start - 1; i++)
		{
			*(fvector[to_write] + i) = missing_value;
		}
		for(i = all_start - 1; i < all_stop; i++)
		{
			ok_to_write = TRUE;
			for(j = 0; j < input_number; j++)
			{
				if(*(fvector[to_nnet[j]] + i) == missing_value) ok_to_write = FALSE;
			}
			if(ok_to_write == FALSE)
			{
				*(fvector[to_write] + i) = missing_value;
			}
			else
			{
				for(k = 0; k < nn_hidden; k++)
				{
					hidden_layer[k] = hidden_bias[k];
					for(l = 0; l < input_number; l++)
					{
						hidden_layer[k] = hidden_layer[k] + in_to_hid_weights[l][k] * ((*(fvector[to_nnet[l]] + i) - input_smallest[l])/(input_largest[l] - input_smallest[l]));
					}
				}
				output_layer = output_bias;
				for(k = 0; k < nn_hidden; k++)
				{
					hidden_layer[k] = squasher_function(hidden_layer[k]);
					output_layer = output_layer + hid_to_out_weights[k] * hidden_layer[k];
				}
				for(k = 0; k < input_number; k++)
				{
					output_layer = output_layer + in_to_out_weights[k] * ((*(fvector[to_nnet[k]] + i) - input_smallest[k])/(input_largest[k] - input_smallest[k]));
				}
				output_layer = squasher_function(output_layer);
				*(fvector[to_write] + i) = smallest + (output_layer * (largest - smallest));
			}
		}
		sprintf(string_one, "%d observations fitted to %s", all_stop - (all_start - 1), data_matrix[to_write].name);
		simple_line_output("nnfit", string_one);
		oktoquit = FALSE;
		sync_graph_browsers(fit_type);
	}
	if(nn_pictex == TRUE && texlog_on == TRUE)
	{
		say_status("Writing PiCTeX Macros to TeXLog");
		fprintf(texlog_file,"\n%%\n%%   PiCTeX Macros for Fitted Neural Network\n%%\n\n");
		fprintf(texlog_file,"\\midinsert\n");
		fprintf(texlog_file,"\\line \\bgroup \\hss\n");
		fprintf(texlog_file,"\\beginpicture\n");
		fprintf(texlog_file,"\\setcoordinatesystem units <0.25in,0.25in>\n");
		fprintf(texlog_file,"\\setsolid\n");
		fprintf(texlog_file,"%%\n%% Change the above two coordinate numbers to scale the image\n%%\n");
		for(i = 0; i < input_number; i++)
		{
			fprintf(texlog_file,"\\putrectangle corners at %d %d and %d %d\n", i*4, 1, i*4+1, 0);
			fprintf(texlog_file,"\\put {$I_%d$} at %f %f\n", i+1, (i*4) + 0.5, 0.5);
			filter_tex_specials(data_matrix[to_nnet[i]].name);
			fprintf(texlog_file,"\\put {\\sevenrm %s} at %f %f\n", filtered_tex_string, (i*4) + 0.5, -0.5);
			fprintf(texlog_file,"\\putrule from %f %f to %f %f\n", i*4 + 0.5,0.0,i*4 + 0.5, -0.2);
		}
		scratch = ((((input_number + 1.0) * 4.0) - 1.0)/2) + 0.5 - (((nn_hidden + 1.0) * 4.0) / 2.0);
		for(i = 0; i < nn_hidden; i++)
		{
			
			fprintf(texlog_file,"\\putrectangle corners at %f %d and %f %d\n", scratch + (i*4), 5, scratch + (i*4)+1, 4);
			fprintf(texlog_file,"\\put {$H_%d$} at %f %f\n", i+1, scratch + (i*4) + 0.5, 4.5);
			fprintf(texlog_file,"\\put {\\sevenrm %f} [l] at %f %f\n", hidden_bias[i], scratch + (i*4) + 1.5, 4.5);
			fprintf(texlog_file,"\\putrule from %f %f to %f %f\n", scratch + (i*4) + 1.0, 4.5, scratch + (i*4) + 1.2, 4.5);
		}
		scratch = ((((input_number + 1.0) * 4.0) - 1.0)/2) - 3.5;
		fprintf(texlog_file,"\\putrectangle corners at %f %d and %f %d\n", scratch, 9, scratch + 1.0, 8);
		fprintf(texlog_file,"\\put {$O_1$} at %f %f\n", scratch + 0.5, 8.5);
		fprintf(texlog_file,"\\put {\\sevenrm %f} [l] at %f %f\n", output_bias, scratch + 1.5, 8.5);
		fprintf(texlog_file,"\\putrule from %f %f to %f %f\n", scratch + 1.0, 8.5, scratch + 1.2, 8.5);
		filter_tex_specials(data_matrix[output_variable].name);
		fprintf(texlog_file,"\\put {\\sevenrm %s} at %f %f\n", filtered_tex_string, scratch + 0.5, 9.5);
		fprintf(texlog_file,"\\putrule from %f %f to %f %f\n", scratch + 0.5, 9.0, scratch + 0.5, 9.2);
		fprintf(texlog_file,"%%\n%%   The next code segment draws the input to hidden weights\n%%   (It can safely be deleted for clarity)\n%%\n");
		fprintf(texlog_file,"\\setlinear\n");
		scratch = ((((input_number + 1.0) * 4.0) - 1.0)/2) + 0.5 - (((nn_hidden + 1.0) * 4.0) / 2.0);
		for(i = 0; i < input_number; i++)
		{
			for(j = 0; j < nn_hidden; j++)
			{
				fprintf(texlog_file,"\\plot %f %f %f %f /\n", i*4 + 0.5, 1.0, scratch + (j*4) + 0.5, 4.0);
			}
		} 
		fprintf(texlog_file,"%%\n%%   This segment draws the hidden to output weights\n%%   (It can safely be deleted for clarity)\n%%\n");
		for(i = 0; i < nn_hidden; i++)
		{
			fprintf(texlog_file,"\\plot %f %f %f %f /\n", scratch + (i * 4) + 0.5, 5.0, ((((input_number + 1.0) * 4.0) - 1.0)/2) - 3.0, 8.0);
		}
		fprintf(texlog_file,"%%\n%%   Finally, we draw the input to output weights\n%%   (This will often need to be deleted for clarity)\n%%\n");
		fprintf(texlog_file, "\\setdots\n");
		scratch = ((((input_number + 1.0) * 4.0) - 1.0)/2) - 3.0;
		for(i = 0; i < input_number; i++)
		{
			fprintf(texlog_file,"\\plot %f %f %f %f /\n", (i*4) + 0.5, 1.0, scratch, 8.0);
		}
		fprintf(texlog_file,"\\endpicture\n");
		fprintf(texlog_file,"\\hss\\egroup\n");
		fprintf(texlog_file,"\\bigskip\n");
		fprintf(texlog_file,"\\endinsert\n");
	}
	return(0);
}

void handle_nnet_buttons(FL_OBJECT *obj, long arg)
{
	if(arg == 0)
	{
		window_geometry[XLDLAS_NNFIT][0] = obj->form->x;
		window_geometry[XLDLAS_NNFIT][1] = obj->form->y;
		window_geometry[XLDLAS_NNFIT][2] = obj->form->w;
		window_geometry[XLDLAS_NNFIT][3] = obj->form->h;
		reenable_input();
		fl_hide_form(nnet_window);
		say_status("Ready");
	}
	if(arg == 1)
	{
		if(do_nnet() == 0)
		{
			fl_hide_form(do_nnet_window);		
			reenable_nn_input();
			say_status("Waiting for Variables for Neural Network");
		}
		else
		{
			reenable_nn_input();
			say_status("Waiting for Variables for Neural Network");
		}
	}
	if(arg == 3)
	{
		nn_cycles = fl_get_counter_value(nnet_cycles_counter);
	}
	if(arg == 4)
	{
		nn_learn = fl_get_counter_value(nnet_learn_counter);
	}
	if(arg == 5)
	{
		nn_hidden = fl_get_counter_value(nnet_hidden_counter);	
	}
	if(arg == 10)
	{
		nn_annealing = fl_get_button(nnet_annealing_button);
	}
	if(arg > 10 && arg < 14)
	{
		nn_squash = arg - 10;
	}
	if(arg == 15)
	{
		nn_pictex = fl_get_button(nnet_pictex_button);
	}
}

void start_nnet()
{
	int i, largest;
	inhibit_input();
	fl_clear_browser(nnet_input_browser);
	fl_clear_browser(nnet_output_browser);
	largest = 1;
	for(i = 0; i < numb_variables; i++)
	{
		if(largest < data_matrix[i].obs) largest = data_matrix[i].obs;
		fl_addto_browser(nnet_input_browser, data_matrix[i].name);
		fl_addto_browser(nnet_output_browser, data_matrix[i].name);
	}
	if(nn_squash == 1)
	{
		fl_set_button(nnet_step_button, 1);
		fl_set_button(nnet_straight_button, 0);
		fl_set_button(nnet_sigmoid_button, 0);
	}
	if(nn_squash == 2)
	{
		fl_set_button(nnet_step_button, 0);
		fl_set_button(nnet_straight_button, 1);
		fl_set_button(nnet_sigmoid_button, 0);
	}
	if(nn_squash == 3)
	{
		fl_set_button(nnet_step_button, 0);
		fl_set_button(nnet_straight_button, 0);
		fl_set_button(nnet_sigmoid_button, 1);
	}
	fl_set_button(nnet_annealing_button, nn_annealing);
	if(texlog_on == TRUE)
	{
		fl_set_button(nnet_pictex_button, nn_pictex);
		fl_activate_object(nnet_pictex_button);
		fl_set_object_lcol(nnet_pictex_button, FL_BLACK);
	}
	else
	{
		fl_set_button(nnet_pictex_button, 0);
		fl_deactivate_object(nnet_pictex_button);
		fl_set_object_lcol(nnet_pictex_button, FL_INACTIVE);
	}
	fl_set_counter_value(nnet_cycles_counter, nn_cycles);
	fl_set_counter_value(nnet_hidden_counter, nn_hidden);
	fl_set_counter_value(nnet_learn_counter, nn_learn);
	fl_set_counter_value(nnet_from_counter, 1);
	fl_set_counter_bounds(nnet_from_counter, 1, largest);
	fl_set_counter_bounds(nnet_learn_counter, 0, 20.0);
	fl_set_counter_bounds(nnet_cycles_counter, 0, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_value(nnet_to_counter, largest);
	fl_set_counter_bounds(nnet_to_counter, 1, largest);
	say_status("Waiting for Variables for Neural Network");
	if(window_geometry[XLDLAS_NNFIT][0] != -1)
	{
		fl_set_form_geometry(nnet_window, 
					window_geometry[XLDLAS_NNFIT][0],
					window_geometry[XLDLAS_NNFIT][1],
					window_geometry[XLDLAS_NNFIT][2],
					window_geometry[XLDLAS_NNFIT][3]);
	}	
	fl_show_form(nnet_window,FL_PLACE_FREE,FL_FULLBORDER,"Neural Network Fit");
}

void handle_anova_buttons(FL_OBJECT *obj, long arg)
{
	if(arg == 1)
	{
		anova_type = 1;
		fl_deactivate_object(anova_block_browser);
		fl_set_object_lcol(anova_block_browser, FL_INACTIVE);
		fl_deactivate_object(anova_block_counter);
		fl_set_object_lcol(anova_block_counter, FL_INACTIVE);
		fl_set_button(anova_one_button, 1);
		fl_set_button(anova_two_button, 0);
	}
	if(arg == 2)
	{
		anova_type = 2;
		fl_activate_object(anova_block_browser);
		fl_set_object_lcol(anova_block_browser, FL_BLACK);
		fl_activate_object(anova_block_counter);
		fl_set_object_lcol(anova_block_counter, FL_BLACK);
		fl_set_button(anova_one_button, 0);
		fl_set_button(anova_two_button, 1);
	}
}

void done_anova(FL_OBJECT *obj, long arg)
{
	window_geometry[XLDLAS_ANOVA][0] = obj->form->x;
	window_geometry[XLDLAS_ANOVA][1] = obj->form->y;
	window_geometry[XLDLAS_ANOVA][2] = obj->form->w;
	window_geometry[XLDLAS_ANOVA][3] = obj->form->h;
	fl_hide_form(anova_window);
	reenable_input();
	say_status("Ready");
}

int click_done_anova(FL_FORM *form, void *arg)
{
	window_geometry[XLDLAS_ANOVA][0] = form->x;
	window_geometry[XLDLAS_ANOVA][1] = form->y;
	window_geometry[XLDLAS_ANOVA][2] = form->w;
	window_geometry[XLDLAS_ANOVA][3] = form->h;
	reenable_input();
	say_status("Ready");
	return(FL_OK);
}

int click_done_nnet(FL_FORM *form, void *arg)
{
	window_geometry[XLDLAS_NNFIT][0] = form->x;
	window_geometry[XLDLAS_NNFIT][1] = form->y;
	window_geometry[XLDLAS_NNFIT][2] = form->w;
	window_geometry[XLDLAS_NNFIT][3] = form->h;
	reenable_input();
	say_status("Ready");
	return(FL_OK);
}


void start_anova()
{
	int i, largest;
	inhibit_input();
	largest = 0;
	fl_clear_browser(anova_block_browser);
	fl_clear_browser(anova_variable_browser);
	for(i = 0; i < numb_variables; i++)
	{
		if(largest < data_matrix[i].obs) largest = data_matrix[i].obs;
		fl_addto_browser(anova_block_browser,data_matrix[i].name);
		fl_addto_browser(anova_variable_browser,data_matrix[i].name);
	}
	fl_set_counter_value(anova_from_counter, 1);
	fl_set_counter_bounds(anova_from_counter, 1, largest);
	fl_set_counter_value(anova_to_counter, largest);
	fl_set_counter_bounds(anova_to_counter, 1, largest);
	fl_set_counter_value(anova_block_counter, 5);
	fl_set_counter_bounds(anova_block_counter, 1, MAX_VARS);

	fl_set_button(anova_one_button, 0);
	fl_set_button(anova_two_button, 0);
	if(anova_type == 1)
	{
		fl_deactivate_object(anova_block_browser);
		fl_set_object_lcol(anova_block_browser, FL_INACTIVE);
		fl_deactivate_object(anova_block_counter);
		fl_set_object_lcol(anova_block_counter, FL_INACTIVE);
		fl_set_button(anova_one_button, 1);
	}
	else
	{
		fl_activate_object(anova_block_browser);
		fl_set_object_lcol(anova_block_browser, FL_BLACK);
		fl_activate_object(anova_block_counter);
		fl_set_object_lcol(anova_block_counter, FL_BLACK);
		fl_set_button(anova_two_button, 1);
	}
	
	say_status("Waiting for Variable/Type selection to do ANOVA");
	if(window_geometry[XLDLAS_ANOVA][0] != -1)
	{
		fl_set_form_geometry(anova_window, 
					window_geometry[XLDLAS_ANOVA][0],
					window_geometry[XLDLAS_ANOVA][1],
					window_geometry[XLDLAS_ANOVA][2],
					window_geometry[XLDLAS_ANOVA][3]);
	}	
	fl_show_form(anova_window,FL_PLACE_FREE,FL_FULLBORDER,"Analysis of Variance");
}


void inhibit_ga_input()
{
	fl_deactivate_object(ga_xvars_browser);
	fl_set_object_lcol(ga_xvars_browser, FL_INACTIVE);

	fl_deactivate_object(ga_yvar_browser);
	fl_set_object_lcol(ga_yvar_browser, FL_INACTIVE);

	fl_deactivate_object(ga_save_input);
	fl_set_object_lcol(ga_save_input, FL_INACTIVE);

	fl_deactivate_object(ga_overwrite_button);
	fl_set_object_lcol(ga_overwrite_button, FL_INACTIVE);

	fl_deactivate_object(ga_go_button);
	fl_set_object_lcol(ga_go_button, FL_INACTIVE);

	fl_deactivate_object(ga_done_button);
	fl_set_object_lcol(ga_done_button, FL_INACTIVE);
	
	fl_deactivate_object(ga_from_counter);
	fl_set_object_lcol(ga_from_counter, FL_INACTIVE);
	fl_deactivate_object(ga_to_counter);
	fl_set_object_lcol(ga_to_counter, FL_INACTIVE);
	fl_deactivate_object(ga_maxreal_counter);
	fl_set_object_lcol(ga_maxreal_counter, FL_INACTIVE);
	fl_deactivate_object(ga_bitsize_counter);
	fl_set_object_lcol(ga_bitsize_counter, FL_INACTIVE);
	fl_deactivate_object(ga_poolsize_counter);
	fl_set_object_lcol(ga_poolsize_counter, FL_INACTIVE);
}

void reenable_ga_input()
{
	fl_activate_object(ga_xvars_browser);
	fl_set_object_lcol(ga_xvars_browser, FL_BLACK);

	fl_activate_object(ga_yvar_browser);
	fl_set_object_lcol(ga_yvar_browser, FL_BLACK);

	fl_activate_object(ga_save_input);
	fl_set_object_lcol(ga_save_input, FL_BLACK);

	fl_activate_object(ga_overwrite_button);
	fl_set_object_lcol(ga_overwrite_button, FL_BLACK);

	fl_activate_object(ga_go_button);
	fl_set_object_lcol(ga_go_button, FL_YELLOW);

	fl_activate_object(ga_done_button);
	fl_set_object_lcol(ga_done_button, FL_BLACK);
	
	fl_activate_object(ga_from_counter);
	fl_set_object_lcol(ga_from_counter, FL_BLACK);
	fl_activate_object(ga_to_counter);
	fl_set_object_lcol(ga_to_counter, FL_BLACK);
	fl_activate_object(ga_maxreal_counter);
	fl_set_object_lcol(ga_maxreal_counter, FL_BLACK);
	fl_activate_object(ga_bitsize_counter);
	fl_set_object_lcol(ga_bitsize_counter, FL_BLACK);
	fl_activate_object(ga_poolsize_counter);
	fl_set_object_lcol(ga_poolsize_counter, FL_BLACK);
}

void handle_ga_buttons(FL_OBJECT *obj, long arg)
{
		if(fl_get_button(ga_force_button) == TRUE) ga_force = TRUE;
		else ga_force = FALSE;
		if(fl_get_button(ga_mutate_button) == TRUE) ga_mutate_ok = TRUE;
		else ga_mutate_ok = FALSE;
		if(fl_get_button(ga_cross_button) == TRUE) ga_cross_ok = TRUE;
		else ga_cross_ok = FALSE;
		if(fl_get_button(ga_perturbe_button) == TRUE) ga_perturbe_ok = TRUE;
		else ga_perturbe_ok = FALSE;
}



void handle_ga_counters(FL_OBJECT *obj, long arg)
{
	if(arg == 1) all_start = fl_get_counter_value(ga_from_counter);
	if(arg == 2) all_stop = fl_get_counter_value(ga_to_counter);
	if(arg == 3) ga_cycles = fl_get_counter_value(ga_cycles_counter);
	if(arg == 4) ga_update = fl_get_counter_value(ga_update_counter);
	if(arg == 5) ga_mutate = fl_get_counter_value(ga_mutate_counter);
	if(arg == 6) ga_maxreal = fl_get_counter_value(ga_maxreal_counter);
	if(arg == 7) ga_bitsize = fl_get_counter_value(ga_bitsize_counter);
	if(arg == 8) ga_poolsize = fl_get_counter_value(ga_poolsize_counter);
	if(arg == 9) ga_swap = fl_get_counter_value(ga_swap_counter);
	if(arg == 10) ga_cross = fl_get_counter_value(ga_cross_counter);
	if(arg == 11) ga_perturbe = fl_get_counter_value(ga_perturbe_counter);
	if(arg == 12) ga_tolerance = fl_get_counter_value(ga_tolerance_counter);
}


float gammaln(float xx)
{
	double x,y,tmp,ser;
	static double cof[6] = {	 76.18009172947146,
					-86.50532032941677,
					 24.01409824083091,
					 -1.231739572450155,
					  0.1208650973866179e-2,
					 -0.5395239384953e-5};
	int j;
	y = x = xx;
	tmp = x + 5.5;
	tmp = tmp - (x+0.5) * log(tmp);
	ser = 1.000000000190015;
	for(j=0; j <=5; j++)
	{
		ser = ser + cof[j] / ++y;
	}
	return -tmp+log(2.5066282746310005*ser/x);
}


float betacf(float a, float b, float x)
{
	int m,m2;
	float aa,c,d,del,h,qab,qam,qap;
	qab=a+b;
	qap=a+1.0;
	qam=a-1.0;
	c=1.0;
	d=1.0-qab*x/qap;
	if(fabs(d) < FPMIN) d = FPMIN;
	d=1.0/d;
	h=d;
	for(m=1;m<MAXIT;m++)
	{
		m2=2*m;
		aa=m*(b-m)*x/((qam+m2)*(a+m2));
		d=1.0+aa*d;
		if(fabs(d) < FPMIN) d = FPMIN;
		c=1.0+aa/c;
		if(fabs(c) < FPMIN) c = FPMIN;
		d = 1.0/d;
		h = h * d * c;
		aa = -(a+m)*(qab+m)*x/((a+m2)*(qap+m2));
		d=1.0+aa*d;
		if(fabs(d) < FPMIN) d = FPMIN;
		c=1.0+aa/c;
		if(fabs(c) < FPMIN) c = FPMIN;
		d = 1.0/d;
		del = d*c;
		h = h * del;
		if(fabs(del-1.0) < EPS) break;
	}
	if(m > MAXIT)
	{
		fl_show_alert("Calculation of Beta Function did not Converge",
			      "Expect very innacurate results in current/forthcoming output",
			      "",
			      TRUE);
	}
	return(h);
}


float betai(float a, float b, float x)
{
	float bt;
	if(x == 0.0 || x == 1.0) bt = 0.0;
	else bt = exp(gammaln(a+b)-gammaln(a)-gammaln(b)+a*log(x)+b*log(1.0-x));
	if( x < (a+1.0) / a+b+2.0) return bt * betacf(a,b,x)/a;
	else return 1.0-bt*betacf(b,a,1.0-x)/b;
}

float pearsn_r(float x[], float y[], int n)
{
	unsigned long j;
	float yt, xt, t, df, r;
	float syy=0.0, sxy = 0.0, sxx=0.0, ay=0.0, ax=0.0;
	
	for(j=1; j < n; j++)
	{
		ax = ax + x[j];
		ay = ay + y[j];
	}
	ax = ax / n;
	ay = ay / n;
	for(j=1; j < n; j++)
	{
		xt = x[j] - ax;
		yt = y[j] - ay;
		sxx = sxx + xt * xt;
		syy = syy + yt * yt;
		sxy = sxy + xt * yt;
	}
	r = sxy / (sqrt(sxx*syy) + TINY);
	df=n-2;
	t = r * sqrt(df/((1.0 - r + TINY) * (1.0 + r + TINY)));
	return(r);
} 

float pearsn_prob(float x[], float y[], int n)
{
	unsigned long j;
	float yt, xt, t, df, r, prob; 
	float syy=0.0, sxy = 0.0, sxx=0.0, ay=0.0, ax=0.0;
	
	for(j=1; j < n; j++)
	{
		ax = ax + x[j];
		ay = ay + y[j];
	}
	ax = ax / n;
	ay = ay / n;
	for(j=1; j < n; j++)
	{
		xt = x[j] - ax;
		yt = y[j] - ay;
		sxx = sxx + xt * xt;
		syy = syy + yt * yt;
		sxy = sxy + xt * yt;
	}
	r = sxy / (sqrt(sxx*syy) + TINY);
	df=n-2;
	t = r * sqrt(df/((1.0 - r + TINY) * (1.0 + r + TINY)));
	prob = betai(0.5*df,0.5,df/(df+t*t));
	return(prob);
} 


void sort_working_vector()
{
	int i, escape;
	float temp;
	escape = FALSE;
	while(escape == FALSE)
	{
		escape = TRUE;
		for(i = 0; i < worksize - 1; i++)
		{
			if(working[i] > working[i+1])
			{
				temp = working[i];
				working[i] = working[i+1];
				working[i+1] = temp;
				escape = FALSE;	
			}
		}
	}
}

void done_ga(FL_OBJECT *obj, long arg)
{
	window_geometry[XLDLAS_GAFIT][0] = obj->form->x;
	window_geometry[XLDLAS_GAFIT][1] = obj->form->y;
	window_geometry[XLDLAS_GAFIT][2] = obj->form->w;
	window_geometry[XLDLAS_GAFIT][3] = obj->form->h;
	fl_hide_form(ga_window);
	reenable_input();
	say_status("Ready");
}

int click_done_ga(FL_FORM *form, void *arg)
{
	window_geometry[XLDLAS_GAFIT][0] = form->x;
	window_geometry[XLDLAS_GAFIT][1] = form->y;
	window_geometry[XLDLAS_GAFIT][2] = form->w;
	window_geometry[XLDLAS_GAFIT][3] = form->h;
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}

int click_user_summarize_variable(FL_FORM *form, void *arg)
{
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}

void user_summarize_variable(FL_OBJECT *obj, long arg)
{
	char string_one[XLDLASMAX_INPUT];
	int i, j, to_summarize[MAX_VARS];
	int nrealobs[MAX_VARS], stat_denom[MAX_VARS], numb_summaries;
	float running[MAX_VARS], 
	runningt, 
	smallest[MAX_VARS], 
	largest[MAX_VARS], 
	average[MAX_VARS], 
	median[MAX_VARS], 
	firstq[MAX_VARS], 
	thirdq[MAX_VARS], 
	variance[MAX_VARS], 
	mad[MAX_VARS], 
	skew[MAX_VARS], 
	kurt[MAX_VARS], 
	sdev[MAX_VARS];
	int summ_start[MAX_VARS];
	int summ_stop[MAX_VARS];
	fl_hide_form(summarize_window);
	say_status("Summarizing Variable(s)");
	all_start = fl_get_counter_value(summarize_from_counter);
	all_stop = fl_get_counter_value(summarize_to_counter);	
	numb_summaries = 0;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(summarize_browser, i+1))
		{
			to_summarize[numb_summaries] = i;
			summ_start[numb_summaries] = fl_get_counter_value(summarize_from_counter);
			summ_stop[numb_summaries] = fl_get_counter_value(summarize_to_counter);
			if(summ_stop[numb_summaries] > data_matrix[i].obs) summ_stop[numb_summaries] = data_matrix[i].obs;
			if(summ_stop[numb_summaries] < summ_start[numb_summaries])
			{
				fl_show_alert("Some Variables have no Observations",
					      "Try adjusting From: value",
					      "",
					      TRUE);
				reenable_input();
				say_status("Ready");
				return;
			}
			numb_summaries++;
		}
	}
	if(numb_summaries == 0)
	{
		say_status("Ready");
		reenable_input();
		return;
	}
	for(i = 0; i < numb_summaries; i++)
	{
		nrealobs[i]=0;
		running[i] = 0;
		runningt = 0;
		smallest[i] = *(fvector[to_summarize[i]] + summ_start[i] - 1);
		largest[i] = *(fvector[to_summarize[i]] + summ_start[i] - 1);
		for(j=all_start - 1;j < all_stop; j++)
		{
			if( *(fvector[to_summarize[i]] + j) != missing_value)
			{
				running[i] = running[i] + *(fvector[to_summarize[i]] + j);
				runningt = runningt + (*(fvector[to_summarize[i]] + j) * *(fvector[to_summarize[i]] + j));
				if(smallest[i] > *(fvector[to_summarize[i]] + j) || smallest[i] == missing_value) smallest[i] = *(fvector[to_summarize[i]] + j);
				if(largest[i] < *(fvector[to_summarize[i]] + j) || largest[i] == missing_value) largest[i] = *(fvector[to_summarize[i]] + j);
				nrealobs[i]++;
			}
		}
		stat_denom[i] = nrealobs[i];
		if(assume_sample == TRUE && nrealobs[i] > 1) stat_denom[i]--;
		average[i] = running[i] / nrealobs[i];
		variance[i] = (runningt  - (nrealobs[i] * pow(average[i], 2))) / stat_denom[i];
		sdev[i] = pow(variance[i],0.5);
		mad[i] = 0;
		skew[i] = 0;
		kurt[i] = 0;
		for(j=all_start - 1;j < all_stop; j++)
		{
			if( *(fvector[to_summarize[i]] + j) != missing_value)
			{
				mad[i] = mad[i] + fabs(*(fvector[to_summarize[i]] + j) - average[i]);
				skew[i] = skew[i] + pow(((*(fvector[to_summarize[i]] + j) - average[i]) / sdev[i]), 3);
				kurt[i] = kurt[i] + pow(((*(fvector[to_summarize[i]] + j) - average[i]) / sdev[i]), 4);
			}
		}

		mad[i] = mad[i] / nrealobs[i];
		skew[i] = skew[i] / stat_denom[i];
		kurt[i] = kurt[i] / stat_denom[i];
		kurt[i] = kurt[i] - 3.0;

		for(j=all_start - 1; j < all_stop; j++)
		{
			working[j - (all_start - 1)] = *(fvector[to_summarize[i]] + j);
		}
		worksize = (all_stop - all_start) + 1;
		sort_working_vector();
		median[i] = (float) working[worksize / 2];
		if(nrealobs[i] % 2 == 0) median[i] = (working[worksize / 2 - 1] + working[worksize / 2]) / 2.0;
		firstq[i] = (float) working[worksize / 4];
		thirdq[i] = (float) working[(3 * worksize) /4];
		if((worksize - 1) % 4 != 0)
		{
			firstq[i] = working[worksize / 4] + (0.25 * (working[(worksize / 4) + 1] - working[worksize/4]));
			thirdq[i] = working[((3* worksize) / 4) - 1] + 0.75 * (working[(3 * worksize)/ 4] - working[((3 * worksize) /4) - 1]); 
		}
	}
	sprintf(string_one,"Summary of data between observations %d and %d", all_start, all_stop);
	simple_line_output("summ","Variable Summary");
	begin_table_output(numb_summaries + 1, string_one);
	begin_column_output("                          ", XLDLAS_JUST_CENTER);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14s",data_matrix[to_summarize[i]].name);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
	}
	end_column_output();
	seperator_output(numb_summaries + 1);
	begin_column_output("    Apparent Observations ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14i",(all_stop-all_start)+1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
	}
	end_column_output();
	begin_column_output("        Real Observations ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14i",nrealobs[i]);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
	}
	end_column_output();
	seperator_output(numb_summaries + 1);
	begin_column_output("                     Sum  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",running[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output("                    Mean  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",average[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output("                Smallest  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",smallest[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output("                 Largest  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",largest[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output("                Variance  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",variance[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output("      Standard Deviation  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",sdev[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output(" Mean Absolute Deviation  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",mad[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();					
	begin_column_output("                  Median  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",median[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output("          First Quartile  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",firstq[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();
	begin_column_output("          Third Quartile  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",thirdq[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();					
	begin_column_output("                Skewness  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f",skew[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();					
	begin_column_output("                Kurtosis  ", XLDLAS_JUST_RIGHT);
	for(i=0; i < numb_summaries; i++)
	{
		sprintf(string_one,"%14.3f", kurt[i]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
	}
	end_column_output();					
	end_table_output(2);
	say_status("Ready");
	reenable_input();
}


void begin_summarize(FL_OBJECT *menu, long user_data)
{
	int i, largest;
	inhibit_input();
	say_status("Waiting for Choice");
	fl_clear_browser(summarize_browser);
	largest = 0;
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_browser(list_browser,data_matrix[i].name);
	}

	fl_set_counter_value(summarize_from_counter, 1);
	fl_set_counter_bounds(summarize_from_counter, 1, largest);
	fl_set_counter_step(summarize_from_counter, 1, 10);

	fl_set_counter_value(summarize_to_counter, largest);
	fl_set_counter_bounds(summarize_to_counter, 1, largest);
	fl_set_counter_step(summarize_to_counter, 1, 10);
	for(i=0; i < numb_variables; i++)
	{
		fl_addto_browser(summarize_browser,data_matrix[i].name);
	}
	fl_show_form(summarize_window,FL_PLACE_FREE,FL_TRANSIENT,"Choose Variable(s)");
}

void corr_variables(FL_OBJECT *obj, long arg)
{
	int i, j, k, numb_corr, to_corr[MAX_VARS], corr_obs;
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	fl_hide_form(corr_window);
	all_start = fl_get_counter_value(corr_from_counter);
	all_stop = fl_get_counter_value(corr_to_counter);
	if(all_stop < all_start)
	{
		fl_show_alert("From Value Greater than to Value!",
			      "",
			      "",
			      TRUE);
		reenable_input();
		say_status("Ready");
		return;
	}
	strcpy(string_one, "Variables: "); 
	numb_corr = 0;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(corr_browser, i+1))
		{
			to_corr[numb_corr] = i;
			sprintf(string_two," %s", data_matrix[i].name);
			strcat(string_one, string_two);
			numb_corr++;
		}
	}
	if(numb_corr == 0)
	{
		reenable_input();
		say_status("Ready");
		return;
	}
	if(numb_corr == 1)
	{
		fl_show_alert("Can't Correlate a Variable with Itself!",
			      "",
			      "",
			      TRUE);
		reenable_input();
		say_status("Ready");
		return;
	}
	say_status("Correlating Variable(s)");
	simple_line_output("corr",string_one);
	begin_table_output(numb_corr, "Correlation Table");
	strcpy(string_one,"");
	for(i=0; i < NAME_LENGTH; i++)
	{
		strcat(string_one," ");
	}
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	for(i=0; i < numb_corr - 1; i++)
	{
		sprintf(string_one,"%*s",NAME_LENGTH, data_matrix[to_corr[i]].name);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
	}
	end_column_output();
	seperator_output(numb_corr + 1);
	for(i = 1; i < numb_corr; i++)
	{
		sprintf(string_one,"%-*s", NAME_LENGTH, data_matrix[to_corr[i]].name);
		begin_column_output(string_one, XLDLAS_JUST_CENTER);
		for(j = 0; j < numb_corr - 1; j++)
		{
			if(i <= j)
			{
				strcpy(string_one,"");
				for(k=0; k < NAME_LENGTH; k++)
				{
					strcat(string_one," ");
				}
				add_column_output(string_one, XLDLAS_JUST_CENTER);
			}
			else
			{
				corr_obs = 0;
				for(k=all_start - 1; k < all_stop; k++)
				{
					if( *(fvector[to_corr[i]] + k) != missing_value 
					    && *(fvector[to_corr[j]] + k) != missing_value
					    && k < data_matrix[to_corr[i]].obs
					    && k < data_matrix[to_corr[j]].obs)
					{
						working[corr_obs] = *(fvector[to_corr[i]] + k);
						working_two[corr_obs] = *(fvector[to_corr[j]] + k);
						corr_obs++;
					}
				}
				if(corr_obs > 1)
				{
					sprintf(string_one,"%*f (%*f)",NAME_LENGTH / 2,pearsn_r(working, working_two, corr_obs), (NAME_LENGTH / 2)-3, pearsn_prob(working,working_two, corr_obs));
				}
				else
				{
					strcpy(string_one,"");
					for(k=0; k < NAME_LENGTH; k++)
					{
						strcat(string_one," ");
					}
				}
				add_column_output(string_one, XLDLAS_JUST_RIGHT);
					
			}
		}
		end_column_output();
	}
	end_table_output(numb_corr);
	reenable_input();
	say_status("Ready");
}


void start_corr_variables()
{
	int i;
	int largest;
	inhibit_input();
	say_status("Waiting for Variable(s) Selection");
	fl_clear_browser(corr_browser);
	largest = 0;
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_browser(corr_browser,data_matrix[i].name);
	}

	fl_set_counter_value(corr_from_counter, 1);
	fl_set_counter_bounds(corr_from_counter, 1, largest);
	fl_set_counter_step(corr_from_counter, 1, 10);

	fl_set_counter_value(corr_to_counter, largest);
	fl_set_counter_bounds(corr_to_counter, 1, largest);
	fl_set_counter_step(corr_to_counter, 1, 10);
	
	fl_show_form(corr_window,FL_PLACE_FREE,FL_TRANSIENT,"Select Variable(s) for Corr");
}


/*
	Abort listing by closing the list browser window
*/

int click_abort_corr_variables(FL_FORM *form, void *arg)
{
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}

/*
	Abort regression by closing the list browser window
*/

int click_abort_regress_variables(FL_FORM *form, void *arg)
{
	window_geometry[XLDLAS_REGRESS][0] = form->x;
	window_geometry[XLDLAS_REGRESS][1] = form->y;
	window_geometry[XLDLAS_REGRESS][2] = form->w;
	window_geometry[XLDLAS_REGRESS][3] = form->h;
	say_status("Ready");
	reenable_input();
	return(FL_OK);
}


void calculate_regression(int depend, int independ[], int numb_independ, int start, int stop)
{
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	int escape, count, countt, counts;
	int numbvars;
	int length;
	int fit_type;
	int fitnumber, place;
	int variables[MAX_VARS];
	float coefs[MAX_VARS];
	float fitted[MAX_OBS];
	float theintercept;
	float ybar, xbar, sst, ssr, scratch, mse;
	double *bigmatrix;
	double *matrix;
	double running;
	int max, column;
	double temp1,temp2;
	escape = FALSE;
	numbvars = numb_independ + 1;
	length = (stop - start) + 1;
	theintercept = 0;
	fitnumber = -1;
	fit_type = 3;
	for(count=0; count < numb_independ; count++)
	{
		variables[count] = independ[count];
	}
	variables[count] = depend;
	if(length <= numbvars)
	{
		fl_show_alert("More Variables than Observations","","",TRUE);
		return;
	}
	if(length - numbvars - 1 <= 0)
	{
		fl_show_alert("Not Enough Observations for Number of Variables","","",TRUE);
		return;
	}	
	say_status("Building Matrix... ");
	bigmatrix = (double *) malloc ((length * (numbvars + 1)) * sizeof (double));
	if(!bigmatrix)
	{
		fl_show_alert("Not Enough Memory to Build Regression Matrix","","",TRUE);
		return;
	}
	for(count = 0; count < length; count++)
	{
		*(bigmatrix + count) = 1;
	}
	for(count = 1; count <= numbvars; count++)
	{
		for(countt = 0; countt < length; countt++)
		{
			if((countt + start - 1) < data_matrix[variables[count - 1]].obs)
			{
				*(bigmatrix + countt + (count * length)) = *(fvector[variables[count - 1]] + countt + (start - 1));
			}
			else
			{
				*(bigmatrix + countt + (count * length)) = missing_value;
			}
		}
	}
	say_status("Zapping Missings...");
	for(count = 0; count < (length * (numbvars + 1)); count ++)
	{
		if(*(bigmatrix + count) == missing_value)
		{
			column = count % length;
			for(countt = numbvars; countt >= 0; countt--)
			{
				for(counts = (countt * length) + column; counts < (length * (numbvars + 1)) - 1; counts++)
				{
					*(bigmatrix + counts) = *(bigmatrix + counts + 1);
				}
			}
			count = 0;
			length--;
			if(length <= numbvars)
			{
				fl_show_alert("Not Enough Actual Observations in Data","","",TRUE);
				free(bigmatrix);
				return;
			}
		}	
	}
	matrix = (double *) malloc ((numbvars * (numbvars + 1)) * sizeof (double));
	if(!matrix)
	{
		fl_show_alert("Not Enough Memory to Build Regression Sub-Matrix","","",TRUE);
		return;
	}
	say_status("Building System of Equations");
	for(count = 0; count < numbvars; count++)
	{
		for(countt = 0; countt <= numbvars; countt++)
		{
			running = 0;
			for(counts = 0; counts < length; counts++)
			{
				running = running + *(bigmatrix + counts + (count * length)) * *(bigmatrix + counts + (countt * length));
			}
			*(matrix + count + (countt * numbvars)) = running;
		}
	}
	say_status("Gauss Eliminating ... ");
	for(count = 0; count < numbvars; count++)
	{
		max = count;
		for(countt = count + 1; countt < numbvars; countt++)
		{
			temp1 = *(matrix + countt + (count * numbvars));
			temp2 = *(matrix + max + (count * numbvars));
			if(fabs(temp1) > fabs(temp2)) max = countt;
			for(counts = 0; counts <= numbvars; counts++)
			{
				running = *(matrix + count + (counts * numbvars));
				*(matrix + count + (counts * numbvars)) = *(matrix + max + (counts * numbvars));
				*(matrix + max + (counts * numbvars)) = running;
			}
		}
		for(countt = count + 1; countt < numbvars; countt++)
		{
			for(counts = numbvars; counts >= 0; counts--)
			{
				temp1 = *(matrix + count + (count * numbvars));
				if(temp1 == 0)
				{
					fl_show_alert("The Regression Matrix is Singular!","","",TRUE);
					return;
				}
				*(matrix + countt + (counts * numbvars)) = *(matrix + countt + (counts * numbvars)) - *(matrix + count + (counts * numbvars)) * *(matrix + countt + (count * numbvars)) / *(matrix + count + (count * numbvars));
			}
		}
	}
	say_status("Doing Substitions...");
	for(count = 0; count <= numbvars; count++)
	{
		coefs[count] = 0;
	}
	for(count = numbvars - 1; count >= 0; count--)
	{
		running = 0;
		for(countt = count + 1; countt <= numbvars; countt++)
		{
			running = running + *(matrix + count + (countt * numbvars)) * coefs[countt];
			temp1 = *(matrix + count + (count * numbvars));
			if(temp1 == 0)
			{
				fl_show_alert("The Reduced Regression Matrix is Singular!","","",TRUE);
				return;
			}
			coefs[count]= ( *(matrix + count + (numbvars * numbvars)) - running ) / *(matrix + count + (count * numbvars));
		}
	}
	theintercept = coefs[0];
	for(count = 0; count < MAX_OBS; count++)
	{
		working[count] = 0;
	}
	ybar = 0;
	for(count = 0; count < length; count++)
	{
		working[count] = *(bigmatrix + count + (numbvars * length));
		ybar = ybar + working[count];
	}
	scratch = length;
	ybar = ybar / scratch;
	sst = 0;
	for(count = 0; count < length; count++)
	{
		sst = sst + ((working[count] - ybar) * (working[count] - ybar));
	}
	for(count = 0; count < MAX_OBS; count++)
	{
		fitted[count] = 0;
	}
	for(count = 0; count < length; count++)
	{
		scratch = theintercept;
		for(countt = 1; countt < numbvars; countt++)
		{
			scratch = scratch + *(bigmatrix + count + (countt * length)) * coefs[countt];
		}
		fitted[count] = scratch;
	}
	ssr = 0;
	for(count = 0; count < length; count++)
	{
		ssr = ssr + ((fitted[count] - ybar) * (fitted[count] - ybar));
	}
	say_status("Displaying Regression Results");
	begin_table_output(2, "OLS Regression Results: Summary Statistics");
	begin_column_output("   Number of obs   ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%i",length);
	add_column_output(string_one, XLDLAS_JUST_CENTER);
	end_column_output(2);
	sprintf(string_one,"    F(%4d,%4d)   ",(numbvars - 1), length - numbvars);
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	sprintf(string_one,"%6.4f",((ssr/(numbvars - 1)) / ((sst - ssr) / (length - numbvars))));
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output(2);

	sprintf(string_one,"         Prob(F)   ");
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	
	scratch = 1.0 - betai((length-numbvars) / 2.0, (numbvars - 1)/2.0, (length - numbvars) / ((length - numbvars) + ((numbvars - 1) * ((ssr/(numbvars - 1)) / ((sst - ssr) / (length - numbvars))))));
	
	sprintf(string_one,"%6.4f",scratch);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output(2);
	
	
	sprintf(string_one,"        R-square   ");
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	sprintf(string_one,"%6.4f",ssr/sst);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output(2);
	scratch = numbvars - 1;
	scratch = scratch / (length - 1);
	scratch = scratch * (1 - (ssr/sst));

	sprintf(string_one,"    Adj R-square   ");
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	sprintf(string_one,"%6.4f",(ssr/sst) - scratch);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output(2);

	sprintf(string_one,"        Root MSE   ");
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	sprintf(string_one,"%6.4f", sqrt((sst - ssr) / (length - numbvars)));
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output(2);
	end_table_output(2);


	begin_table_output(4, "OLS Regression Results: Model SS vs. Residual SS");
	begin_column_output("Source   ", XLDLAS_JUST_CENTER);
	add_column_output("            SS", XLDLAS_JUST_CENTER);
	add_column_output("            df", XLDLAS_JUST_CENTER);
	add_column_output("            MS", XLDLAS_JUST_CENTER);
	end_column_output();
	seperator_output(4);
	
	begin_column_output("Model    ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%14.3f", ssr);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	sprintf(string_one,"%14i", numbvars - 1);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	sprintf(string_one,"%14.3f", ssr / (numbvars - 1));
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output();
	
	begin_column_output("Residual ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%14.3f", sst - ssr);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	sprintf(string_one,"%14i", length - numbvars);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	sprintf(string_one,"%14.3f", (sst - ssr) / (length - numbvars));
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output();
	
	seperator_output(4);

	begin_column_output("Total    ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%14.3f", sst);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	sprintf(string_one,"%14i", length - 1);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	sprintf(string_one,"%14.3f", sst / (length - 1));
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output();

	end_table_output(4);
	

	begin_table_output(6, "OLS Regression Results: Estimates of Coefficients");
	
	strcpy(string_two,"Variable");
	sprintf(string_one,"%-*s",NAME_LENGTH,string_two);
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	add_column_output("   Coefficient", XLDLAS_JUST_CENTER);
	add_column_output("    Std. Error", XLDLAS_JUST_CENTER);
	add_column_output("             t", XLDLAS_JUST_CENTER);
	add_column_output("       Prob(t)", XLDLAS_JUST_CENTER);
	add_column_output("          Mean", XLDLAS_JUST_CENTER);
	end_column_output();
	
	seperator_output(6);
	
	sprintf(string_one,"%-*s",NAME_LENGTH,data_matrix[depend].name);
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	add_column_output("              ", XLDLAS_JUST_CENTER);
	add_column_output("              ", XLDLAS_JUST_CENTER);
	add_column_output("              ", XLDLAS_JUST_CENTER);
	add_column_output("              ", XLDLAS_JUST_CENTER);
	sprintf(string_one,"%14.3f", ybar);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	end_column_output();
	
	seperator_output(6);
	
	strcpy(string_two,"(intcpt)");
	sprintf(string_one,"%-*s",NAME_LENGTH,string_two);
	begin_column_output(string_one, XLDLAS_JUST_CENTER);
	sprintf(string_one,"%14.3f", coefs[0]);
	add_column_output(string_one, XLDLAS_JUST_RIGHT);
	add_column_output("              ", XLDLAS_JUST_RIGHT);
	add_column_output("              ", XLDLAS_JUST_RIGHT);
	add_column_output("              ", XLDLAS_JUST_CENTER);
	add_column_output("              ", XLDLAS_JUST_RIGHT);
	end_column_output();
	
	seperator_output(6);
	
	mse = ((sst - ssr) / (length - numbvars));

	for(count = 1; count < numbvars; count++)
	{
		scratch = 0;
		xbar = 0;
		for(countt = 0; countt < length; countt++)
		{
			working[countt] = *(bigmatrix + countt + (count * length));
			xbar = xbar + working[countt];
		}
		xbar = xbar / length;
		for(countt = 0; countt < length; countt++)
		{
			scratch = scratch + ((working[countt] - xbar) * (working[countt] - xbar));
		}

		sprintf(string_one,"%-*s", NAME_LENGTH, data_matrix[variables[count - 1]].name);
		begin_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", coefs[count]);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", sqrt(mse/scratch));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", coefs[count] / (sqrt(mse/scratch)));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		
		scratch = (length - numbvars - 1) / ((length - numbvars - 1) + pow(coefs[count] / (sqrt(mse/scratch)),2));
		scratch = 1.0 - betai((length - numbvars - 1)/2.0, 0.5, scratch);
	
		sprintf(string_one,"%14.3f", scratch);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", xbar);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
	}

	end_table_output(6);
	
	free(matrix);
	free(bigmatrix);

	strcpy(string_one, fl_get_input(fit_variable_input));
	if(strlen(string_one) > 0 && numb_variables == MAX_VARS && check_variable_name(string_one) == TRUE)
	{
		fl_show_alert("No Room to Add Fitted Variable","","",TRUE);
	}
	if(strlen(string_one) > 0 && numb_variables < MAX_VARS)
	{
		if(fl_get_button(fit_overwrite_button) == TRUE)
		{
			if(check_variable_name(string_one) == TRUE)
			{
				strcpy(data_matrix[numb_variables].name,string_one);
				strcpy(data_matrix[numb_variables].description,"Fitted Values from OLS Regression");
				fvector[numb_variables] = (float *) malloc (MAX_OBS * sizeof (float));
				fitnumber = numb_variables;
				numb_variables++;
				fit_type = 0;
			}
			else
			{
				for(count = 0; count < numb_variables; count++)
				{
					if(strcmp(data_matrix[count].name,string_one) == 0) fitnumber = count; 
				}
				free(fvector[fitnumber]);
				fvector[fitnumber] = (float *) malloc (MAX_OBS * sizeof (float));
				fit_type = 1;
			}
		}
		else
		{
			if(check_variable_name(string_one) == FALSE)
			{
				fl_show_alert("Variable Name for Fitted Values Already Exists","","",TRUE);
				return;
			}
			strcpy(data_matrix[numb_variables].name,string_one);
			strcpy(data_matrix[numb_variables].description,"Fitted Values from OLS Regression");
			fvector[numb_variables] = (float *) malloc (MAX_OBS * sizeof (float));
			fitnumber = numb_variables;
			numb_variables++;
			fit_type = 0;
		}
		place = 0;
		for(count = 0; count < start - 1; count++)
		{
			*(fvector[fitnumber] + place) = missing_value;
			place++; 
		}
		for(count = start - 1; count < stop; count++)
		{
			*(fvector[fitnumber] + place) = theintercept;
			for(countt = 1; countt < numbvars; countt++)
			{
				if(*(fvector[variables[countt - 1]] + count + (start - 1))  == missing_value || data_matrix[variables[countt - 1]].obs <= count + (start - 1))
				{
					countt = numbvars;
					*(fvector[fitnumber] + place) = missing_value;
				}
				else
				{
					*(fvector[fitnumber] + place) = *(fvector[fitnumber] + place) + (coefs[countt] * *(fvector[variables[countt - 1]] + count + (start - 1))); 
				}
			}	
			place++;
		}
		sprintf(string_one,"%d fitted observations stored in %s", place, data_matrix[fitnumber].name);
		simple_line_output("reg",string_one);
		oktoquit = FALSE;
		data_matrix[fitnumber].obs = place;
		sync_graph_browsers(fit_type);
	}

}


void regress_variables(FL_OBJECT *obj, long arg)
{
	int i, dependent;
	int independent[MAX_VARS];
	int numb_independent;
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	say_status("Starting Regression ...");
	all_start = fl_get_counter_value(regress_from_counter);
	all_stop = fl_get_counter_value(regress_to_counter);	
	if(all_stop < all_start)
	{
		fl_show_alert("From Value Greater than to Value!",
			      "",
			      "",
			      TRUE);
		reenable_input();
		say_status("Ready");
		return;
	}
	strcpy(string_one, "OLS Regression Equation: "); 
	dependent = fl_get_browser(regress1_browser) - 1;
	if(dependent < 0)
	{
		fl_show_alert("No Dependent Variable Selected!",
			      "",
			      "",
			      TRUE);
		reenable_input();
		say_status("Ready");
		return;
	}
	sprintf(string_two,"%s = a ",data_matrix[dependent].name);
	strcat(string_one, string_two);
	numb_independent = 0;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(regress2_browser, i+1) && i != dependent)
		{
			independent[numb_independent] = i;
			sprintf(string_two,"+ b%d * %s ", numb_independent + 1, data_matrix[i].name);
			strcat(string_one, string_two);
			numb_independent++;
		}
	}
	if(numb_independent == 0)
	{
		fl_show_alert("No Independent Variables Selected!",
			      "",
			      "",
			      TRUE);
		reenable_input();
		say_status("Ready");
		return;
	}
	simple_line_output("reg",string_one);
	calculate_regression(dependent, independent, numb_independent, all_start, all_stop);
	say_status("Waiting for Variable Selection");
}

void done_regress_variables(FL_OBJECT *obj, long arg)
{
	window_geometry[XLDLAS_REGRESS][0] = obj->form->x;
	window_geometry[XLDLAS_REGRESS][1] = obj->form->y;
	window_geometry[XLDLAS_REGRESS][2] = obj->form->w;
	window_geometry[XLDLAS_REGRESS][3] = obj->form->h;
	fl_hide_form(regress_window);
	say_status("Ready");
	reenable_input();
}



void start_regress_variables(FL_OBJECT *obj, long arg)
{
	int i;
	int largest;
	inhibit_input();
	say_status("Waiting for Variable Selection");
	fl_clear_browser(regress1_browser);
	fl_clear_browser(regress2_browser);
	largest = 0;
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_browser(regress1_browser,data_matrix[i].name);
		fl_addto_browser(regress2_browser,data_matrix[i].name);
	}

	fl_set_counter_value(regress_from_counter, 1);
	fl_set_counter_bounds(regress_from_counter, 1, largest);
	fl_set_counter_step(regress_from_counter, 1, 10);

	fl_set_counter_value(regress_to_counter, largest);
	fl_set_counter_bounds(regress_to_counter, 1, largest);
	fl_set_counter_step(regress_to_counter, 1, 10);
	if(window_geometry[XLDLAS_REGRESS][0] != -1)
	{
		fl_set_form_geometry(regress_window, 
					window_geometry[XLDLAS_REGRESS][0],
					window_geometry[XLDLAS_REGRESS][1],
					window_geometry[XLDLAS_REGRESS][2],
					window_geometry[XLDLAS_REGRESS][3]);
	}	
	fl_show_form(regress_window,FL_PLACE_FREE,FL_FULLBORDER,"Regression Analysis");
}

void fit_gavariable(int tofit, int variables[], int numbvars, float intercept, int start, int stop)
{
	int i, j, k;
	float scratch;
	int oktoprocess;
	for(i = 0; i < start-1; i++)
	{
		*(fvector[tofit] + i) = missing_value;
	}
	for(i = start - 1; i < stop; i++)
	{
		oktoprocess = TRUE;
		for(j = 0; j < numbvars; j++)
		{
			if(*(fvector[variables[j]] + i) == missing_value)
				oktoprocess = FALSE;
		}
		if(oktoprocess == TRUE)
		{
			scratch = intercept;
			for(j = 0; j < numbvars; j++)
			{
				for(k = 0; k < 4; k++)
				{
					scratch = scratch + ga_coefs[j][k] * pow(*(fvector[variables[j]] + i), ga_powers[j][k]);
				}
			}
			*(fvector[tofit] + i) = scratch;
		}
		else
		{
			*(fvector[tofit] + i) = missing_value;
		}
	}
}

double calculate_sserrors(int dependent, int variables[], int numbvars, float intercept, int start, int stop)
{
	int i, j, k, count;
	float scratch;
	double errors;
	int oktoprocess;
	errors = 0.0;
	count = 0;
	for(i = start - 1; i < stop; i++)
	{
		oktoprocess = TRUE;
		if(*(fvector[dependent] + i) == missing_value)
			oktoprocess = FALSE;
		for(j = 0; j < numbvars; j++)
		{
			if(*(fvector[variables[j]] + i) == missing_value)
				oktoprocess = FALSE;
		}
		if(oktoprocess == TRUE)
		{
			scratch = intercept;
			for(j = 0; j < numbvars; j++)
			{
				for(k = 0; k < 4; k++)
				{
					scratch = scratch + ga_coefs[j][k] * pow(*(fvector[variables[j]] + i), ga_powers[j][k]);
				} 	
			}
			errors = errors + pow((scratch - *(fvector[dependent] + i)), 2);
			count++;
		}
	}
	errors = errors / count;
	return(errors);
}

void draw_ga_chart(int winner, int loser, double values[], int how_many, int round, int total)
{
	int i;
	char string_one[XLDLASMAX_INPUT];
	int colour[XLDLAS_MAX_GA_POOLSIZE];
	fl_freeze_form(ga_window);
	fl_clear_chart(ga_chart);
	for(i = 0; i < how_many; i++)
	{
		if(values[i] > 10 * values[winner])
		{
			values[i] = 10 * values[winner];
			colour[i] = FL_RED;
		}
		else
		{
			if( i == winner) colour[i] = FL_YELLOW;
			else colour[i] = FL_BLUE;
			
		}
	}
	for(i = 0; i < how_many; i++)
	{
		if(i != how_many / 3 && i != (how_many / 3) * 2)
		{
			fl_add_chart_value(ga_chart, values[i], "", colour[i]);
		}
		else
		{
			if( i == how_many / 3)
			{
				sprintf(string_one,"%f", values[winner]);
				fl_add_chart_value(ga_chart, values[i], string_one, colour[i]);
			}
			if( i == (how_many / 3) * 2)
			{
				sprintf(string_one,"%d/%d", round+1, total);
				fl_add_chart_value(ga_chart, values[i], string_one, colour[i]);
			}
		}
	}	
	fl_unfreeze_form(ga_window);
}


void run_ga(int dependent, int variables[], int numbvars, int ga_start, int ga_stop) 
{
	int i,j,k,l,m, length, rander, cross_one, cross_two, 
		crosser, pstart, pstop, fitnumber, fit_type;
	float intercept, scratch;
	float ga_denom;
	int negative_exists[MAX_VARS];
	int changed[XLDLAS_MAX_GA_POOLSIZE];
	double ss_errors[XLDLAS_MAX_GA_POOLSIZE];
	double smallest, largest;
	int small_numb, large_numb;
	int *ga_pool[XLDLAS_MAX_GA_POOLSIZE];
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	inhibit_ga_input();
	say_status("GA Fitting (this may take awhile ...)");
	fl_set_chart_maxnumb(ga_chart,ga_poolsize);
	ga_denom = 0;
	for(i = 0; i < ga_bitsize; i++)
	{
		ga_denom = ga_denom + pow(2,i);
	}
	for(i = 0; i < numbvars; i++)
	{
		negative_exists[i] = FALSE;
		for(j = ga_start - 1; j < ga_stop; j++)
		{
			if(*(fvector[variables[i]] + j) < 0.0)
			{
				negative_exists[i] = TRUE;
				j = ga_stop;
			}
		} 
	}
	length = 1 + ga_bitsize + numbvars * (4 + 4 * (2 + 2 * ga_bitsize));
	for(i = 0; i < ga_poolsize; i++)
	{
		ga_pool[i] = (int *) malloc(length * sizeof (int));
		if(!ga_pool[i])
		{
			fl_show_alert("Not enough memory to build GA Pool","","",TRUE);
			return;
		}
		changed[i] = TRUE;
		for(j = 0; j < length; j++)
		{
			rander = rand() % 1000;
			if(rander < 500)
			{
				*(ga_pool[i] + j) = TRUE;
			}
			else
			{
				*(ga_pool[i] + j) = FALSE;
			}
		} 
	}
	general_abort = FALSE;
	fl_show_form(abort_window,FL_PLACE_FREE,FL_FULLBORDER,"Abort GAFit");
	for(i = 0; i < ga_cycles; i++)
	{
		fl_check_forms();
		if(general_abort == TRUE)
		{
			general_abort = FALSE;
			for(j = 0; j < ga_poolsize; j++)
			{
				free(ga_pool[j]);
			}
			fl_clear_chart(ga_chart);
			reenable_ga_input();
			fl_hide_form(abort_window);
			sprintf(string_one,"GA Fit was aborted at cycle %d", i+1);
			simple_line_output("abort", string_one);
			return;
		}
		for(j = 0; j < ga_poolsize; j++)
		{
			if(changed[j] == TRUE)
			{
				intercept = 0;
				for(k = 1; k < 1 + ga_bitsize; k++)
				{
					if(*(ga_pool[j] + k) == TRUE)
					{
						intercept = intercept + pow(2,k-1);
					} 
				}
				intercept = intercept / ga_denom;
				intercept = intercept * ga_maxreal;
				if(*(ga_pool[j]) == TRUE)
				{
					intercept = -1.0 * intercept;
				}
				for(k = 0; k < numbvars; k++)
				{
					for(l = 0; l < 4; l++)
					{
						if(*(ga_pool[j] + ga_bitsize + 1 + k * (4 + 4 * (ga_bitsize + 2)) + l) == TRUE || (ga_force == TRUE && l == 0))
						{
							ga_coefs[k][l] = 0.0;
							for(m = 0; m < ga_bitsize; m++)
							{
								if(*(ga_pool[j] + 1 + ga_bitsize + k * (4 + 4 * (ga_bitsize + 2)) + 4 + l * (2 * (ga_bitsize + 1)) + 1 + m) == TRUE)
								{
									ga_coefs[k][l] = ga_coefs[k][l] + pow(2,m);
								}
							}
							ga_coefs[k][l] = ga_coefs[k][l] / ga_denom;
							ga_coefs[k][l] = ga_coefs[k][l] * ga_maxreal;
							if(*(ga_pool[j] + 1 + ga_bitsize + k * (4 + 4 * ( ga_bitsize +2)) + 4 + l * ( 2 *(ga_bitsize+1))) == FALSE)
							{
								ga_coefs[k][l] = -1.0 * ga_coefs[k][l];
							}
							ga_powers[k][l] = 0.0;
							for(m = 0; m < ga_bitsize; m++)
							{
								if(*(ga_pool[j] + 1 + ga_bitsize + k * (4 + 4 * (ga_bitsize + 2)) + 4 + l * (2 * (ga_bitsize + 1)) + 1 + m + ga_bitsize + 1) == TRUE)
								{
									ga_powers[k][l] = ga_powers[k][l] + pow(2,m);
								}
							}
							ga_powers[k][l] = ga_powers[k][l] / ga_denom;
							ga_powers[k][l] = ga_powers[k][l] * 10.0;
							if(negative_exists[k] == TRUE)
							{
								ga_powers[k][l] = ((int) ga_powers[k][l]) + 1;
							}
						}
						else
						{
							ga_coefs[k][l] = 0.0;
							ga_powers[k][l] = 1.0;
						}
					}
				}
				ss_errors[j] = calculate_sserrors(dependent, variables, numbvars, intercept, ga_start, ga_stop);
				changed[j] = FALSE;
			}
		}
		smallest = ss_errors[0];
		small_numb = 0;
		for(j = 1; j < ga_poolsize; j++)
		{
			if(smallest > ss_errors[j])
			{
				smallest = ss_errors[j];
				small_numb = j;
			}
		}
		largest = ss_errors[0];
		large_numb = 0;
		for(j = 1; j < ga_poolsize; j++)
		{
			if(largest < ss_errors[j])
			{
				largest = ss_errors[j];
				large_numb = j;
			}
		}
		if( (i+1) % ga_update == 0 || i == 0 || i == ga_cycles - 1) draw_ga_chart(small_numb, large_numb, ss_errors, ga_poolsize, i, ga_cycles);
		for(j = 0; j < ga_swap; j++)
		{
			largest = ss_errors[0];
			large_numb = 0;
			for(k = 1; k < ga_poolsize; k++)
			{
				if(largest < ss_errors[k])
				{
					largest = ss_errors[k];
					large_numb = k;
				}
			}
			for(k = 0; k < length; k++)
			{
				*(ga_pool[large_numb] + k) = *(ga_pool[small_numb] + k);
			}
			ss_errors[large_numb] = ss_errors[small_numb];
		}
		if(smallest < ga_tolerance) i = ga_cycles - 1;
		if(i != ga_cycles - 1)
		{
			if(ga_cross_ok == TRUE)
			{
				for(j = 0; j < ga_poolsize; j++)
				{
					rander= rand() % ga_cross;
					if(rander < 1)
					{
						crosser = rand() % ga_poolsize;
						cross_one = rand() % length;
						cross_two = rand() % length;
						if(cross_two < cross_one)
						{
							rander = cross_one;
							cross_one = cross_two;
							cross_two = rander;
						}
						for(k = cross_one; k <= cross_two; k++)
						{
							rander = *(ga_pool[j] + k);
							*(ga_pool[j] + k) = *(ga_pool[crosser] + k);
							*(ga_pool[crosser] + k) = rander;
						}
						changed[j] = TRUE;
						changed[crosser] = TRUE;
					}
				}
			}
			if(ga_mutate_ok == TRUE)
			{
				for(j = 0; j < ga_poolsize; j++)
				{
					for(k = 0; k < length; k++)
					{
						rander = rand() % ga_mutate;
						if(rander < 1)
						{
							if(*(ga_pool[j] + k) == TRUE) *(ga_pool[j] + k) = FALSE;
							else *(ga_pool[j] + k) = TRUE;
							changed[j] = TRUE;
						}
					}
				}
			}
			if(ga_perturbe_ok == TRUE)
			{
				for(j = 0 ; j < ga_poolsize; j++)
				{
					for(k = 0; k < 1 + numbvars; k++)
					{
						rander = rand() % ga_perturbe;
						if(rander < 1)
						{
							if(k == 0)
							{
								pstart = 1;
								pstop = 1 + ga_bitsize;
							}
							else
							{
								pstart = 1 + ga_bitsize + ((k-1) * (4 + 2 * (ga_bitsize + 1))) + 4 + 1 + ((rand() % 2) * (ga_bitsize + 1));
								pstop = pstart + ga_bitsize;
							}
							scratch = 0;
							for(l = pstart; l < pstop; l++)
							{
								if(*(ga_pool[j] + l) == TRUE)
								{
									scratch = scratch + pow(2,l-pstart);
								} 
							}
							rander = rand() % 1000;
							if(rander < 500) scratch = scratch + 1;
							else scratch = scratch - 1;
							if(scratch <= ga_denom && scratch >= 0)
							{
								for(l = pstop - 1; l >= pstart; l--)
								{
									if(scratch >= pow(2,l-pstart))
									{
										*(ga_pool[j]+l) = TRUE;
										scratch = scratch - pow(2,l-pstart);
									}
									else
									{
										*(ga_pool[j]+l) = FALSE;
									}
								}
								changed[j] = TRUE;
							}
						}
					}
				} 
			}
		}	
	}
	fl_hide_form(abort_window);
	smallest = ss_errors[0];
	small_numb = 0;
	for(j = 1; j < ga_poolsize; j++)
	{
		if(smallest > ss_errors[j])
		{
			smallest = ss_errors[j];
			small_numb = j;
		}
	}
	intercept = 0;
	for(k = 1; k < 1 + ga_bitsize; k++)
	{
		if(*(ga_pool[small_numb] + k) == TRUE)
		{
			intercept = intercept + pow(2,k-1);
		} 
	}
	intercept = intercept / ga_denom;
	intercept = intercept * ga_maxreal;
	if(*(ga_pool[small_numb]) == TRUE)
	{
		intercept = -1.0 * intercept;
	}
	for(k = 0; k < numbvars; k++)
	{
		for(l = 0 ; l < 4; l++)
		{
			if(*(ga_pool[small_numb] + ga_bitsize + 1 + k * (4 + 4 * (ga_bitsize + 2)) + l) == TRUE || (ga_force == TRUE && l == 0))
			{
				ga_coefs[k][l] = 0.0;
				for(m = 0; m < ga_bitsize; m++)
				{
					if(*(ga_pool[small_numb] + 1 + ga_bitsize + k * (4 + 4 * (ga_bitsize + 2)) + 4 + l * (2 * (ga_bitsize + 1)) + 1 + m) == TRUE)
					{
						ga_coefs[k][l] = ga_coefs[k][l] + pow(2,m);
					}
				}
				ga_coefs[k][l] = ga_coefs[k][l] / ga_denom;
				ga_coefs[k][l] = ga_coefs[k][l] * ga_maxreal;
				if(*(ga_pool[small_numb] + 1 + ga_bitsize + k * (4 + 4 * ( ga_bitsize +2)) + 4 + l * ( 2 *(ga_bitsize+1))) == FALSE)
				{
					ga_coefs[k][l] = -1.0 * ga_coefs[k][l];
				}
				ga_powers[k][l] = 0.0;
				for(m = 0; m < ga_bitsize; m++)
				{
					if(*(ga_pool[small_numb] + 1 + ga_bitsize + k * (4 + 4 * (ga_bitsize + 2)) + 4 + l * (2 * (ga_bitsize + 1)) + 1 + m + ga_bitsize + 1) == TRUE)
					{
						ga_powers[k][l] = ga_powers[k][l] + pow(2,m);
					}
				}
				ga_powers[k][l] = ga_powers[k][l] / ga_denom;
				ga_powers[k][l] = ga_powers[k][l] * 10.0;				
				if(negative_exists[k] == TRUE)
				{
					ga_powers[k][l] = ((int) ga_powers[k][l]) + 1;
				}
			}
			else
			{
				ga_coefs[k][l] = 0.0;
				ga_powers[k][l] = 1.0;
			}
		}
	}
	sprintf(string_one,"GA Fitted Equation: %s = a ",data_matrix[dependent].name);
	for(i = 0; i < numbvars; i++)
	{
		strcat(string_one,"+/- ");
		sprintf(string_two,"b%d * (%s)^p%d ",i, data_matrix[variables[i]].name, i);
		strcat(string_one,string_two);
	}	
	simple_line_output("gafit",string_one);
	
	begin_table_output(2, "GA Fit: Settings Used");
		begin_column_output("Cycles         ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"%d", ga_cycles);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		end_column_output();
		begin_column_output("Pool Size      ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"%d", ga_poolsize);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		end_column_output();
		if(ga_mutate_ok == TRUE)
		{
			begin_column_output("Mutation       ", XLDLAS_JUST_CENTER);
			sprintf(string_one,"1/%d", ga_mutate);
			add_column_output(string_one, XLDLAS_JUST_CENTER);
			end_column_output();
		}
		if(ga_cross_ok == TRUE)
		{
			begin_column_output("Crossover      ", XLDLAS_JUST_CENTER);
			sprintf(string_one,"1/%d", ga_cross);
			add_column_output(string_one, XLDLAS_JUST_CENTER);
			end_column_output();
		}
		if(ga_perturbe_ok == TRUE)
		{	
			begin_column_output("Perturbation   ", XLDLAS_JUST_CENTER);
			sprintf(string_one,"1/%d", ga_perturbe);
			add_column_output(string_one, XLDLAS_JUST_CENTER);
			end_column_output();
		}
		begin_column_output("Segment Length ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"%d", ga_bitsize);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		end_column_output();
		begin_column_output("Maximum Real   ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"+/-%d", ga_maxreal);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		end_column_output();
		begin_column_output("Swapping       ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"%d", ga_swap);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		end_column_output();
		begin_column_output("Tolerance      ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"%d", ga_tolerance);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		end_column_output();
		begin_column_output("Observations   ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"%d - %d", ga_start, ga_stop);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		end_column_output();
	end_table_output(2);
	
	begin_table_output(4, "GA Fit: Estimates");
		strcpy(string_one,"Name");
		for(i = strlen(string_one); i < NAME_LENGTH; i++)
		{
			strcat(string_one," ");
		}
		begin_column_output(string_one, XLDLAS_JUST_CENTER);
		add_column_output(" Opr ", XLDLAS_JUST_CENTER);
		add_column_output("    Coefficient", XLDLAS_JUST_CENTER);
		add_column_output("          Power", XLDLAS_JUST_CENTER);
		end_column_output();
		seperator_output(4);
		
		sprintf(string_one,"%-*s", NAME_LENGTH, data_matrix[dependent].name);
		begin_column_output(string_one, XLDLAS_JUST_CENTER);
		add_column_output("  =  ", XLDLAS_JUST_CENTER);
		add_column_output("               ", XLDLAS_JUST_CENTER);
		add_column_output("               ", XLDLAS_JUST_CENTER);
		end_column_output();
		seperator_output(4);
		
		strcpy(string_one,"(intrcpt)");
		for(i =strlen(string_one); i < NAME_LENGTH; i++)
		{
			strcat(string_one," ");
		}
		begin_column_output(string_one, XLDLAS_JUST_CENTER);
		add_column_output("     ", XLDLAS_JUST_CENTER);
		sprintf(string_one,"%15f",intercept);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		add_column_output("               ", XLDLAS_JUST_CENTER);
		end_column_output();
		seperator_output(4);
		for(i = 0; i < numbvars; i++)
		{
			for(j = 0; j < 4; j++)
			{
				if(ga_coefs[i][j] != 0.0)
				{
					sprintf(string_one,"%-*s", NAME_LENGTH, data_matrix[variables[i]].name);
					begin_column_output(string_one, XLDLAS_JUST_CENTER);
					if(ga_coefs[i][j] >  0.0)
					{
						add_column_output("  +  ", XLDLAS_JUST_CENTER);
						sprintf(string_one,"%15f", ga_coefs[i][j]);
					}
					else
					{
						add_column_output("  -  ", XLDLAS_JUST_CENTER);
						sprintf(string_one,"%15f", -1.0 * ga_coefs[i][j]);
					}
					add_column_output(string_one, XLDLAS_JUST_RIGHT);
					sprintf(string_one,"%15f", ga_powers[i][j]);
					add_column_output(string_one, XLDLAS_JUST_RIGHT);
					end_column_output();
				}
			}
		}
	end_table_output(4);

	strcpy(string_one,fl_get_input(ga_save_input));
	fitnumber = -1;
	fit_type = 3;
	if(strlen(string_one) > 0)
	{
		if(check_variable_name(string_one) == TRUE && numb_variables != MAX_VARS)
		{
			strcpy(data_matrix[numb_variables].name,string_one);
			strcpy(data_matrix[numb_variables].description,"Fitted Values from GA Fit");
			data_matrix[numb_variables].obs = ga_stop;
			fitnumber = numb_variables;
			fvector[fitnumber] = (float *) malloc (MAX_OBS * sizeof (float));
			numb_variables++;
			fit_type = 0;
		}
		if(check_variable_name(string_one) == TRUE && numb_variables == MAX_VARS)
		{
			fl_show_alert("No Room to Add Fitted Variables","","",TRUE);
		}
		if(fitnumber == -1 && check_variable_name(string_one) == FALSE && fl_get_button(ga_overwrite_button) == TRUE)
		{
			for(i = 0; i < numb_variables; i++)
			{
				if(strcmp(data_matrix[i].name,string_one) == 0)
				{
					fitnumber = i;
					data_matrix[i].obs = ga_stop;
				}
			}
			fit_type = 1;
		}
		if(fitnumber == -1 && check_variable_name(string_one) == FALSE && fl_get_button(ga_overwrite_button) == FALSE)
		{
			i = fl_show_choice("Name for Fitted Variable Exists", "Should I overwrite it's current values?", "", 3,
					   "Yes","No", "Cancel");
			if( i == 1)
			{
				for(j = 0; j < numb_variables; j++)
				{
					if(strcmp(data_matrix[j].name,string_one) == 0)
					{
						fitnumber = j;
						data_matrix[i].obs = ga_stop;
					}
				}
				fit_type = 1;
			}
			
		}
	}
	if(fitnumber != -1)
	{
		fit_gavariable(fitnumber, variables, numbvars, intercept, ga_start, ga_stop);
		sprintf(string_one,"%d observations fitted to %s", ga_stop - (ga_start - 1), data_matrix[fitnumber].name);
		simple_line_output("gafit",string_one);
		oktoquit = FALSE;
		sync_graph_browsers(fit_type);
	}
	for(i = 0; i < ga_poolsize; i++)
	{
		free(ga_pool[i]);
	}
	reenable_ga_input();
	say_status("Waiting for GA variables");
}


void launch_ga(FL_OBJECT *obj, long arg)
{
	int i, dep;
	int indeps[MAX_VARS];
	int numbindeps;
	numbindeps = 0;	
	dep = -1;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(ga_yvar_browser, i+1))
		{
			dep = i;
			i = numb_variables;
		}
	}
	if(dep == -1)
	{
		fl_show_alert("No Dependent Variable Selected!","","",TRUE);
		return;
	}
	if(all_stop > data_matrix[dep].obs) all_stop = data_matrix[dep].obs;
	if(all_stop < all_start)
	{
		fl_show_alert("From Value Greater than to Value!",
			      "(or at least it is after to was adjusted to the dependent",
			      "variables number of observations)",
			      TRUE);
		return;
	}
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(ga_xvars_browser, i+1) && i != dep)
		{
			indeps[numbindeps] = i;
			numbindeps++;
		}
	}
	if(numbindeps == 0)
	{
		fl_show_alert("No Independent Variable(s) Selected!","","",TRUE);
		return;
	}
	run_ga(dep, indeps, numbindeps, all_start, all_stop); 
}


void start_gafit()
{
	int i;
	int largest;
	inhibit_input();
	say_status("Waiting for GA Values");
	largest = 0;
	fl_clear_browser(ga_xvars_browser);
	fl_clear_browser(ga_yvar_browser);
	for(i=0; i < numb_variables; i++)
	{
		if(data_matrix[i].obs > largest) largest = data_matrix[i].obs;
		fl_addto_browser(ga_xvars_browser,data_matrix[i].name);
		fl_addto_browser(ga_yvar_browser,data_matrix[i].name);
	}
	fl_set_counter_value(ga_from_counter, 1);
	fl_set_counter_bounds(ga_from_counter, 1, largest);
	fl_set_counter_step(ga_from_counter, 1, 10);
	all_start = 1;
	fl_clear_chart(ga_chart);
	
	fl_set_counter_value(ga_to_counter, largest);
	fl_set_counter_bounds(ga_to_counter, 1, largest);
	fl_set_counter_step(ga_to_counter, 1, 10);
	all_stop = largest;
	
	fl_set_counter_value(ga_cycles_counter, ga_cycles);
	fl_set_counter_bounds(ga_cycles_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(ga_cycles_counter, 1, 10);
	
	fl_set_counter_value(ga_update_counter, ga_update);
	fl_set_counter_bounds(ga_update_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(ga_update_counter, 1, 10);
	
	fl_set_counter_value(ga_mutate_counter, ga_mutate);
	fl_set_counter_bounds(ga_mutate_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(ga_mutate_counter, 1, 10);
	
	fl_set_counter_value(ga_maxreal_counter, ga_maxreal);
	fl_set_counter_bounds(ga_maxreal_counter, 1, XLDLAS_GA_MAXREAL);
	fl_set_counter_step(ga_maxreal_counter, 1, 10);
	
	fl_set_counter_value(ga_poolsize_counter, ga_poolsize);
	fl_set_counter_bounds(ga_poolsize_counter, 1, XLDLAS_MAX_GA_POOLSIZE);
	fl_set_counter_step(ga_poolsize_counter, 1, 10);
	
	fl_set_counter_value(ga_bitsize_counter, ga_bitsize);
	fl_set_counter_bounds(ga_bitsize_counter, 1, XLDLAS_MAX_GA_BITSIZE);
	fl_set_counter_step(ga_bitsize_counter, 1, 10);
	
	fl_set_counter_value(ga_swap_counter, ga_swap);
	fl_set_counter_bounds(ga_swap_counter, 1, XLDLAS_MAX_GA_POOLSIZE);
	fl_set_counter_step(ga_swap_counter, 1, 10);
	
	fl_set_counter_value(ga_cross_counter, ga_cross);
	fl_set_counter_bounds(ga_cross_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(ga_cross_counter, 1, 10);

	fl_set_counter_value(ga_perturbe_counter, ga_perturbe);
	fl_set_counter_bounds(ga_perturbe_counter, 1, XLDLAS_MAX_GA_CYCLES);
	fl_set_counter_step(ga_perturbe_counter, 1, 10);

	fl_set_counter_value(ga_tolerance_counter, ga_tolerance);
	fl_set_counter_bounds(ga_tolerance_counter, 0, XLDLAS_GA_MAXREAL);
	fl_set_counter_step(ga_tolerance_counter, 1, 10);

	if(ga_force == TRUE) fl_set_button(ga_force_button,1);
	else fl_set_button(ga_force_button, 0);
	
	if(ga_mutate_ok == TRUE) fl_set_button(ga_mutate_button,1);
	else fl_set_button(ga_mutate_button, 0);
	
	if(ga_cross_ok == TRUE) fl_set_button(ga_cross_button,1);
	else fl_set_button(ga_cross_button, 0);
	
	if(ga_perturbe_ok == TRUE) fl_set_button(ga_perturbe_button,1);
	else fl_set_button(ga_perturbe_button, 0);
	if(window_geometry[XLDLAS_GAFIT][0] != -1)
	{
		fl_set_form_geometry(ga_window, 
					window_geometry[XLDLAS_GAFIT][0],
					window_geometry[XLDLAS_GAFIT][1],
					window_geometry[XLDLAS_GAFIT][2],
					window_geometry[XLDLAS_GAFIT][3]);
	}	
	
	fl_show_form(ga_window,FL_PLACE_FREE,FL_FULLBORDER,"Fit Data Using a Genetic Algorithm");
}


void do_twoway_anova()
{
	float smallest, largest;
	char string_one[XLDLASMAX_INPUT];
	char string_two[XLDLASMAX_INPUT];
	int to_anova[MAX_VARS];
	int numb_anova, i,j,k;
	int block_variable;
	int block_categories;
	float block_boundary_step;
	float group_means[MAX_VARS];
	int   group_obs[MAX_VARS];
	float block_means[MAX_VARS];
	int block_obs[MAX_VARS];
	float cell_means[MAX_VARS][MAX_VARS];
	int cell_obs[MAX_VARS][MAX_VARS];
	float overall_mean;
	int total_obs;
	float ssg, ssb, sse, sst, ssi;
	float mean_ss_one, mean_ss_two;
	int df_one, df_two; 
	say_status("Doing Two Way ANOVA");
	all_start = fl_get_counter_value(anova_from_counter);
	all_stop = fl_get_counter_value(anova_to_counter);
	if(all_stop < all_start)
	{
		fl_show_alert("From Value Great than To Value","","",TRUE);
		return;
	}
	numb_anova = 0;
	strcpy(string_one,"Two Way ANOVA on: ");
	block_variable = -1;
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(anova_block_browser, i+1))
		{
			block_variable = i;
			i = numb_variables;
		}
		
	}
	if(block_variable == -1)
	{
		fl_show_alert("No Block Variable Selected for Two Way Anova","","",TRUE);
		return;
	}
	for(i = 0; i < numb_variables; i++)
	{
		if(fl_isselected_browser_line(anova_variable_browser, i+1) && i != block_variable)
		{
			to_anova[numb_anova] = i;
			numb_anova++;
			strcat(string_one,data_matrix[i].name);
			strcat(string_one, "  ");
		}
		
	}
	if(numb_anova == 0)
	{
		fl_show_alert("No variables Selected","","",TRUE);
		return;
	}
	if(numb_anova == 1)
	{
		fl_show_alert("ANOVA Requires at Least Two Variables","","",TRUE);
		return;
	}
	block_categories = fl_get_counter_value(anova_block_counter);
	sprintf(string_two," ( Block is %s, %d categories) ", data_matrix[block_variable].name, block_categories);
	strcat(string_one,string_two);	

	if(all_start > data_matrix[block_variable].obs)
	{
		fl_show_alert("No Block Variable Observations in Range","","",TRUE);
		return;
	}

	smallest = *(fvector[block_variable] + all_start - 1);
	largest = *(fvector[block_variable] + all_start - 1);
	for(i = all_start - 1; i < all_stop; i++)
	{
		if(*(fvector[block_variable] + i) != missing_value && i < data_matrix[block_variable].obs)
		{
			if(smallest == missing_value || smallest > *(fvector[block_variable] + i))
			{
				smallest = *(fvector[block_variable] + i);
			}
			if(largest == missing_value || largest < *(fvector[block_variable] + i))
			{
				largest = *(fvector[block_variable] + i);
			}
		}
	}
	if(smallest == missing_value || largest == missing_value)
	{
		fl_show_alert("No observations for Block Variable in Boundaries","","",TRUE);
		return;
	}
	if(smallest == largest)
	{
		fl_show_alert("No variation in Block Variable","Just do One Way Anova?","",TRUE);
		return;
	}
	block_boundary_step = (largest - smallest) / block_categories;
	simple_line_output("anova", string_one);
	
	begin_table_output(2, "Block Boundaries");
	begin_column_output("Category",XLDLAS_JUST_CENTER);
	add_column_output("            Bounds              ", XLDLAS_JUST_CENTER);
	end_column_output();
	
	seperator_output(2);
	
	for(i = 0; i < block_categories; i++)
	{
		sprintf(string_two,"%8d", i+1);
		begin_column_output(string_two, XLDLAS_JUST_CENTER);
		sprintf(string_two,"%14.3f to %-14.3f", smallest + (i * block_boundary_step), smallest + ((i+1) * block_boundary_step));
		add_column_output(string_two, XLDLAS_JUST_CENTER);
		end_column_output();
		block_means[i] = 0.0;
		block_obs[i] = 0;
		for(j = 0; j < block_categories; j++)
		{
			cell_means[i][j] = 0.0;
			cell_obs[i][j] = 0;
		}
	}
	end_table_output(2);
	

	for(i = 0 ; i < numb_anova; i++)
	{
		group_means[i] = 0;
		group_obs[i] = 0;
		for(j = all_start - 1; j < all_stop; j++)
		{
			if(j < data_matrix[to_anova[i]].obs && *(fvector[to_anova[i]] + j) != missing_value && *(fvector[block_variable] + j) != missing_value)
			{
				group_means[i] = group_means[i] + *(fvector[to_anova[i]] + j);
				group_obs[i]++;
				for(k = 0; k < block_categories; k++)
				{
					if(*(fvector[block_variable] + j) == largest)
					{
						block_means[block_categories - 1] = block_means[block_categories - 1] + *(fvector[to_anova[i]] + j);
						block_obs[block_categories - 1]++;
						cell_means[i][block_categories - 1] = cell_means[i][block_categories - 1] + *(fvector[to_anova[i]] + j);
						cell_obs[i][block_categories - 1]++;
						k = block_categories;
					}
					else
					{
						if(*(fvector[block_variable] + j) >= smallest + (k * block_boundary_step) && *(fvector[block_variable] + j) < smallest + ((k + 1) * block_boundary_step))
						{
							block_means[k] = block_means[k] + *(fvector[to_anova[i]] + j);
							block_obs[k]++;
							cell_means[i][k] = cell_means[i][k] + *(fvector[to_anova[i]] + j);
							cell_obs[i][k]++;
							k = block_categories;
						}
					}
				}
			}
		}
		if(group_obs[i] == 0)
		{
			fl_show_alert("No observations in the Following Variable", data_matrix[to_anova[i]].name, "", TRUE);
			return;
		}
		group_means[i] = group_means[i] / group_obs[i];
	}
	overall_mean = 0;
	total_obs = 0;
	for(i = 0; i < block_categories; i++)
	{
		if(block_obs[i] == 0)
		{
			sprintf(string_two,"%d", i+1);
			fl_show_alert("No Observations in the following category of Block Variable", string_two, "", TRUE);
			return;
		}
		else
		{
			overall_mean = overall_mean + block_means[i];
			block_means[i] = block_means[i] / block_obs[i];
			total_obs = total_obs + block_obs[i];
		}
	}
	overall_mean = overall_mean / total_obs;
	ssg = 0;
	ssb = 0;
	sst = 0;
	ssi = 0;
	for(i = 0 ; i < numb_anova; i++)
	{
		for(j = all_start - 1; j < all_stop; j++)
		{
			if(j < data_matrix[to_anova[i]].obs && *(fvector[to_anova[i]] + j) != missing_value && *(fvector[block_variable] + j) != missing_value)
			{
				sst = sst + pow(*(fvector[to_anova[i]] + j) - overall_mean, 2);
			}
		}
		for(j = 0; j < block_categories; j++)
		{
			cell_means[i][j] = cell_means[i][j] / cell_obs[i][j];
		}
	}
	
	for(i = 0; i < numb_anova; i++)
	{
		ssg = ssg + group_obs[i] * pow(group_means[i] - overall_mean, 2);
	}
	
	for(i = 0; i < block_categories; i++)
	{
		ssb = ssb + block_obs[i] * pow(block_means[i] - overall_mean, 2);
	}
	
	if(cell_obs[0][0] == 1)
	{
		sse = sst - ssg - ssb;
		say_status("Displaying ANOVA Table");
		begin_table_output(6, "Two Way ANOVA (1 observation per cell)");
		begin_column_output("      Source of ", XLDLAS_JUST_CENTER);
		add_column_output(  "       Sums of", XLDLAS_JUST_CENTER);
		add_column_output(  "    Degrees of", XLDLAS_JUST_CENTER);
		add_column_output(  "          Mean", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		end_column_output();		
	
		begin_column_output("      Variation ", XLDLAS_JUST_CENTER);
		add_column_output(  "       Squares", XLDLAS_JUST_CENTER);
		add_column_output(  "       Freedom", XLDLAS_JUST_CENTER);
		add_column_output(  "       Squares", XLDLAS_JUST_CENTER);
		add_column_output(  "       F Ratio", XLDLAS_JUST_CENTER);	
		add_column_output(  "       Prob(F)", XLDLAS_JUST_CENTER);
		end_column_output();
			
		seperator_output(6);
	
		begin_column_output(" Between Groups ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", ssg);	
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", numb_anova - 1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", ssg / (numb_anova - 1));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", (ssg / (numb_anova - 1)) / (sse / ((numb_anova - 1) *(block_categories - 1))));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", 1.0 - betai(((block_categories - 1) * (numb_anova - 1)) / 2.0, 
							(numb_anova - 1) / 2.0 , 
							((block_categories - 1) * (numb_anova - 1)) / ( ((block_categories - 1) * (numb_anova - 1)) + ((numb_anova - 1) * ((ssg / (numb_anova - 1)) / (sse / ((numb_anova - 1) *(block_categories - 1))))))));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
			
		begin_column_output(" Between Blocks ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", ssb);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", block_categories - 1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", ssb / (block_categories - 1));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", (ssb / (block_categories - 1)) / (sse / ((numb_anova - 1) *(block_categories - 1))));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", 1.0 - betai(((block_categories - 1) * (numb_anova - 1)) / 2.0, 
							(block_categories - 1) / 2.0  , 
							((block_categories - 1) * (numb_anova - 1)) / ( ((block_categories - 1) * (numb_anova - 1)) + ((block_categories - 1) * ((ssb / (block_categories - 1)) / (sse / ((numb_anova - 1) *(block_categories - 1))))))));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
			
		begin_column_output("          Error ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", sse);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", (block_categories - 1) * (numb_anova - 1));
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", sse / ((block_categories - 1) * (numb_anova - 1)));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		end_column_output();
			
			
		seperator_output(6);
	
		begin_column_output("          Total ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", sst);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", total_obs - 1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		end_column_output();

		end_table_output(6);
	}
	else
	{
		ssi = 0;
		for(i = 0; i < numb_anova; i++)
		{
			for(j = 0; j < block_categories; j++)
			{
				ssi = ssi + cell_obs[i][j] * pow(cell_means[i][j] - group_means[i] - block_means[j] + overall_mean,2);
			}
		}		
		sse = sst - ssg - ssb - ssi;
		say_status("Displaying ANOVA Table");
		begin_table_output(6, "Two Way ANOVA (Multiple observations per cell)");
		begin_column_output("      Source of ", XLDLAS_JUST_CENTER);
		add_column_output(  "       Sums of", XLDLAS_JUST_CENTER);
		add_column_output(  "    Degrees of", XLDLAS_JUST_CENTER);
		add_column_output(  "          Mean", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		end_column_output();		
	
		begin_column_output("      Variation ", XLDLAS_JUST_CENTER);
		add_column_output(  "       Squares", XLDLAS_JUST_CENTER);
		add_column_output(  "       Freedom", XLDLAS_JUST_CENTER);
		add_column_output(  "       Squares", XLDLAS_JUST_CENTER);
		add_column_output(  "       F Ratio", XLDLAS_JUST_CENTER);	
		add_column_output(  "       Prob(F)", XLDLAS_JUST_CENTER);
		end_column_output();
			
		seperator_output(6);
	
		df_one = numb_anova - 1;
		df_two = numb_anova * block_categories * (cell_obs[0][0]  - 1);
		mean_ss_one = ssg / df_one;
		mean_ss_two = sse / df_two;
		begin_column_output(" Between Groups ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", ssg);	
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", df_one);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", mean_ss_one);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", mean_ss_one / mean_ss_two);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", 1.0 - betai(df_two/2.0, df_one/2.0, df_two/(df_two+(df_one * (mean_ss_one/mean_ss_two)))));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
			
		df_one = block_categories - 1;
		mean_ss_one = ssb / df_one;
		begin_column_output(" Between Blocks ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", ssb);	
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", df_one);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", mean_ss_one);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", mean_ss_one / mean_ss_two);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", 1.0 - betai(df_two/2.0, df_one/2.0, df_two/(df_two+(df_one * (mean_ss_one/mean_ss_two)))));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
			
		df_one = (block_categories - 1) * (numb_anova - 1);
		mean_ss_one = ssi / df_one;
		begin_column_output("    Interaction ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", ssi);	
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", df_one);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", mean_ss_one);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", mean_ss_one / mean_ss_two);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", 1.0 - betai(df_two/2.0, df_one/2.0, df_two/(df_two+ (df_one * (mean_ss_one/mean_ss_two)))));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
			
		begin_column_output("          Error ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", sse);	
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", df_two);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", mean_ss_two);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		end_column_output();
			
			
		seperator_output(6);
	
		begin_column_output("          Total ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", sst);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", cell_obs[0][0] * numb_anova * block_categories - 1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_RIGHT);
		end_column_output();

		end_table_output(6);
	}

}


void do_anova(FL_OBJECT *obj, long arg)
{
	char string_one[XLDLASMAX_INPUT];
	float ssg, ssw, sst;
	int to_anova[MAX_VARS];
	int numb_anova, i,j;
	float sample_means[MAX_VARS];
	int true_obs[MAX_VARS];
	float total_mean;
	float ss_groups[MAX_VARS];
	int total_obs;
	if(anova_type == 1)
	{
		say_status("Doing One Way ANOVA");
		all_start = fl_get_counter_value(anova_from_counter);
		all_stop = fl_get_counter_value(anova_to_counter);
		if(all_stop < all_start)
		{
			fl_show_alert("From Value Great than To Value","","",TRUE);
			say_status("Waiting for Variable/Type selection to do ANOVA");
			return;
		}
		numb_anova = 0;
		strcpy(string_one,"One Way ANOVA on: ");
		for(i = 0; i < numb_variables; i++)
		{
			if(fl_isselected_browser_line(anova_variable_browser, i+1))
			{
				to_anova[numb_anova] = i;
				numb_anova++;
				strcat(string_one,data_matrix[i].name);
				strcat(string_one, "  ");
			}
			
		}
		if(numb_anova == 0)
		{
			fl_show_alert("No variables Selected","","",TRUE);
			say_status("Waiting for Variable/Type selection to do ANOVA");
			return;
		}
		if(numb_anova == 1)
		{
			fl_show_alert("ANOVA Requires at Least Two Variables","","",TRUE);
			say_status("Waiting for Variable/Type selection to do ANOVA");
			return;
		}
		
		for(i = 0; i < numb_anova; i++)
		{
			sample_means[i] = 0.0;
			true_obs[i] = 0;
			for(j = all_start - 1; j < all_stop; j++)
			{
				if(*(fvector[to_anova[i]] + j) != missing_value && j < data_matrix[to_anova[i]].obs)
				{
					sample_means[i] = sample_means[i] + *(fvector[to_anova[i]] + j); 
					true_obs[i]++;
				}
			}
			if(true_obs[i] == 0)
			{
				strcpy(string_one, data_matrix[to_anova[i]].name);
				fl_show_alert("The following Variable has no Observations in Current Range:", string_one, "", TRUE);
				say_status("Waiting for Variable/Type selection to do ANOVA");
				return;
			}
			sample_means[i] = sample_means[i] / true_obs[i];
		}
		total_mean = 0;
		total_obs = 0;
		for(i = 0; i < numb_anova; i++)
		{
			total_mean = total_mean + sample_means[i] * true_obs[i];
			total_obs = total_obs + true_obs[i];
		}
		total_mean = total_mean / total_obs;
		ssw = 0;
		for(i = 0; i < numb_anova; i++)
		{
			ss_groups[i] = 0;
			for(j = all_start - 1; j < all_stop; j++)
			{
				if(*(fvector[to_anova[i]] + j) != missing_value && j < data_matrix[to_anova[i]].obs)
				{
					ss_groups[i] = ss_groups[i] + pow(*(fvector[to_anova[i]] + j) - sample_means[i], 2);
				}
			}
			ssw = ssw + ss_groups[i];
		}
		ssg = 0;
		for(i = 0; i < numb_anova; i++)
		{
			ssg = ssg + true_obs[i] * pow(sample_means[i] - total_mean,2);
		}
		sst = ssg + ssw;

		say_status("Displaying ANOVA Table");
		simple_line_output("anova", "One Way Analysis of Variance");
		begin_table_output(6, string_one);

		begin_column_output("      Source of ", XLDLAS_JUST_RIGHT);
		add_column_output(  "       Sums of", XLDLAS_JUST_CENTER);
		add_column_output(  "    Degrees of", XLDLAS_JUST_CENTER);
		add_column_output(  "          Mean", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		end_column_output();		

		begin_column_output("      Variation ", XLDLAS_JUST_RIGHT);
		add_column_output(  "       Squares", XLDLAS_JUST_CENTER);
		add_column_output(  "       Freedom", XLDLAS_JUST_CENTER);
		add_column_output(  "       Squares", XLDLAS_JUST_CENTER);
		add_column_output(  "       F Ratio", XLDLAS_JUST_CENTER);
		add_column_output(  "       Prob(F)", XLDLAS_JUST_CENTER);
		end_column_output();
		
		seperator_output(6);

		begin_column_output(" Between Groups ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", ssg);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14d", numb_anova - 1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", ssg / (numb_anova - 1));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", (ssg / (numb_anova - 1)) / (ssw / (total_obs - numb_anova)));
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", 1.0 - betai((total_obs - numb_anova) / 2.0, 
							(numb_anova - 1) / 2.0  , 
							(total_obs - numb_anova) / ( (total_obs - numb_anova) + ((numb_anova - 1) * ((ssg / (numb_anova - 1)) / (ssw / (total_obs - numb_anova)))))  ));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		end_column_output();
		
		begin_column_output("  Within Groups ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", ssw);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14d", total_obs - numb_anova);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		sprintf(string_one,"%14.3f", ssw / (total_obs - numb_anova));
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		end_column_output();

		seperator_output(6);		

		begin_column_output("          Total ", XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14.3f", sst);
		add_column_output(string_one, XLDLAS_JUST_RIGHT);
		sprintf(string_one,"%14d", total_obs - 1);
		add_column_output(string_one, XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		add_column_output(  "              ", XLDLAS_JUST_CENTER);
		end_column_output();
		

		end_table_output(6);

	}
	if(anova_type == 2)
	{
		do_twoway_anova();
	}
	say_status("Waiting for Variable/Type selection to do ANOVA");
}



void analysis_routines(FL_OBJECT *menu, long user_data)
{
	int choice;
	choice = fl_get_menu(menu);
	if(choice == 1) begin_summarize(menu, 0);
	if(choice == 2) start_corr_variables(menu, 0);
	if(choice == 3) start_regress_variables(menu, 0);
	if(choice == 4) start_gafit();
	if(choice == 5) start_nnet();
	if(choice == 6) start_anova();
}
