/***************************************************************************
**    xIrcServerQuery.h  $Revision: 1.8 $ - $Name: V1-17B $ 
**    Dialog box to get server name
**
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
 ***************************************************************************/
#ifndef _xIRCSERVERQUERY_H
#define _xIRCSERVERQUERY_H

#include <xPshBtnFrame.h>
#include <xLineEdit.h>
#include <xComboBox.h>
#include <xDialog.h>
#include <xResources.h>
#include "xIrcSocket.h"

class xServerQuery : public xDialog
{
   Q_OBJECT
   
public:   
   xServerQuery(xWidgetResInfo *pPRes, QWidget *pParent = NULL,
                const char *pName = NULL);
   ~xServerQuery();
   void initClass(const char *pName);
   
   const char *server() { return(pServer->text()); };
   const char *port() { return(pPort->text()); };

   enum QryResults { Rejected, Accepted, Disconnect, Clear };

signals:
   void msgToSocket(const char *pBuf);

protected slots:
   void gotButton(int btn);
   virtual void done(int results) { QDialog::done(results); };
   void reject();
   void accept();
   
private slots:
   void gotReturn();
   void gotReturnFromServer(const char *pStr);

private:   
   xComboBox        *pServer;
   xLineEdit        *pPort;
   xPshBtnFrame     *pButtons;
   xWidgetResInfo    *wdtRes;
};

#endif
