/* Author's note:  THIS IS A STINKY HACKED-UP MESS.  I'm only
   releasing it in its current state because it's pretty useful even
   like this, and I don't know when I'll have time to work on it again.
                     --Adam Moss, adam@fox.org */

/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * 
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gimp.h"

/* Declare a local function.
 */
static void linearinvert (Image);
static void bezierinvert (Image);
static void hybridinvert (Image);

static void genbez(void);

static void scale_callback (int, void *, void *);
static void radio_callback (int, void *, void *);
static void ok_callback (int, void *, void *);
static void cancel_callback (int, void *, void *);

static char *prog_name;

static int dialog_ID;

static long amount = 2;

static Image input;

int
main (argc, argv)
     int argc;
     char **argv;
{
  int group_ID,group2_ID;
  int radio1_ID,radio2_ID,radio3_ID;
  int scale_ID;
  long radio1,radio2,radio3;

  /* Save the program name so we can use it later in reporting errors
   */
  prog_name = argv[0];

  /* Call 'gimp_init' to initialize this filter.
   * 'gimp_init' makes sure that the filter was properly called and
   *  it opens pipes for reading and writing.
   */
  if (gimp_init (argc, argv))
    {
      input = 0;
      
      /* This is a regular filter. What that means is that it operates
       *  on the input image. Output is put into the ouput image. The
       *  filter should not worry, or even care where these images come
       *  from. The only guarantee is that they are the same size and
       *  depth.
       */
      input = gimp_get_input_image (0);

      if (1)
	{
	  /* If input image is available, then do some work. (Invert).
	   *  Then update the output image.
	   */
	  if (input)
	    switch (gimp_image_type (input))
	      {
	      case RGB_IMAGE:
	      case GRAY_IMAGE:
		radio1=1;
		radio2=0;
		radio3=0;
		
		dialog_ID = gimp_new_dialog ("Enhanced Image-Expand");
		
		group2_ID = gimp_new_column_group (dialog_ID, DEFAULT, RADIO, "");
		/*		radio1_ID = gimp_new_radio_button (dialog_ID,group2_ID, "Hybrid");
		gimp_change_item (dialog_ID, radio1_ID, sizeof (radio1), &radio1);*/
		radio2_ID = gimp_new_radio_button (dialog_ID,group2_ID, "Bezier");
		gimp_change_item (dialog_ID, radio2_ID, sizeof (radio2), &radio2);
		radio3_ID = gimp_new_radio_button (dialog_ID,group2_ID, "Linear");
		gimp_change_item (dialog_ID, radio3_ID, sizeof (radio3), &radio3);
		
		group_ID = gimp_new_row_group (dialog_ID, group2_ID, NORMAL, "");
		scale_ID = gimp_new_scale (dialog_ID, group_ID, 2, 10, 2, 0);
		
		gimp_add_callback (dialog_ID, scale_ID, scale_callback, &amount);
		gimp_add_callback (dialog_ID, gimp_ok_item_id (dialog_ID), ok_callback, 0);
		gimp_add_callback (dialog_ID, gimp_cancel_item_id (dialog_ID), cancel_callback, 0);
		/*		gimp_add_callback (dialog_ID, radio1_ID, radio_callback, &radio1);*/
		gimp_add_callback (dialog_ID, radio2_ID, radio_callback, &radio2);
		gimp_add_callback (dialog_ID, radio3_ID, radio_callback, &radio3);
		
		if (gimp_show_dialog (dialog_ID))
		  {
		    /*			invert(input,output,amount);
					gimp_update_image (output);*/
		    gimp_init_progress ("Enhanced Image-Expand");
		    /*		    if (radio1==1)
		      {
		      }
		    else */
		    if (radio2==1)
		      {
			bezierinvert(input);
		      }
		    else 
		    if (radio3==1)
		      {
			linearinvert(input);
		      }
		  }
		break;
	      case INDEXED_IMAGE:
		gimp_message ("invert: cannot operate on indexed color images");
		break;
	      default:
		gimp_message ("invert: cannot operate on unknown image types");
		break;
	      }
	  
	  /* Free both images.
	   */
	  if (input)
	    gimp_free_image (input);
	}

	  /* Quit
	   */
      gimp_quit ();
    }

  return 0;
}

static void
scale_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}

static void
radio_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  *((long*) client_data) = *((long*) call_data);
}
 
static void
ok_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 1);
}

static void
cancel_callback (item_ID, client_data, call_data)
     int item_ID;
     void *client_data;
     void *call_data;
{
  gimp_close_dialog (dialog_ID, 0);
}

static void
linearinvert (input)
     Image input;
{
  Image output;
  long width, height;
  long channels, srowstride, drowstride;
  unsigned char *src_row, *dest_row;
  unsigned char *src, *dest;
  short row, col, cha, tmp, tmp2;
  int x1, y1, x2, y2;

  /* Get the input area. This is the bounding box of the selection in 
   *  the image (or the entire image if there is no selection). Only
   *  operating on the input area is simply an optimization. It doesn't
   *  need to be done for correct operation. (It simply makes it go
   *  faster, since fewer pixels need to be operated on).
   */
  gimp_image_area (input, &x1, &y1, &x2, &y2);

  output = gimp_new_image (0,
                           (x2-x1)*amount,
                           (y2-y1)*amount,
                           gimp_image_type (input)); 

  /* Get the size of the input image. (This will/must be the same
   *  as the size of the output image.
   */
  width = gimp_image_width (input);
  height = gimp_image_height (input);
  channels = gimp_image_channels (input);
  srowstride = width * channels;
  drowstride = (x2-x1) * channels;

  src_row = gimp_image_data (input);
  dest_row = gimp_image_data (output);

  src_row += srowstride * y1 + x1*channels;

  for (row = y1; row < y2; row++) /* interpolate horizontally */
    {
      src     = src_row;
      dest    = dest_row;
      for (col = 0; col < (x2-x1); col++)
	{
	  for (cha=0;cha<channels;cha++)
	    {
	      for (tmp=0;tmp<amount;tmp++)
		{
		  if (col !=(x2-x1-1)) /* if we're not along an edge... */
		    *(dest+(channels*col*amount)+cha+(channels*(tmp))) =
		    (((*(src+(col*channels)+cha))*(amount-tmp))/amount)
		      + (((*(src+(col*channels)+cha+channels))*(tmp))/amount);
		  else
		    *(dest+(channels*col*amount)+cha+(channels*(tmp))) =
		    (*(src+(col*channels)+cha));
		}
	    }
	}
      src_row += srowstride;
      dest_row += (amount)*drowstride*amount;
    }

  drowstride=(x2-x1)*channels;
  src_row = dest_row = gimp_image_data (output);
  for (row = y1; row < y2; row++) /* interpolate vertically */
    {
      src     = src_row;
      dest    = dest_row;
      if (row%10==0) gimp_do_progress ((y2-y1)-(y2-row), y2-y1);
      for (col = 0; col < (x2-x1); col++)
	{
	  for (cha=0;cha<channels;cha++)
	    {
	      for (tmp2=0;tmp2<amount;tmp2++)
		{
		  for (tmp=1;tmp<amount;tmp++)
		    {
		      if (row !=(y2-1)) /* if we're not along an edge... */
			{
			  *(dest + cha + (drowstride*amount*tmp) + (col*channels*amount) + (channels*tmp2)) =
			    ((*(dest + cha + (col*channels*amount) + (channels*tmp2))*(amount-tmp))/amount)
			+ ((*(dest + amount*drowstride*amount + cha + (col*channels*amount) + (channels*tmp2))*tmp)/amount);
			}
		      else
			{
			  *(dest + cha + (drowstride*amount*tmp)) = 0;
			  /*		  *(dest+(channels*col*amount)+cha+(drowstride*amount*tmp)) =0;*/
			}
		    }
		}
	    }
	}
      
      src_row = dest_row = src_row+ amount*drowstride*amount;
    }

  gimp_display_image (output);
  gimp_update_image (output);
  gimp_free_image (output); 
}


static signed long *bezx;
static signed long *bezy;
static signed long *bezbuf;
static signed long npts;

static void
bezierinvert (input)
     Image input;
{
  Image output;
  long width, height;
  long channels, srowstride, drowstride;
  unsigned char *src_row, *dest_row;
  unsigned char *src, *dest;
  short row, col, cha, tmp, tmp2;
  int x1, y1, x2, y2;
  /* Get the input area. This is the bounding box of the selection in 
   *  the image (or the entire image if there is no selection). Only
   *  operating on the input area is simply an optimization. It doesn't
   *  need to be done for correct operation. (It simply makes it go
   *  faster, since fewer pixels need to be operated on).
   */
  gimp_image_area (input, &x1, &y1, &x2, &y2);

  output = gimp_new_image (0,
                           (x2-x1)*amount,
                           (y2-y1)*amount,
                           gimp_image_type (input)); 

  /* allocate a suitably large space to put the b-spline & controls pts into (yuck) */
  bezx=malloc(sizeof(signed long)*amount*((x2-x1)+(y2-y1)));
  bezy=malloc(sizeof(signed long)*amount*((x2-x1)+(y2-y1)));
  bezbuf=malloc(sizeof(signed long)*amount*((x2-x1)+(y2-y1)));

  /* Get the size of the input image. (This will/must be the same
   *  as the size of the output image.
   */
  width = gimp_image_width (input);
  height = gimp_image_height (input);
  channels = gimp_image_channels (input);
  srowstride = width * channels;
  drowstride = (x2-x1) * channels;

  src_row = gimp_image_data (input);
  dest_row = gimp_image_data (output);

  src_row += srowstride * y1 + x1*channels;

  for (row = y1; row < y2; row++) /* interpolate horizontally */
    {
      src     = src_row;
      dest    = dest_row;
      for (cha=0;cha<channels;cha++)
	{
	  npts=0;
	  for (col = 0; col < (x2-x1); col++)
	    {
	      bezx[npts]=col*amount;
	      bezy[npts]=(*(src+cha+col*channels));
	      npts++;
	    }
	  genbez();
	  for (col = 0; col < (x2-x1)*amount; col++)
	    {
	      *(dest+cha+col*channels) = bezbuf[col];
	    }
	}
      src_row += srowstride;
      dest_row += (amount)*drowstride*amount;
    }

  src = dest = gimp_image_data (output);
  for (col=0; col<(x2-x1)*amount; col++)  /* interpolate vertically */
    {
      if (col%8==0) gimp_do_progress (col, (x2-x1)*amount);

      for (cha=0;cha<channels;cha++)
	{
	  npts=0;
	  for (row=0; row<(y2-y1); row++)
	    {
	      bezx[npts]=row*amount;
	      bezy[npts]=(*(src + cha + col*channels + (row*drowstride*amount*amount) ) );
	      npts++;
	    }
	  genbez();
	  for (row=0; row<(y2-y1)*amount; row++)
	  {
	    *(src + cha + col*channels + (row*drowstride*amount) ) = bezbuf[row];
	  }
	}
    }

  free(bezx);
  free(bezy);
  free(bezbuf);
  gimp_display_image (output);
  gimp_update_image (output);
  gimp_free_image (output); 
}

static void
genbez (void)
{
  int gb=0;
  int c;
  int i;
  double t,x,y,t2,t3;
  for (i=1;i<npts-2;i++)
    {
      for (c=0;c<bezx[i+1]-bezx[i];c++)
	{
/*	  bezbuf[gb++]=bezy[i];*/
	  t=(double)c/(double)(bezx[i+1]-bezx[i]);
	  t2=t*t;
	  t3=t2*t;
	  x = ( (-1.0/6.0)*t3 + (1.0/2.0)*t2 - (1.0/2.0)*t + 1.0/6.0 )
	    * (double) bezx[i-1] +
	      ( (1.0/2.0)*t3 - t2 + 2.0/3.0 )
		* (double) bezx[i] +
		  ( (-1.0/2.0)*t3 + (1.0/2.0)*t2 + (1.0/2.0)*t + 1.0/6.0 )
		    * (double) bezx[i+1] +
		      ( (1.0/6.0)*t3 )
			* (double) bezx[i+2]
			  ;
	  y = ( (-1.0/6.0)*t3 + (1.0/2.0)*t2 - (1.0/2.0)*t + 1.0/6.0 )
	    * (double) bezy[i-1] +
	      ( (1.0/2.0)*t3 - t2 + 2.0/3.0 )
		* (double) bezy[i] +
		  ( (-1.0/2.0)*t3 + (1.0/2.0)*t2 + (1.0/2.0)*t + 1.0/6.0 )
		    * (double) bezy[i+1] +
		      ( (1.0/6.0)*t3 )
			* (double) bezy[i+2]
			  ;
	  if (x<0)
	    {
/*	      printf("\n[X<0]");*/
	      x=0;
	    }
	  if (y<0)
	    {
/*	      printf("\n[Y<0]");*/
	      y=0;
	    }
	  if (y>255)
	    {
/*	      printf("\n[Y>255]");*/
	      y=255;
	    }
	  bezbuf[(int)x]=(int)y;
	}
    }
}
