

proc AddConf { fid var_var setto expl } {
  global glob config 
  upvar $var_var var
  puts -nonewline $fid {#-----------------------------------------------------------------------}
  #puts -nonewline $fid "# Variable: $var_var"
  puts $fid "$expl"
  if { $setto == "" } {
    puts $fid "set $var_var \{$var\}"
  } else {
    puts -nonewline $fid "set $var_var $setto"
  }
  puts $fid ""
}

proc SaveConfig {}  {
  global glob config env
  set r [catch {open $env(HOME)/.fr w} fid]
  if {$r != 0} { PopError "Saving config: $fid"; return "" }
  
  puts $fid {
# This is the configuration file for FileRunner. It will be read
# everytime FileRunner starts up and also when you do a Save&Quit after
# editing this file. Only edit values for variables that are listed. Do
# not add or delete anything, since this file will be automatically
# re-generated when you do a Save Settings and those changes will be
# lost.
}

  AddConf $fid config(hotlist) "{" {
# This list is what will show up in your HotList menu. (Like "bookmarks"
# in Netscape). Feel free to edit this list.
}
  foreach k $glob(hotlist) {
    if { [lindex $k 1] != "" } {
      puts $fid "    {$k}"
    } else {
      puts $fid "    $k"
    }
  }
  puts $fid "  }\n"

  puts $fid {
# ****** COMMAND SETTINGS ***********************************************
}

  AddConf $fid config(editor) "" {
# This variable should be set to the name of your favourite text
# editor. This editor will be invoked when you select files and press
# the "Edit" button. The text editor you choose should be an
# X-application, not a text-terminal application. You can start
# text-terminal edtiors for example by launching them from inside an
# xterm. E.g: "xterm -e vi %s". The editor you choose should be able to
# load multiple files specified as arguments to the editor (e.g: 
# "emacs /tmp/foo /home/joe/bar"). The editor will be launched in the
# background.
}

  AddConf $fid config(view,extensions) "" {
# This parameter contains a list of commands and the file patterns that
# are used when finding the right viewer for various files. The commands
# will receive a list of selected files. The first file in the selected
# list are used when deciding which viewer should be used. (Don't try
# and view a couple of text files and images simultaneously by selecting
# and pressing the view button). If you add a the option "-viewtext"
# last in the rule that means the command outputs a listing/view and it
# should be viewed in the internal text viewer. The viewing commands
# will be executed in the background.
}

  AddConf $fid config(cmd,print) "" {
# The print command you want to use to print files.
}

  AddConf $fid config(cmd,term) "" {
# The name of your favourite terminal program.
# This is the program that will be launched when you press the button
# with the image of the terminal window (upper right of the file list
# panels). It will be launched in the background.
}

  AddConf $fid config(cmd,diff) "" {
# Your favourite diff command. Should be able to diff directories also.
# Used in the "Diff" button command. This program will run
# synchronously, i.e. FileRunner will wait until it's done.
}

  puts $fid {
# ****** ARCHIVER/PACKER SETTINGS ***************************************
}

  AddConf $fid config(cmd,unarc,extensions) "" {
# Extensions and bindings for unarchive rules. This is a list of
# commands and file name extensions. FileRunner will use this variable
# when deciding which command should be used to unarchive the file when
# you press the UnArc button.
}

  AddConf $fid config(cmd,unpack,extensions) "" {
# Extensions and bindings for unpacking rules. This is a list of
# commands and file name extensions. FileRunner will use this variable
# when deciding which command should be used to unpack the file when you
# press the UnPack button.
}

  AddConf $fid config(cmd,pack) "" {
# The name of your favourite packer command. 
# Used in the "Arc" button command to pack files. Run synchronously.
}

  AddConf $fid config(cmd,arc) "" {
# This is the name of your archiver program. The name of a directory
# will show up twice as "%s". The archive created is supposed to contain
# the contents of the directory.
# Used in the "Arc" button command to pack/archive directories. Run 
# synchronously.
}

  puts $fid {
# ****** FTP SETTINGS ***************************************************
}

  AddConf $fid config(ftp,login) "" {
# Rule based login information. Allows automatic determination
# if the login should use a proxy and what username/password it
# should use etc.
# See the online guide, chapter 8.8.
}

  AddConf $fid config(ftp,fastlink) "" {
# Set this to 1 if you feel your FTP connections are fast, to 0
# otherwise. If you set it to 1, soft-links in FTP listings are
# correctly identified either as links to directories or to files,
# otherwise it will always think links are links to directories.
}

  AddConf $fid config(ftp,proxy) "" {
# If you have to go through a firewall via an FTP proxy, set this
# variable to the hostname of your FTP proxy. Set it to "" if you don't
# have an FTP proxy.
}

#  AddConf $fid config(ftp,user) "" {
# Set username for FTP sessions. If you are doing anonymous FTP, set
# this to "anonymous".
#}

  AddConf $fid config(ftp,password) "" {
# Set password for anonymous FTP sessions. This should be your 
# email address.
}

  AddConf $fid config(ftp,timeout) "" {
# Set timeout in seconds for FTP communication. 
}

  AddConf $fid config(ftp,anonymous) "" {
# 1 -> Do anonymous FTP
# 0 -> Log in to FTP with username and password.
}

  AddConf $fid config(ftp,useproxy) "" {
# 1 -> Use defined ftp proxy
# 0 -> Don't use proxy
}

  puts $fid {
# ****** APPEARANCE SETTINGS ********************************************
}

  AddConf $fid config(gui,color_bg) "" {
# Background color of listboxes etc.
# You can edit this easier from the settings menu.
}

  AddConf $fid config(gui,color_fg) "" {
# Foreground color of listboxes etc.
# You can edit this easier from the settings menu.
}

  AddConf $fid config(gui,color_cmd) "" {
# Color for commands in the command window.
# You can edit this easier from the settings menu.
}

  AddConf $fid config(gui,color_select) "" {
# Selection color.
# You can edit this easier from the settings menu.
}

  AddConf $fid config(gui,color_scheme) "" {
# Scheme color.
# Default Tk is to be "grey85"
# You can edit this easier from the settings menu.
}

  AddConf $fid config(gui,font) "" {
# Font for listboxes etc. Must be fixed-width.
# Some good choices:
#  screen-bold-12
#  *-lucidatypewriter-bold-r-normal-*-12-*
#  *-lucidatypewriter-bold-r-normal-*-14-*
#  *-courier-bold-r-normal-*-14-*
}

  AddConf $fid config(gui,font_scheme) "" {
# Font for default Tcl/Tk stuff (menus, buttons etc.)
# Set this to "" in order to not change from what it already is.
# Default Tk seems to be "-Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*"
}

  AddConf $fid config(geometry,main) "" {
# The X11 geometry string deciding where and how big the FileRunner
# main window should be at startup.
}

  AddConf $fid config(geometry,textviewer) "" {
# The X11 geometry string deciding where and how big the FileRunner
# text viewer window should be.
}

  AddConf $fid config(geometry,qedit) "" {
# The X11 geometry string deciding where and how big the FileRunner
# quick-editor window should be.
}

  puts $fid {
# ****** SHELL SETTINGS *************************************************
}

  AddConf $fid config(shell,height,left) "" {
# Height in lines of text of the left shell text window.
}

  AddConf $fid config(shell,height,right) "" {
# Height in lines of text of the right shell text window.
}

  AddConf $fid config(shell,buffer) "" {
# Size of shell buffer, in lines of text.
}

  AddConf $fid config(shell,aliases) "{" {
# Shell aliases, in the form of a list of tuples: " { alias, command } .. "
# If there are arguments to the command line they are just tagged onto the
# alias. (I.e, aliases can take arguments)
}
  foreach k $config(shell,aliases) {
    if { [lindex $k 1] != "" } {
      puts $fid "    {$k}"
    } else {
      puts $fid "    $k"
    }
  }
  puts $fid "  }\n"

  puts $fid {
# ****** MISC SETTINGS **************************************************
}

  AddConf $fid config(startpwd,left) "" {
# At startup, show this directory in the left panel.
# If you set it to "", FileRunner will show the directory from where 
# it was invoked.
}

  AddConf $fid config(startpwd,right) "" {
# At startup, show this directory in the right panel
# If you set it to "", FileRunner will show the directory from where 
# it was invoked.
}

  AddConf $fid config(fileshow,all) "" {
# 1 -> Will show files beginning with a dot ".".
# 0 -> Won't.
}

  AddConf $fid config(fileshow,sort) "" {
# This variable determines how file listings are sorted. Possible values
# are "nameonly", "dirsfirst", "dirslast", "time" and "size"
}

  AddConf $fid config(dateformat) "" {
# Sets date format. Possible values "yymmdd" and "ddmmyy".
# (yy=year mm=month dd=day)
}

  AddConf $fid config(autoupdate) "" {
# Sets how often FileRunner checks to see if it needs to update its 
# windows.
# Set this to 0 to disable. Value is in seconds.
}

  AddConf $fid config(logsize) "" {
# Size of log in bytes. Don't set this too high, or FileRunner might 
# slow down a little. When the log exceeds this size, it will be 
# truncated.  
}

  AddConf $fid config(check_ownership) "" {
# If this is "1", FileRunner will check as best as it can if you are
# about to overwrite or delete a file you do not own and warn you about
# it. This can be handy when working in groups with other people and you
# want an extra check that you don't accidentally erase someone elses
# files.  This will slow some operations down slightly.
}

  AddConf $fid config(keyb_support) "" {
# If this is 1, you will make the file listbox take focus when clicked
# and this will let you use the keyboard for traversing the list (using
# arrows and PgUp/PgDown) and issuing commands.
# You'll have to restart FileRunner to get this setting to have effect.
}

  AddConf $fid config(ask,dir_delete) "" {
# If 1, FileRunner will ask you if you are sure when you delete 
# directories. If 0, it will go ahead and delete without asking.
}

  AddConf $fid config(ask,file_delete) "" {
# If 1, FileRunner will ask you if you are sure when you delete 
# files. If 0, it will go ahead and delete without asking.
}


  puts $fid {
# ****** DANGEROUS SETTINGS :-) *****************************************
# Below this point you can change some of the stuff that is used
# internally by FileRunner. This should almost never be necessary if the
# platform is standard Unix or close to standard Unix. If you change any
# of this below, make very very sure you get it right. If you are
# unsure, don't touch it. If you get it wrong, very bad things can
# happen...
# 
# A note on having the full path to the commands below, like using
# "/bin/cp" and not just "cp": Lets say you have a dot "." in your path
# and someone really mean has created a command called "cp" in his home
# directory that does a "rm" instead. Then you cd to his home directory
# and type cp <something>, you will invoke his evil manipulated version
# of cp that removes whatever you inteded to copy. The morale of this is
# to always use full path to critical commands and hope your sysop is
# not so mean he will rename "/bin/rm" to "/bin/mkdir"...
# A few commands below do not have specified full path, that's because
# they aren't very critical and seem to move around between different
# versions of Unix.
}

  AddConf $fid config(cmd,mkdir) "" {
# The make-dir command. This should almost always be /bin/mkdir.
}

  AddConf $fid config(cmd,mkdir,hier) "" {
# The make-dir hierarchic command. This should almost always be /bin/mkdir -p.
}

  AddConf $fid config(cmd,sh) "" {
# The bourne-shell command. This should almost always be /bin/sh.
}

  AddConf $fid config(cmd,rm) "" {
# The rm (remove-files) command. This should almost always be /bin/rm.
}

  AddConf $fid config(cmd,mv) "" {
# The mv (move-files or rename) command. This should almost always be /bin/mv.
}

  AddConf $fid config(cmd,cp) "" {
# The cp (copy-files) command. This should almost always be /bin/cp.
}

  AddConf $fid config(cmd,ln) "" {
# The ln (link) command. This should almost always be /bin/ln.
}

  AddConf $fid config(cmd,chmod) "" {
# The change mode (chmod) command. This should almost always be /bin/chmod.
}

  AddConf $fid config(cmd,touch) "" {
# The touch command.
}

  AddConf $fid config(cmd,du) "" {
# The "du" command. Should return size in kilobytes. On many
# systems other than BSD (?) you need to add a -k argument
# to this command to get it in kilobytes.
}

  close $fid
  Log "Settings saved to $env(HOME)/.fr"
}

proc InitConfig {} {
  global glob config env argv

  set config(hotlist) ""
  if {[info exists env(EDITOR)]} {
    set config(editor) "$env(EDITOR) {%s}"
  } else {
    set config(editor) "xterm -e vi {%s}"
  }
  set config(fileshow,all) 0
  set config(fileshow,sort) "dirsfirst"

  set config(cmd,print) "lpr {%s}"
  set config(cmd,term) "xterm"
  set config(cmd,diff) "diff -r {%s} {%s}"
  set config(cmd,pack) "gzip {%s}"
  set config(cmd,arc) "tar cf - {%s} | gzip > {%s.tar.gz}"

  set config(cmd,unarc,extensions) {
  { {gzip -cd {%s} | tar xfBp -}
    {*.tgz *.taz *.tar.z *.tar.gz} }
  { {tar xfBp {%s}}
    {*.tar} }
  { {unzip -oqq {%s}}
    {*.zip} }
  { {lha -x {%s}}
    {*.lha} }
}

  set config(cmd,unpack,extensions) {
  { {gzip -d {%s}}
    {*.gz} }
}

  set config(startpwd,left) ""
  set config(startpwd,right) ""
  set config(ask,dir_delete) "1"
  set config(ask,file_delete) "0"
  set config(ftp,fastlink) 0
  set config(ftp,proxy) ""
  set config(ftp,user) anonymous
  set config(ftp,password) ""
  set config(ftp,timeout) "120"
  set config(ftp,anonymous) 1
  set config(ftp,useproxy) 1
  set config(ftp,login) {}
  set config(gui,color_bg) FloralWhite
  set config(gui,color_fg) Black
  set config(gui,color_cmd) "#ffffe4e679db"
  set config(gui,color_select) "#f1a9ec43aa9d"
  set config(gui,color_scheme) "#d1f0dfbebd10"
  set config(gui,font_scheme) ""

  foreach testfont { 
      screen-bold-12 
      *-lucidatypewriter-bold-r-normal-*-12-*
      *-lucidatypewriter-bold-r-normal-*-14-*
      *-courier-bold-r-normal-*-14-* 
      fixed 
      } {
    set config(gui,font) $testfont
    set r [catch { label .foo -font $testfont } out]
    catch {destroy .foo}
    #puts "$r $out"
    if {$r == 0} {
      break
    }
  }
  set config(keyb_support) 0
  set config(dateformat) "yymmdd"
  set config(autoupdate) 20
  set config(logsize) 5000
  set config(check_ownership) 0
  set config(geometry,main) "840x720+31+0"
  set config(geometry,textviewer) "80x30"
  set config(geometry,qedit) "80x30"
  set config(shell,height,left) 10
  set config(shell,height,right) 10
  set config(shell,buffer) 1000
  set config(shell,aliases) {{.. {cd ..}} {md mkdir} {m view} {more view} {less view}}
  set config(view,extensions) {
  { {xmikmod {%s}}
    {*.mod.gz *.s3m *.mtm *.stm *.xm *.uni *.mod} }
  { {timidity {%s}}
    {*.midi.gz *.midi *.mid.gz *.mid} }
  { {xv -gamma 2.0 {%s}}
    { *.bmp *.iff *.jpg *.pbm *.pgm *.png *.ppm *.tga *.tif *.tiff *.xbm *.xpm *.gif} }
  { {gzip -dc {%s} | ghostview -}
    { *.ps.gz } }
  { {ghostview {%s}}
    { *.ps } }
  { {xanim {%s}}
    {*.avi *.fli *.flc *.mpg} }
  { {gzip -cd {%s} | tar tvf -} 
    { *.tgz *.taz *.tar.z *.tar.gz }
    -viewtext }
  { {tar tvf {%s}}
    {*.tar}
    -viewtext }
  { {unzip -lv {%s}}
    {*.zip}
    -viewtext }
  { {lha -v {%s}}
    {*.lha}
    -viewtext }
  { {gzip -cd {%s}}
    {*.gz}
    -viewtext }
}

  set config(cmd,mkdir) "/bin/mkdir"
  set config(cmd,mkdir,hier) "/bin/mkdir -p"
  set config(cmd,sh) "/bin/sh"
  set config(cmd,rm) "/bin/rm"
  set config(cmd,mv) "/bin/mv"
  set config(cmd,cp) "/bin/cp"
  set config(cmd,ln) "/bin/ln"
  set config(cmd,chmod) "/bin/chmod"
  set config(cmd,touch) "touch"
  set config(cmd,du) "du -s"

  set glob(searchstring) ""
  set glob(log) ""
  set glob(left,pwd)  [Pwd]
  set glob(right,pwd) [Pwd]
  set glob(left,update_oldpwd) $glob(left,pwd)
  set glob(right,update_oldpwd) $glob(right,pwd)
  set glob(left,newpwd_oldpwd) $glob(left,pwd)
  set glob(right,newpwd_oldpwd) $glob(right,pwd)
  set glob(left,filelist) {}
  set glob(right,filelist) {}
  set glob(hotlist) {}
  set glob(toplevelidx) 0
  set glob(entry_dialog_return) {}
  set glob(ftp_entry_dialog_return) {}
  set glob(forceupdate) 0
  set glob(havedoneftp) 0
  set glob(enableautoupdate) 1
  set glob(left,df) ?
  set glob(right,df) ?
  set glob(abortcmd) 0
  set glob(left,dirstack) ""
  set glob(right,dirstack) ""
  set glob(left,shell,packed) 0
  set glob(right,shell,packed) 0
  set glob(shell,maxed) 0
  set glob(left,shell,history) {}
  set glob(right,shell,history) {}
  set glob(left,shell,complete,flipping) 0
  set glob(right,shell,complete,flipping) 0
  set glob(left,shell,history,flipping) 0
  set glob(right,shell,history,flipping) 0
  set glob(left,shell,history,flipping,index) 0
  set glob(right,shell,history,flipping,index) 0

  set glob(win,top) .fupper.ftop
  set glob(win,left) .fupper.fleft
  set glob(win,right) .fupper.fright
  set glob(win,middle) .fupper.fmiddle
  set glob(win,bottom) .flower

  set glob(gui,color_xx,winlist) ""
  set glob(gui,color_cmd,winlist) ""
  set glob(gui,color_scheme,winlist) ""
  set glob(gui,tablist) ""

  # These settings have already been incorporated, since they are used when creating
  # new widgets. (No widgets have been created yet)
  set glob(gui,color_bg)      $config(gui,color_bg)
  set glob(gui,color_fg)      $config(gui,color_fg)
  set glob(gui,color_cmd)     $config(gui,color_cmd)
  set glob(gui,color_select)  $config(gui,color_select)
  # These settings have not been set yet, must be done in ReConfigColors
  set glob(gui,color_scheme) ""
  set glob(gui,font_scheme) ""

  set glob(gui,font) $config(gui,font)
  set glob(gui,font_scheme) ""

  set glob(async) 0
  set glob(left,shellcount) 0
  set glob(right,shellcount) 0

  if {![info exists env(USER)]} {
    if {![info exists env(LOGNAME)]} {
      PopError "Cannot read \$USER or \$LOGNAME environment variable. FileRunner cannot work without this correctly set."
      CleanUp 1
    }
    set env(USER) $env(LOGNAME)
  }
  if {![info exists env(HOME)]} {
    PopError "Cannot read \$HOME environment variable. FileRunner cannot work without this correctly set."
    CleanUp 1
  }
  if {![info exists env(HOST)]} {
    set env(HOST) unknown
  }
  if {$env(HOST) == "unknown"} {
    set r [catch { exec uname -n } out]
    if {!$r} {
      set env(HOST) $out
    }
  }

  set glob(history) ""
  # read history from disk
  if { [file exists $env(HOME)/.fr_history ] } {
    set r [catch {set fid [open $env(HOME)/.fr_history r];gets $fid glob(history);close $fid} out]
    if {$r} {
      puts "FileRunner: Can't read directory history from disk: $out"
    }
  }

  # set up a few default options
#  option add *HighlightThickness 1 widgetDefault
  option add *InsertWidth 2 widgetDefault
  option add *Scrollbar.Width 11 widgetDefault
  option add *Button.BorderWidth 1 widgetDefault
  option add *Scrollbar.BorderWidth 2 widgetDefault
#  option add *Listbox.BorderWidth 2 widgetDefault # makes the spacing between list elements too large...
  option add *Frame.BorderWidth 2 widgetDefault
  option add *Entry.BorderWidth 2 widgetDefault
#  option add *insertBorderWidth 2 widgetDefault
#  option add *BorderWidth 1 widgetDefault
}

proc ReadConfig {} {
  global glob config env argv argv0
  if {[file readable $glob(lib_fr)/.fr]} {
    set r [catch {source $glob(lib_fr)/.fr} out]
    if {$r} {
      tk_dialog .error_dialog "Init error" "Reading system wide settings from $glob(lib_fr)/.fr:\n$out" error 0 "OK"
    }
  }
  if {[file readable $env(HOME)/.fr]} {
    set r [catch {source $env(HOME)/.fr} out]
    if {$r} {
      tk_dialog .error_dialog "Init error" "Reading user settings $env(HOME)/.fr:\n$out" error 0 "OK"
    }
  }
  set glob(hotlist) $config(hotlist)
  if {$config(ftp,password) == "" } {
    set r [catch {set config(ftp,password) "$env(USER)@[exec domainname]"}]
  }
  foreach k { left right } {
    if { $config(startpwd,$k) != "" && !$glob(init_done)} {
      catch { cd $config(startpwd,$k); set glob($k,pwd) [Pwd] } out
    }
  }
  if { $config(ftp,proxy) == "" } {
    set config(ftp,useproxy) 0
  }
  if { $config(dateformat) == "ddmmyy" } {
    GetTimeFromSecsSetFormat 1
  }
  if { $config(dateformat) == "yymmdd" } {
    GetTimeFromSecsSetFormat 0
  }
  ReConfigColors
  ReConfigFont
}

proc ConfigPwd {} {
  global glob config env argv argv0
  set pwd(left) [lindex $argv 1]
  set pwd(right) [lindex $argv 2]
  foreach k { left right } {
    if { $pwd($k) != "" && $glob($k,pwd) != $pwd($k) } {
      NewPwd $k $pwd($k)
      UpdateWindow $k
    } else {
      if { $config(startpwd,$k) != "" && $glob($k,pwd) != $config(startpwd,$k)} {
        NewPwd $k $config(startpwd,$k) 
        UpdateWindow $k
      }
    }
  }
  AppendToDirHistory $glob(left,pwd)
  AppendToDirHistory $glob(right,pwd)
  set glob(left,dirstack) $glob(left,pwd)
  set glob(right,dirstack) $glob(right,pwd)
}

