#! /bin/sh

me=`basename $0`

usage() {
    >&2 echo usage: $me basename control "[ historic ]"
    exit 1
}

ishistoric=0

if [ $# -lt 2 ]
then
    usage
fi

basename="$1"
shift
control="$1"
shift

case $# in
    0)
	;;
    1)
	if [ "$1" = "historic" ]
	then
	    ishistoric=1
	else
	    if [ "$1" = "basic" ]
	    then
		ishistoric=-1
	    else
		if [ "$1" = "" ]
		then
		    ishistoric=0
		else
	            usage
		fi
	    fi
	fi
	kind="$1"
	if [ ! -z "$kind" ]
	then
	    kindext="-$kind"
	fi
	;;
    *)
	usage
	;;
esac

# First ensure we do not provide any gzip or gunzip!

gzip="gzip gunzip"

findcmdargs="( -name `echo $gzip | sed 's/ / -o -name /g'` )"
findmanargs="( -name `echo $gzip | sed 's/ /.1 -o -name /g'`.1 )"

find debian-tmp/usr/bin ! -type d -a $findcmdargs -print | xargs rm -f
find debian-tmp/usr/man ! -type d -a $findmanargs -print | xargs rm -f

# Now do our stuff.

# These are known historic commands.

if [ $ishistoric -eq -1 ]
then
    historic=" compress "
else
    historic=" uncompress zcat zmore zless zcmp zdiff zgrep zegrep zfgrep "

    # Add commands from the gzip package to the ones that should go in the
    # historic package only.

    for gzcmd in `dpkg -L gzip | sed -n -e '/compress$/d' -e '/bin/p'`
    do
        if [ ! -d $gzcmd -a -e $gzcmd ]
        then
	    cmd=`basename $gzcmd`
	    if [ -z "`echo \"$historic\" | grep \" $cmd \"`" ]
	    then
	        historic="$historic $cmd "
	    fi
        fi
    done
fi

findcmdargs="( -name `echo $historic | sed 's/ / -o -name /g'` )"
findmanargs="( -name `echo $historic | sed 's/ /.1 -o -name /g'`.1 )"

if [ ! -d debian-tmp/usr/bin -o ! -d debian-tmp/usr/man ]
then
    >&2 echo $me: no correct debian-tmp directory here, aborting
    exit 2
fi

if [ ! -z "`find debian-tmp/usr/bin ! -type d -a $findcmdargs \
    -print 2>/dev/null`" ]
then
    hashistoric=1
else
    hashistoric=0
fi

manypacks=0

if [ -f stamp-historic -o -f stamp-basic ]
then
    manypacks=1
fi

rm -f stamp-historic

if [ $ishistoric -ne 0 ]
then
    if [ $hashistoric -eq 1 ]
    then
	find debian-tmp/usr/bin ! -type d -a ! $findcmdargs -print | xargs rm -f
	find debian-tmp/usr/man ! -type d -a ! $findmanargs -print | xargs rm -f
    fi
else
    if [ $hashistoric -eq 1 ]
    then
	find debian-tmp/usr/bin ! -type d -a $findcmdargs -print | xargs rm -f
	find debian-tmp/usr/man ! -type d -a $findmanargs -print | xargs rm -f
	if [ "$historic" = compress ]
	then
    	    touch stamp-basic
	else
    	    touch stamp-historic
	fi
    fi
fi

# Remove any unnecessary manual page.

commands="`find debian-tmp/usr/bin ! -type d -exec basename {} \;`"
findmanargs="( -name `echo $commands | sed 's/ /.1 -o -name /g'`.1 )"

find debian-tmp/usr/man ! -type d -a ! $findmanargs -print | xargs rm -f

# Fix the compress manual page if we're not an historic package.

manmagic='.\" Do not remove this magic line for Debian compress manual.'

if [ $ishistoric -ne 1 -a -e debian-tmp/usr/man/man1/compress.1 ] && \
    ! fgrep -q "$manmagic" debian-tmp/usr/man/man1/compress.1 2>/dev/null
then
    blurb=/tmp/.blurb.$$
    echo $manmagic >$blurb
    cat <<EOF >>$blurb
.SH IMPORTANT NOTE
Of the commands that are documented in this page, only
.B compress
is guaranteed to have been installed by the
.B $basename$kindext
package. Commands like
.B uncompress
and
.BR zcat ,
for instance, are supplied by the
.B gzip
package and have an usage that differs from the one documented in this
manual page.
EOF

    if [ $hashistoric -ne 0 ]
    then
    cat <<EOF >>$blurb
If you really want the less versatile and old-fashioned forms of the
gzip-provided commands, you may install the
.I historic
version of the
.B $basename$kindext
package (look for a package named something like
.BR $basename$kindext-historic ")."
EOF
    fi

    titleline=`grep -n '^.TH ' debian-tmp/usr/man/man1/compress.1 |
	sed 's/:.*//'`
    if [ -z "$titleline" ]
    then
        cat debian-tmp/usr/man/man1/compress.1 $blurb >/tmp/.compress.1.$$ \
	    && mv /tmp/.compress.1.$$ debian-tmp/usr/man/man1/compress.1
    else
	nextline=`expr $titleline + 1`
	rm -f /tmp/.compress.$$
	sed "$titleline,\$d" debian-tmp/usr/man/man1/compress.1 \
	    >>/tmp/.compress.1.$$
	echo >>/tmp/.compress.1.$$ \
	    '.TH COMPRESS 1 "" "Compatibility commands" "Debian User'"'"'s Manual"'
	cat $blurb >>/tmp/.compress.1.$$
	sed "1,${titleline}d" debian-tmp/usr/man/man1/compress.1 \
	    >>/tmp/.compress.1.$$
	mv /tmp/.compress.1.$$ debian-tmp/usr/man/man1/compress.1
    fi

    rm -f $blurb
fi

if [ -e debian-tmp/usr/man/man1/compress.1 ]
then
    if [ -z "$kind" ]
    then
     	mv debian-tmp/usr/man/man1/compress.1 \
	    debian-tmp/usr/man/man1/bsd-compress.1
    else
     	mv debian-tmp/usr/man/man1/compress.1 \
	    debian-tmp/usr/man/man1/${kind}-compress.1
    fi
fi

# Change the control file.

if [ -f stamp-historic -o -f stamp-basic ]
then
    manypacks=1
fi

magic=/tmp/.magic.$$
rm -f $magic

if [ $manypacks -eq 1 ]
then
    echo "Source: $basename" >>$magic
fi

sed '/^=MAGIC=$/,$d' $control
if [ -f $magic ]
then
    cat $magic
fi
sed '1,/^=MAGIC=$/d' $control

rm -f $magic

exit 0

