/*
 * Midnight Commander -- GNOME frontend
 *
 * Copyright (C) 1997 The Free Software Foundation
 *
 * Author: Miguel de Icaza (miguel@gnu.org)
 *
 */

#include <config.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include "x.h"
#include "main.h"
#include "key.h"
#include "global.h"
#include "dir.h"
#include "panel.h"
#include "tty.h"		/* for KEY_BACKSPACE */

GdkColorContext *mc_cc;

#define MAX_COLOR_PAIRS 32
struct gmc_color_pairs_s gmc_color_pairs [MAX_COLOR_PAIRS];

void
init_pair (int index, GdkColor fore, GdkColor back)
{
	if (index < 0 || index > MAX_COLOR_PAIRS){
		printf ("init_pair called with invalid index\n");
		exit (1);
	}
	gmc_color_pairs [index].fore = fore;
	gmc_color_pairs [index].back = back;
}

void
get_color (char *cpp, GdkColor *colp)
{
	GdkColor color;
	gint     status;
	
	gdk_color_parse (cpp, &color);
	colp->pixel = gdk_color_context_get_pixel (mc_cc, color.red, color.green, color.blue, &status);
}

static void
gmc_color_init (void)
{
	mc_cc = gdk_color_context_new (gtk_widget_get_default_visual (),
				       gtk_widget_get_default_colormap ());

	/* Call the code in color.c to parse the color definitions */
	init_colors ();
}

int
xtoolkit_init (int *argc, char *argv [])
{
	LINES = 40;
	COLS = 80;
	gnome_init (argc, &argv);
	gmc_color_init ();
}

int
xtoolkit_end (void)
{
	return 1;
}

widget_data
xtoolkit_create_dialog (Dlg_head *h, int grided)
{
	GtkWidget *win;

	win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	return (widget_data) win;
}

void
x_set_dialog_title (Dlg_head *h, char *title)
{
	gtk_window_set_title (GTK_WINDOW (h->wdata), title);
}

widget_data
xtoolkit_get_main_dialog (Dlg_head *h)
{
	return xtoolkit_create_dialog (h, 0);
}

/* Creates the containers */
widget_data
x_create_panel_container (int which)
{
	GtkWidget *win;

	win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	return (widget_data) win;
}

void
x_panel_container_show (widget_data wdata)
{
	printf ("x_panel_container_show\n");
	gtk_widget_show (GTK_WIDGET (wdata));
}

void
x_focus_widget (Widget_Item *p)
{
	printf ("x_focus_widget\n");
}

void
x_init_dlg (Dlg_head *h)
{
	printf ("x_init_dlg\n");
}

void
x_destroy_dlg (Dlg_head *h)
{
	gtk_widget_destroy (GTK_WIDGET(h->wdata));
}

void
gtkrundlg_event (Dlg_head *h)
{
	gtk_main ();
}

void
edition_pre_exec ()
{
}

void
edition_post_exec ()
{
}

void
done_screen ()
{
}

void
setup_sigwinch ()
{
}

void
create_panels (void)
{
	Dlg_head *h;

	current_panel = left_panel = create_a_panel ("My Panel");
	right_panel = create_a_panel ("My other panel");

	set_current_panel (0);
}


