#!@PERL@
#
# This program runs all test that starts with 'test-' and sums
# the results that the program prints.
# Each time result should be of the form:
# Time for|to KEYWORD (number_of_runs) 'other info': timestr()
#
# All options to this script is passed to all test program.
# useful options:
# --fast --force --lock-tables
# --server   ==> mysql (default) / mSQL / Pg (postgres) / Solid 
# --user     ==> the user with permission to create / drop / select
# --pass     ==> password for the user
# --cmp      ==> Compare --server with one of the others (mysql/mSQL/Pg/Solid)
# --comments ==> everything you want to say such as the extra options you 
#                gave to the db server. (use --comments="xxx xxx xxx"
# --machine  ==> Give a OS/machine id for your logfiles.
# --log	     ==> puts output in output/RUN-server-machine-cmp-$opt_cmp

use DBI;

$pwd = `pwd`; chomp($pwd);
$opt_silent=1;			# Don't write header
$prog_args=join(" ",@ARGV);
require "$pwd/bench-init.pl" || die "Can't read Configuration file: $!\n";
$opt_silent=0;
$perl=$^X;

$prog_count=$errors=0;

if ($opt_cmp) {
	$filename = "$opt_server$opt_suffix-" . machine_part() . "-cmp-$opt_cmp";
} else {
	$filename = "$opt_server$opt_suffix-" . machine_part();
}

if (! -d $opt_dir)
{
  if (-e $opt_dir)
  {
    die "$opt_dir isn't a directory\n";
  }
  mkdir $opt_dir,0777 || die "Can't create directory: $opt_dir\n";
}

if (!$opt_log)
{
  open(LOG,">&STDOUT");
}
else
{
  open(LOG, "> $opt_dir/RUN-$filename") ||
    die "Can't write to $opt_dir/RUN-$filename: $!\n";
}
select(LOG);
$|=1;

print "Benchmark DBD suit:  1.0a\n";
print "Date of test:        $date\n";
print "Running tests on:    ";
$machine = `uname -a`; chomp($machine);
print "$machine\n";
print "Arguments:           $log_prog_args\n";
print "Comments:            $opt_comments\n";
print "Limits from:         $opt_cmp\n";
print "Server version:      " . $server->version() . "\n\n";

$estimated=$warning=$got_warning=0;
while (<test-*>)
{
  next if (/\.sh$/);		# configure script
  next if (/\-fork$/);		# test script
  $prog_count++;
  /test-(.*)$/;			# Remove test from name
  $prog=$1;
  print "$prog: ";
  if (!$opt_use_old_results)
  {
    system("$perl ./test-$prog $prog_args > $opt_dir/$prog-$filename 2>&1") &&
      die "Can't execute $prog.  Check the '$opt_dir' directory\n";
  }
  open(TEST,"tail -1 $opt_dir/$prog-$filename|");
  $last_line= <TEST>;
  if ($last_line =~ /Total time:/i)
  {
    print $last_line;
    open(TEST,"$opt_dir/$prog-$filename");
    while (<TEST>)
    {
      if (/^(estimated |)time (to|for) ([^\s:]*)\s*\((\d*)\)[^:]*:\s*(\d*) secs \(\s*([^\s]*) usr\s*([^\s]*) sys[^\d]*([^\s]*) cpu/i)
      {
	$arg=$summa{$3};
	if (!defined($arg))
	{
	  $summa{$3}= [ $4,$5,$6,$7,$8,""];
	}
	else
	{
	  $arg->[0]+=$4;
	  $arg->[1]+=$5;
	  $arg->[2]+=$6;
	  $arg->[3]+=$7;
	  $arg->[4]+=$8;
	}
	if (length($1))
	{
	  $summa{$3}->[5].="+";
	  $estimated=1;
	}
	if ($got_warning)
	{
	  $summa{$3}->[5].="?";
	  $warning=1;
	  $got_warning=0;
	}
      }
      elsif (/^warning/i)
      {
	$got_warning=1;
      }
      else
      {
	$got_warning=0;
      }
    }
  }
  else
  {
    $errors++;
    print "Failed\n";
  }
}

print "\n";
if (!$errors)
{
  print "All $prog_count test executed successfully\n";
}
else
{
  print "Of $prog_count tests, $errors tests didn't work\n";
}
if ($estimated)
{
  print "Tests with estimated time have a + at end of line\n"
}
if ($warning)
{
  print "Tests with didn't return the correct result have a * at end of line\n";
}

if (%summa)
{
  @total=(0,0,0,0,0,"");
  print "\nTotals per operation:\n";
  print "Operation             seconds     usr     sys     cpu   tests\n";
  foreach $key (sort(keys %summa))
  {
    $arg=$summa{$key};
    printf("%-20.20s %8d %7.2f %7.2f %7.2f %7d %s\n",
	   $key,$arg->[1],$arg->[2],$arg->[3],$arg->[4],$arg->[0],
	   $arg->[5]);

    for ($i=0 ; $i < 5 ; $i++)
    {
      $total[$i]+=$arg->[$i];
    }
    $total[5].=$arg->[$i];
  }
  printf("%-20.20s %8d %7.2f %7.2f %7.2f %7d %s\n", 
	 "TOTALS",$total[1],$total[2],$total[3],$total[4],$total[0],
	 $total[5]);
}

select(STDOUT);
if ($opt_log)
{
  print "Test finished. You can find the result in:\n$opt_dir/RUN-$filename\n";
}
