%% $Id: xyguide.man,v 3.0 1995/07/07 20:14:21 kris Exp kris $
%%
%% ``Xy-pic User's Guide''.
%%
%% This file is part of the Xy-pic package for graphs and diagrams in TeX.
%% See the companion README and INSTALL files for further information.
%% Copyright (c) 1991-1995	Kristoffer H. Rose	<kris@diku.dk>
%%
%% The Xy-pic package is free software; you can redistribute it and/or modify
%% it under the terms of the GNU General Public License as published by the
%% Free Software Foundation; either version 2 of the License, or (at your
%% option) any later version.
%%
%% The Xy-pic package is distributed in the hope that it will be useful, but
%% WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
%% or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU General Public License
%% for more details.
%%
%% You should have received a copy of the GNU General Public License along
%% with this package; if not, write to the Free Software Foundation, Inc.,
%% 675 Mass Ave, Cambridge, MA 02139, USA.

\documentclass[twocolumn]{article}
\usepackage{xydoc}
\CompilePrefix{xygui-}
\makeindex
\begin{document}

\title{ \Xy-pic User's Guide }
\author{ Kristoffer H. Rose\quad<kris@diku.dk>\thanks{%
		DIKU (Computer Science dept.), University of Copenhagen,
		Universitetsparken~1, DK--2100 K{\o}benhavn {\O}, Denmark.}}
\date{Version \xyversion, \printdate{\xydate}}
\maketitle

\begin{abstract}
	\Xy-pic is a package for typesetting graphs and diagrams using
	Knuth's \TeX\ typesetting system.  \Xy-pic works with most of the
	many formats available, \eg, plain \TeX, \LaTeX, and \AMS-\TeX.
	Several styles of input for various diagram types are supported; they
	all share a mnemonic notation based on the "logical composition of
	visual components".  This guide concentrates on how to typeset
	`matrix-like' diagrams, such as ??w![commutative diagrams], in the
	following style:
%
\begin{code}
\xymatrix{
 U \ar@/_/[ddr]_y \ar@/^/[drr]^x
   \ar@{.>}[dr]|-{(x,y)}            \\
  & X \times_Z Y \ar[d]^q \ar[r]_p  
                 & X \ar[d]_f       \\
  & Y \ar[r]^g   & Z                }
\end{code}
$$\docode$$
%
	was typeset by the \Xy-pic input lines
%
\displaycode\noindent
%
	Such diagrams have the following characteristics:
%
\begin{itemize}
\item
	Specified as a matrix of entries that are automatically aligned in
	rows and columns.
\item
	Any entry may be connected to any other entry using a variety of
	arrow styles all rotated and stretched as required.
\item
	Arrows may be decorated with labels that are tied to a specified
	point along the arrow and extend in a particular direction; and
	arrows may be paired, cross, and visit/bend around other entries `on
	the way'.
\end{itemize}
%
	Several other styles of input are supported; a short survey of the
	possibilities is included last at the end along with information on
	how \Xy-pic can be obtained.
\end{abstract}

\tableofcontents
\newpage



\section*{Preface}\noindent
\addcontentsline{toc}{section}{Preface}%
%
	This guide explains some features of \Xy-pic that are relevant to
	typesetting of `matrix-like diagrams' as used in, for example,
	category theory; please refer to the reference
	manual~\cite{RM95:Xy-picRM} for complete information on the described
	constructions.  The guide assumes that you have some experience in
	using \TeX\ for typesetting mathematics, \eg, have
	studied~\cite[ch.~16--19]{K84:TeXbook}, \cite[sec.~3.3]{L94:LaTeX},
	or~\cite{S90:JoyT}, and that \Xy-pic is installed on your \TeX\
	system as described in the |INSTALL| file accompanying the
	distribution.

	The first section describes what you need to get started, in
	particular all that is needed to typeset the diagram in the abstract.
	Section~??[arrows] and~??[entries] explain advanced use of arrows and
	entries, respectively.  Finally, section~??[avail] explains where and
	under what conditions \Xy-pic is available, gives the relation of
	\xyversion\ to previous versions, and lists further sources of
	information.  Throughout we give exercises that you should be able to
	solve as you go along; all exercises are answered at the end just
	prior to the references and index.



\section{Basics}
??=[basics]
%
	This section explains the \Xy-diagram construction concepts needed to
	get started with typesetting matrix-like diagrams.


\subsection{Loading}
??=[basics.loading]
%
	The \Xy-pic setup used in this guide is loaded??w[loading] by
	inserting the lines
%
\begin{defs1}
 ??c![\input xy]\cr
 ??c![\xyoption]|{all}|??c[\xyoption{all}]\cr
\end{defs1}
\noindent\unskip
%
	in the definitions part of your
	document\footnote{??w![\LaTeXe]~\cite{L94:LaTeX} users can use
	??c![\usepackage]|[all]{xy}|.}.  If you wish to load only the
	features you use, or you wish to use non-standard facilities like the
	|v2| backwards compatibility mode\footnote{If you use the version~2
	loading command ??c![\input xypic] then the ??c![v2] option will be
	loaded automatically.} or the ??c![ps] \PS\ backend then this is also
	possible as described in the reference manual~\cite{RM95:Xy-picRM}.


\subsection{Entries}
??=[basics.entries]
%
	A diagram is created by the command
%
\begin{defs1}
 ??c![\xymatrix]|{|~\dots~|}|
\end{defs1}
\noindent\unskip
%
	where the `\dots' should be replaced by "entries"??w[entry] to be
	"aligned in ??w![rows] and ??w![columns]" where
%
\begin{itemize}
\item	entries in a row are separated by ??c![&] and
\item	entire rows are separated by ??c![\\].
\end{itemize}
%
	For example,
\begin{code}
\xymatrix{
  A &*+[F]{\sum_{i=n}^m {i^2}} \\
    & {\bullet} & D \ar[ul]	}
\end{code}
$$\docode$$
%
	was typeset by
%
\displaycode\noindent
%
	Notice the following:
%
\begin{itemize}
\item
	entries are typeset as mathematics (in `??w![text style]'); entries
	should not start with a macro (hence the use of |{|\dots|}| in some
	of the entries),
\item
	all entries are centered,
\item
	the separation between rows and columns is usually quite large in a
	diagram,
\item
	entries at the end of rows that are empty may be omitted,
\item
	``\Xy-decorations'' (here |\ar[ul]|) last in entries allow drawing of
	arrows and such relative to the entries without changing the overall
	layout, and
\item
	``\Xy-modifiers'' (here |*+[F]|) first in entries allow changing the
	format and shape in many ways.
\end{itemize}


\subsection{Arrows}
??=[basics.arrows]
%
	An `??w![arrow]' in an \Xy-pic diagram is a generic term for the
	drawn decorations that are added to the basic matrix structure.  In
	\Xy-pic all arrows must be specified along with the entry they start
	in; this is called their "??w![base entry]".  Each particular arrow
	command then refers explicitly to its "??w![target entry]".

	All arrows are obtained through the ??c![\ar] command which takes
	many options of which we will describe a few here and some more in
	section~??[arrows].  In its simplest form an arrow is entered as
	|\ar[|"hop"|]| where "??w![hop]" is a sequence of single letters:
	??c![u] for up, ??c![d] for down, ??c![l] for left, and ??c![r] for
	right, \eg, the arrow |\ar[ur]| reads `typeset an arrow from the
	current entry to that one up and one right'.

\begin{exercise}
	Which entry does ??C![] refer to?
\answertext{The target |[]| is the current entry itself.}
\end{exercise}

\vspace{\medskipamount}\noindent
%
	The relative ??w![coordinates] specified in this way are purely
	logical, \eg, if the diagram contains very wide entries then the
	arrows will be nearly horizontal.  The constructed arrows are aligned
	along the line between the centers of the base and target entries;
	they will not automatically disappear under entries that they cross
	(we discuss how this is achieved in section~??[arrows.pass]).

	The ??w![arrow style] kan be changed by writing the command as
	|\ar@|"style"|[|"hop"|]|.  This will be described in more detail in
	section~??[arrows.styles]; here we just list the most common
	??c![@]"style"s (most obvious variations also work):
$$
 \def\st#1{\hbox{\lower1ex\rlap{\kern1pc %
       \xy*{}+/r2pt/\ar@{#1},<1pc,-1.8pc>*{}\endxy}|@{#1}|}}
 \st{.>}~\st{=>}~\st{-->}~\st{==>}~\st{-}~\st{.}~\st{=}~\st{}
$$

\begin{exercise}
\begin{code}
\xymatrix{
 {\bullet} \ar@{--}[d]\ar@{=}[dr]\ar@{-}[r]
           & {\bullet} \ar@{.}[d] \\
 {\bullet} & {\bullet} \ar[l] }
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author did \displaycode\noindent Notice how
	\texttt{\string\bullet} has been enclosed in |{}| since it is an
	`expandable' entity, \ie, a defined macro.}
\end{exercise}


\subsection{Labels}
??=[basics.labels]
	You can put ??w![label]s on arrows.  Labels are conceptualized as
	sub- and superscripts on arrows such that they are placed in the
	usual positions (as `limits'), \ie, ??c![^] reads `above' and ??c![_]
	`below' on an arrow pointing right.  Notice that the positions depend
	"only" on the direction of the arrow, the absolute notions of `up',
	`down', etc. are not important.  For example,
\begin{code}
$\xymatrix{ X\ar[r]^a_b & Y & Z\ar[l]^A_B }$
\end{code}
\displaycode\noindent
%
	will set \docode.

	Each label is placed perpendicular to the center of the arrow
	(measured from the middle of the objects at the ends).  See
	section~??[arrows.places] for more ways to place labels.

	It is possible to use labels that are not single letters, digits, or
	control sequences: if a simple math formula in the default style
	(script style) is desired then simply enclose in |{|\dots|}|.  In
	practice anything can be used as a label as described in
	section~??[arrows.objects].

\begin{exercise}
\begin{code}
\xymatrix{
 A \ar[r]^f \ar[dr]_{f;g}
  & B \ar[d]^g \ar[dr]^{g;h} \\
  & C \ar[r]_h & D	     }
\end{code}
%
	Typeset the second axiom of category theory as
%
$$\docode$$
%
\answercode
\answertext{The author used \displaycode}
\end{exercise}


\subsection{Breaks}
??=[basics.breaks]
	It is also possible to `??w![break]' an arrow with a label using the
	??c![|] character:
%
\begin{code}
$\xymatrix{A\ar[r]|f&B}$
\end{code}
%
	\thecode\ will set \docode.

	If you just want an empty break you should use the special
	??c![\hole] break:
%
\begin{code}
$\xymatrix{ A\ar[r]|\hole & B }$
\end{code}
%
	the arrow \docode\ was typeset by including \thecode\ in the text.

        A different use of breaks is to place a label somewhere in a diagram
	outside the normal matrix mesh??w[entry outside matrix]: this is
	accomplished by `breaking' an ??w![invisible arrow] obtained using
	the ??c![@{}] ??w![arrow style]: the square
\begin{code}
\xymatrix{\ar @{} [dr] |{=}
 A \ar[d] \ar[r] & B \ar[d] \\
 B \ar[r]        & C        }
\end{code}
$$\docode$$
%
	was typeset by
%
\displaycode\noindent
%
	There is more on breaks in section~??[arrows.pass].

\begin{exercise}
\begin{code}
\xymatrix{
 A \ar[d]_f \ar[r]^f
            & B \ar[dl]|{i_B} \ar[d]^g \\
 B \ar[r]_g & C }
\end{code}
%
	Typeset the first axiom of category theory as the display
%
$$\docode$$
%
\answercode
\answertext{The author used \displaycode}
\end{exercise}


\subsection{Bends}
??=[basics.bends]
%
	Arrows can be made to ??w![curve], for example to avoid going through
	another entry, using the special style |@/|"curving"|/|.  The
	simplest styles of "curving" are the following, shown applied to an
	arrow from $A$ to $B$:
$$
\def\a#1{*\hbox{\def\1{#1}\enspace\tt\codeof\1\index code{#1}}& A \ar#1[r] & B}
\xymatrix @R-1.4pc{
 \a{@/^/} \\
 \a{@/_/} \\
 \a{@/_1pc/} }
$$
	As the last example shows a dimension can be inserted just after |^|
	or |_| if more or less curving is desired.

	In case it is easier to specify the in- and out-going directions of
	the curving then that is also possible: use
%
\begin{defs1}
 ??c![@(]"in"|,|"out"|)|
\end{defs1}
\noindent\unskip
%
	where "in" and "out" are one of the following "??w![direction]s"
	named as simple "hop"s:
$$
\xy *[o]\cir<1pc>{}="c",
  "c"; (-1,-1)**{},p+/3pc/ *+{|dl|} **@{-}?>*@{>},
  "c"; ( 0,-1)**{},p+/3pc/ *+{|d|}  **@{-}?>*@{>},
  "c"; ( 1,-1)**{},p+/3pc/ *+{|dr|} **@{-}?>*@{>},
  "c"; ( 1, 0)**{},p+/3pc/ *+{|r|}  **@{-}?>*@{>},
  "c"; ( 1, 1)**{},p+/3pc/ *+{|ur|} **@{-}?>*@{>},
  "c"; ( 0, 1)**{},p+/3pc/ *+{|u|}  **@{-}?>*@{>},
  "c"; (-1, 1)**{},p+/3pc/ *+{|ul|} **@{-}?>*@{>},
  "c"; (-1, 0)**{},p+/3pc/ *+{|l|}  **@{-}?>*@{>},
\endxy
$$
	I this case the curving is computed such that the curve begins at the
	base entry in the "in" direction and ends at the target entry from
	the "out" direction (this means that $|@(|d_1|,|d_2|)|$ and
	$|@(|d_2|,|d_1|)|$ are mirror images.  See
	section~??[arrows.changing] for more directions).

\begin{exercise}
	Typeset
%
\begin{code}
\xymatrix{
 x \ar@(ul,dl)[]|{id} \ar@/^/[rr]|f
 && f(x) \ar@/^/[ll]|{f^{-1}} }
\end{code}
$$
\docode
$$
\answercode
\answertext{The author did \displaycode\noindent Note that both arrows are
	curved `above' relative to their direction.}
\end{exercise}


\subsection{Speeding up typesetting}
??=[basics.speeding]
%
	One thing that you will notice is that \Xy-pic is sometimes slow in
	typesetting diagrams (this is to be expected considering the number
	of drawing operations performed as reflected by the number last in
	each |xymatrix| message).  If you followed the rule of starting all
	entries with a (nonexpandable) character or |{| then you can insert
	the declaration
%
\begin{defs1}
 ??c![\CompileMatrices]\cr
\end{defs1}
\noindent\unskip
%
	in the preamble of your document: this will create temporary
	files\footnote{The temporary files are named the same as your
	document but |.tex| is replaced by |-|$n$|.xyc| where $n$ is a
	sequence number.} containing "compiled" versions of each matrix that
	can be loaded very quickly; they are automatically recreated when a
	matrix is changed.

	If this doesn't work for a few diagrams then compilation can be
	explicitly switched off by using ??c![\xymatrixnocompile] instead of
	|\xymatrix|; compilation can be switched completely off with
	??c![\NoCompileMatrices] (which respects \TeX\ grouping as does
	??c![\CompileMatrices], by the way).



\section{More Arrows and Labels}
??=[arrows]
%
	In this section we explain a number of variations of the
	??w![arrow]??c[\ar] commands that are useful in ??w![commutative
	diagrams].


\subsection{Explicit label positioning}
??=[arrows.places]
%
	The ??w![label]??w[explicit positioning] commands explained in
	section~??[basics.labels] place the label text near the point along
	the arrow halfway between the centers of the base and target entries.
	This, however, may be changed by inserting a "place" between the
	??c![^], ??c![_], or ??c![|], and the actual label. In general you
	may insert the following:
%
\begin{itemize}
\item
	??c![<] will place the label at the point where the actual arrow
	begins, \ie, `appears from under' the base, so
%
\begin{code}
$\xymatrix{A\ar[r]^<{+}&B}$
\end{code}
%
	\thecode\ will typeset \docode.

\item
	Similarly, ??c![>] will place the label at the point where the actual
	arrow ends, \ie, `disappears below' the target, so
%
\begin{code}
$\xymatrix{A\ar[r]^>{+}&B}$
\end{code}
%
	\thecode\ will typeset \docode.

\item
	??c![<<] and ??c![>>] will place the following label at a point just
	a bit\footnote{`A bit' is in fact a \TeX\ ??c![\jot] which is usually
	3pt.}\ further from the beginning and end of the arrow, so
%
\begin{code}
$\xymatrix{A\ar[r]^>>{+}&B}$
\end{code}
%
	\thecode\ will typeset \docode.	 Using more |<|s or |>|s will move
	the label further in.

\item
	A factor in ??c![()]s: $|(|a|)|$ indicates that the label should be
	`tied' to the point $a$ of the way from the center of the base entry
	(called ??c![(0)]) to the center of the target (called ??c![(1)])
	instead of in the middle, so
%
\begin{code}
$\xymatrix{A\ar[r]^(.3){+}&B}$
\end{code}
%
	\thecode\ will typeset \docode.

\item
	A factor can be given "after" some |<| or |>|s: in that case the
	place is computed as if the base was the place specified by the |<|s
	and the target the place specified by the |>|s:
%
\begin{code}
$\xymatrix{A\ar[r]^<(0){+}&B}$
\end{code}
%
	\thecode\ will typeset {\docode}.

\item
	Finally, a ??c![-] means the same as |<>(.5)|, \ie, place at the
	"middle of the arrow"\index{label on middle of arrow} rather than the
	middle between the base and target, so
%
\begin{code}
$\xymatrix{
 A\times B\times C\times D \ar[r]^-{+} &B
}$
\end{code}
%
	 \docode\ was typeset by
%
\displaycode
%
	It becomes
%
$\xymatrix{
 A\times B\times C\times D \ar[r]^{+} &B
}$
%
	without~|-|.

\end{itemize}

\begin{exercise}
\begin{code}
\xymatrix{
 A \ar[d] ^>>\ast ^b \ar[dr] ^>>\ast ^c
   \ar[r] ^>>\ast ^d  & D \\
 B                    & C }
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author used the display \displaycode}
\end{exercise}


\subsection{Labeling with any object}
??=[arrows.objects]
%
	\Xy-pic supports a general format for entering any \TeX\
	??w![text]\index{text label} as labels (as well as entries to be
	explained later).  The character |*| is reserved for this: in its
	simplest form |*{|"math"|}| will typeset the "math" material as an
	object.  This is like |{|"math"|}| except that the default style is
	ignored and there is no added blank margin.

	However, in general\index{label with any object} the following form
	of ??c![*]"object"??w[object] is available:
%
\begin{defs1}
|*|"modifiers" "boxing"|{|"text"|}|
\end{defs1}
\noindent\unskip
%
	where "modifiers"??w[object modifier] can be used to change the shape
	and size of the constructed object and "boxing" changes the
	interpretation of the "text" from `math mode material' (both
	"modifiers" and "boxing" may be empty).  The following are the most
	common, the full list of possibilities can be found in the reference
	manual~\cite{RM95:Xy-picRM}.

	Possible "modifier" components (interpreted from left to right):
%
\begin{defs}
 ??c![+] & ??w![grow] \cr
 ??c![+<]"dimen"|>| & grow by "dimen" \cr
 ??c![+=] & grow to enclosing square \cr
 ??c![-] & ??w![shrink] \cr
 ??c![-<]"dimen"|>| & shrink by "dimen" \cr
 ??c![-=] & shrink to contained square \cr
 ??c![!] & do not center \cr
 ??C![o] & round??w[round shape] \cr
 ??C![l] ??C![r] ??C![u] ??C![d] & adjust left, right,\dots??w[adjust] \cr
 ??C![F-] & $\xy*[F-]\hbox{frame}\endxy$??w[frame] \cr
 ??C![F.] & $\xy*[F.]\hbox{dotted frame}\endxy$??w[dotted frame] \cr
 ??C![F--] & $\xy*[F--]\hbox{dashed frame}\endxy$??w[dashed frame] \cr
\end{defs}
\noindent\unskip
%
	Since objects specified this way start with no margin, a single |+|
	is usually included to get the default spacing.

\begin{exercise}
\begin{code}
\xymatrix{ A \ar[r]^*[o][F-]{x} & B }
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author used the display \displaycode}
\end{exercise}

	There can only be one "boxing".  This can be any box generation
	command.  The following are the most useful "boxing"|{|"text"|}|
	combinations:
%
\begin{defs}
 ??c![@]"tip" & ??w![tip] or ??w![shaft] object \cr
 ??c![\txt]|{|\dots|}| & ordinary "??w![text]" \cr
 ??c![\composite]|{|\dots??c![*]\dots|}| & ??w![combined objects] \cr
 ??c![\frm{}] & ??w![repeat last object] \cr
\end{defs}
\noindent\unskip
%
	(the possibilities for "tip" are given in the following section).
	Finally, ??c![\hbox]|{|\dots|}|\footnote{The plain \TeX\ command
	corresponding to ??c![\mbox] in \LaTeX\ and ??c![\text] in
	\AMS-\TeX.} is a quick way to ensure text-mode interpretation of a
	single object.  However, ??c![\txt] allows the use of ??c![\\] in
	"text" to create a ??w![line break], and the special form
	|\txt<6pc>{|\dots|}| will constrain the text to a ??w![centered] 6pc
	wide column.  By the way, |\txt| can be used outside of \Xy-pic
	constructions.

	Finally, several objects can be combined using the last form: the
	individual objects should be separated by~|*| (but each "object"
	should not include~|*|s).

\begin{exercise}
\begin{code}
\xymatrix{
 A \ar @{|*\composite{{+}*{\times}}|} [rr]
       ^*+\txt{High\\label}
 && B}
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author used the display \displaycode}
\end{exercise}


\subsection{More arrow styles}
??=[arrows.styles]
	The ??w![arrow style]s described in section~??[basics.arrows] are all
	examples of the genereral "arrow style" constructions
%
\begin{defs1}
??c![@]"??w![variant]"|{|"??w![tail]" "??w![shaft]" "??w![head]"|}|\cr
??c![@]"variant"|{|"head"|}|\cr
\end{defs1}
\noindent\unskip
%
	that in describes arrows with the indicated "tail", "shaft", and
	"head" (on the first form the tail and head can be omitted; the
	second style defaults to having no tail and a standard shaft).

	The following possibilities exist for "head" and "tail" which we will
	denote "tips" (here shown as heads):
%
\vspace{\bigskipamount}
\topofdefs
{\def\DT#1#{\DTx{#1}}
 \def\DTx#1#2{\Dx{#1}{#2}&\xy-(4,0)*{};(4,2)*+{}**{}?>*@#1{#2} **@#1{.}\endxy}
 \def\Dx#1#2{\hbox{\def\1{#2}\enspace{\tt\codeof\1}\index code{#2}}}
 \def\Darray#1{{\let\\=\cr \tabskip=2em plus 1fil %
  \halign to\hsize{&\hfil$##$\tabskip=1em&$##$\hfil\tabskip=2em plus 1fil \cr
   #1\crcr}}}
 %
 \Darray{%
  \DT{<}   &\DT{>}   &\DT{x}  \\
  \DT{<<}  &\DT{>>}  &\DT{+}  \\
  \DT{|<}  &\DT{>|}  &\DT{|}  \\
  \DT{|<<} &\DT{>>|} &\DT{||} \\
  \DT{(}   &\DT{)}   &\DT{o}  \\
  \DT{/}   }}%
\bottomofdefs
\vspace{\bigskipamount}\noindent
%
	and the "shaft" should be one of the following:
%
\vspace{\bigskipamount}
\topofdefs
{\def\DC#1#{\DCx{#1}}
 \def\DCx#1#2{ \Dx{#1}{#2} & \xy *+{} ; (12,4)*+{} **@#1{#2}\endxy}
 \def\Dx#1#2{\hbox{\def\1{#2}\enspace\tt\codeof\1\index code{#2}}}
 \def\Darray#1{{\let\\=\cr \tabskip=2em plus 1fil %
  \halign to\hsize{&\hfil$##$\tabskip=1em&$##$\hfil\tabskip=2em plus 1fil \\
   #1\crcr}}}
 %
 \Darray{%
  \DC{-} &\DC{--} \\
  \DC{~} &\DC{~~} \\
  \DC{.} }}%
\bottomofdefs
\vspace{\bigskipamount}\noindent
%
	The "variant" should be empty or one of the following:
%
\begin{defs}
|^| & `above' variant \cr
|_| & `below' variant \cr
|2| & `double' variant \cr
|3| & `triple' variant \cr
\end{defs}
\noindent\unskip
%
	Here are some standard arrows in this notation, all from $A$ to $B$
	as usual:
$$
\def\a#1{*\hbox{\def\next{#1}\tt\codeof\next}& A \ar#1[rr] && B}
\xymatrix @R-1.8pc @C-1pc {
 \a{@{->}}  \\
 \a{@^{->}} \\
 \a{@_{->}} \\
 \a{@2{->}} \\
 \a{@3{->}} }
$$
	As a special convenience |=| and |:| are provided as abbreviations
	for |-| and |.| with variant set to~|2|.

	As it can be seen, the variant will affect the "entire" arrow.
	Sometimes this is not what is wanted.  In that case a "local variant"
	can be used by entering any of the "tail", "shaft", and "head", on
	the following general form:
%
\begin{defs1}
"variant"|{|"tip"|}|\cr
"variant"|{|"shaft"|}|\cr
\end{defs1}
\noindent\unskip
%
	Here are some arrows where this is required:
$$
\def\a#1{*\hbox{\def\next{#1}\tt\codeof\next}& A \ar#1[r] & B}
\xymatrix @R-1.8pc{
\a{@{^{(}->}} \\
\a{@{|-_{>}}} }
$$
	Notice that there is no distinction between shafts and tips using
	this form, thus it is necessary to include all three of "tail",
	"shaft", and "head", when using it.  The advantage is that it is
	possible then to `fill with a tip'. Furthermore, the following
	additional possibilities are available when using this notation:
%
\vspace{\bigskipamount}
\topofdefs
{\def\DT#1#{\DTx{#1}}
 \def\DTx#1#2{\Dx{#1}{#2}&\xy-(4,0)*{};(4,2)*+{}**{}?>*@#1{#2} **@#1{.}\endxy}
 \def\Dx#1#2{\hbox{\def\1{#1{#2}}\enspace{\tt\codeof\1}\index code{#1{#2}}}}
 \def\Darray#1{{\let\\=\cr \tabskip=0pt plus 1fil %
  \halign to\hsize{&\hfil$##$\tabskip=1em&$##$\hfil\tabskip=1em plus 1fil \cr
   #1\crcr}\bigskip}}
 %
 \Darray{%
  \DT{|-} &\DT^{|-} &\DT_{|-} \\
         &&\DT {|=} &\DT3{|-} \\
  \DT{*}  &\DT^{`}   &\DT_{`}  \\
         &&\DT^{'}   &\DT_{'}  }}%
\bottomofdefs
\vspace{\bigskipamount}\noindent
%
	In fact the even more general form |*|"object" can be used, where
	"object" refers to any of the constructions described in
	section~??[arrows.objects].

\begin{exercise}
\begin{code}
\xymatrix{
 A \ar @/^/ @{^{<}-_{>}} [r]
   \ar @/_/ @{{*}{x}{*}} [r] & B }
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author used the display \displaycode}
\end{exercise}


\subsection{Sliding arrows sideways}
??=[arrows.sliding]
	It is often desirable to have several ??w![parallel] arrows between
	two objects.  This can be done by ??w![sliding] either or both arrows
	sideways by giving the distance as an optional \TeX\ dimension
	enclosed in ??c![<>]s: it specifies how far `sideways' the arrow
	should be moved, \eg,
%
\begin{code}
\xymatrix{
 A \ar[dr]<1ex>^a_{.} \\
   & B \ar[ul]<1ex>^b \ar[r]<1ex>^c
     & C \ar[l]<1ex>^d_{.} }
\end{code}
\displaycode
\noindent will typeset
$$\docode$$
%
	A positive distance will slide the arrow in the `|^|-direction', \eg,
	the two arrows above are slid in the direction of the labels~$a$
	and~$b$, respectively; a negative distance in the `|_|-direction'.
	The distance |<1ex>| is often appropriate since it corresponds
	roughly to the height of letters like `x', independently of the used
	type size.

\begin{exercise}
\begin{code}
\xymatrix{
 A \ar@/^/[r] \ar@/^/[r]<-1ex> & B }
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author typed \displaycode}
\end{exercise}


\subsection{More targets}
??=[arrows.targets]
%
	The ??w![target] address can be given in a large number of formats
	called "??w![positions]".  The full range of possibilities is
	described in the reference manual~\cite{RM95:Xy-picRM}; here is a
	number of useful ones in addition to the "hop" format described in
	section~??[basics.arrows]:
%
\begin{itemize}
\item
	$??c![[]r|,|c|]|$~, where $r,c$ are integers, denotes the
	"??w![relative entry]" found $r$~??w![rows] below and
	$c$~??w![columns] to the right of the current entry (the ??w![current
	entry] itself is thus |[0,0]|).  This always corresponds to a
	|[|"??w![hop]"|]|, \eg, |[1,2]| is the same as |[drr]| and |[-2,0]|
	is the same as |[uu]|.

\item
	$|"|r|,|c|"|$~, where $r,c$ are positive integers, denotes the
	"??w![absolute entry]" found in the $r$th row and $c$th column of the
	diagram.  The top left entry is |"1,1"|.

\item
	$t'??c![;]t$~, where $t'$ is any target, changes the ??w![base entry]
	of the present arrow to $t'$ and then sets the target to $t$ relative
	to the original base.  For example,
%
\begin{code}
\xymatrix{
 A \\
 B & C \ar[ul]    <1ex>
       \ar[ul];[] <1ex> }
\end{code}
\displaycode
%
\noindent typesets
$$
\docode
$$
	\ie, the second |\ar[ul]| arrow starts at the |[ul]| entry and ends
	in the current entry.

\end{itemize}
%
	See section~??[entries.naming] for how to use a label as a target.


\subsection{Changing the target}
??=[arrows.changing]
%
	It is possible to ??w![overwrite] a ??w![target] with another by
	appending something of the form ??c![*]"object" to it.  This has the
	effect of typesetting the "object" at the current position, thus
	effectively on top of the target, and then use what was typeset as
	the target.

	A target may also have its ??w![position] changed by one of the
	following constructions:
%
\begin{itemize}
\item
	??c![+]"vector" or ??c![-]"vector" which changes the target to be a
	zero-sized one at the position obtained by adding or subtracting the
	"vector" to its center, or

\item
	??c![!]"vector" which moves the center of the target by the "vector";
\end{itemize}
%
	where a "??w![vector]" should have the form
%
\begin{itemize}
\item
	$|<|D_x|,|D_y|>|$ , where $D_x,D_y$ are \TeX\ dimensions, is the
	vector with those coordinates??w[vector coordinates],

\item
	the following `corner offsets' of a target are vectors as shown:
 $$
\def\[#1]{\POS"box"+0;"box"+#1 **@{-} ?>*@{>} +/1pc/ *\hbox{\tt#1}}
%
\xy 0.(-11,-6).(11,6)!C="box"*\frm{.},"box";
 "box"+L**@{.}, "box"+R**@{.}, "box"+D**@{.}, "box"+U**@{.}
%
 \[L] \[R] \[D] \[U]
 \[DL]\[DR]\[UL]\[UR]
\endxy
$$
	(they must be specified in upper case)??w[vector to corner], and

\item
	??c![/]$d$ "dimen"|/| is the "vector" going "dimen" in the particular
	??w![direction]??w[vector in direction] $d$ which can be either the
	eight simple ones in section~??[basics.bends], empty to denote that
	the "??w![current direction]" (the last direction of an arrow) should
	be used, or one of the following:
%
\begin{defs}
 ??c![a(]$\alpha$|)| & absolute angle \cr
 $d$??c![:a(]$\alpha$|)| & relative angle in degrees \cr
 $d$??c![:a(]$x$,$y$|)| & relative vector \cr
 $d$??c![^] / $d$??c![_] & short for |:a(90)| / |:a(-90)| \cr
\end{defs}
\noindent\unskip
%
	where the $d$ in the last four may be empty to denote the `current
	direction'.

\item
	??c![0] is the zero vector.

\end{itemize}
%
	Many, many more possibilities are described in the reference
	manual~\cite{RM95:Xy-picRM} (see exercise~??[arrows.def.ex] for some
	examples)

\begin{exercise}
%
	What is the difference between a target $t$ and the target $t$|+0|?
\answertext{The size: $t$|+0| always has zero size.}
\end{exercise}


\subsection{Arrows passing under}
??=[arrows.pass]
%
	Arrows can pass under any other entry: Just insert ??c![']$t$, \ie, a
	quote (apostrophe) character followed by a target, for each entry
	that should be visited except the last, `ordinary \& final' entry:
%
\begin{code}
\xymatrix{
 {\circ}
  \ar@{|-->} '[dr] ^a
             '[rr]+D*{\bullet} ^b
              [drrr] ^c
         & {\circ} & {\circ} & {\circ} \\
 {\circ} & {\circ} & {\circ} & {\circ} }
\end{code}
\displaycode
%
\noindent
	typesets
$$
\docode
$$
	As you see, labels are set separately on each ??w![segment].

\begin{exercise}
\begin{code}
\xymatrix@!{
 & \lambda\omega \ar@{-}[rr]\ar@{-}'[d][dd]
   & & \lambda C \ar@{-}[dd]
\\
 \lambda2 \ar@{-}[ur]\ar@{-}[rr]\ar@{-}[dd]
 & & \lambda P2 \ar@{-}[ur]\ar@{-}[dd]
\\
 & \lambda\ar@{-}\omega \ar@{-}'[r][rr]
   & & \lambda P\underline\omega
\\
 \lambda{\to} \ar@{-}[rr]\ar@{-}[ur]
 & & \lambda P \ar@{-}[ur]
}
\end{code}
%
	Typeset the `lambda ??w![cube]'??w[crossing arrows]
$$
\docode
$$
	"Hint": `going under' an empty entry leaves a small gap at that
	location.??w[crossing arrows]
%
\answercode
\answertext{The author typed \displaycode  The |@!| code added at the top
	forces rows and columns to be equally spaced as discussed in
	section~??[entries.resizing].}
\end{exercise}


\subsection{More bending arrows}
??=[arrows.bend]
%
	Finally, arrows can ??w![bend] around entries: just insert
	??c![`]$d\,t$, \ie, a backquote and a ??w![direction] $d$ followed by
	a target $t$, for each `turn' that starts out in the $d$-direction
	and ends in a quarter turn towards the target~$t$.  This is different
	from the curving??w[curve] described earlier in that all turns
	consist of a straight part ending in a turn which is a multiple of
	\slashedfrac18 circle segments, and each segment allows separate
	??w![label]s.

	The possible directions are those of section~??[basics.bends] and
	??[arrows.changing], and the possible targets include all those
	discussed above.  Actually the direction is only required for the
	first in a series of turns since the final direction of one turn is
	the obvious choice for the following turn.  Furthermore, turns can be
	changed from the default by adding either ??c![^]$d$ for
	anticlockwise turn to $d$ or ??c![_]$d$ for clockwise turn to $d$,
	where $d$ is the `exit direction' of the turn.

	Finally, the turns will have ??w![radius] 10pt by default, but this
	can be changed to any dimension $R$ from a particular turn and
	onwards by inserting ??c![/]$R$ immediately after the |`| of the
	turn.  Here is an example involving all of these features:
%
\begin{code}
\xymatrix{
 {\circ} \ar `r[d]     ^a
           `[rr]     ^b
           `/4pt[rr] ^c
           `[rrr]    ^d
           `_dl[drrr]^e
            [drrr]^f
         & {\circ} & {\circ} & {\circ} \\
 {\circ} & {\circ} & {\circ} & {\circ} }
\end{code}
\displaycode
%
	typesets
$$
\docode
$$
	The example illustrates the following points:
%
\begin{itemize}
\item
	If the segment can not be made as short as required then it will
	point `past' the target.  This is useful for `??w![going around]'
	entries.

\item
	Each target appears as many times as there are turns towards it,
	except the last target that appears both as the last |`|-target and
	once as an `ordinary' target to set the final stretch.

\item
	The sizes of the intermediate targets are ignored.

\end{itemize}


\subsection{Defining new arrow types}
??=[arrows.defining]
%
	Last in this treatment of arrows we will explain how new arrows can
	be defined.  The crucial fact is that the characters used for
	"??w![tip]s" and "??w![shaft]s" are restricted to the following:
%
\begin{defs}
 |><||ox+/()[]|\verb*+ + & "tip" characters??w[tip characters]\cr
 |-.~:=| & "shaft" characters??w[shaft characters]\cr
\end{defs}
\noindent\unskip
%
	When an arrow is interpreted by \Xy-pic it is first split into the
	three components and then each component is looked up in a library of
	so-called `??w![directionals]'. It is possible to add new such
	directionals using the command 
%
\begin{defs1}
 ??c![\newdir]|{| "directional" |}{| "composite" |}| \cr
\end{defs1}
\noindent\unskip
%
	where "directional" should be a sequence either of tip characters or
	of shaft characters, and "composite" should be a list of
	objects??w[combined objects] separated with ??c![*] just like the
	argument to ??c![\composite] described in section~??[arrows.objects].
	If arrows of a particular "??w![variant]" (always one of the letters
	|^_23|) needs an alternate definition then another declaration can be
	given with the variant inserted between |\newdir| and the first |{|.

	There is one ??w![object modifier] which is very useful in this
	context, in addition to those of section~??[arrows.objects]:
%
\begin{defs}
 ??c![!]"vector" & shift object "vector" \cr
\end{defs}
\noindent\unskip
%
	Combined with the direction code this is very powerful, for example,
%
\begin{code}
\newdir{|>}{%
 !/4.5pt/@{|}*:(1,-.2)@^{>}*:(1,+.2)@_{>}}
\end{code}
\displaycode
\gdocode
\noindent\unskip
%
	defines a new tip that makes
%
\begin{code}
\xymatrix{ A \ar @{=|>} [r] & B }
\end{code}
\displaycode\noindent
%
	typeset
$$
\docode
$$
	In particular notice how the `relative direction' is used here to
	rotate some of the composed components.

\begin{exercise}??=[arrows.def.ex]
	Often tips used as `tails' have their ink on the wrong side of the
	point where they are placed.  Fortunately space (\verb*+ +) is also a
	tip character so we can define the directional \verb*+ >+ to generate
	a `tail-spaced' arrow.  Do this such that
%
\begin{code}
\xymatrix{ A
 \ar @{>->}  [r] < 2pt>
 \ar @{ >->} [r] <-2pt>
 & B }
\end{code}
\displaycode\noindent
%
	typesets
%
$$
 \newdir{ >}{{}*!/-5pt/\dir{>}}
 \docode
$$
%
\begin{code}
\newdir{ >}{{}*!/-5pt/\dir{>}}
\end{code}
\answercode
\answertext{The author used \displaycode}
\end{exercise}

	Finally, when \Xy-pic diagrams are used in conjunction with Knuth's
	"??w![computer modern fonts]" then the declaration
%
\begin{defs1}
 ??c![\UseComputerModernTips]\cr
\end{defs1}
\noindent\unskip
%
	will change the tips to some that emulate them, \eg,
%
\begin{code}
$\UseComputerModernTips
 \xymatrix{A\ar@{->>|}[r]&B}$
\end{code}
\displaycode\noindent
%
	typesets \docode\ (the declaration respects \TeX\ grouping).



\section{More Entries}
??=[entries]
%
	This section explains what can go in an entry and how the general
	form of the entries??w[entry] is changed.


\subsection{Manual entry formatting}
??=[entries.manual]
%
	All the entries we have seen thus far have been simple math objects.
	However, it is possible to change the ??w![format] of an individual
	??w![entry]??w[entry format] by using the form:
%
\begin{defs1}
 ??c![*]"object" "arrows"\cr
\end{defs1}
\noindent\unskip
%
	This allows complete control over what object is placed in the entry,
	overriding any spacing and other conventions for the entry.  This was
	how the frame was obtained in the figure in
	section~??[basics.entries].

	A simple use of this is to insert text in entries using ??c![\txt]
	objects just like labels as described above in
	section~??[arrows.objects]:
%
\begin{code}
\xymatrix{
 *\txt{A very long and stupid\\program}
  \ar[rr]^-{\txt{weird\\arrow}}
 &&*\txt<2pc>{Com\-pli\-cated\\Code}}
\end{code}
\displaycode
%
\noindent will typeset
$$
\docode
$$
	Notice how the ??c![-] label position is really needed here, and how
	the |\txt|-label uses the label style (by "not" using the |*|-form
	but instead enclose in |{}|s) to get the label in reduced type size.


\subsection{Extra entries outside the matrix}
??=[entries.extra]
%
	It is possible to put extra entries in your diagrams that are not
	part of any `entry' of the matrix created by |&| and |\\|.  This is
	done with the "??w![excursion]" command
%
\begin{defs1}
 |\save| $t$ |\restore|
\end{defs1}
\noindent\unskip
%
	where $t$ should be a target in one of the formats described in
	section~??[arrows.targets]-??[arrows.changing].  $t$ can do any kind
	of typesetting desired, for example,
%
\begin{code}
\xymatrix{
 A \ar@{-}[dr]
 &{}\save[]+<3cm,0cm>*\txt<8pc>{%
     This is a very big commentary
     but it does not otherwise affect
     the diagram.}
     \ar[l] \ar[d] \restore \\
 & B \ar@{-}[r] & C \ar@{-}[r] & D
}
\end{code}
\displaycode
%
\noindent will typeset
$$
\docode
$$
	It illustrates how a `down' arrow does not necessarily have to point
	particularly straight down---in this case because it is based in the
	displaced pseudo entry.


\subsection{Spacing and rotation}
??=[entries.resizing]
%
	The |*|"object" form described above can be used to space individual
	objects differently, however, it is also possible to change the
	overall spacing of a matrix by inserting the following codes
	"between" |\xymatrix| and the following |{|:
%
\begin{defs}
 ??c![@=]"dimen" & set spacing \cr
 ??c![@R=]"dimen" & set row spacing \cr
 ??c![@C=]"dimen" & set column spacing \cr
 ??c![@!] & uniform spacing \cr
 ??c![@!R] & uniform row spacing  \cr
 ??c![@!C] & uniform column spacing  \cr
\end{defs}
\noindent\unskip
%
	In the first three you can use the operators ??c![+], ??c![+=],
	??c![-], and ??c![-=], instead of ??c![=] with the same meaning as in
	section~??[arrows.objects], \ie, replace `set' with `increase',
	`increase to at most', `decrease', and `decrease to at least',
	respectively.  For example,
%
\begin{code}
$\xymatrix@=0pt@!{A&B\\C&D}$
\end{code}
%
	\thecode\ typesets \docode.

	A similar notation allows "??w![rotation]" of an entire matrix:
%
\begin{defs}
 ??c![@]\,$d$ & rotate towards $d$ \cr
\end{defs}
\noindent\unskip
%
	Only the matrix grid will rotate, however, not the actual contents.


\subsection{Entry style}
??=[entries.style]
%
	As mentioned above, the entries of a diagram are set in math mode in
	text style.  You may change this by redefinining the macro
	|\objectstyle|, and the label style by redefining |\labelstyle|.  We
	can combine this with the above to get `small diagrams', \eg, typing
%
\begin{code}
$\left(
 \def\objectstyle{\scriptstyle}
 \def\labelstyle{\scriptstyle}
 \vcenter{\xymatrix @-1.2pc @ur {
  A \ar[r]^{a}	& B \ar[d]^{b}  \\
  A'\ar[u]^{a'} & B'\ar[l]^{b'} }}
\right)$
\end{code}
\displaycode
%
\noindent in a paragraph will typeset ``\docode''.

	You can even abandon the use of math mode entirely: the command
	|\def| |\objectstyle| |{\hbox}|\ will change the format of entries to
	plain text.

	Similarly, all entries are rectangular by default, but it is possible
	to change this to "??w![round]??w[elliptical]" as follows:
%
\begin{code}
\entrymodifiers={++[o][F-]}
\xymatrix @-1pc {
 *\txt{start} \ar[r]
 & 0 \ar@(r,u)[]^b \ar[r]_a
 & 1 \ar[r]^b \ar@(r,d)[]_a
 & 2 \ar[r]^b
   \ar `dr_l[l]  `[l]  _a [l]
 &*++[o][F=]{3}
   \ar `ur^l[lll]`[lll]^b [lll]
   \ar `dr_l[ll] `[ll]    [ll] }
\end{code}
\displaycode
%
\noindent will typeset
$$
\docode
$$
	Notice how we obtain the double ellipse using the |*|"object" form
	which then has to include all the desired modifiers.


\subsection{Naming for later use as targets}
??=[entries.naming]
%
	If you build an entry with a long and complicated excursion then you
	might wish to be able to refer to it later.  \Xy-pic provides a
	mechanism for this: there is a special ??w![target] form which we
	haven't discussed yet:
%
\begin{defs1}
 $t$ ??c![=]|"|"name"|"|
\end{defs1}
\noindent\unskip
%
	This will introduce the new target |"|"name"|"| which will refer to
	the target just before the |=|.  This is particularly useful inside
	excursions, of course, and can also be used after labels.

\begin{exercise}
\begin{code}
\xymatrix{
 A \ar[r] ^a="a" & B \ar[r] ^b="b" & C
  \ar @/^/ "a";"b" }
\end{code}
%
	Typeset
$$
\docode
$$
\answercode
\answertext{The author typed the display \displaycode\noindent Notice the use
	of both explicit base and target in the arrow between the labels.}
\end{exercise}


\subsection{Grouping objects}
??=[entries.grouping]
%
	Sometimes you wish to frame or otherwise treat a rectangle of objects
	as a single object??w[grouping].  This is possible with the last two
	target position forms that we will mention:
%
\begin{defs}
 $t$|.|$s$ & merge $t$ with simple $s$ \cr
 |{|$t$|}| & make $t$ simple \cr
\end{defs}
\noindent\unskip
%
	The first will enlarge $t$ to also `??w![cover]' the simple $s$
	(simple means that it cannot have changes etc. attached unless
	encapsulated in |{}|s).  Here is an example where we ??w![merge] and
	frame:
%
\begin{code}
\xymatrix{ 1,1 & 1,2 & 1,3 & 1,4 & 1,5 \\
           2,1 & 2,2 & 2,3 & 2,4 & 2,5
 \save "1,2"."2,4"*[F.]\frm{}
  \ar"1,1" \ar"2,1" \ar"1,5" \ar"2,5"
 \restore }
\end{code}
\displaycode
\noindent will typeset
$$
\docode
$$
	As you can see, the center of the merged object is the same as the
	one of the target "before" the |.|.

	Finally a more advanced example where we create two merged objects
	with center in their `real' center, ??w![name] them and then connect
	to them; it also shows how macros can be used inside diagrams: they
	should always expand to `commands' like |\ar|\dots, etc.:
\begin{code}
\def\g#1{\save.[dr]!C="g#1"*[F]\frm{}\restore}
\xymatrix{
\g1 A\ar[r]&B\ar[d]&\g2 A'\ar[r]&B'\ar[d]\\
    C\ar[u]&D\ar[l]&    C'\ar[u]&D'\ar[l]
  \ar @{.>}  "g1" ;"1,4"
  \ar @{-->} "2,1";"g2" }
\end{code}
$$
\docode
$$
	can be typeset by
%
\displaycode\noindent
%
	Then we can make arrows from/to the two frames by using the two new
	targets |"g1"| and |"g2"| as shown.



\section{Availability and Further Information}
??=[avail]

\subsection{Getting \Xy-pic}
??=[avail.ftp]
%
	The latest version of \Xy-pic can be retrieved from Internet
	??w![ftp] host {\tt ftp.diku.dk} in {\tt/diku\slash users\slash
	kris\slash TeX} as well as from {\tt ftp.mpce.mq.edu.au} in {\tt
	/pub\slash maths\slash TeX} in files starting with |xy|.  It has also
	been contributed to the CTAN archives where it is located in the
	directory {\tt/tex-archive\slash macros\slash generic\slash
	diagrams\slash xypic} (see also section~??[avail.further]).

\paragraph*{License:}
%
	\Xy-pic is free software in the sense that it is available under the
	following license conditions:
$$
\xy*+[F-]\txt{\Xy-pic: Graphs and Diagrams with \TeX\\
	      \copyright~1991--1995\quad Kristoffer H. Rose}\endxy
$$
\begin{quotation}
	The \Xy-pic package is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License as
	published by the Free Software Foundation; either version 2 of the
	License, or (at your option) any later version.

	The \Xy-pic package is distributed in the hope that it will be
	useful, but "without any warranty"; without even the implied warranty
	of "merchantability" or "fitness for a particular purpose".  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this package; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
\end{quotation}
%
	In practice this means that you are free to use \Xy-pic for your
	documents but if you distribute any part of \Xy-pic (including
	modified versions) to someone then you are obliged to ensure that the
	full source text of \Xy-pic is available to them (the full text of
	the license in the file |COPYING| explains this in somewhat more
	detail~\smiley~).

\subsection{Backwards compatibility}
%
	The first widely distributed version of \Xy-pic was ??w![version 2]
	(from release 1.40 to release 2.6).  A special "??w![compatibility]"
	mode is used automatically if the old style of loading is used (using
	files named |xypic.tex| and |xypic.sty|).  You can also mix old and
	new diagrams in a document if you load as described in
	section~??[basics.loading] and add the declaration
	??c![\xyoption{v2}].  This provides almost full backwards
	compatibility: the following are the only known exceptions:
%
\begin{itemize}
\item
	Automatic `shortening' of arrow tails by ??c![|<<] break was a bug
	and has been `fixed' so it does not work any more.  "Fix": Put a
	|||<\hole| break before it as described in section~??[arrows.styles].
\item
	The release~2.6 ??c![*] position operator is not available.  "Fix":
	Use the |:| and |::| operators (described in detail in the reference
	manual~\cite{RM95:Xy-picRM}).
\item
	Using $t_1|;|t_2|:(|x|,|y|)|$ as the target of an arrow command does
	not work.  "Fix": Enclose it in braces, \ie, write
	$|{|t_1|;|t_2|:(|x|,|y|)}|$.
\item
	The older ??c![\pit], ??c![\apit], and ??c![\bpit] commands are not
	defined.  "Fix": Use |*@{>}| (or |\tip|) with variants and rotation.
\item
	The obsolete notation where an argument in braces to |\rto| and the
	others was automatically taken to be a `tail' is not supported.
	"Fix": Use the supported |||<|\dots\ notation.
\end{itemize}
%
	Finally note that sometimes the spacing with version~\xyversion\ is
	`improved' relative to earlier versions~\smiley~.  Please report all
	other things that do not work the same in version~2.6 and~\xyversion\
	to the author.

\subsection{Further information}
??=[avail.further]
%
	The reference manual~\cite{RM95:Xy-picRM} describes several more
	input modes that are useful when the diagram is not organised as a
	matrix: the `??w![graph]' feature allows input of data structured as
	"??w![directed graphs]", the `??w![knot]' feature allows input of
	mathematical "knots and ??w![links]", the `??w![2cell]' feature
	provides special support for "categorical ??w![twocells]", the
	`??w![poly]' and `??w![web]' features for composition in polygons and
	lattices.  Furthermore, the following documents might prove useful:
	\cite{R92:HowTPDAT} presents some of the design decisions behind
	\Xy-pic, \cite{R94:Xy-picNCD} explains how the modularity of \Xy-pic
	can be used to obtain complex effects with commutative diagrams,
	and~\cite{M94:TypesettingNNX} explains how "neural networks" can be
	typeset using the package.

	If you have accesss to the "??w![World Wide Web]" then you can access
	these documents through the "\Xy-pic ??w![home
	page]"~\cite{R95:Xy-picHP} as well as on the ftp servers at the
	locations mentioned in ??[avail.ftp] above in the directory
	\texttt{xy\slash papers}.


\section*{Answers to all exercises}
\addcontentsline{toc}{section}{Answers to all exercises}
\Answers

\BIBLIOGRAPHY
\INDEX

\end{document}


% $Log: xyguide.man,v $
% Revision 3.0  1995/07/07  20:14:21  kris
% Major release w/new User's Guide!
%
% Revision 2.13  1995/07/04  15:11:17  kris
% Ready to release v3?
%
% Revision 2.12	 1994/10/25  11:34:25  kris
% Interim release just before v3 [works with AMS-LaTeX 1.2]...
%
% Revision 2.10	 1994/06/15  12:55:07  kris
% Second 3beta release: bug fixes.
%
% Revision 2.9	1994/06/09  14:59:19  kris
% Release 3beta.
%
% Revision 2.8	1994/04/08  04:30:00  kris
% Second (bug fix) 3alpha release.
%
% Revision 2.7	1994/03/08  02:06:01  kris
% Release 3alpha.
%
% Revision 2.6.9.1  1994/03/07	04:22:46  kris
% Last internal 3alpha and pre-2.7 release.
%
% Reformatted for LaTeX with companion xydoc.sty.
% Renamed from xypicman.doc to xyguide.man.
%
% Revision 2.6.1.1  1992/07/01	07:08:24  kris
% Send to EuroTeX '92...
%
% Revision 2.6	1992/06/24  01:23:34  kris
% Reorganised...
% Documented new features: hooks, triple lines, positions, and LaTeXdiagrams.
%
% Revision 2.5	1992/02/24  03:30:54  kris
% Documented changes in xypic.doc[2.5].
%
% Revision 2.4	1992/01/22  02:15:10  kris
% Cosmetic changes; removed \pit and introduced \rotate.
%
% Revision 2.3	1992/01/13  01:51:02  kris
% Changed to use `pure' XPPT [1.20].
% Several cosmetic changes, e.g., corrected definition of \ddtor in footnote.
%
% Revision 2.2	1992/01/09  04:05:40  kris
% Patched to fix problem with \text and support AMS-LaTeX.
%
% Revision 2.1	1992/01/02  14:54:07  kris
% Release version.
%
% Revision 1.7	1991/12/17  04:53:23  kris
% Version distributed as `final draft' on Usenet.
% Added bent arrows properly; support for double tips; proper \Text;
% fixed name clashes...
% This version is for bug fixes only!!
%
% Revision 1.6	1991/12/06  08:53:06  kris
% Draft ready for wider distribution...
% Fits xypic.doc[1.39]; still needs better examples.
%
% Revision 1.5	1991/12/03  07:53:28  kris
% Extended with the xypic.doc[1.37] possibility for exotic arrow
% tips; also added description of \merge.
%
% Revision 1.4	1991/12/02  06:08:42  kris
% Fixed various things; fits xypic.doc[1.36].
%
% Revision 1.3	1991/12/01  07:40:07  kris
% Corresponds to xypic.doc[1.35].
%
% Revision 1.2	1991/11/28  04:42:49  kris
% Corresponds to xypic.doc[1.34].
% Cleaned up a lot; now only bending arrows are missing...and good examples.
%
% Revision 1.1	1991/11/27  06:48:17  kris
% Initial: \beta-test on DIKU.
%
% Based on version in DIKU student report 91-7-10.


% Tell Emacs that this is a LaTeX document and how it is formatted:
% Local Variables:
% mode:latex
% fill-prefix:"\t"
% fill-column:77
% paragraph-separate:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% paragraph-start:"^[ \t\f]*$\\|^[^\t]\\|\\\\\\\\\\|\\$\\$\\|[^\n\\\\][%&]"
% End:
