/* tr.c  94.05.27
 * Copyright 1983-1992   Albert Davis
 * tran and fourier commands -- top
 */
#include "ecah.h"
#include "mode.h"
#include "status.h"
#include "tr.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_tr(const char*,int*);
	void	cmd_fourier(const char*,int*);
/*--------------------------------------------------------------------------*/
extern struct status stats;
extern transient_t *tr;
extern int run_mode;	/* variations on handling of dot cmds		    */
extern int sim_mode;	/* simulation type (AC, DC, ...)		    */
/*--------------------------------------------------------------------------*/
/* cmd_tr: transient analysis command
 */
void cmd_tr(const char *cmd, int *cnt)
{
 static transient_t parameters;
 tr = &parameters;

 sim_mode = sTRAN;
 time_zstart(&(stats.total));
 time_zstart(&(stats.tran));
 stats.iter[sim_mode] = 0;
 stats.iter[iPRINTSTEP] = 0;
 
 allocate(sim_mode);
 tr_setup(cmd,cnt,tr);
 if (run_mode != rEXECUTE)
    return;
 tr_sweep(tr);

 time_stop(&(stats.tran));
 time_stop(&(stats.total));
}
/*--------------------------------------------------------------------------*/
/* cmd_fourier: fourier analysis command
 * performs transient analysis, silently, then fft.
 * outputs results of fft
 */
void cmd_fourier(const char *cmd, int *cnt)
{
 static fourier_t fo;
 tr = &fo.tr;
 
 sim_mode = sFOURIER;
 time_zstart(&(stats.total));
 time_zstart(&(stats.four));
 stats.iter[sim_mode] = 0;
 stats.iter[iPRINTSTEP] = 0;
 
 allocate(sim_mode);
 fo_setup(cmd,cnt,&fo);
 if (run_mode != rEXECUTE)
    return;
 tr_sweep(tr);
 foout(fo.start,fo.stop,fo.step);

 time_stop(&(stats.four));
 time_stop(&(stats.total));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
