/* status.c  93.12.21
 * Copyright 1983-1992   Albert Davis
    Displays the status of the system.	Makes all the calculations associated
with allocating memory but does not actually allocate it, unless necessary to
make the rest of the calculations.

    If "allocate" is changed, this must also be changed.

*/
#include "ecah.h"
#include "branch.h"
#include "error.h"
#include "io.h"
#include "mode.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_status(void);
static	void	fixoverhead(struct status*);
static	void	printtime(const char*, struct time_s);
/*--------------------------------------------------------------------------*/
extern const struct ioctrl io;
extern       struct status stats;

extern const unsigned aspace;
/*--------------------------------------------------------------------------*/
void cmd_status(void)
{ 
 mprintf(io.mstdout,"ACS   System status\n");
 allocate(sSTATUS);

 if (stats.total_nodes)
    stats.density = ((double)(aspace-1)*100.)/
    			((double)stats.total_nodes*(double)stats.total_nodes);
 else
    stats.density = 0.;

 mprintf(io.mstdout,
 "command      --------  last  --------    --------  total  --------\n");
 mprintf(io.mstdout,
 "               user      sys    total       user      sys    total\n");
 printtime("get",     stats.get);
 printtime("op",      stats.op);
 printtime("dc",      stats.dc);
 printtime("tran",    stats.tran);
 printtime("fourier", stats.four);
 printtime("ac",      stats.ac);

 mprintf(io.mstdout,
 "function     --------  last  --------    --------  total  --------\n");
 mprintf(io.mstdout,
 "               user      sys    total       user      sys    total\n");
 printtime("setup",   stats.setup);
 printtime("order",   stats.order);

 fixoverhead(&stats);
 mprintf(io.mstdout,
 "function     --------  last  --------    --------  total  --------\n");
 mprintf(io.mstdout,
 "               user      sys    total       user      sys    total\n");
 printtime("load",    stats.load);
 printtime("lu",      stats.lu);
 printtime("back",    stats.back);
 printtime("review",  stats.review);
 printtime("output",  stats.output);
 printtime("overhead",stats.overhead);
 printtime("total",   stats.total);

 mprintf(io.mstdout,"iterations: op=%d, dc=%d, tran=%d, fourier=%d, total=%d\n",
     stats.iter[sOP], stats.iter[sDC], stats.iter[sTRAN], stats.iter[sFOURIER],
     stats.iter[iTOTAL]);
 mprintf(io.mstdout,"nodes: user=%d, subckt=%d, model=%d, total=%d\n",
     stats.user_nodes, stats.subckt_nodes, stats.model_nodes,
     stats.total_nodes);
 mprintf(io.mstdout,"density=%.1f%%\n", stats.density);
#ifdef NEVER
 mprintf(io.mstdout,"diodes=%d, bjts=%d, mosfets=%d, gates=%d subckts=%d\n",
     stats.diodes, stats.bjts, stats.mosfets, stats.gates, stats.subckts);
 mprintf(io.mstdout,"matrix: terms=%d, fills=%d, total=%d, ops=%d\n",
     stats.matrix_terms, stats.matrix_fills, stats.matrix_total,
     stats.matrix_ops);
#endif
}
/*--------------------------------------------------------------------------*/
static void fixoverhead(struct status *x)
{
 x->overhead.last_user = x->total.last_user - x->load.last_user -
    x->lu.last_user - x->back.last_user - x->output.last_user - x->review.last_user;

 x->overhead.last_system = x->total.last_system - x->load.last_system -
    x->lu.last_system - x->back.last_system - x->output.last_system - x->review.last_system;

 x->overhead.total_user = x->total.total_user - x->load.total_user -
    x->lu.total_user - x->back.total_user - x->output.total_user - x->review.total_user;

 x->overhead.total_system = x->total.total_system - x->load.total_system -
    x->lu.total_system - x->back.total_system - x->output.total_system - x->review.total_system;
}
/*--------------------------------------------------------------------------*/
static void printtime(const char *name, struct time_s v)
{
 mprintf(io.mstdout, "%10s %8.2f %8.2f %8.2f   %8.2f %8.2f %8.2f\n", name,
    v.last_user,  v.last_system,  v.last_user  + v.last_system,
    v.total_user, v.total_system, v.total_user + v.total_system);
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
