/* dc.c  93.12.19
 * Copyright 1983-1992   Albert Davis
 * dc analysis top
 */
#include "ecah.h"
#include "branch.h"
#include "dc.h"
#include "mode.h"
#include "options.h"
#include "status.h"
#include "declare.h"
/*--------------------------------------------------------------------------*/
	void	cmd_dc(const char*,int*);
	void	cmd_op(const char*,int*);
/*--------------------------------------------------------------------------*/
extern const struct options opt;
extern 	     struct status stats;

extern int run_mode;	/* variations on handling of dot cmds		    */
extern int sim_mode;	/* simulation type (AC, DC, ...)		    */
extern double trtime0;	/* transient analysis time, -1 means dc		    */
/*--------------------------------------------------------------------------*/
void cmd_dc(const char *cmd, int *cnt)
{
 static dc_t dc;
 
 sim_mode = sDC;
 time_zstart(&(stats.total));
 time_zstart(&(stats.dc));
 stats.iter[sim_mode] = 0;
 stats.iter[iPRINTSTEP] = 0;

 trtime0 = -1.;

 allocate(sim_mode);
 dc_setup(cmd,cnt,&dc);
 if (run_mode != rEXECUTE)
    return;
 dc_sweep(&dc);

 time_stop(&(stats.dc));
 time_stop(&(stats.total));
}
/*--------------------------------------------------------------------------*/
void cmd_op(const char *cmd, int *cnt)
{
 static dc_t op;
 
 sim_mode = sOP;
 time_zstart(&(stats.total));
 time_zstart(&(stats.op));
 stats.iter[sim_mode] = 0;
 stats.iter[iPRINTSTEP] = 0;

 trtime0 = -1.;

 allocate(sim_mode);
 op_setup(cmd,cnt,&op);
 if (run_mode != rEXECUTE)
    return;
 dc_sweep(&op);

 time_stop(&(stats.op));
 time_stop(&(stats.total));
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
