#!/bin/sh

if [ $# -ne 2 ]; then
	echo usage: $0 directory extension
	exit 1
fi

if ! cd $1; then
	echo $0: can not cd to $1
	exit 1
fi

ext=$2

function fixman {
	if [ $# -lt 2 ]; then
		echo fixman: called with too few args
		exit 1
	fi

	if ! mv -f $1.$ext $2.$ext; then
		echo fixman: can not mv $1.$ext to $2.$ext
		exit 1
	fi

	local base=$2
	shift 2

	for f in $*; do
		if ! ln -sf $base.$ext $f.$ext; then
			echo fixman: cant ln $base.$ext to $f.$ext
		fi
	done
}

fixman dialog tk_dialog
fixman lbSingSel tk_listboxSingleSelect
fixman menubar tk_menuBar tk_bindForTraversal
