(game-module "t-africa"
  (title "Africa's terrain, at 10 miles/hex")
  (default-base-module "africa")
  (variants
   (see-all false)
   ;; The following is useful for hacking on the terrain
   (bare false
    (true
     (set synthesis-methods nil)
     (add u* start-with 0)
     (add u* independent-near-start 0)
     (table independent-density (u* t* 0))
     (set sides-min 1)
     ))
   )
  )

(world 2488)

(area 360 360 (latitude -68) (longitude 194))

(area (terrain
 (by-name
    (sea 0) (lake 1) (swamp 2) (desert 3) (savannah 4)
    (forest 5) (mountains 6) (wide-river 7) (salt-lake 8) (hills 9)
    (forested-hills 10) (Europe 11) (river 12))
  "360a"
  "173a2e185a"
  "2a3l7a142d9e3g4e4a2eae182a"
  "2a4l7a139d12e3g5eae186a"
  "3a3l7a138d14e3g4ea2eae183a"
  "11a139d14e6g3ea2e184a"
  "10a140d15e6g7e182a"
  "8a141d16e7g8e180a"
  "6a142d17e8g8e179a"
  "5a26d9e8d19e16d6e56d21e8g8e178a"
  "3a18d72e50d22e9g3ec6e176a"
  "2a15d80e44d24e10g3e2c6e174a"
  "2a13d88e35d26e12g3e2c7e172a"
  "2a11d95e27d28e14g2e2c9e170a"
  "2a112e20d30e13g14e169a"
  "2a119e13d30e13g15e168a"
  "2a124e7d30e15g15e167a"
  "2ae5b155e15g17e165a"
  "2ae9b151e16g17e164a"
  "2ae10b151e15g18e163a"
  "2ae9b152e16g19e161a"
  "2ae8b153e16g20e160a"
  "2ae6b155e17g20e159a"
  "2a2e4b156e2ge14g21e158a"
  "2a3e2b140ec16e18g21e157a"
  "2a145e2c16e18g21e156a"
  "2a145e3c15e19g21e155a"
  "2a146e3c13e3g3b14g22e154a"
  "2a51e2c2ec79e2c10ec15e3g3b14g21e154a"
  "2a51e5c80ec24e7gb15g20e154a"
  "2a48e9c105e22g10e4c5e2a2e151a"
  "2a49e9c103e24g12e2c9e150a"
  "2a49e8cec102e24g15eb8e149a"
  "2a48e9ce3c101e24g24e148a"
  "2a48e4ce10c74e2c24e24g24e147a"
  "2a48e4ce5c2e3c69e9c22e25g24e146a"
  "2a48e15c69e4ce6c20e25g25e145a"
  "2a48e7ce7c69ec2e9c18e27g25e144a"
  "2a49e13c70e2cece7cec17e26g26e143a"
  "2a49e13c68e17c16e26g4ebc21e142a"
  "2a47e7ce5c69e3c2e2ce11c17e25g4e2c21e141a"
  "2a47e7ce4c61e4c2e8c2e12c17e25g5ec22e140a"
  "2a47e13c59e30c16e26g28e139a"
  "2a47e13c53e5ce2ce3ce2ce6c2e13c16e26g12e4gegeg8e138a"
  "2a49e11c54e7ce6cece3ce15c16e26g10e4g2eg12e137a"
  "2a50e8c56e4cece9ce2c2e2ce13c15e27g7e6g16e136a"
  "2a50e8c56e3c2ece13ce6ce5ce4c15e26g5e6g2eg16e135a"
  "2a51e7c56e5cecece7ce3ce4ce13c11e19ge8g4e5g22e134a"
  "2a55e3c55e4c2ece3ce19ce2ce7c10e28g3e5g24e133a"
  "2a41ec73e3c2e30ce6c6ege27g3e5g26e132a"
  "2a116e2c2e3cece10cecece13cec3e2ge29g3e5g28e131a"
  "2a116e3c2e18ce17c2e32g2e4geg29e130a"
  "2a117e3ce18c2e2ce14c3eg3e25g2e5geg30e129a"
  "2a118ec3e5ce7ce2ce2ce16c6e26ge7g32e128a"
  "2a118ecece15ce3ce4ce3ce3c10e25gb7g34e127a"
  "2a119ebce5ce12ce2cece9c10e24gb7g35e126a"
  "2a119e2c2ece3ce11c3e2ce9c11e30g37e125a"
  "2a119e2c4ecece15ce11c13e19gbgb4g39e124a"
  "2a120ec4ec5e12ce2ce2ce6c12e28g39e123a"
  "2a130e14c2e3ce5c14ege18gb5g2e2g37e122a"
  "2a131e14ce9c17e23ge4g37e121a"
  "2a131e14c2e3ce4c19e26g38e120a"
  "2a132e14ce6c21e2ge14gb8g39e119a"
  "2a134ec2e9ce3cecec4ec15e2g2e22g40e118a"
  "2a138e9ce6c4e2c15eg2e11ge8g43e117a"
  "2a139e16c4e2c13e3ge11g2b6g45e116a"
  "2a140e16c4ec13e2g2e12gb6g46e115a"
  "2a143e6ce7c4ec12e2g2e12gb5g48e114a"
  "2aefe5f136e3c2e9c3e2c11e2g2e7ge4ge4g50e113a"
  "2a19f8e2f117e2ce2ce6c4e2c11e2g2e6g4egb5g50e112a"
  "2a26fe3f11e2f104e2c2e4cec6e2c11eg5e4g6e4g51e111a"
  "2a35f6e4f103ec15e2c17e3g7e2g53e110a"
  "2a38f4e5f101ec16e3c26eg54e109a"
  "2a51f31ef66ec17ec26e2g54e108a"
  "2a56f26ef66ec21e4c20eg55e107a"
  "2a59f5e8f11ef3ef82e5c76ed106a"
  "2a71f12e2f2e3f81e3c77e2d105a"
  "2a78f5e3f2e4f80e2c13e2a63e2d104a"
  "2a90f2ef80e2c13e2a54e2c6e3d103a"
  "2a90f84ec8ea4ea56e2c6e3d102a"
  "2a28f2c61f92e2a62ec5e4d101a"
  "2a24f2c2f3c62f91e2a61e2c4e5d100a"
  "2afa22f3cf3c63f21e5f64e2a68e5d99a"
  "4a23fc2f2c74f5e3f3e7f63e2a67e6d98a"
  "4a121f32ec29e2a67e7d97a"
  "5a124f6e12f10e2c29e2a66e7de96a"
  "6a145f6ec30e2a66e6d3e95a"
  "7a146f2ef33e2a63ec2e5d3e95a"
  "7a149f34e2a62ec2e5d2e96a"
  "8a149f34e2a62ece4d3e96a"
  "8a148fcef33e2a61ec2e3d2e97a"
  "9a59f3c85fcf19ec15ea61e2ce3d2e97a"
  "9a59f5c84fc2f16e2c16ea60e2c5e98a"
  "10a58f9c80fcfef15ec77e3c5e98a"
  "10a58f12c81f16ec17eb57e3c5e99a"
  "11a57f14c79f16ec17ec14ec41e3c5e100a"
  "11a57f15c76f2b15e3c31e2c40e3c3e102a"
  "11a52fc4f15c76f3b8e2b5e2c33ec44e103a"
  "11a51f3c4f11c79f3b8eb6e4c75e104a"
  "11a51f4c3f8c82f3b6e3b3e2bcbc2bc72e106a"
  "12a51f3c4f5c84f2b10eb2eb5cec67e2c2e107a"
  "12a51f3c4f4c85f2b11e3be3cb43e2c23e3c2e107a"
  "12a52f2c4f4c85f2b14eb2e3c44ec22e2c2e108a"
  "16a55f3c84f2cb18e3c3eg33e3c26e2c2e108a"
  "12af2a56f4c83fec20e2c39e2c25ec2e109a"
  "16a41f2c12f4c84f22e2c39e2c27e109a"
  "14a2fa41f2c11f4c82fe2f22e2c13eb25e2c19ec6e109a"
  "14a46f2cf2c7f3c82fg66e4c3e3c11ec4e110a"
  "16a46f3c7f4c81fg18eb5ebeb14eb28e4c13e2c2e111a"
  "15af2a3h51f4c81fg19e2b2ebe2b61ec2e111a"
  "16a47f2c8f4c79f3eb14ebe2be5bebc57ec3e112a"
  "16a47f2c8f4c77fe2b13e3c9be4bc2e2b17eg38e112a"
  "16a47f3c8f3c77fe3b11e3c4be12be3b54e113a"
  "16a47f4c7f3c77fe3b11e4c14be3b56e113a"
  "14afa48f4c7f2c78f2b11e5c2be13b13eb28ec14e114a"
  "15a50f4c7f2b78f12e5c4be11b57e114a"
  "15a51f2c9fb77fef11e2cb2c16b16eb39e115a"
  "16a138f2ef12e5c16b54e116a"
  "17a137fef19e15b16e2c24ec11e116a"
  "18a53fc83fef19e14b2e3c11e2c24e2c10e116a"
  "19afb49f3c84f19e13b4e2c13ec24ec10e116a"
  "20af2b47f3c82fef17eb2e10b2e2be4c38ec9e116a"
  "21a49f2c84f2eb18e8be2b5e4c9ea27ec9e116a"
  "22a48f2c85fe2b17e2be7b7e3c10ea27ec8e116a"
  "23afb45f2c85febeb6eb9e8b2eb7ec40ec5e118a"
  "24afb132fe2b12eb3e15b44ec4e2ae116a"
  "25a133fe2b18ebe5b2e3b16ea29ec3eae117a"
  "26a133feb6eb12e2b2e3b21ea7e2c19ec3e119a"
  "28af2b127fef21ebc3eb21ea9ec19e2c120a"
  "29a2fbf2c125fef19ebc4eb32ec18ec120a"
  "31a3fbc123fefef24e2b29e2g20e120a"
  "32a2f2c124fef26eb29e3g19e120a"
  "34af2c98fc26fe2f23eb30e2g19e120a"
  "35a100f2c26f78e119a"
  "37a99fc28f76e119a"
  "39a96f3c27fb40e2a3ea29e119a"
  "40a94f4c27fb39e2a4ea28e120a"
  "41a125fb14ec58e120a"
  "43a123f2b13e2c57e120a"
  "44a123fb14e5c53e120a"
  "45a122f2b14e6c12e2c37e120a"
  "47a121f2b13e7c11e2c37e120a"
  "48a120f3b12e7c12ec37e120a"
  "49a120f2b13e6c12e2c36e120a"
  "50a120f2b11e6c14ec36e120a"
  "51a119f4b8e6c15e2c34e4ae116a"
  "52a119f4b9e4c16ec34e5ae115a"
  "53a119f4b9e4c50e6ae114a"
  "54a119f3b10e4c49e6ae114a"
  "55a119f3b9e4c50e120a"
  "57a117f4b9e3c50e120a"
  "58a116f5b9e4c48e3ae116a"
  "58a3f3h111f3b11e4c22e2c24e3ae115a"
  "59a3h114f3b37e2c11ec10ec3a2e114a"
  "59a118f2b56ec5ec3a2e113a"
  "60a20f5e93f3b37ec22ece3ae113a"
  "61a7f3e8f7e87f2efe2f4b38ec23e115a"
  "62a6f4e8f7e86fe2f3ef5b33ec27e114a"
  "64af8e7f8e9f2e75f2e3f2e6b48ec12e112a"
  "65af12e3f10e7f3e75f2efe2fe5b61e111a"
  "66a26e7f4e75fe3f2e5b51ec2ec5e111a"
  "67a27e5f5e72fef4ef2e5b6ec52e111a"
  "68a41e54fc3f2e7fef9e4b5e2c51e111a"
  "69a44e50fc5fe7fef10e3b5e2c50e111a"
  "69a59e35fc4f3e5f14e3b5eca35e2c13e110a"
  "70a60e34f2cb4f2e4f11e3f3b5e3a33e2c14e109a"
  "71a61e34fc2f3ef4e2f9efefe3b5e4a48e108a"
  "72a77e16f2c3f3ef2e2fef9e3f4b8eca25e5c16e108a"
  "72a82e10f3c3f17ef2e3fe3b8ec2a10ec5ec5e7c15ec107a"
  "73a84e7f2c4f8e2f10e5feb19e4c9e7c17ec106a"
  "74a2eb86e2cb4f9efb7efe6f19e5c9e6c18ec106a"
  "73a90e2c2e2f11e3b2e3c2e5fc18e6c9e5c20ec105a"
  "73a89e3c3ef11e3b2e3c3e6f19e4c9e4c23e104a"
  "73a89e3c15e3b2e2c3e7f20ec11e4c23e104a"
  "74a72ec16e2c15e3b9e5f33e2c25ef102a"
  "75a70e3c16ec15e3b10e4f33e2c26ef101a"
  "75a70ecec33ebc11e4f8ec24ec27ef100a"
  "76a95e2c8e3c10e5f8ec12eb38ef100a"
  "77a73ec21e2c7e3c9e6f21e2b38ef99a"
  "78a62ec6ec3ec22ec7e3c8e6f22e2b38ef98a"
  "78a63ec5ec26e2c6e3c9e5f22e3b37e2f97a"
  "79a62ec5e2c25e2c8ec9e6f4ec17e2b38e2f96a"
  "80a62ec4e2c25ecec6e2c9e6f23e2b37e4f94a"
  "81a67ec28ec5ec11e3f26e2b36e6f92a"
  "82a142e2b36e6fc91a"
  "83a112e2c28e2b35e7fc90a"
  "83a93eb19e3c21ec4e3b32e9fc90a"
  "84a112ea4c25e2b31e11fc89a"
  "85a111e2a4c24e3b23e3fe14fc89a"
  "85a111e2a4c25e3b25e8f3e5fc88a"
  "86a112e5c24e3b29e2f6e4fc88a"
  "86a112e5c25e3b37e4fc87a"
  "87a112e5c24e4b37e4fc86a"
  "87a112e5c24e4b38e3fc86a"
  "87a112e4c25e5b37e3fc86a"
  "87a129ef12e3b39e3fc85a"
  "86a130ef12e4b38e3fc85a"
  "86a130ef13e3b39e3fc84a"
  "85a131ef14e3b38e3fc84a"
  "85a131ef8ec5e3b39e3f84a"
  "85a130e2f5e2ce2c5e3b39e2f84a"
  "85a130e2f6e4c6e2b39e3fe82a"
  "85a106ec23e2f7e3c7e2b39e3f82a"
  "86ad99ec2e3c23e2f8e3c7e2b38e4f81a"
  "86ad100e5c22e3f9e2c8e2b37e4f81a"
  "86ad100e3c24e2f11ec9e3b35e5f80a"
  "86ad101e2c23e3f21e4b32e8f79a"
  "86ad101ec2e3c19e2f22e2be2b27e12f79a"
  "86a2d89e3c9ece3c19e2f23eb2eb25e5f5e5f78a"
  "86ad92ec9ece4c18e2f19e2c6eb22e4f9e5f77a"
  "86a2d101ec2e3c18e2f20e2c12ec29e5f76a"
  "86a2d124e3f34ec29e5f76a"
  "86a3d123e2f35e2c29e5f75a"
  "86a3d123e3f34e2c28e5f76a"
  "86a3d122e4f34ec2b26e6fe75a"
  "86a3d123e4f34e2b25e7f76a"
  "86a3d124e4f34e2b23e7f2c75a"
  "86a3d124e7f55e7f3c75a"
  "86a4d100e6c16e18f43e8f3c76a"
  "87a3d98e10c9e28f38e8f2c77a"
  "87a4d94e4c3e6c2e2fefe32f36e9f78a"
  "87a4d95ec15efe6fe4f2e2f2ef4ef4e4fe3f33e7fcf79a"
  "88a3d113e4f19e2c9e2f7ec24e6f2c80a"
  "88a4d112e3f21ec10e4f5e2c22e6fc81a"
  "89a3d113e2f34e3f5e2c20e8f81a"
  "89a4d112e2f36e3f4e2c18e8f82a"
  "90a3d111e3f38e3f4ec16e8f83a"
  "90a4d109e3f40e6fec15e8f83a"
  "91a4d108e3f42e5f2cf12e8f84a"
  "91a6d105e3f45e4f2cf10e8f85a"
  "92a6d103e4f47e5f9e6f2c86a"
  "92a6d101e2fe2f49e5f7e6f2c87a"
  "93a6d87ef14e3f50e5f5e6f2c88a"
  "93a7d81ef6ef9ef2e3f51e4f2e10f89a"
  "94a7d80ef2e2f3efef3e3f2e3f53e12fef90a"
  "94a8d84ef6ef2e7f52e3c2h9f91a"
  "95a8d77ec15efe4f53e3c2fh7f92a"
  "96a8d60ec90ec4fc2h4f93a"
  "98a7d60ec87e2ce5f2ch2f94a"
  "99a8d146e3c5f3chf94a"
  "100a9d144e3c5f4c95a"
  "102a8d61e4c79e2c5f4c95a"
  "103a8d61e6c76e3c4f3c96a"
  "104a8d60e8c75e3c4fc97a"
  "105a8d60e7c75e3c5f97a"
  "106a9d59e5c77e2c4f98a"
  "107a9d136e4f3c3f98a"
  "108a8d135e6f2cae99a"
  "109a9d133e7f2c100a"
  "111a9d131e4fe5f99a"
  "112a10d135e4f99a"
  "113a10d135e3f99a"
  "114a11d133e4f98a"
  "115a14d130e5f96a"
  "116a16d128e5f95a"
  "117a17d125e7f94a"
  "118a18d122e9f93a"
  "120a17d120e10f93a"
  "121a18d112e17f92a"
  "122a18d113e6f5e5f91a"
  "123a19d124e4f90a"
  "124a20d123e3f90a"
  "125a20d123e3f89a"
  "126a22d120e4f88a"
  "128a23d118e2fc88a"
  "129a26d115efcf87a"
  "130a28d112e3f87a"
  "130a31d110e3f86a"
  "131a33d108e2f86a"
  "132a35d105e3f85a"
  "132a36d105e2f85a"
  "133a37d104e2f84a"
  "133a38d103e3f83a"
  "134a40d101e3f82a"
  "134a43d99e2f82a"
  "135a44d97e3f81a"
  "136a46d93ece2f81a"
  "137a47d91e3c2f80a"
  "137a51d74ec12e3c2f80a"
  "138a52d73ec11e2ce3f79a"
  "139a54d70e3c13e3f78a"
  "139a61d64e4c11eb2f78a"
  "140a68d57e4c11e2f78a"
  "141a69d56e5c9ef79a"
  "141a71d54e6c8e80a"
  "142a72d53e5c6e82a"
  "143a74d50e6ce86a"
  "143a77d47e2c91a"
  "144a77d47e92a"
  "145a77d46e92a"
  "145a77d46e2ae89a"
  "146a77d44e3ae89a"
  "146a78d45e2ae88a"
  "147a79d44eae88a"
  "148a79d45e88a"
  "149a79d45e87a"
  "149a80d44e87a"
  "150a80d44e86a"
  "151a80d43e86a"
  "151a80d41ebe86a"
  "152a79d43e86a"
  "153a78d41ebe86a"
  "154a77d43e86a"
  "155a76d43e86a"
  "157a74d41ebe86a"
  "158a73d43e86a"
  "159a72d43e86a"
  "161a70d43e86a"
  "162a69d43e86a"
  "164a67d19e2g22e86a"
  "165a66d21eg19e88a"
  "166a65d22e2g17e88a"
  "168a63d23e2g15e89a"
  "169a60d27eg13e90a"
  "171a59d26eg13e90a"
  "172a59d25e2g11e91a"
  "173a58d25e2g11e91a"
  "174a58d24eg11e92a"
  "175a57d22e3g12e91a"
  "176a56d22eg13e92a"
  "177a55d21e2g13e92a"
  "178a53d22eg14e92a"
  "179a50d39e92a"
  "180a39d49e92a"
  "181a15d5e10d56e93a"
  "182a11d9e9d56e93a"
  "183a9d74e94a"
  "184a7d74e95a"
  "185a3d77e95a"
  "187a2d75e96a"
  "188a2d73e97a"
  "189a2d72e97a"
  "190ad71e98a"
  "190ad71e98a"
  "191ad69e99a"
  "191ad68e100a"
  "192ad66e101a"
  "190aead65e102a"
  "190a67e103a"
  "191a65e104a"
  "192a62e106a"
  "193a60e107a"
  "194a57e109a"
  "195a50e115a"
  "195a50e115a"
  "198a43e2a3e114a"
  "201a24e11a5e119a"
  "204a15e141a"
  "205a12e143a"
  "206a9e145a"
  "208a6e146a"
  "209a2e149a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  ))

(area (aux-terrain river
  "360a"
  "121ae238a"
  "122aH237a"
  "122af>u235a"
  "123aDa>u233a"
  "123af3a@232a"
  "124aD3a@231a"
  "124aj4aD230a"
  "124aj4af230a"
  "124aj5a>u228a"
  "124af7aFu226a"
  "125a@6afa>u224a"
  "126a@6a>ya@223a"
  "127a@6af2a>u221a"
  "128a@6aFsua@220a"
  "129a@5af2a@a>u218a"
  "130a@5a>ua>ya>u216a"
  "131a@6a>uduam>u214a"
  "132a@7aDa>r@a>u212a"
  "133aD6af4aD2a<211a"
  "133af7aD3alu213a"
  "9ae124aD6af3aja>y211a"
  "10a@123aj7a>uadyadsu209a"
  "11aD122af9aDaf4aFsq206a"
  "11af123aD8adyaD3af208a"
  "12a@122af9ajaf4a<207a"
  "13a>u121aD8af2aD211a"
  "15aFu119af9aDaf211a"
  "15afa@119aD8af2a<210a"
  "16aDaD118af9a>u21ae22aku165a"
  "16afaf119aD10a>u20a@21afa>suaku159a"
  "17aDa@118aj12aD20a>u20aD3a>ra@158a"
  "17af2a@117aj12af22a@19af7a<157a"
  "18aD2a@115akr13a>su20a>u18aD164a"
  "18af3a>u113aj17a@21a>su13aksr164a"
  "19aD4a>su110aj18aD23aD12af166a"
  "19af7a>u108af18af23af13a@165a"
  "20a@8a>3su104aD18aD7aku14aD13a@164a"
  "21a>u11a>u16ai36ak5su42af18af7afa@13af14aD163a"
  "23a>u11a>u14aj17akq17aj6a>u41aD18a>u5akLa>u12aD13af163a"
  "12ae12a>u11a@13aj17aj18aj8a@40aj20a>uamkr4a>su9aj14aD162a"
  "13aD3ak3su5a>u10a>u10akr12akqkwsr18aj9a>u38aj22a>v=8a>su5akr13akr162a"
  "12akt3sr4a@6a@11a@7aksr11akszaja>u13ak4sz11a@36akr24a>u10a>u2akr13akr163a"
  "acsuaku5aj10aD6a@11a>u2ak2sr5ai2ai4ajkvkr3a>su9acr3akr12a>3su30akr27aFu2aku6a>sr14af164a"
  "4a>ra>uakwr10ab7a>u11aBsr5ak2sr2aj4a2ja?u6a>sq10akr18a>2su13ak4s{u6aj28afa>sra<23aD163a"
  "9a>ra@20a@11aH2ak2swr5aj4altsua>u16akr23a>su9akr4aja>s{u2aj29aD28af163a"
  "13a>uak2sq14a@10ajBsr3a>5sz3aktsua<2a>q13akr27a>swsu3akr5aj3aja>stum27af29aD162a"
  "15a>v18aBu8aja@9akr2aktsua@18ab22acu7aFsP2aj6af3an5a=>u26a>u25aksr162a"
  "17aBu17a2D6akz2a>u2ak4st3sr3a@a@42a>4s{sr2a>sz7aD2aj@7a>y26aD24aj164a"
  "18a@>q13aksrf5acrf4a>sv13a@a<44aksr6aj7aj2ajaD7aduam2am20af23akr164a"
  "19a>sq10aksr3aD7aD6aB2su10a<45aj4ak3sv7af2afaf9aFr>sr@kum17a<21akr165a"
  "30acwr5aj7aj7aD2a>sq22ae30aj2aksr4aD7aD2aDa<7acr5aEa=>u23ae13aj166a"
  "32aD5aj7aj7af28a@2ai26aj2af6af7af2aj16af4a>sq21a>u10akr166a"
  "32af5aj7aj8aD18ae9a@kr26af3aD6a>u6aDaf16akNy28aFwsq5akr15aksu149a"
  "33aD4aj7af8af19aD9aE27akLakv8a>u4af2aD15ajadu26akraD2ai3ab14aksr2aD148a"
  "33aj4aj8aD8aD18af9aj27aj2abaD9a<4a@aj15af3a<24akr2af2af3ai13akr4af148a"
  "33aj4aj8af8aj19aD7akr26akr4af8ai6a@f14aekP27ab4aD2aDakr10ak2sr6a>su145a"
  "33ab4af9aFsu5af19aj6akr27ab6aD6akz7a@H14a=aJ2su28af2afalsq6ak2sr12a@144a"
  "39aD7akr2aH5a<18aj6aj34akv5akrf8aED15af>ua>u27aD2aDf7akr16a@143a"
  "39aj7ab3aj@23af5akr33akra@3akr2aD5aia2f5ae9agLaFua>u25af2afa<5akr18a@142a"
  "39aj10akra<23aD3akr33akr3aD2aj3af5af2a2@5aD8agLady>2sP20acsu2aD2aD6ab20aD141a"
  "39ab9akr26af3aj34ab4af2af4aD5aD2a@>u3af9a>yaf4a>u21a>stuaf27af141a"
  "43aku2aksr28a>ukr40aD2aD2agr5af3a@a@3a@9aj2a>su3a>su22aDaD27aD140a"
  "42akra>sr32aE41aj2af3aD6aD3a@a@3aD7akv5a>su3a>sq17aksraj27aj140a"
  "41akr37af41af3aD2af6af4a@a>uab6akra>u6a>q17ak3sr3aj27af140a"
  "40akr39aD13ai27aD2aj3a@6aD4a>su@6akr4a@22aksr7ab5ae22a>su137a"
  "39acr40af13aj27aj2af4aD4akr7a@>u4ab6a>su16ak2sr16a@24a>u135a"
  "82aD12af27af3aD3af4af9a>uD13a>sq13af20a@25a>u133a"
  "72aku8af5ai7aD27aD2an4a<4aD10aA30aD20a@26a>u131a"
  "72aja<8aD4af7af27ab2af@8af11aH29af21a>su25a>su128a"
  "30ai41aj10aj5aD7aD30aD<8a<10afD29aD23a>u26a>su125a"
  "3ai21ae3akr13acu26af10af5aj7af30ab21aE29af25aD4aksu21a>su122a"
  "3af22aDakr16a>u25aD10aD4aj8aD51af30aD24adsu2aj2a>u22a@121a"
  "4a@20akvaj19a@24af10aj4aj8af52aD29af27a>sr4a@22a>u119a"
  "5a>u18afa>r20a>u23aD9af4aj9aD51aj30a>y33a@23a@118a"
  "7a@13aksu2aD24a@15aku2ak2sr10aD3aj9aj6aksu42aj31aj34a@23a>u116a"
  "8a>su8aksr2a>sr25a@13akra>sv13af3afku7aj2aku2aj2a>sq39af31adu34a@3ae20a@115a"
  "11a>ui3aksr24ae8a@12aj5a>su11a>u2aEa>u5al2sra>sr45aD31agL34a@3aD20a>u113a"
  "13aEk2sr27a>u7a@3acu5akr8a>5su6aDaj3a>uaksr52af32aD35a>uaf22a@112a"
  "13alr32a@7a@acua>u3aj16a>3suajaj5a>r55a@31ab37a@aD22a@111a"
  "11aksr34aD7a@2a>su@2aj21a>tsv63a@69a>v2ai20a@110a"
  "10akr14ae21aj8a@4a>Nwr25a@63a@70a>uj21a@109a"
  "8aksr16aFq19af9a@6a@26a@63a@71aA22a@108a"
  "7akr16aksr21aD9a@6aD26a>u23akq37aFu70a@22a@107a"
  "5aksr12amkuksr23af8acsNsu3aj28a>8su12akr38afa@70aD22aD106a"
  "4acr2amam4am3akr=a=26aD12a>2sv38a>u5ak4sr39akLa@13ae55af22af106a"
  "7akr>r>uakr>ukr30af16aD39a>4sr43akr3a@13aD55a@22aD105a"
  "6acr5a>r3a=32a@15af87akr5a@12afai54aD21aj105a"
  "52a@15aD86aj7a>u11aDf54af21af105a"
  "52akL14aj86af9a@10ajaD54aD21aD104a"
  "52af15aj87aD9a@9ajkv54aj21aj104a"
  "53aD14aj38aksq46af10a<8a2ja>q52aj21af104a"
  "12aku39af14aj37akr49aD18alr55ady21aD103a"
  "12aja>u38aD13aj36akr50af18af57af20akr103a"
  "9ac2sr3a>8sqac4su21af13aj35akr52a@18aD56akL18akr104a"
  "33aD21aD12aj5aksu13ak9su2akr54aD17aj56af18akr105a"
  "33aj21af12aj5aj2a>q3ak7sr10a>wr19aku34abc2su13af57a>u15akr106a"
  "17akwsq12aj18acu2aD11af3aksr4ak2sr20a>u15ak2sra>su36a@13aD58a@13akr107a"
  "16akraD13adu19a>sv12aDakv3ak2sr25a@13akr7a>sq34aD12aj59aD12aj108a"
  "15akr2af15aD21a@11afajaDksr29a>u6ak4sr45al2sq9adq58af10aksr108a"
  "11ac3stsq2a>6sq7af22a@11aDjalr33a@ak3sr50aj73a@9aj110a"
  "36aD22a>u9ajfaj10akq23a>v54aj74aD7akr110a"
  "36af3ak2sq17a@8afaFz6ak3sr26a>u46ai4akr9ae64af7aj111a"
  "15ae21aF2sr21a@8aD2j2ak3sr32a>u43akrc2sqb11a@64a@6aj111a"
  "16a>u2a2i15ajaksq14ae6aD7a2jfksr38aFsu39akr18a@64aD4akr111a"
  "18a>qjf15apsr17a>u4af7a2jaE40aj2a>su34aksr20aD63af4aj112a"
  "20ajaD14aj>u19a@4aD6a2faj40af5a>su30akr22af64a@3ab112a"
  "20anaj8ae3aksr2a>u18a>u2af7a2Df41aD7a>su27aj24a@64aD115a"
  "20aj>r2ai6aDagr6a>u2ai15a@2a>u5alraD40af10aD26aj25a@63af115a"
  "20ab3akr6afakL8aBsr16a@3a>u3af2af41aD9af26af26a<63aD114a"
  "24aj8aFr10a>u17aD4aD3aD2aFu39af10aD26aD89aj114a"
  "24ajak4swsv3akq8a<16af4af3af2aja>2su6ak2su26a@9af26ab56acsuk5su23af114a"
  "24alsr5aDa>wsr27a@4aD3aDaj5a>uak2sr3a>4sq21a@9a@85aE6a>u22a@113a"
  "22aksr7af3a@29a@3af3afkr7aBr34a@9aD82acsz8a>u21a<112a"
  "18aiks{~10a@3a@29a@3aFu2aI9a>2su32a@8af84af10a>u132a"
  "17akt|str@10aD3a@9ai19aD2afa>{r<12aD32a>u7a@67ai8acu6aD11a@131a"
  "14acs{t{r4a@k2su5af4a>su6aj16ak2sv3aDkr14af34a@7a@65akr10a>u2aksr12a>u129a"
  "15ac|sr4aiaA3a@5aD6a>u3akr13ac2sr3a@2a2j16a>4su29a>u6a@63akr13a>sr16a@128a"
  "16ab6af2a@3a<4af8a>swr14aksu5a@alr22a>u29a@6aD62af11acsuaku17aD127a"
  "24aD2a@8a>u9a>sw2sq8akr2a>u4a@j25a<29a@5af54ac5su2aD13a>ra@16af127a"
  "18acsq3aj3a>u8aD11aD9acr5a>u3aE56aD5aD60a>sr17a@16a@126a"
  "22acstsu3aBu6ab11af18a>s{r56af5af81a@16aD125a"
  "27a<i2a2@18a>su17aj58aD5aD81a@15af125a"
  "27aif3a<@20a@16aj58af5aj82a@15a@124a"
  "22ac3sqjaDae2a<20a<14akr59a@4af83a@15aD123a"
  "25aeajaf2a@37aj61a@4aD83a>u13af123a"
  "26a>r2aD2a@3ai12ae19af13ai48aD3af85a@13aD122a"
  "30af3a>ukr13aD19aD12af48af4a@21ai63a@12af122a"
  "29aiaD4aA14af19af13aD48aD4a@20aj64a@12a>sq119a"
  "29ajab3aksNu13a@kq8aku3aksuaD9ak2stu47aj5aD19af65a@133a"
  "29ab5aj3aBu12aGsu7aba>2sr2a>v7aksr4a>su44af5af20a@65a@132a"
  "34amj4aD@10akr2a>q15aF4swsr9a>q43aD5aD20a@57ac7sN6su124a"
  "33acr=4afa>u7akr20aj5a>su53aj5af21a@72a>3sq119a"
  "41a<2a@aeakswr21af8a>{u50af6aD21aD195a"
  "45a<a@j2a>u21aD8alu>3su46aD5af21af195a"
  "48aA4a@9ai10aj8afa@4a>su43aj6aD21a<194a"
  "49aD4aD8af10af9aDa>u5a>su40aj6af216a"
  "49aj4af9aD10aD7akr3a>u6a>su37af7aD215a"
  "49aj5a@8aj10aj6akr6a>u7a>su8ak10su15a@6af28aku185a"
  "49aj6a>4su2aj8aksr5akr9a>u8a>su4akr11a>su13a@6a>u25akra>u5ae177a"
  "48akr7ai4a>sr5akuaj6agr12a@10a>uaor15a>u12aD7a@24ab4a>y4a@176a"
  "47aktu7ab11akra>r7aD13a>u10a>r>u16aD11aj8a>u28af5aD3ai171a"
  "47ab2a>q16akr11af15a@13a>u14af11af10a>su26a>u3af2aktu170a"
  "64ak3sr13aD15a<14a@14a@11a@12a>u26aD3aFwr2a>u3ai164a"
  "64af17af31aD14a>su9a@13aD25af2akra>q3a>uaj164a"
  "65aD17aD30af17a@9a>u11af25akNsr9a>r164a"
  "65af17af31aD17aD10a@11aD19akuaksr178a"
  "66aD17aD30aj17aj11a@10aj18acra>r180a"
  "65akr17af30aj17af12a<9af39aksq161a"
  "64akr19aD29aj18aD22aD29ae6aksr163a"
  "63agr20af29aj18aj22af30a@3aksr165a"
  "64aD21aD27akr18af23aD30a>2sr167a"
  "63acr21af27af20aD22af201a"
  "87a@27a@19an23aD200a"
  "88aD27a@18aj>y21af200a"
  "74akq12af28a@17afad}21aD53ae145a"
  "73akv14a@28aH17aDaj>u19af54a>u143a"
  "72akraD14aD27aj>u15ajaf2aD19aH55a@142a"
  "67ak4sr2af14af27af2a>u13af2aDaf19af>su51aksN2su138a"
  "66akr8a>u13a@27aD3a>u12aDaj2aD19aD2a>su47akr5aF3s}133a"
  "65acr11a>q12a>u25aj5a>u10ajafagr19aj5a>u44akr5akr2akr>u131a"
  "94a>u23af7a@9aj2aDaD19af7a@43ab5akr3aj3a@130a"
  "96a@23aD7aD8af2abaf20aD7aD47akr4af4a>su127a"
  "97a@22aj7af9aD4aD19aj7af47aj6aD6a>u125a"
  "98a@21af8aD8ab4af19af8a>u45aj6aj8a>2suak2su116a"
  "99a@21aD7af14aD19a>wq7a>su41akr6ab12a>z3a>u114a"
  "100aD20af8aD13af21aD10a@40aj21af5a>5sq107a"
  "100af21aD7af14aD19akr11a@39aj22aD118a"
  "80akq19aD20af8a@13aj19aj13aD38ajaku2ai10aksu3aj118a"
  "76ak3sr20ab21aD8aD12af18akv13af36akwxsra>sr8aksr2a>uaj118a"
  "73ac2stu45af8aj13aD17alq>u12a<34akvaD>q11akr6a>r118a"
  "78a>sq43a@7af13af16akr3aD45acraDf12akr127a"
  "125aD7a@13aD15aj4aj48aba<11aj128a"
  "73aksu49af8a@12aj15aj4af61akr128a"
  "73ab2a>u48aD8aD11an12akukv5aD60aj129a"
  "78a>u46af8af10acrD10akraEa<4af35aeai22aj129a"
  "80a>su44aD8aD11af10aj2aj7a@10ae17ai6aBr21acr129a"
  "83a>suaku6aksu28akr8af12a@4ae3akr2af8a>u9a@16aj7aDakq149a"
  "86a>ra>5sr2a>u25akr10a@12a<4a>swr4aD9a@9aD15af7alsr150a"
  "100a@23akr12a>u18aD4af10a@8af16a@5akr152a"
  "101a@22aj15aD17af5aD10aD8aD16a@4af153a"
  "85aksu14a@21ab15af18aD4af10af8af17aD4aD152a"
  "79acsu3alua>su12aB2su34aD17ab5aD10a@8aD9acu5af3akr152a"
  "82a>2sra>u2a>u11a>}a>su31af23af11aD7af11a@5aDakr61ai91a"
  "89a>u2a>u10aj>u2aD29aksL23aBu9aj8aD11a@4afkr61akr91a"
  "82acsu6a>uku<9aj2a@af29aj26aD<7akr8aj12a@4aA61akr92a"
  "85a>u6a=a>q8af3a@a<28aj25akr8ab9af13a@3akL58aksr93a"
  "87a>5su12aD3aD29aj25af20aD8acs}2a@2aj56ak2sr95a"
  "94a@11aj3af19ac2su4aksr26a>u18aj9acr@2aDkr47aksu2ak3sr98a"
  "95a>u9ab4a@22a>uksr30a>q16af9agwsN{tr11ai21aksu12aj2a>sr102a"
  "97a@14a@23a=51aD9a2Dkr13aj19acsr2a>u5ak4sr107a"
  "98aD14a@74af9aflr14af26a>4sr112a"
  "98af15aD74a@9aE16aD143a"
  "99a@14af66ae8a>u7aj16aj143a"
  "100a<14aD35ai30a@9a>u5aj16aj143a"
  "86acsu26af32acuaj31a@10a@4af16aj143a"
  "89a@26aD16ae16a>v26ai5a>u9a>4sL15aj143a"
  "90a>4su20aj17a>u16a@3ai21af7a>2su26aj12akq129a"
  "96aBsq17af19a>u15a@akr22aD10a@25aj12aj130a"
  "97a@19aD20a>u14a@j23af11aD24aj11akr130a"
  "98aD18aj22a>u13aA24aDe9af24aj10akr131a"
  "98ab18ab24a>su11a@23afaDi8aD22akr6ac3sr132a"
  "145a>su9a@23a@lr7akr22aj144a"
  "103ai44a>su7aD16ae6aE3ae3akr23aj144a"
  "103af47a>su4af17aD4akr4aDakr23akr61aksq80a"
  "104aD27aeae19a>su2a@15agr4aj5afkr24aj60aksr82a"
  "104aj28a@a@21a>uaD15a@4aj6aE25aj58aksr84a"
  "104aj29a@a@22a>v2ak5sq7a@3af6af24akr55ak2sr86a"
  "104aj30aDa@23aBsr14a@3a@6aD23aj14ai38ak2sr89a"
  "104aj30af2a@23aD16a@3aD5aj23aj14af13ae20ac3sr92a"
  "104aj31a@2a@22aj17a>yaf3aksr23aj15aD13a@116a"
  "104aj32a@2a@4ae16aj18afakN2sr25aj12acuaf14aD115a"
  "104af33a>ua@4aD15af19aFr29aj14a@a@13af115a"
  "105a@34a>sP3af16aD17agr26aksuaj15aDaD3ae2ai6aD114a"
  "106aD36a>3sP15aj18aD25akr2a@j15afaf4aDaj6aj114a"
  "106af41a@14af18af24acr4aA16a@aD3afaj6aj114a"
  "107aD41a>u13a@18aD30a@16a@f4aDj5akr114a"
  "107af43a>u12a@17af31aD16a@D3afj5aj115a"
  "108aD44a@12aD17aD30af17aA4aEai3aj115a"
  "108af16ae28a>u10af17af3ak3su2aksu10ak7sN2su3aksu3ak4sP3afkr3af115a"
  "109a@16a@29a@10a@17a>{sr4a>sr2a>2su3ak2sr11a>2sr2a>2sr5a>u2aE5a@114a"
  "110aD16a@29a>u9aD17aj15a>s{r31a@aj6a@113a"
  "110af17a>u29a@8af16akr17af33a>v7a@112a"
  "111a@18a@9ae19a>u7a@15af19aD34a>u6a@111a"
  "112aD18a@9aD20a@7a>u14a>u17af24ak2su7akP6a>u109a"
  "111akr19aD8af21a>u7a@15a<17aH22acr3a>uakuakra>u6a@108a"
  "111aj20af9aD22a@7a@31akr@28a>rkNz4a>u5a@107a"
  "111aj21a@8af23a>u6a>u28akr2a@27aksraj6a>u4a@106a"
  "98aksu9akr22a@8a@24a@7a>u25akr4a>u21ak3sr2akr8a>su2a@105a"
  "96aksr2a>su6aj24a@8a>u23a>u7a>su22aj7a@20ab6ab12a@2aD6ae97a"
  "91ac4sr7a>su3aj25a@9a>u23a@9a@20akr8a@40a@kv7aD96a"
  "107a>2sr26a>u9a>su21a>su7a@19aj10a>u39aAaD6af96a"
  "139a>u10a>u22aD7a>2su15aj12a@39a@f7aD95a"
  "141a>su9a>u20aj11a>u12akr13a>u38a@D6af95a"
  "144a>5su4a>u18af6am4aksNsu3aku4aj16a>u37aA6akN2su91a"
  "151a>5sN3su14a@4akr>3sr4a>2sra>uakz18a<35aksLc4sr4a<90a"
  "162a>u13a@2akr17a>rf53akr103a"
  "164a@13a@aj21a>u51ab104a"
  "165a>u12a>r23a@58ac2sq93a"
  "167a>u36aB2sw3sq147a"
  "169a>u35a>su>u44ai104a"
  "171a<37aDa@43af104a"
  "209af2a>4su38aD103a"
  "210aD7a>u36af103a"
  "210af9a@36aD102a"
  "211a@9a>u34af102a"
  "212a@10a<34a@101a"
  "213a@39acu4a<100a"
  "214a<40a>4sq99a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "263ak2sq93a"
  "247acu12aksr96a"
  "249a>u6ak3sr98a"
  "251a>uak2sr102a"
  "253a>r105a"
  "360a"
  "360a"
  "360a"
  "360a"
  "230ak11su117a"
  "230aj12a>su114a"
  "228aksr15a>su111a"
  "227akr20a>u109a"
  "227aj23a>u107a"
  "226akr25a>u105a"
  "226aj28a@104a"
  "225akr29a@103a"
  "223aksr31a@102a"
  "223ab34aD7ae93a"
  "258af8aD92a"
  "259a@7af92a"
  "260a@7aD91a"
  "261a@6af91a"
  "262a@6aD90a"
  "263a@5aj90a"
  "264a@4aj90a"
  "265a>u2af90a"
  "267a>uaD89a"
  "269a>v89a"
  "271aD88a"
  "270agr88a"
  "271a@88a"
  "272a<87a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "236akq122a"
  "231akuaksr123a"
  "231afa>r125a"
  "228aku2aD127a"
  "228aja>sr127a"
  "227akr131a"
  "227aj132a"
  "222akuaksr132a"
  "221akra>r134a"
  "219aksr138a"
  "167aku50af140a"
  "167aja@50aD139a"
  "167aj2a>u48af139a"
  "167aj4aD14aksu7aksu17agukuD138a"
  "166akr4af13akr2a>su3akr2a@16akL=a=138a"
  "165akr6aD10aksr6a>2sr4a@14akr142a"
  "165ab7af10af17a@12aor143a"
  "174a>2su7aD17a@10akr@143a"
  "178a>4suaj18a>su5aksr2a@142a"
  "184a>r21a>2sukr5a>u140a"
  "211a=8a>u31ai106a"
  "222a>u29aj106a"
  "224a>u24ak2sr106a"
  "226a>u20aksr109a"
  "228a>su14ak2sr111a"
  "231a>su2aksu3ak2sr114a"
  "234a>sr2a>2sr117a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  "360a"
  ))

(unit-defaults)

(village 196 213 0 (n "Tabore"))
(village 172 215 0 (n "Ujiji"))
(town 186 312 0 (n "Adis Abeba"))
(town 242 204 0 (n "Bagamoyo"))
(town 260 112 0 (n "Beira"))
(town 87 163 0 (n "Benguela"))
(town 233 47 0 (n "Bloemfontein"))
(town 61 208 0 (n "Boma"))
(town 195 15 0 (n "Cape Town"))
(town 245 202 0 (n "Dar es Salaam"))
(town 208 329 0 (n "Djibouti"))
(town 4 277 0 (n "Douala"))
(town 267 43 0 (n "Durban"))
(town 166 336 0 (n "Gondar"))
(town 122 357 0 (n "Khartoum"))
(town 255 187 0 (n "Kilwa"))
(town 15 252 0 (n "Libreville"))
(town 267 69 0 (n "Lourenco Marques"))
(town 73 188 0 (n "Luanda"))
(town 169 357 0 (n "Massawa"))
(town 257 263 0 (n "Mogadishu"))
(town 239 221 0 (n "Mombasa"))
(town 284 145 0 (n "Mozambique"))
(town 277 158 0 (n "Pemba"))
(town 262 45 0 (n "Pietermaritzburg"))
(town 245 14 0 (n "Port Elizabeth"))
(town 268 125 0 (n "Quelimane"))
(town 244 206 0 (n "Zanzibar"))
(city 2 357 0 (n "Berlin"))
(city 5 356 0 (n "Istanbul"))
(city 2 356 0 (n "London"))
(city 3 355 0 (n "Paris"))
(city 4 355 0 (n "Rome"))
