#!/usr/local/bin/perl
# index.cgi
# Display the wuFTPd main menu

require './wuftpd-lib.pl';
use Socket;
$| = 1;
&header($text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("wu-ftpd", "man", "doc", "google"));
print "<hr>\n";

# Check if wuftpd is installed
if (!-x $config{'ftpd_path'}) {
	print "<p>",&text('index_eftpd', "<tt>$config{'ftpd_path'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check if the ftpaccess file exists
if (!-r $config{'ftpaccess'}) {
	print "<p>",&text('index_eftpaccess', "<tt>$config{'ftpaccess'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

@st = stat($config{'ftpd_path'});
&read_file("$module_config_directory/ftpd", \%ftpd);
if ($ftpd{'size'} != $st[7] || $ftpd{'mtime'} != $st[9]) {
	# Run the ftpd to check if it is really wuftpd
	socketpair(LOCAL, FTP, AF_UNIX, SOCK_STREAM, PF_UNSPEC) ||
		print "socketpair failed : $!<p>";
	select(LOCAL); $| = 1; select(FTP); $| = 1; select(STDOUT);
	if (!($pid = fork())) {
		close(LOCAL);
		untie(*STDIN);
		untie(*STDOUT);
		untie(*STDERR);
		open(STDIN, "<&FTP");
		open(STDOUT, ">&FTP");
		open(STDERR, ">&FTP");
		exec($config{'ftpd_path'}, "-A");
		print "Exec failed : $!\n";
		exit;
		}
	close(FTP);
	print LOCAL "quit\n";
	while(<LOCAL>) {
		$version = $1 if (/Version\s+wu-(\d+\.\d+)/i);
		}
	close(LOCAL);
	waitpid($pid, 0);
	if (!$version) {
		print "<p>",&text('index_eversion',
				  "<tt>$config{'ftpd_path'}</tt>",
				  "/config.cgi?$module_name"),"<p>\n";
		print "<hr>\n";
		&footer("/", $text{'index'});
		exit;
		}

	# Save version information
	$ftpd{'size'} = $st[7];
	$ftpd{'mtime'} = $st[9];
	$ftpd{'version'} = $version;
	&write_file("$module_config_directory/ftpd", \%ftpd);
	}

# Display table of icons
@names = ( 'class', 'message', 'acl', 'net', 'log',
	   'alias', 'anon', 'perm', 'misc' );
@links = map { "edit_${_}.cgi" } @names;
@titles = map { $text{"${_}_title"} } @names;
@icons = map { "images/${_}.gif" } @names;
&icons_table(\@links, \@titles, \@icons, 5);

if (&foreign_check('inetd')) {
	# Check if ftpd is in inetd
	&foreign_require('inetd', 'inetd-lib.pl');
	foreach $i (&foreign_call('inetd', 'list_inets')) {
		if ($i->[1] && $i->[3] eq 'ftp') {
			$inet = $i;
			last;
			}
		}
	$inet_mod = 'inetd';
	}
elsif (&foreign_check('xinetd')) {
	# Check if ftpd is in xinetd
	&foreign_require('xinetd', 'xinetd-lib.pl');
	foreach $xi (&foreign_call("xinetd", "get_xinetd_config")) {
		if ($xi->{'quick'}->{'disable'}->[0] ne 'yes' &&
		    $xi->{'value'} eq 'ftp') {
			$inet = $xi;
			last;
			}
		}
	$inet_mod = 'xinetd';
	}
else {
	# Not supported on this OS .. assume so
	$inet = 1;
	}

if (!$inet) {
	# Get the FTP server pid
	if (open(PID, $config{'pid_file'})) {
		chop($pid = <PID>);
		close(PID);
		}
	$pid = undef if (!kill(0, $pid));
	}

if (!$inet && $pid) {
	print "<hr>\n";
	print "<form action=restart.cgi>\n";
	print "<input type=hidden name=pid value='$pid'>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_apply'}\"></td>\n";
	print "<td>$text{'index_applymsg'}</td>\n";
	print "</tr></table></form>\n";
	}
elsif (!$inet && !$pid) {
	print "<hr>\n";
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	if ($inet_mod) {
		print "<td>",&text('index_startmsg', "/$inet_mod/"),"</td>\n";
		}
	else {
		print "<td>$text{'index_startmsg2'}</td>\n";
		}
	print "</tr></table></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

