<?php
/**
 * Copyright 1999 - 2002 by Gero Kohnert
 *
 * @modulegroup address
 * @module address_ins
 * @package address
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("address","ins");

 $msg = "";

 $gotourl = "address_new.php";

 # Base entry
 $a = new tutos_address($dbconn);
 if ( isset($_POST['id']) ) {
   $gotourl= addUrlParameter($gotourl,"id=". $_POST['id']);
   $a->read($_POST['id']);
   $a->read_picture();
   if ( ! $a->mod_ok() ) {
     # Not allowed
     $msg .= sprintf($lang['Err0024'],$lang[$a->getType()]);
   }
   $new = false;
 } else {
   $a->creator = $current_user;
   $a->id = -1;
   $new = true;
 }

 $birthday = new DateTime(0);
 $birthday->setDateTimeF("birthday",1);


 if ( 1 != $birthday->checkDMY() ) {
   $msg .= sprintf($lang['Err0038'],$lang['AdrBirthday']) ."<br>";
 } else {
   $gotourl= addUrlParameter($gotourl,"bd=". $birthday->getYYYYMMDD());
 }
 if ( empty($_POST['f_name']) || ($_POST['f_name'] == "Unknown" ) || !isset($_POST['f_name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['AdrFirstName']) ."<br>";
 } else {
   $f_name = trim(StripSlashes($_POST['f_name']));
   $gotourl= addUrlParameter($gotourl,"f_name=". UrlEncode(StripSlashes($f_name)));
 }

 if ( empty($_POST['l_name']) || !isset($_POST['l_name']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['AdrLastName']) ."<br>";
 } else {
   $l_name = trim(StripSlashes($_POST['l_name']));
   $gotourl= addUrlParameter($gotourl,"l_name=". UrlEncode(StripSlashes($l_name)));
 }
 if ( isset($_POST['m_name']) ) {
   $m_name = trim(StripSlashes($_POST['m_name']));
   $gotourl= addUrlParameter($gotourl,"m_name=". UrlEncode(StripSlashes($m_name)));
 }
 if ( isset($_POST['title']) ) {
   $title = trim(StripSlashes($_POST['title']));
   $gotourl= addUrlParameter($gotourl,"title=". UrlEncode(StripSlashes($title)));
 }

 if ( isset($_POST['pic_id']) ) {
   $pic_id = $_POST['pic_id'];
   $gotourl= addUrlParameter($gotourl,"pic_id=". $pic_id);
 }
 if ( isset($HTTP_POST_FILES['file']) ) {
   $file = $HTTP_POST_FILES['file'];
   $gotourl= addUrlParameter($gotourl,"pic_path=". $file['name']);
 }
#echo var_dump($_POST) ."<br>";
#echo var_dump($HTTP_POST_FILES) ."<br>";

 # If no other problems than check if name is already used
 if ( $msg == "" ) {
   if ( $new
    || ($birthday->getYYYYMMDD() != $a->birthday->getYYYYMMDD())
    || ($f_name != $a->f_name)
    || ($m_name != $a->m_name)
    || ($l_name != $a->l_name) ) {

     $q = "SELECT * FROM ". $a->tablename ." WHERE ". $dbconn->Like2("f_name", $f_name) ." AND ". $dbconn->Like2("m_name",$m_name) ." AND ". $dbconn->Like2("l_name",$l_name);
     if ( $birthday->notime != 1 ) {
       $q .= " AND birthday = ". $dbconn->Date($birthday);
     }
     if ( ! $new ) {
       $q .= " AND id != ". $a->id;
     }
     $r = $dbconn->Exec($q);
     $n = $r->numrows();
     if ( 0 != $n) {
       $x = new tutos_address($dbconn);
       $x->read_result($r,0);
       $msg .= sprintf($lang['Err0039'],$x->getLink()) ."<br>";
     }
     $r->free();
   }
 }
 # after check we can set the stuff
 $a->setTitle($title);
 $a->setFName($f_name);
 $a->setLName($l_name);
 $a->setMName($m_name);


 $savefile = 0;
 if ( $msg == "" ) {
   if ( isset($file) && ($file != "none") ) {
     $farr = $HTTP_POST_FILES['file'];
     $a->pic_file = new tutos_file($dbconn);
     $a->pic_file->tmploc = $farr['tmp_name'];
     $a->pic_file->filesize = $farr['size'];
     $a->pic_file->filename = $farr['name'];
     $a->pic_file->filetype = $farr['type'];
     $a->pic_file->name = $lang['AdrPicture'] ." ". $a->getFullName();
     $a->pic_file->logtxt = $a->getFullName();
     $a->pic_file->savemode = 0;
     if ( isset($farr['size']) && ($farr['size'] > 0) && ($farr['name'] != "")) {
       $savefile = 1;
     }
   }
 }
 # other modules
 $msg .= module_parseforms($current_user,$a,$gotourl);
 if ( $msg == "" ) {
   $a->setBirthday($birthday);

   $dbconn->Begin("WORK");
   $msg = $a->save();
   if ( $savefile == 1 ) {
     $a->pic_file->link_id = $a->id;
     $msg .= $a->pic_file->save();
     $a->pic_id = $a->pic_file->id;
     $msg = $a->save();
   }
   $dbconn->Commit("WORK");

   $gotourl = "address_new.php?id=". $a->id;
 }

 $_SESSION['MSGID'.$a->id] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". $a->id);
 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location:". getBaseUrl(). $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: address_ins.php,v 1.38.2.5 2003/08/08 14:26:05 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>