/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: cardselect.cpp 
 *              
 *      Abstract: Implement card select dialog 
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      PaulL           22nd Jan 02     Created
 *      MarkW           9th  Feb 04     Baseline of code
 *      Ivo van Doorn   17th May 04     Updates to QT styles
 ***************************************************************************/ 


#include "cardselect.h"
#include "rt_tool.h"

#include <qapplication.h>
#include <qvariant.h>
#include <qheader.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmime.h>
#include <qdragobject.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qmessagebox.h>

static QPixmap uic_load_pixmap_CardSelect( const QString &name )
{
	const QMimeSource *m = QMimeSourceFactory::defaultFactory()->data( name );
	if ( !m )
		return QPixmap();
	QPixmap pix;
	QImageDrag::decode( m, pix );
	return pix;
}
/* 
 *  Constructs a CardSelect which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
CardSelect::CardSelect( int Socket_Id, PRT_DEVICE_ADAPTER prtAdapter,  QWidget* parent,  const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
	if ( !name )
		setName( "CardSelect" );
	resize( 493, 224 ); 
	setMinimumSize( 493, 224 ); 
	setMaximumSize( 493, 224 ); 
	setIcon( uic_load_pixmap_CardSelect( "raconfig.xpm" ) );	
	setCaption( trUtf8( "Select Wireless Adapter" ) );

	// qApp->setStyle("Windows");

	TextLabel1 = new QLabel(this, "TextLabel1" );
	TextLabel1->setGeometry( QRect( 20, 20, 400, 20 ) ); 
	TextLabel1->setText( trUtf8( "Please select a adapter to configure :" ) );

	OkPushButton = new QPushButton( this, "OkPushButton" );
	OkPushButton->setGeometry( QRect( 216, 180, 60, 30 ) ); 
	OkPushButton->setText( trUtf8( "&Ok" ) );

	AdapterListView = new QListView( this, "AdapterListView" );
	AdapterListView->addColumn( trUtf8( "" ) );
	AdapterListView->addColumn( trUtf8( "   Device Name   " ) );
	AdapterListView->addColumn( trUtf8( "   Status   " ) );
	AdapterListView->addColumn( trUtf8( "   Type   " ) );
	AdapterListView->addColumn( trUtf8( "   MAC Address   " ) );
	AdapterListView->setGeometry( QRect( 20, 50, 450, 111 ) ); 
	AdapterListView->setSelectionMode( QListView::Single );
	AdapterListView->setHScrollBarMode( QListView::AlwaysOn );
	AdapterListView->setAllColumnsShowFocus( TRUE );

	QListViewItem *Item;
	int first=TRUE;
	char tmp[40];

	while(prtAdapter)
	{
		Item = new QListViewItem(AdapterListView, 0);		
		Item -> setPixmap(0, uic_load_pixmap_CardSelect("adapter.xpm"));
		Item -> setText(1, (const char *)prtAdapter->Device_Name);
		if(Get_Media_State(Socket_Id, prtAdapter->Device_Name) == NdisMediaStateConnected)
		{
			NDIS_802_11_SSID SSID;		
			NDIS_802_11_MAC_ADDRESS Bssid;
			if( (Get_OID_802_11_SSID(Socket_Id, prtAdapter->Device_Name, &SSID) >= 0 ) &&
					(Get_OID_802_11_BSSID(Socket_Id, prtAdapter->Device_Name, &Bssid) >= 0) )
			{
				DBGPRINT(RT_DEBUG_TRACE, (">> SSID=%s", SSID.Ssid));			
				DBGPRINT(RT_DEBUG_TRACE, (">> %02X:%02X:%02X:%02X:%02X:%02X", Bssid[0],Bssid[1],Bssid[2],Bssid[3],
														Bssid[4],Bssid[5]));
				SSID.Ssid[SSID.SsidLength]=0x00;   
				sprintf(tmp, "%s <--> %02X-%02X-%02X-%02X-%02X-%02X", SSID.Ssid, Bssid[0], Bssid[1], Bssid[2], Bssid[3], Bssid[4], Bssid[5] );			
				Item -> setText(2, (const char *)tmp);
			}
		}
		else
		{
			Item -> setText(2, (const char *)"Disconnect");
		}

		Item -> setText(3, "   Wireless Ethernet   ");
		NDIS_802_11_MAC_ADDRESS		CurrentAddress;      // User changed MAC address
		
		if( Get_OID_802_3_CURRENT_ADDRESS(Socket_Id, prtAdapter->Device_Name, &CurrentAddress) >= 0)
		{
			if( CurrentAddress[0] == 0x00 && CurrentAddress[1] == 0x00 && CurrentAddress[2] == 0x00 &&
				 CurrentAddress[3] == 0x00 && CurrentAddress[4] == 0x00 && CurrentAddress[5] == 0x00 )
			{
				Item -> setText(2, "Not Active");
			}
			else
			{
				//printf("%s \n", prtAdapter->Device_Name);
				sprintf(tmp, "%02X-%02X-%02X-%02X-%02X-%02X", CurrentAddress[0], CurrentAddress[1],
							CurrentAddress[2], CurrentAddress[3], CurrentAddress[4], CurrentAddress[5]);
				Item -> setText(4, (const char *)tmp);
			}			
		}

		if(first)
		{
			AdapterListView->setSelected(Item, TRUE);
			first=FALSE;
		}
		prtAdapter = prtAdapter->Next;
	}

    // signals and slots connections
	connect( OkPushButton, SIGNAL( clicked() ), this, SLOT( OkPushButton_Clicked() ) );
	connect( AdapterListView, SIGNAL( doubleClicked(QListViewItem*) ), this, SLOT( AdapterListView_doubleClicked() ) );
}

/*  
 *  Destroys the object and frees any allocated resources
 */
CardSelect::~CardSelect()
{
    // no need to delete child widgets, Qt does it all for us
}

void CardSelect::AdapterListView_doubleClicked()
{
	OkPushButton_Clicked();
}

const char *CardSelect::Get_Device_Name()
{
	return device.ascii();
}

void CardSelect::OkPushButton_Clicked()
{
	QListViewItem *Item;	
	QString str;	

	if(AdapterListView->childCount()==0)
	{//Never happened.	
		return;
	}

	Item = AdapterListView->currentItem();	
	if(Item == NULL)
	{
		QMessageBox::warning(this, "Warning", "Please select a adapter first.!");
		return ;
	}
	device=Item->text(1);
	close();
}
