#!@@PERL@@ @@PERLOPTS@@

# Copyright 1999, 2000, 2001 (c) Thomas Erskine <@@AUTHOR@@>
# See the COPYRIGHT file with the distribution.

# genindex - make a POD index from (URL, text) pairs
# $Id: genindex.pl,v 1.4 2001/08/28 15:22:24 remstats Exp $

# - - -   Configuration   - - -

# What is this program called, for error-messages and file-names
$main::prog = 'genindex';
# What format of output to use
$main::index_format = 'pod';

# - - -   Version History   - - -

(undef, $main::version) = split(' ', '$Revision: 1.4 $');

# - - -   Setup   - - -

use Getopt::Std;

# Parse the command-line
# STRICT use vars qw( $opt_d $opt_f $opt_h );
getopts('d:f:h');

if (defined $main::opt_h) { &usage; } # no return
if (defined $main::opt_d) { $main::debug = $main::opt_d; } else { $main::debug = 0; }
if (defined $main::opt_f) { $main::index_format = $main::opt_f; }

unless ($main::index_format eq 'html' or $main::index_format eq 'pod' or
		$main::index_format eq 'text') {
	&usage; # no return
}

# - - -   Mainline   - - -

my ($url, $text, %urls, $key);
# Slurp in the index pairs
while (<>) {
	chomp;
	($url, $text) = split(' ', $_, 2);
	$urls{$text} = $url;
}

for $key (sort keys %urls) {
	if ($main::index_format eq 'html') {
		print "<A HREF=\"$urls{$key}\">$key</A><BR>\n";
	}
	elsif ($main::index_format eq 'pod') {
		print "=for html\n<A HREF=\"$urls{$key}\">$key</A><BR>\n\n" .
			"=for text $key - $urls{$key}\n\n";
	}
	elsif ($main::index_format eq 'text') {
		print "$key - $urls{$key}\n";
	}
	else {
		&abort("unknown index format '$main::index_format')");
	}
}

exit 0;

#----------------------------------------------------------------- usage ---
sub usage {
	print STDERR <<"EOD_USAGE";
$main::prog version $main::version
usage: $main::prog [options] file ...
where options are:
	-d	enable debugging output
	-f fff  use 'fff' format for output (html, pod or text)[$main::index_format]
	-h	show this help
EOD_USAGE
	exit 0;
}

#----------------------------------------------------------------- debug ---
sub debug {
	my ($msg) = @_;

	if ($main::debug) { print STDERR "DEBUG: $msg\n"; }
0;
}

#----------------------------------------------- keep_strict_happy ---
sub keep_strict_happy {
	$main::opt_h = 0;
}
