<?php
	/**************************************************************************\
	* phpGroupWare - Chat                                                      *
	* http://www.phpgroupware.org                                              *
	* This application written by Joseph Engo <jengo@phpgroupware.org>         *
	* --------------------------------------------                             *
	*  This program is free software; you can redistribute it and/or modify it *
	*  under the terms of the GNU General Public License as published by the   *
	*  Free Software Foundation; either version 2 of the License, or (at your  *
	*  option) any later version.                                              *
	\**************************************************************************/

	/* $Id: users.php,v 1.10.2.1.2.2 2004/05/11 04:58:14 skwashd Exp $ */


	$GLOBALS['phpgw_info']['flags'] = array(
		'currentapp' => 'chat',
		'noheader'   => True,
		'nonavbar'   => True
	);
	include('../header.inc.php');
	$GLOBALS['phpgw']->common->phpgw_header();
	

	$userlist = $GLOBALS['phpgw']->session->list_sessions(0, 'ASC', 'session_lid');

	$size = count($userlist);
	if (($size == 0) || ($size == 1))
	{
		$size = 2;
	}
	elseif ($size > 10)
	{
		$size = 10;
	}
	
	$tpl = &$GLOBALS['phpgw']->template;
	$tpl->set_file(array('user' => 'user.tpl'));
	
  $tplvars['online']     = lang('Online');
	$tplvars['load']     	 = $GLOBALS['phpgw']->link('/chat/load.php');
  $tplvars['channel']  	 = $channel;
  $tplvars['size']			 = $size;

	$alreadyListed = array();
	while(list($key, $value) = each($userlist))
	{
		$userName = $userlist[$key]['session_lid'];
		if(!in_array($userName, $alreadyListed))
		{
			$tplvars['user_name']	.= '<option value="'.$userName.'">'.$userName.'</option>\n';
			$alreadyListed[] = $userName;
		}
	}
	
  $tplvars['privat_chat']	  = lang('Private Chat');
	$tplvars['users']         = $GLOBALS['phpgw']->link('/chat/users.php');
	$tplvars['refresh_users'] = lang('Refresh Users');
	
	$tpl->set_var($tplvars);
	$tpl->pfp('out','user');
?>
