<?php
/**
 * French Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2006  Christophe Bx, Julien Damon
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @author Christophe Bx
 * @author Julien Damon
 * @version $Id: help_text.fr.php,v 1.17.2.18 2006/07/07 21:36:50 opus27 Exp $
 */
if (preg_match("/help_text\...\.php$/", $_SERVER["SCRIPT_NAME"])>0) {
  print "You cannot access a language file directly.";
  exit;
}

#pgv_lang["edit_add_unlinked_source_help"]= "~#pgv_lang[add_unlinked_source]#~<br /><br />Use this link to add a new source to your database without linking the source to a source citation in another record.  The new source will appear in the source list, but will not appear on any charts or anywhere else in the program until it is linked up to a source citation.";
#pgv_lang["link_person_id_help"]        = "~#pgv_lang[label_local_id]#~<br /><br />In this field you enter the ID of the person you are linking to (e.g. I100).";
#pgv_lang["link_gedcom_id_help"]        = "~#pgv_lang[label_gedcom_id]#~<br /><br />Use this section to select the alternate database identifier that contains the the person you are linking to.";
#pgv_lang["link_remote_site_help"]      = "~#pgv_lang[label_site]#~<br /><br />In this section you specify the parameters that are required to connect to the remote site hosting the data you are linking to. You have the option of choosing from a list of known sites that you have used before, or entering the #pgv_lang[label_site_url2]# and #pgv_lang[label_gedcom_id]# for a new one.<br /><br />In the <b>#pgv_lang[label_site_url2]#</b> field, you enter the URL to access the web services description file (WDSL) which tells PhpGedView how to access the data on the remote site.  For a remote PhpGedView website, the URL to the WSDL file will look like this: <u>http://www.remotesite.com/phpGedView/genservice.php?wsdl</u><br /><br />The <b>#pgv_lang[label_gedcom_id]#</b> field is used to enter an optional database identifier for remote sites that require one.  For PhpGedView sites, this is the name of the GEDCOM file. <br /><br />The <b>#pgv_lang[label_username_id]#</b> and the <b>#pgv_lang[label_password_id]#</b> fields are necessary if the database requires it.<br /><br /><i>Note: Remote PhpGedView sites must be running version 4.0 or later; earlier versions do not have this capability.</i>";
#pgv_lang["link_remote_location_help"]  = "~#pgv_lang[label_location]#~<br /><br />This option allows you to choose whether data for the person you are linking to is on the same site but in a different genealogical database set, or whether the data is on a different site accessible through the Internet.<br /><br />If the person is on the same site, you will be asked to select the dataset identifier and enter the person's ID.<br /><br />For a remote site, you will be asked to enter its URL, a database identifier, and the person's remote ID.";
#pgv_lang["link_remote_rel_help"]       = "~#pgv_lang[label_rel_to_current]#~<br /><br />Use this option to select the relationship the remote person has to the person you are linking them with on your site.  For example, selecting <i>Father</i> would mean that the person on the remote site is the father of the person you are linking them to locally.";
#pgv_lang["link_remote_help"]           = "~#pgv_lang[link_remote]#~<br /><br />Use this form to link people to other people either from another site or another genealogical database accessible to your copy of PhpGedView.<br /><br />To add such a link, you must first select the relationship type, then choose a site already known to PhpGedView or define a new site, and then enter that site's ID of the person you want to link to.  PhpGedView will then automatically download information from the remote site as necessary.  The downloaded information does <u>not</u> become part of your genealogical database; it remains on the original site but is incorporated into the various pages where this remotely linked person is displayed.<br /><br />Refer to the Help link next to each element on the page for more information about that element.  You can also check the online English tutorial for more information: <a href=\"http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link\" target=\"_blank\">http://wiki.phpgedview.net/en/index.php/How_to_Remote_Link</a>.";

//-- Edit Interface
#pgv_lang["edit_ABBR_help"]             = "~ABBREVIATED TITLE~<br /><br />Use this field for storing an abbreviated version of a title.  This field is used in conjunction with the title field on sources.  By default PGV will first use the title and then the abbreviated title.<br /><br />According to the GEDCOM 5.5 specification, \"this entry is to provide a short title used for sorting, filing, and retrieving source records (pg 62).\"<br /><br />In PhpGedView the abbreviated title is optional, but in other genealogical programs it is required.";
#pgv_lang["edit_ROMN_help"]             = "~ROMANIZED NAME~<br /><br />In many cultures it is customary to have a traditional name spelled in the traditional characters and also a romanized version of the name as it would be spelled or pronounced in languages based on the Latin alphabet, such as English.<br /><br />If you prefer to use a non-Latin alphabet such as Hebrew, Greek, Russian, Chinese, or Arabic to enter the name in the standard name fields, then you can use this field to enter the same name using the Latin alphabet.  Both versions of the name will appear in lists and charts.<br /><br />Although this field is labelled \"Romanized\", it is not restricted to containing only characters based on the Latin alphabet.  This might be of use with Japanese names, where three different alphabets may occur.";
#pgv_lang["edit__HEB_help"]             = "~HEBREW NAME~<br /><br />In many cultures it is customary to have a traditional name spelled in the traditional characters and also a romanized version of the name as it would be spelled or pronounced in languages based on the Latin alphabet, such as English.<br /><br />If you prefer to use the Latin alphabet to enter the name in the standard name fields, then you can use this field to enter the same name in the non-Latin alphabet such as Greek, Hebrew, Russian, Arabic, or Chinese.  Both versions of the name will appear in lists and charts.<br /><br />Although this field is labelled \"Hebrew\", it is not restricted to containing only Hebrew characters.";
$pgv_lang["edit_sex_help"]              = "~#pgv_lang[sex]#~<br /><br />Choisissez le sexe approprié dans la liste déroulante. Choisissez <b>inconnu</b> si vous n'avez pas l'information.<br /><br />";
$pgv_lang["edit_name_help"]             = "~#pgv_lang[name]#~<br /><br />C'est le champ le plus important dans l'enregistrement du nom d'un individu. Ce champ peut être rempli automatiquement en remplissant les champs particuliers qui suivent, (méthode préférable), il est fourni de façon à ce que vous puisssiez saisir ces information selon vos préférences personnelles. Ce champ doit être saisi selon les standards de la norme GEDCOM 5.5.1, avec le nom de famille entouré de \"/\". Par exemple, le nom \"John Robert Finlay Jr.\" doit être entré : \"John Robert /Finlay/ Jr.\".<br /><br />";
$pgv_lang["edit_add_unlinked_person_help"]= "~#pgv_lang[add_unlinked_person]#~<br /><br />Utilisez ce formulaire pour ajouter une personne isolée.<br /><br />Quand vous ajoutez une personne isolée à votre arbre généalogique, la personne restera isolée tant que vous ne la relierez pas à une autre. Plus tard, vous pourrez lier des personnes ensemble à partir de l'onglet \"#pgv_lang[relatives]#\" de l'individu.";
$pgv_lang["edit_URL_help"]              = "Entrez l'adresse URL y compris le sigle http://.<br /><br />Une adresse URL ressemble à ceci:<b>http://www.phpgedview.net/</b> Laissez ce champ vide si vous ne souhaitez pas inclure une adresse URL.";
$pgv_lang["edit_EMAIL_help"]            = "Entrez l'adresse mail.<br /><br />Une adresse mail a la forme suivante:<b>nom@hotmail.com</b> Laissez ce champ en blanc si vous ne voulez pas inclure d'adresse mail.";
$pgv_lang["edit_FAX_help"]              = "Entrez le numero de FAX y compris le numéro du pays, et de la zone si il y a lieu.<br /><br />Laissez ce champ à blanc si vous ne voulez pas inclure de numéro FAX. Par exemple, un numéro de FAX en France doit être du type (sans le zero du début):  +33 491422679 et un numéro aux USA ou au Canada doit être du type: +1 888 555-1212.";
$pgv_lang["edit_PHON_help"]             = "Entrez le numéro de téléphone y compris le numéro du pays, et de la zone si il y a lieu.<br /><br />Laissez ce champ en blanc si vous ne voulez pas inclure de numéro de téléphone. Par exemple, un numéro en France est du type (sans le zero du début): +33 391322679 et un numéro aux USA ou au Canada du type: +1 888 555-1212.";
$pgv_lang["edit_ADDR_help"]             = "Entrez l'adresse dans le champ exactement comme si vous l'écriviez sur une enveloppe.<br /><br />Laissez ce champ à blanc si vous ne souhaitez pas inclure d'adresse.";
#pgv_lang["edit_GIVN_help"]             = "#pgv_lang[edit_given_name_help]#";
$pgv_lang["edit_SPFX_help"]             = "~#factarray[SPFX]# HELP~<br /><br />Entrer les(s) préfixe(s) pour le nom de famille.<br />Exemple : 'de la' pour Louis de la Martinière.<br /><br />Si la première lettre du préfixe est une majuscule, le nom sera trié sur ce préfixe :<br />'De la Martinière' sera classé à la lettre 'D'.<br />Inversement, pour une minuscule le tri se fera sur la première lettre du nom :<br />'de la Martinière' sera classé à la lettre 'M'.";
#pgv_lang["edit_SURN_help"]             = "#pgv_lang[edit_surname_help]#";
#pgv_lang["edit_NSFX_help"]             = "#pgv_lang[edit_suffix_help]#";
#pgv_lang["edit__MARNM_help"]           = "~#factarray[_MARNM]#~<br /><br />Enter the married name for this person, using the same formatting rules that apply to the Name field.  This field is optional.<br /><br />For example, if Mary Jane Brown married John White, you might enter (without the quotation marks, of course)<ul><li>American usage:&nbsp;&nbsp;\"Mary Jane Brown /White/\"</li><li>European usage:&nbsp;&nbsp;\"Mary Jane /White/\"</li><li>Alternate European usage:&nbsp;&nbsp;\"Mary Jane /White-Brown/\" or \"Mary Jane /Brown-White/\"</li></ul>You should do this only if Mary Brown began calling herself by the new name after marrying John White.  In some places, Quebec (Canada) for example, it's illegal for names to be changed in this way.<br /><br />Men sometimes change their name after marriage, most often using the hyphenated form but occasionally taking the wife's surname.";

$pgv_lang["context_help"]               = "Une aide est disponible en cliquant sur le <b>\"?\"</b> des différents champs de la page.";

$pgv_lang["register_gedcomid_help"]     = "~#pgv_lang[gedcomid]#~<br /><br />Chaque personne figurant dans la base est identifiée par un numéro d'ID unique sur ce site. Si vous connaissez le numéro d'ID de votre enregistrement, entrez le ici. Si vous ne le connaissez pas ou ne pouvez pas le trouver à cause des règles de protections sur la vie privée, veuillez laisser assez de renseignements dans le champ Commentaires pour aider l'administrateur du site à vous identifier, afin de mettre à jour ce champ avec votre numéro d'ID.<br />";
$pgv_lang["register_comments_help"]     = "~#pgv_lang[comments]#~<br /><br />Utilisez ce champ pour dire à l'administrateur du site pourquoi vous souhaitez un compte et en quoi vous êtes concerné par les informations généalogiques présentées sur ce site. Vous pouvez aussi utiliser ce champ pour tout autre commentaire à l'attention de l'administrateur.<br />";
$pgv_lang["utf8_ansi_help"]             = "~CONVERT FROM UTF-8 TO ANSI~<br /><br />Pour un affichage optimal sur Internet, PhpGedView utilise le codage des caractère en UTF-8. Certains programmes, Family Tree Maker par exemple, ne supportent pas l'importation de fichier GEDCOM encodés en UTF-8. Cocher cette case entrainera la conversion du fichier de l'<b>UTF-8</b> à l'<b>ANSI (ISO-8859-1)</b>.<br /><br />Le format dont vous avez besoin dépend donc du programme que vous utilisez pour ouvrir et importer votre GEDCOM. Si vous avez un doute, consultez la documentation de votre programme.<br /><br />Notez que pour conserver certains caractères spéciaux, vous devez garder le fichier en UTF-8 et le convertir avec la méthode appropriée de votre programme. Consultez votre éditeur ou l'auteur.<br /><br />";
$pgv_lang["remove_tags_help"]           = "~REMOVE CUSTOM PGV TAGS~<br /><br />Cocher cette option effacera tous les tags qui peuvent avoir été ajoutés par PhpGedView.<br /><br />Ces tags utilisés par PhpGedView comprennent le tag <b>_PGVU</b> qui identifie l'utilisateur ayant modifié un enregistrement en ligne et le tag <b>_THUM</b> qui indique à PhpGedView que l'image peut être utilisée comme miniature.<br /><br />Ces tags peuvent provoquer des erreurs à l'importation du fichier GEDCOM dans une autre appliquation de généalogie.<br /><br />";
#pgv_lang["download_zipped_help"]       = "~DOWNLOAD GEDCOM AS ZIP FILE~<br /><br />When you check this option, a copy of the GEDCOM file will be compressed into ZIP format before the download begins. This will reduce its size considerably, but you will need to use a compatible Unzip program (WinZIP, for example) to decompress the transmitted GEDCOM file before you can use it.<br /><br />This is a useful option for downloading large GEDCOM files.  There is a risk that the download time for the uncompressed file may exceed the maximum allowed execution time, resulting in incompletely downloaded files.  The ZIP option should reduce the download time by 75%.<br /><br />";
$pgv_lang["remember_me_help"]           = "~Rester mémorisé~<br /><br />En cochant cette case, vos paramètres seront mémorisés, évitant d'avoir à vous connecter la prochaine fois où vous reviendrez sur ce site.<br /><br />Cependant, pour des raisons de sécurité, vous devrez vous identifier de nouveau pour avoir accès aux fonctions d'administration.<br /><br />Les informations sont enregistrées dans un <i>cookie</i>.<br /><br />NE PAS UTILISER cette option sur un ordinateur public, cela permettrait à n'importe qui de consulter les données protégées.";
$pgv_lang["edit_NCHI_help"]             = "~#factarray[NCHI]# HELP~<br /><br />Entrer le nombre d'enfants pour cet individu ou cette famille. Ce champ est facultatif.<br /><br />";
$pgv_lang["edit_TIME_help"]             = "~#factarray[TIME]# HELP~<br /><br />Entrer l'heure de l'évènement sous la forme HH:MM. Exemples: 04:50 13:00 20:30.<br /><br />";
$pgv_lang["edit_NOTE_help"]             = "~#factarray[NOTE]# HELP~<br /><br />Une note est un texte libre qui s'affichera dans l'onglet Détails.<br /><br />";
$pgv_lang["edit_CEME_help"]             = "~#factarray[CEME]# HELP~<br /><br />Entrer le nom du cimetière où cette personne est enterrée. Exemple : Père-Lachaise.<br />La commune est à saisir dans le champ lieu.<br /><br />";
$pgv_lang["edit_ASSO_help"]             = "~#factarray[ASSO]# HELP~<br /><br />Entrer l'identifiant GEDCOM de la personne à associer.<br /><br />";
$pgv_lang["edit_RELA_help"]             = "~#factarray[RELA]# HELP~<br /><br />Choisir dans la liste le lien entre les deux personnes.<br />Exemple : en choisissant 'Parrain', cela signifie que la personne associée est le parrain de l'individu sélectionné.<br /><br />";
$pgv_lang["show_spouse_help"]           = "~#pgv_lang[show_spouses]#~<br /><br />Par défaut, ce diagramme ne présente pas les conjoints pour les descendants, car cela rend celui-ci difficile à lire et à comprendre. Cochez cette option si vous voulez voir figurer les conjoints sur le diagramme.<br /><br />";
$pgv_lang["reorder_families_help"]      = "~#pgv_lang[reorder_families]#~<br /><br />Les membres d'une famille sont présentés sur l'onglet #pgv_lang[relatives]# dans l'ordre où ils apparaissent à l'intérieur des enregistrements individuels du fichier GEDCOM. Les familles ne sont pas triées par date de mariage, car celles-ci sont souvent inconnues, alors que <u>l'ordre</u> des mariages l'est. <br /><br />Cette option vous permet de changer l'ordre de présentation des familles dans l'onglet  #pgv_lang[relatives]#.  Si vous souhaitez trier les familles par date de mariage, cette option le fera automatiquement.<br /><br />";
$pgv_lang["import_marr_names_help"]     = "~#pgv_lang[import_marr_names]#~<br /><br />Si vous choisissez l'option 'Ajouter le nom des maris', PhpGedView regardera toute les femmes de votre fichier GEDCOM et créera automatiquement une ligne 'nom marital' dans leur enregistrement GEDCOM. Cela vous permettra une recherche sur les femmes soit par leur nom de famille soit par leur nom de mariage.<br /><br />Cette option vous permettra aussi de faire apparaître leur nom de mariage dans les liste individuelles si vous activez l'option <b>#pgv_lang[SHOW_MARRIED_NAMES]#</b> dans les option de configuration de votre GEDCOM.<br /><br />";
$pgv_lang["firstname_alpha_help"]       = "~FIRSTNAME ALPHABETICAL INDEX~<br /><br />Le nom que vous avez choisi contient plus de 500 individus. Pour vous aider à trouver la personne que vous cherchez, nous avons divisé la liste à partir de la première lettre du prénom. Ce sous-index alphabétique travaille de la même façon que l'index sur les noms. Cliquez sur une lettre du prénom pour voir tous les prénom commençant avec cette lettre. Choisissez <b>#pgv_lang[NN]#</b> pour lister toutes les personnes dont le prénom est inconnu.<br /><br />Choisir <b>ALL</b> listera tous les individus ayant ce nom. Comme il y beaucoup de noms, cela peut prendre un certain temps avant d'avoir la réponse.<br /><br />";
$pgv_lang["edit_TYPE_help"]             = "~#factarray[TYPE]#~<br /><br />Le champ #factarray[TYPE]# vous permet de spécifier un évenement particulier. C'est un champ libre dans lequel vous pouvez entrer toute information que vous voulez mémoriser.<br /><br />";
#pgv_lang["edit_TEMP_help"]             = "~#factarray[TEMP]#~<br /><br />For LDS ordinances, this field records the Temple where it was performed.<br /><br />";
#pgv_lang["edit_STAT_help"]             = "~#factarray[STAT]#~<br /><br />This is an optional status field and is used mostly for LDS ordinances as they are run through the TempleReady program.<br /><br />";
$pgv_lang["edit__PRIM_help"]            = "~#factarray[_PRIM]#~<br /><br />Utilisez ce champ pour signaler que ce média est le média principal de l'individu auquel il est attaché. L'image principale est celle qui sera utilisée dans les diagrammes et sur la page de l'individu.<br /><br />";
$pgv_lang["edit__THUM_help"]            = "~#factarray[_THUM]#~<br /><br />C'est un champ PhpGedView qui permet de spécifier si une miniature doit être utilisée dans les diagrammes même si cette miniature n'existe pas.<br /><br />";
$pgv_lang["edit_TITL_help"]             = "~#factarray[TITL]#~<br /><br />Entrez un titre pour l'objet que vous mettez à jour. Si c'est un titre pour un objet multimédia, donnez un titre descriptif pour son identification par l'utilisateur.<br /><br />";
$pgv_lang["edit_FILE_help"]             = "~#factarray[FILE]#~<br /><br />C'est le champ le plus important pour l'enregistrement de l'objet multimédia. Il indique quel est le fichier à utiliser. Vous devez entrer au minimum le nom du fichier. En fonction de vos paramètres, plus d'information à propos de la localisation du fichier peut être utile.<br /><br />Vous pouvez utiliser le lien <b>#pgv_lang[find_media]#</b> pour vous aider à localiser les objets multimédia que vous avez déjà chargés sur le site.<br /><br />#pgv_lang[readme_help]#<br /><br />";
$pgv_lang["edit_FORM_help"]             = "~#factarray[FORM]#~<br /><br />Il s'agit d'un champ optionnel qui peut être utilisé pour renseigner le type de fichier multimédia. Certains programmes généalogiques regardent ce champ pour déterminer comment traiter le fichier. De toute façon, comme les transferts de fichiers média entre systèmes ne sont pas toujours évidents, ce champ n'est pas très important.<br /><br />";
$pgv_lang["generate_thumb_help"]        = "~GENERER LES MINIATURES~<br /><br />Nous avons détecté que votre système est capable de générer automatiquement des miniatures pour certains type d'images (cela peut être les fichiers JPG, GIF, et PNG). Les types que votre système gère sont listés à coté de la case à cocher.<br /><br />En cliquant cette case, vous signalez au système que vous chargez des images de ce type et que vous désirez qu'il essaie de générer les miniatures correspondantes. Laissez cette case vide si vous chargez vos propres miniatures.<br /><br />";
$pgv_lang["edit_add_NOTE_help"]         = "~#pgv_lang[add_note]#~<br /><br />Cette partie vous permet d'ajouter une note relative à l'évenement que vous mettez à jour. Les notes sont du texte libre, et la note apparaîtra dans la section <b>Faits et détails personnels</b> de la page de l'individu.<br /><br />";
$pgv_lang["edit_add_SOUR_help"]         = "~#pgv_lang[add_source]#~<br /><br />Cette section vous permet d'ajouter une source concernant l'évènement que vous mettez à jour.<br /><br />Dans le champ 'source', entrez le numéro de la source si celle-ci existe déjà. Cliquez sur le lien <b>#pgv_lang[create_source]#</b> si vous désirez créer une nouvelle source. Dans le champ 'Page', vous pouvez entrer les références (cote) ou toute autre information permettant de trouver la source. Dans le champ 'Texte', vous pouvez entrer la transcription textuelle de la source.<br /><br />";
$pgv_lang["edit_add_ASSO_help"]         = "~#pgv_lang[add_asso]#~<br /><br />#pgv_lang[add_asso]# Vous permet d'associer à un évènement une personne du site. C'est une des façons d'enregistrer, par exemple, que quelqu'un est le parrain d'une autre personne.<br /><br />";
#pgv_lang["edit_QUAY_help"]             = "~#factarray[QUAY]#~<br /><br />You would use this field to record the quality or reliability of the data found in this source.  Many genealogy applications use a number in the field. <b>1</b> might mean that the data is a primary source, <b>2</b> might mean that it was a secondary source, <b>3</b> might mean the information is unreliable.<br /><br />";
$pgv_lang["edit_PAGE_help"]             = "~#factarray[PAGE]#~<br /><br />Dans le champ 'Page', vous pouvez entrer la cote du document et/ou tout autre information (page, folio) permettant de trouver l'information dans le document source.<br /><br />";
$pgv_lang["edit_TEXT_help"]             = "~#factarray[TEXT]#~<br /><br />Dans ce champ, vous pouvez entrer des citations concernant cette source. Ce peut être la transcription textuelle, ou la description de ce qui se trouve dans le document.<br /><br />";
$pgv_lang["edit_SOUR_help"]             = "~#factarray[SOUR]#~<br /><br />Saisir dans ce champ le numero ID de la source associée à l'évènement. Si la source que vous voulez associer existe déjà, la case de gauche listera l'ensemble des sources de la base, présentées par titre, vous permettant d'en sélectionnner une. Si la source que vous voulez associer est à créer, selectionnez la case de droite. Quand le champ est rempli, le titre de la source figure à droite du champ. Pour enlever une source, mettez le champ à blanc.<br /><br />";
$pgv_lang["edit_edit_raw_help"]         = "~#pgv_lang[edit_raw]#~<br /><br />Cette page vous permet de mettre à jour directement l'enregistrement du fichier GEDCOM. Utilisez cette possibilité avec précaution, car cela nécessite une bonne compréhension de la syntaxe GEDCOM 5.5.1. Pour plus d'information sur le standard GEDCOM 5.5.1, veuillez vous référer à l'aide.<br /><br />PhpGedView permet (c'est son rôle) de mettre à jour votre fichier GEDCOM au travers des différentes transactions, mais vous pouvez avoir besoin d'intervenir directement sur celui-ci. Ne le faites que quand vous ne pensez pas possible de passer par les possibilités de transactions fournies par PhpGedView.<br /> A la mise à jour, la conformité de vos modifications est vérifiée par rapport aux standards de base de la norme GEDCOM, et le label CHAN est mis à jour.<br /><br /><br />";
#pgv_lang["add_from_clipboard_help"]    = "~#pgv_lang[add_from_clipboard]#~<br />PhpGedView allows you to copy facts to a clipboard.  You can copy up to 5 facts and store them in the clipboard.  From the Add New Facts drop-down menu you can choose to paste one of the facts from the clipboard into the record you are editing.  This is very helpful when entering similar facts, such as census facts, for many individuals or families.<br /><br />";
$pgv_lang["edit_PLAC_help"]             = "~#factarray[PLAC]#~<br /><br />Les lieux doivent être saisis selon les standards généalogiques. Les lieux sont enregistrés par niveaux, allant du particulier au général, séparés par une virgule.<br />Par exemple, un endroit comme Bergerac en Dordogne s'écrit: <br /> \"Bergerac, F24100, Dordogne, Aquitaine, France\".<br />Examinons chaque partie de ce lieu, ou nous avons précisé 5 niveaux:<br /> \"Bergerac\" est le niveau le plus fin que nous ayons voulu indiquer, la commune. Viennent ensuite \"F24100\" le code postal (ou code INSEE de la commune selon les bases, le code INS en Belgique), puis \"Dordogne\" et \"Aquitaine\", le département et la région. Le pays clôture la liste comme étant le niveau le plus général. Nous aurions pu aussi, détailler plus, et faire précéder le niveau commune d'un niveau plus fin (lieu dit, par exemple), ayant alors 6 niveaux.<br />Si un niveau est inconnu (ou que vous ne pensiez pas utile de le préciser), il vous faut laisser l'emplacement vide entre les deux virgules correspondantes. Si par exemple vous ne connaissez pas la région, l'adresse suivante est valide: <br />\"Lieu-dit, Begerac, F24100, Dordogne, , France\".<br /> Supposons que vous sachiez uniquement que l'évenement que vous décrivez se passe en Dordogne, vous notez : <br />\", , , Dordogne, , France\". <br /><br /> D'une base à l'autre, et d'un pays à l'autre, le nombre de niveaux, et la définition des niveaux varient, mais est définie une fois pour toute dans le fichier GEDCOM. Vous devez donc saisir le lieux conformément à ce qui est prévu dans le fichier GEDCOM sur lequel vous intervenez. Vous trouvez cette information sur la page 'Liste des lieux', indiqué en bas ('Les lieux sont classés dans cet ordre :').<br /><br /> Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour trouver les lieux déjà existants dans la base.<br /> <br />";
$pgv_lang["edit_add_parent_help"]       = "~AJOUT D'UNE MERE OU D'UN PERE~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme père ou mère de la personne sélectionnée. Saisissez le nom, les informations de naissance et de décès, c'est tout. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou évènements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez sur le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. A partir de cette page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.<br /><br />";
$pgv_lang["edit_add_spouse_help"]       = "~AJOUT D'UNE NOUVELLE FEMME OU D'UN NOUVEL EPOUX~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme épouse ou époux de la personne sélectionnée. Saisissez le nom, les informations de naissance et de décès, c'est tout. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou évènements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez sur le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. A partir de cette page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.<br /><br />";
$pgv_lang["edit_death_help"]            = "~#pgv_lang[death]#~<br /><br />Vous pouvez entrer ici les informations de décès. Saisissez en premier la date du décès, au format généalogique (1 JAN 2004). Vous pouvez cliquer sur l'icône  du calendrier afin de sélectionner une date. Entrez ensuite le lieu. Vous pouvez utiliser le lien #pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base.<br /><br />";
$pgv_lang["edit_birth_help"]            = "~#pgv_lang[birth]#~<br /><br />Vous pouvez entrer ici les informations de naissance. Saisissez en premier la date de celle-ci, au format généalogique (1 JAN 2004). Vous pouvez cliquer sur l'icône  du calendrier afin de sélectionner une date. Entrez ensuite le lieu. Vous pouvez utiliser le lien #pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base.<br /><br />";
$pgv_lang["edit_sex_help"]              = "~#pgv_lang[sex]#~<br /><br />Choisissez le sexe approprié dans la liste déroulante. Choisissez <b>inconnu</b> si vous n'avez pas l'information.<br /><br />";
$pgv_lang["edit_name_help"]             = "~#pgv_lang[name]#~<br /><br />C'est le champ le plus important dans l'enregistrement du nom d'un individu. Ce champ peut être rempli automatiquement en remplissant les champs particuliers qui suivent, (méthode préférable), il est fourni de façon à ce que vous puisssiez saisir ces information selon vos préférences personnelles. Ce champ doit être saisi selon les standards de la norme GEDCOM 5.5.1, avec le nom de famille entouré de \"/\". Par exemple, le nom \"John Robert Finlay Jr.\" doit être entré : \"John Robert /Finlay/ Jr.\".<br /><br />";
$pgv_lang["edit_suffix_help"]           = "~#pgv_lang[suffix]#~<br /><br />Ce champ optionnel vous permet de rentrer le suffixe du nom de la personne. Pa rexemple, \"Sr.\", \"Jr.\", ou \"III\".<br /><br />";
$pgv_lang["edit_surname_help"]          = "~#pgv_lang[surname]#~<br /><br />Saisir dans ce champ le nom de famille. Par exemple, \"Dupont\", pour une personne s'appellant \"Jean pierre Dupont\".<br /><br />";
$pgv_lang["edit_NICK_help"]             = "~#factarray[NICK]#~<br /><br />Dans ce champ, vous pouvez saisir le ou les surnoms de la personne. <br />Il s'agit d'un champ optionnel.<br /><br />";
$pgv_lang["edit_given_name_help"]       = "~#pgv_lang[given_name]#~<br /><br />Saisissez dans ce champ le ou les prénoms de la personne. Par exemple, si le nom de la personne est \"Jean Pierre Dupont\", saisissez \"Jean Pierre\".<br /><br />";
$pgv_lang["edit_NPFX_help"]             = "~#factarray[NAME]# #factarray[NPFX]#~<br /><br />Ce champ vous permet de saisir un préfixe du nom, tel \"Dr.\", ce qui donnera \"Dr Jean Dupont\".<br /> A ne pas confondre avec le préfixe du nom de famille (particule, par ex.), qui est saisi dans le champ \"Préfixe du nom de famille\" ci-dessous.<br /><br />";
$pgv_lang["edit_add_child_help"]        = "~#pgv_lang[add_child]#~<br /><br />Avec cette page, vous pouvez ajouter une nouvelle personne comme enfant de la famille sélectionnée. Saisissez le nom, les informations de naissance et de décès, c'est tout. Si vous ne possédez pas une des informations, laissez le champ correspondant à blanc.<br /><br />Pour ajouter d'autres faits ou évènements en sus de la naissance ou du décès, créer d'abord la personne en confirmant la mise à jour. Après, cliquez sur le nom de la personne apparaissant maintenant sur la page de la Famille ou dans l'onglet #pgv_lang[relatives]# pour voir la page des #pgv_lang[indi_info]# de la personne. A partir de cette page #pgv_lang[indi_info]#, vous pouvez ajouter des informations détaillées.<br /><br />";

$pgv_lang["review_changes_help"]        = "~MODIFICATIONS NON ACCEPTEES~<br /><br />Ce bloc liste tous les enregistrements qui ont été mis à jour en ligne, et qui doivent être vérifiés et acceptés.<br /><br />";
$pgv_lang["quick_update_name_help"]     = "~MODIFICATION DU NOM~<br /><br />Utilisez <b>Modif nom</b> pour mettre à jour le nom de la personne choisie. Vous avez un champ pour le nom propre et un champ pour le ou les prénoms. Par exemple, si la personne s'appelle \"Jean Pierre Dupont\", entrez \"Jean Pierre\" dans le champ <b>Prénom(s)</b> et \"Dupont\" dans le champ <b>Nom de famille</b>.<br /><br /> Remplir ces champs <u>modifiera</u> les noms de la personne,  cela n'ajoutera pas de nouveau nom.<br /><br /><i>Note: vous ne devez <u>pas</u> utiliser cette méthode si la modification est due à un nouveau mariage. Dans ce cas, utilisez le champ <b>Ajouter un nouvel époux</b> ci-dessous</i><br /><br />";
$pgv_lang["quick_update_fact_help"]     = "~MODIFICATION D'UN EVENEMENT~<br /><br />Utilisez les champs <b>Modif évènement</b> pour ajouter ou pour mettre à jour un évènement concernant la personne choisie. Choisissez un évènement dans la liste déroulante, puis entrez la date à laquelle cet évènement est survenu, en respectant le standard généalogique du format des dates  (1 JAN 2004). Vous pouvez cliquer sur l'icône du calendrier pour selectionner une date dans celui-ci. Entrez ensuite le lieu de cet évènement. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour sélectionner un lieu déjà existant dans la base.<br /><br />Comme l'ensemble des champs de cette page, votre information remplacera l'information existante si elle existe, ou créera une nouvelle entrée.<br /><br />";
$pgv_lang["quick_update_photo_help"]    = "~MODIF PHOTO~<br /><br />Utilisez <b>Modif photo</b> pour charger une image de la personne choisie. Dans le champ <b>Titre</b> entrez un texte descriptif de cette image, par exemple quelque chose comme \"Jean Pierre Dupont en tenue, Strasbourg 1912\". Puis cliquez sur le bouton <b>Parcourir</b> pour rechercher le média sur votre ordinateur. Si une image existe déjà pour cette personne, un message vous demandera si vous voulez remplacer ou ajouter.<br /><br />";
$pgv_lang["quick_update_address_help"]  = "~MODIF  ADDRESSE~<br /><br />Utilisez <b>Modif adresse</b> pour modifier celle-ci, ou le numéro de téléphone, de fax ou le mail de la personne choisie.<br /><br />Comme pour l'ensemble des champs de cette page, votre information remplacera celle existante si elle existe ou créera une nouvelle entrée.<br /><br />";
$pgv_lang["quick_update_spouse_help"]   = "~AJOUTER UN MARI OU UNE FEMME~<br /><br />Utilisez ces champs quand vous désirez <u>ajouter</u> une épouse ou un époux à la personne choisie. Saisissez le nom du conjoint et les informations de naissance dans les champs concernés, puis entrez la date du mariage dans le champ correspondant. Entrez les dates dans le format du standard généalogique (1 JAN 1908). Vous pouvez cliquer sur l'icône du calendrier pour selectionner une date dans celui-ci. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour selectionner un lieu déjà existant dans la base.<br /><br />Ces champs peuvent seulement <u>ajouter</u> un conjoint, il ne sont pas faits pour mettre à jour un conjoint existant. Pour mettre à jour une personne déjà existante, fermez cette fenêtre et cliquez sur le nom de la personne concernée dans l'onglet <b>#pgv_lang[relatives]#</b>. Puis procédez à sa mise à jour avec cette même fenêtre.<br /><br />";
$pgv_lang["quick_update_marriage_help"] = "~MODIF MARIAGE~<br /><br />Vous pouvez employer ces champs conjointement avec les champs pour ajouter un nouveau conjoint si vous voulez enregistrer un nouveau mariage. Autrement, les données entrées dans ces champs modifieront les informations sur le dernier mariage de la personne. Entrez les dates dans le format généalogique (1 JAN 1908). Vous pouvez cliquer sur l'icône du calendrier afin de selectionner une date dans celui-ci. Vous pouver cliquer sur le lien <b>#pgv_lang[find_place]#</b> afin de sélectionner un lieu déjà existant dans la base.<br /><br />";
$pgv_lang["quick_update_child_help"]    = "~AJOUTER UN NOUVEL ENFANT~<br /><br />Utilisez ces champs afin d'ajouter un nouvel enfant à la personne choisie. Entrez son ou ses prénoms et son sexe. Entrez ensuite le lieu et la date de naissance. Entrez les dates au format généalogique (1 JAN 1908). Vous pouvez cliquer sur l'icône du calendrier afin de choisir une date dans celui-ci. Vous pouvez utiliser le lien <b>#pgv_lang[find_place]#</b> pour sélectionner un lieu déjà existant dans le base.<br /><br /> Ces champs servent seulement à <u>ajouter</u> un nouvel enfant. Ils ne peuvent mettre à jour un enfant déjà existant. Pour mettre à jour une personne déjà existante dans la base, fermez cette fenêtre, cliquez sur son nom dans l'onglet <b>#pgv_lang[relatives]#</b>. Il s'agira alors de la personne sélectionnée, et vous aurez accès à toutes les modifications la concernant.<br /><br />";
$pgv_lang["index_top10_pageviews_help"] = "~MOST VIEWED ITEMS BLOCK~<br /><br />Ce bloc liste les 10 individus, familles ou sources ayant étés le plus vus par les visiteurs. Pour que ce bloc fonctionne, l'administrateur doit avoir activé le compteur de visites.<br /><br />";
$pgv_lang["useradmin_user_default_tab_help"]= "~USER DEFAULT TAB SETTING~<br /><br />Ce paramètre vous permet de spécifier quel est l'onglet ouvert automatiquement lorsque l'utilisateur accède à la page #pgv_lang[indi_info]#. Si il a l'autorisation d'éditer son compte, l'utilisateur peut modifier ce paramêtre par la suite.<br /><br />";
$pgv_lang["edituser_user_default_tab_help"]= "~USER DEFAULT TAB SETTING~<br /><br />Ce paramètre vous permet de spécifier quel est l'onglet ouvert automatiquement lorsque vous ouvrez la page #pgv_lang[indi_info]#.<br /><br />";
$pgv_lang["reorder_children_help"]      = "~RE-ORDER CHILDREN~<br /><br />Les enfants apparaissent dans l'ordre dans lequel ils figurent dans l'enregistrement de la famille. Les enfants ne sont pas triés sur la date de naissance, car souvent celles-ci sont inconnues, alors que <u>l'ordre</u> des naissance l'est.<br /><br />Cette option vous permet de changer cet ordre, les enfants étant alors triés automatiquement sur la date de leur naissance.<br /><br />";
#pgv_lang["rss_feed_help"]              = "~RSS FEED SETTINGS~<br /><br />The RSS feed available in PhpGedView allows you to view the main contents of your welcome page from you favorite RSS feed aggregator without visiting the site. Most aggregators will pop up a notice letting you know when something has changed on the Index page. This essentially allows you to monitor a PhpGedView site without needing to visit it regularly.<br /><br />With the RSS Feed block you customize the link to the feed, allowing specific feed types (most readers can deal with most types so this can usually be left at the default), and the specific module you would like in your feed. The language of the feed and the GEDCOM used will be based on the language and GEDCOM active in PhpGedView when you select the feed.<br /><br />The types of feed that can be generated include RSS 0.92, RSS 1.0, RSS 2.0, ATOM 1.0, ATOM 0.3, HTML and JavaScript. The first 5 types are for feed aggregators, while JavaScript and HTML are meant to enable inclusion of the feeds in other web pages.  Note that the various version numbers of the RSS feed indicate different styles, not a different version.<br /><br />There is an option to select authentication that will log the user in, and allow the user to view via an RSS Agregator, any information that they could normally view if logged in. Basic Authentication uses &quot;Basic HTTP Authentication&quot; to log the user in. Future enhancements might allow &quot;Digest Authentication&quot;.<br /><br />";

#pgv_lang["upload_media_folder_help"]   = "~#pgv_lang[folder]#~<br /><br />Your GEDCOM configuration allows up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b> where uploaded media files are normally stored. This lets you organize your media files, and you don't need to be as concerned about maintaining unique names for each media file.<br /><br />In this field you specify the destination directory on your server where the uploaded media file is to be stored.  Be sure to pay attention to the case (upper or lower case) of what you enter or select here, since file and directory names are case sensitive.<br /><br />If the directory name you enter here does not exist, it will be created automatically. If you enter more than the additional #GLOBALS[MEDIA_DIRECTORY_LEVELS]# directory levels permitted by your GEDCOM configuration, your input will be truncated accordingly.<br /><br />Thumbnails will be uploaded or created in an identical directory structure, starting with <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />";
#pgv_lang["upload_media_file_help"]     = "~#pgv_lang[media_file]#~<br /><br />In this field you specify the location and name, on your local computer, of the media file you wish to upload to the server.  You can use the <b>Browse</b> button to search your local computer for the desired file.<br /><br />The uploaded file will have the same name on the server, and it will be uploaded to the directory specified in the <b>#pgv_lang[folder]#</b> field.  If you do not see this field or cannot change it, your GEDCOM configuration has been set to allow no directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b> where uploaded media files are normally stored.<br /><br />You can leave this field blank if you wish to upload only a thumbnail file and have that uploaded thumbnail file become the main image as well.<br /><br />";
#pgv_lang["upload_thumbnail_file_help"] = "~#pgv_lang[thumbnail]#~<br /><br />In this field you specify the location and name, on your local computer, of the thumbnail file you wish to upload to the server.  You can use the <b>Browse</b> button to search your local computer for the desired file.  When this field is filled in, the <b>#pgv_lang[auto_thumbnail]#</b> checkbox is ignored.<br /><br />If the <b>#pgv_lang[media_file]#</b> field has been filled in, your uploaded thumbnail file will be named according to the contents of that field, regardless of what it is called on your local computer.  If that field is empty, the uploaded thumbnail file will be copied to two places on the server, once into the server directory mentioned in the <b>#pgv_lang[folder]#</b> field, and then again into an identical directory structure starting with <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b>.<br /><br />If you do not see the <b>#pgv_lang[folder]#</b> field or cannot change it, your GEDCOM configuration has been set to allow no directory levels beyond the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b> where uploaded media files are normally stored.<br /><br />";


//-- GENERAL
$pgv_lang["help_header"]                = "<span class=\"error\"><small>Avertissement : certains textes d'aide n'ont pas encore été traduits en français.</small></span><br/><br/>Aide sur : ";
$pgv_lang["privacy_error_help"]         = "<b>Détails privés</b><br /><br />Plusieurs raisons possibles à ce message :<dl><dt>1. Vous n'êtes pas inscrit sur ce site</dt><dd>Les détails sur les personnes vivantes sont masqués.<br />Les visiteurs non authentifiés ont accès aux fiches des personnes décédées uniquement.<br />Vous pouvez faire une demande de compte.</dd><dt>2. Vous disposez d'un compte et d'un mot de passe</dt><dd>mais vous avez oublié de vous connecter.</dd><dt>3. Information marque 'Privé'</dt><dd>La personne sélectionnée a demandé ce verrouillage à l'administrateur<br />Dans ce cas, seul l'administrateur a l'accès aux détails sur cette personne.</dd><dt>4. Vous n'avez pas de lien direct</dt><dd>Même pour les utilisateurs déclarés et connectés, certaines informations ne sont accessibles qu'aux proches, suivant le degré fixé par l'administrateur.<br />Exemples:<br />Pour le degré <b>1</b>, vous verrez les détails de votre propre famille, père, mère, frère, sœur (mais pas leurs conjoints ni vos neveux et nièces)<br />Pour le degré <b>2</b>, vous verrez en plus les conjoints de vos frères/sœurs et vos neveux/nièces.<br />Plus le degré est élevé, plus vous voyez de proches.<br />Si vous pouvez justifier d'un lien de parenté, contacter l'administrateur.</dd></dl>";
$pgv_lang["more_help"]                  = "<br />Pour une aide plus détaillée, vérifier l'option <b>#pgv_lang[show_context_help]#</b> dans le menu <b>#pgv_lang[page_help]#</b>, et suivre les liens <b>#pgv_lang[qm]#</b> de la page.<br />";
$pgv_lang["more_config_help"]           = "<br /><b>Aide détaillée</b><br />Une aide plus détaillée est disponible.<br />Suivre les liens <b>?</b> de la page.<br /><br />";
$pgv_lang["start_admin_help"]           = "+++ Début du complément d'informations de l'administrateur +++";
$pgv_lang["end_admin_help"]             = "--- Fin du complément d'informations de l'administrateur ---";
$pgv_lang["multiple_help"]              = "<center>--- Aide commune à plusieurs pages ---</center>";
$pgv_lang["header_general_help"]        = "<div class=\"name_head\"><center><b>Informations générales</b></center></div><br />";
$pgv_lang["best_display_help"]          = "~#pgv_lang[resolution]#~<br />PhpGedView est prévu pour une taille d'écran de 1024x768 pixels.<br />Il s'agit de la valeur minimum pour que tout s'affiche correctement.<br />Avec une résolution inférieure, par exemple 800x600, vous devrez souvent utiliser les ascenceurs (scrolling).<br />";
$pgv_lang["preview_help"]               = "~#pgv_lang[print]#~<br />Le lien <b>#pgv_lang[print_preview]#</b> en bas de chaque page permet une impression plus propre en n'affichant pas les menus, les liens, les boutons d'aide...<br /><br />Le lien <b>#pgv_lang[print_preview]#</b> devient alors <b>#pgv_lang[print]#</b>, et affiche votre menu d'impression habituel.<br />Après l'impression, utilisez simplement le bouton <b>Retour</b> de votre navigateur.<br /><br /><b>Note :</b><br />En mode <b>#pgv_lang[print_preview]#</b> la plupart des liens sont cachés. Les liens sur les boîtes et les personnes restent néanmoins actifs.<br />";
$pgv_lang["readme_help"]                = "<center>Voir le fichier <a href=\"readme.txt\" target=\"_blank\"><b>Readme.txt</b></a> pour davantage d'informations.</center>";
$pgv_lang["is_user_help"]               = "--- Texte identique à l'aide visiteur. --- <br />--- Pour économiser de la place, il n'y a pas de texte spécial administrateur ici. ---";
$pgv_lang["edit_raw_gedcom_help"]       = "~#pgv_lang[edit_raw]#~<br /><br />En cliquant sur ce lien, une nouvelle fenêtre s'ouvre permettant la <B>modification</B> de l'enregistrement GEDCOM.<br />Respecter impérativement la syntaxe GEDCOM 5.5 car aucun contrôle n'est réalisé.<br />Les modifications effectuées seront soumises à l'approbation de l'administrateur.";
$pgv_lang["RESN_help"]                  = "~Restrictions d'accès sur un enregistrement~<br /><br />En plus des règles globales de restrictions d'accès, PhpGedView offre la possibilité d'ajouter des restrictions d'accès en lecture et/ou écriture à certains enregistrements concernant une Famille ou un Individu.<br /><br />Valeurs possibles pour ce champ :<br /><ul><li><b>#pgv_lang[none]#</b><br/>Les administrateurs du site ou du fichier GEDCOM, ainsi que les utilisateurs avec privilèges, peuvent modifier l'information. Pour les autres, la lecture est autorisée conformément aux règles de restrictions globales.</li><li><b>#pgv_lang[locked]#</b><br />Le droit de modification est réservé aux administrateurs, et à l'utilisateur dont ce sont les propres informations.</li><li><b>#pgv_lang[privacy]#</b><br />L'information est cachée, sauf aux administrateurs et à l'utilisateur concerné.</li><li><b>#pgv_lang[confidential]#</b><br />Information accessible aux seuls administrateurs.</li></ul><br /><table><tr><th></th><th colspan=2>Admin</th><th colspan=2>Individu</th><th colspan=2>Autres</th></tr><tr><th></th><th>R</th><th>W</th><th>R</th><th>W</th><th>R</th><th>W</th></tr><tr><td><img src=\"images/RESN_none.gif\" alt=\"\"/> #pgv_lang[none]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th></tr><tr><td><img src=\"images/RESN_locked.gif\" alt=\"\"/> #pgv_lang[locked]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_privacy.gif\" alt=\"\"/> #pgv_lang[privacy]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked_qm.gif\" /></th><th><img src=\"images/checked_qm.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr><tr><td><img src=\"images/RESN_confidential.gif\" alt=\"\"/> #pgv_lang[confidential]#</td><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/checked.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th><th><img src=\"images/forbidden.gif\"/></th></tr></table><ul><li>R : droit de lire</li><li>W : droit de modifier</li><li><img src=\"images/checked_qm.gif\"/> : droits selon les règles de restrictions globales</li></ul>";


//-- Pages Help-messages
//-- Index-page
$pgv_lang["index_help"]                 = "~#pgv_lang[welcome_page]#~<br />Bienvenue sur la page d'accueil du fichier <a href=\"#def_gedcom\">GEDCOM</a> sélectionné. A tout moment vous pouvez revenir sur cette page par le bouton <b>#pgv_lang[welcome_page]#</b> du menu principal. Si plusieurs fichiers GEDCOM sont disponibles, faîtes-votre choix dans le menu déroulant<br /><br /><b>Ici vous trouverez de l'aide sur:</b><br /><li><a href=\"#header_general\">Informations générales</a><li><a href=\"#header\">#pgv_lang[header]#</a><li><a href=\"#menu\">Menus</a><li><a href=\"#index_portal\">#pgv_lang[welcome_page]#</a><li><a href=\"#def\">Définitions</a><br /><br />La version #VERSION# de <a href=\"#def_pgv\">PhpGedView</a> apporte des améliorations sur la présentation, les menus, la page d'accueil, et de nombreuses fonctions ont été revues.<br /><br />";

//-- Index-page Header
$pgv_lang["header_help"]                = "<div class=\"name_head\"><center><b>#pgv_lang[header]#</b></center></div><br />En haut de chaque page s'affichent des boutons et liens utilisables à tout moment.<br />La présentation du site étant personnalisable, le bandeau est variable selon le <a href=\"#def_theme\">thème</a> choisi.<br /><br /><b>Voici la liste des liens que vous pourrez y trouver :</b><li><a href=\"#header_search\">#pgv_lang[search]#</a><li><a href=\"#header_lang_select\">#pgv_lang[change_lang]#</a><li><a href=\"#header_user_links\">#pgv_lang[login]#</a><li><a href=\"#header_favorites\">#pgv_lang[gedcom_favorites]#</a><li><a href=\"#header_theme\">#pgv_lang[change_theme]#</a><br />";
$pgv_lang["header_search_help"]         = "~#pgv_lang[header]# «#pgv_lang[search]#»~<br />Cette boîte de recherche est petite mais puissante.<br />Laissez PhpGedView chercher pour vous.<br />Vous trouverez une aide détaillée sur la page de recherche.<br />";
$pgv_lang["header_lang_select_help"]    = "~#pgv_lang[header]# «#pgv_lang[change_lang]#»~<br />PhpGedView est multi-langues. Par défaut il démarre dans la langue de votre navigateur.<br />Vous pouvez changer de langue en utilisant le <B>menu déroulant</B> ou bien la liste des <B>drapeaux</B> en couleur.<br />";
$pgv_lang["header_user_links_help"]     = "~#pgv_lang[header]# «#pgv_lang[login]#»~<br />Cette liste de liens reste présente au même endroit sur toutes les pages (sauf si vous changez le thème).<br />Non connecté, vous voyez uniquement le lien <B>#pgv_lang[login]#</B>.<br />Connecté, vous voyez <b>#pgv_lang[logged_in_as]#</b>. Ce lien vous donne l'accès à votre compte. Cliquer sur <B>#pgv_lang[logout]#</B> pour vous déconnecter.<br />Si vous avez les droits d'administrateur, le lien <B>#pgv_lang[admin]#</B> s'affiche.<br />";
$pgv_lang["header_favorites_help"]      = "~#pgv_lang[header]# «#pgv_lang[gedcom_favorites]#»~<br />Cette liste affiche les liens favoris que vous avez sélectionnés. S'y ajoutent les favoris enregistrés pour ce fichier GEDCOM par l'administrateur.<br />Ces liens vous offrent l'accès direct à la page détaillée de l'individu choisi.<br />Pour savoir comment ajouter un favori, consulter l'aide sur la page <B>#pgv_lang[my_favorites]#</B>.<br />";
$pgv_lang["header_theme_help"]          = "~#pgv_lang[header]# «#pgv_lang[change_theme]#»~<br />Si l'administrateur l'autorise, vous pouvez choisir votre thème dans une liste, et modifier ainsi l'affichage du site. Si vous êtes connecté, ce thème sera mémorisé et deviendra votre thème par défaut.<br />";

//-- Index-page Menu
$pgv_lang["menu_help"]                  = "<div class=\"name_head\"><center><b>Menus</b></center></div><br />En passant votre souris sur l'icone d'un menu, un sous-menu s'affiche.<br />Un clic vous emmène sur la page du premier sous-menu.<br /><br />Liste des menus disponibles:</b><br /><li><a href=\"#menu_fam\">#pgv_lang[welcome_page]#</a><br /><li><a href=\"#menu_myged\">#pgv_lang[mygedview]#</a><br /><li><a href=\"#menu_charts\">#pgv_lang[charts]#</a><br /><li><a href=\"#menu_lists\">#pgv_lang[lists]#</a><br /><li><a href=\"#menu_annical\">#pgv_lang[anniversary_calendar]#</a><br /><li><a href=\"#menu_clip\">#pgv_lang[clippings_cart]#</a><br /><li><a href=\"#menu_search\">#pgv_lang[search]#</a><br /><li><a href=\"#menu_rslog\">#pgv_lang[research_log]#</a><br /><li><a href=\"#menu_help\">#pgv_lang[page_help]#</a><br /><br />";
$pgv_lang["menu_famtree_help"]          = "~#pgv_lang[menu]# «#pgv_lang[welcome_page]#»~<br />Tous les fichiers GEDCOM disponibles sur le site sont présentés ici. Chacun ayant sa propre présentation.<br />Quand le site ne présente qu'un seul fichier GEDCOM, ce sous-menu est vide.<br /><br />";
$pgv_lang["menu_myged_help"]            = "~#pgv_lang[menu]# «#pgv_lang[mygedview]#»~<br />Si vous êtes connecté, ce menu présente les choix suivants :<dl><dt>#pgv_lang[mygedview]#</dt><dd>Vous renvoie sur votre propre #pgv_lang[welcome_page]#.</dd><dt>#pgv_lang[editowndata]#</dt><dd>Pour modifier vos paramètres personnels.</dd><dt>#pgv_lang[my_pedigree]#</dt><dd>Si vous avez choisi un #pgv_lang[root_person]# pour ce fichier GEDCOM, son #pgv_lang[index_header]# s'affichera</dd><dt>#pgv_lang[my_indi]#</dt><dd>Lien vers votre page individuelle, où se trouvent les données de votre propre famille.</dd></dl>";
$pgv_lang["menu_charts_help"]           = "~#pgv_lang[menu]# «#pgv_lang[charts]#»~<br />Liste des diagrammes disponibles :<dl><dt><a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a></dt><dd>Affiche les parents de l'individu racine du fichier GEDCOM. Vous pouvez le modifier si vous êtes connecté.</dd><dt><a href=\"?help=help_descendancy.php\">#pgv_lang[descend_chart]#</a></dt><dd>Même principe. Affiche la liste des enfants.</dd><dt><a href=\"?help=help_timeline.php\">#pgv_lang[timeline_chart]#</a></dt><dd>Affiche les évènements d'une ou plusieurs personnes sur une même ligne de temps, permettant de les comparer.</dd><dt><a href=\"?help=help_relationship.php\">#pgv_lang[relationship_chart]#</a></dt><dd>Recherche du lien de parenté entre deux personnes</dd><dt><a href=\"?help=help_ancestry.php\">#pgv_lang[ancestry_chart]#</a></dt><dd>Présentation sous forme #pgv_lang[ancestry_list]# ou #pgv_lang[ancestry_booklet]#</dd><dt><a href=\"?help=help_fanchart.php\">#pgv_lang[fan_chart]#</a></dt><dd>Présentation en roue ou en éventail.</dd></dl>";
$pgv_lang["menu_lists_help"]            = "~#pgv_lang[menu]# «#pgv_lang[lists]#»~<br />Les choix suivants sont présentés dans ce menu:<dl><dt><a href=\"?help=help_indilist.php\">#pgv_lang[individual_list]#</a></dt><dd>Présentation alphabétique des individus du fichier GEDCOM.</dd><dt><a href=\"?help=help_famlist.php\">#pgv_lang[family_list]#</a></dt><dd>Présentation alphabétique des familles du fichier GEDCOM.</dd><dt><a href=\"?help=help_sourcelist.php\">#pgv_lang[source_list]#</a></dt><dd>Liste des sources d'informations citées dans ce fichier GEDCOM.</dd><dt><a href=\"?help=help_placelist.php\">#pgv_lang[place_list]#</a></dt><dd>Liste par lieux sur deux colonnes : à gauche les individus et à droite les familles.</dd><dt><a href=\"?help=help_medialist.php\">#pgv_lang[media_list]#</a></dt><dd>Cette option ne s'affiche que si l'administrateur l'a autorisé.<br />Liens vers tous les OBJEts MultiMedia de ce fichier GEDCOM.</dd></dl>";
$pgv_lang["menu_annical_help"]          = "~#pgv_lang[menu]# «#pgv_lang[anniversary_calendar]#»~<br />Affiche les évènements ayant eu lieu à une certaine date. Choix entre une présentation par jour (ex: <tt>5 Avril</tt>), par mois (ex: <tt>Avril</tt>>) ou par année (ex: <tt>1999</tt>>).<dl><dt>#pgv_lang[viewday]#</dt><dd>Affichage du calendrier #pgv_lang[on_this_day]#.</dd><dt>#pgv_lang[viewmonth]#</dt><dd>Affichage du calendrier #pgv_lang[in_this_month]#.</dd><dt>#pgv_lang[viewyear]#</dt><dd>Affichage du calendrier #pgv_lang[in_this_year]#.</dd></dl>";
$pgv_lang["menu_clip_help"]             = "~#pgv_lang[menu]# «#pgv_lang[clippings_cart]#»~<br />Si l'administrateur l'a autorisé, ce menu s'affiche sur le bandeau.<br />Un panier vous permet de collecter des informations.<br /><br />";
$pgv_lang["menu_search_help"]           = "~#pgv_lang[menu]# «#pgv_lang[search]#»~<br />Accès à une page de recherche très puissante.<br /><br />";
$pgv_lang["menu_help_help"]             = "~#pgv_lang[menu]# «#pgv_lang[page_help]#»~<br />#pgv_lang[help_help_items]#";

//-- Index-page Portal
$pgv_lang["index_portal_head_help"]     = "<div class=\"name_head\"><center><b>#pgv_lang[welcome_page]#</b></center></div><br />";
$pgv_lang["index_portal_help"]          = "La #pgv_lang[welcome_page]# présente plusieurs blocs séparés, et elle est personnalisable. Ainsi, chaque fichier GEDCOM de ce site peut avoir sa propre #pgv_lang[welcome_page]#.<br /><br />Voici la liste des blocs disponibles :<ul><li><a href=\"#index_welcome\">#pgv_lang[welcome_block]#</a><li><a href=\"#index_login\">#pgv_lang[login_block]#</a><li><a href=\"#index_events\">#pgv_lang[upcoming_events_block]#</a><li><a href=\"#index_onthisday\">#pgv_lang[todays_events_block]#</a><li><a href=\"#index_favorites\">#pgv_lang[gedcom_favorites_block]#</a><li><a href=\"#index_stats\">#pgv_lang[gedcom_stats_block]#</a><li><a href=\"#index_media\">#pgv_lang[random_media_block]#</a><li><a href=\"#index_loggedin\">#pgv_lang[logged_in_users_block]#</a><li><a href=\"#gedcom_news\">#pgv_lang[gedcom_news_block]#</a><li><a href=\"#recent_changes\">#pgv_lang[recent_changes_block]#</a></ul>";
$pgv_lang["index_welcome_help"]         = "~#pgv_lang[welcome_block]#~<br />Ce bloc affiche :<br />Le fichier GEDCOM actif, et suivant la configuration : la date, l'heure et le compteur de visites.<br />Le compteur ne fonctionne que sur les pages #pgv_lang[welcome_page]# et 'Individu'. Il enregistre le nombre d'accès (<i>hits</i>) à ces pages.<br />Le compteur ne vérifiée pas la provenance des visites, donc quand un même visiteur revisite une page aprèsThe counter does not check the URL of a visitor, so when somebody revisits a page after some time, it will be counted as another Hit.<br />";
$pgv_lang["index_login_help"]           = "~#pgv_lang[login_block]#~<br />Vous n'aurez accès aux informations protégées qu'une fois connecté.<br />Pour cela, entrez votre <b>nom d'utilisateur</b> et votre <b>mot de passe</b>.<br /><br />#pgv_lang[new_password_help]#<br /><br />";
$pgv_lang["index_events_help"]          = "~#pgv_lang[upcoming_events_block]#~<br />This block show you anniversaries of events from the GEDCOM that are coming up in the next month.<br />";
#pgv_lang["days_to_show_help"]          = "~#pgv_lang[days_to_show]#~<br /><br />Enter the number of days to show.  This number cannot be greater than <b>#DAYS_TO_SHOW_LIMIT#</b>.  If you enter a larger value, that limit will be used.<br /><br />The limit shown is set by the administrator in the GEDCOM configuration, Display and Layout section, Hide &amp; Show sub-section.";
#pgv_lang["random_media_persons_or_all_help"]= "~#pgv_lang[random_media_persons_or_all]#~<br /><br />This option lets you determine the type of media to show.<br /><br />When you select <b>#pgv_lang[random_media_persons]#</b>, only media associated with persons will be shown.  Usually, this would be a person's photograph.  When you select <b>#pgv_lang[random_media_events]#</b>, only media associated with facts or events will be shown.  This might be an image of a certificate.  When you select <b>#pgv_lang[all]#</b>, this block will show all types of media.";
#pgv_lang["basic_or_all_help"]          = "~#pgv_lang[basic_or_all]#~<br /><br />This option lets you eliminate some dated events.  For example, #factarray[DIV]#, #factarray[CREM]#, #factarray[GRAD]#, #factarray[BARM]#, #factarray[FCOM]#, etc. should all be dated.<br /><br />When you select <b>Yes</b>, only Births, Deaths, and Marriages will be shown. When you select <b>No</b>, all dated events will be shown.";
$pgv_lang["index_onthisday_help"]       = "~#pgv_lang[todays_events_block]#~<br />This block works like the \"Upcoming Events\" block, only it displays today's events from your GEDCOM<br />";
$pgv_lang["index_favorites_help"]       = "~#pgv_lang[gedcom_favorites_block]#~<br />Fonctionnement identique au bloc \"My Favorites\", mais il n'est modifiable que par l'administrateur.<br />Son but est d'attirer l'attention des visiteurs sur une personne qui présente un intérêt particulier.<br />La liste déroulante des favoris est disponible à tout moment sur chaque page.<br />Le lien vous conduira vers la page détaillée de l'individu choisi.<br /><br />To save space, the boxes are displayed with limited information. At the right side of the name box you see the magnifying glass to reveal some more information.<br />Clicking the name will forward you to the individual page of the person.<br />Also at the right side you will find a menu, that can take to pages with more information or charts.<br />";
#pgv_lang["index_add_favorites_help"]   = "~ADD A FAVORITE~<br />This form allows you to add a new favorite item to your list of favorites.  You must enter either an ID for the person, family, or source you want to store as a favorite, or you must enter a URL and a title.  The Note field is optional can be used to describe the favorite.  Anything entered in the Note field will be displayed in the Favorites block after the item.<br /><br />";
$pgv_lang["index_stats_help"]           = "~#pgv_lang[gedcom_stats_block]#~<br />Ce bloc présente quelques chiffres concernant ce fichier GEDCOM.<br />Si vous souhaitez d'autres informations, utilisez le lien <B>Contact</B> en bas de page.<br /><br />#pgv_lang[index_common_names_help]#";
$pgv_lang["index_common_names_help"]    = "~#pgv_lang[common_surnames]#~<br />Ce bloc affiche la liste des noms de familles les plus fréquents. Leur nombre est déterminé par l'administrateur.<br /><br />En cliquant sur un nom de la liste, vous afficherez la page <b>#pgv_lang[individual_list]#</b>, qui vous donnera davantage de détails.<br />";
$pgv_lang["index_media_help"]           = "~#pgv_lang[random_media_block]#~<br />Ce bloc affiche de façon aléatoire un OBJEt MultiMedia de la base GEDCOM.<br />En cliquant sur l'objet, il s'affichera en taille réelle.<br /><br />Au-dessous de l'objet, vous trouverez un lien vers la fiche de la personne associée à cet objet.<br />";
$pgv_lang["index_loggedin_help"]        = "~#pgv_lang[logged_in_users_block]#~<br />Ce bloc affiche le nombre d'utilisateurs actuellement connectés.";
$pgv_lang["index_gedcom_news_help"]     = "~#pgv_lang[gedcom_news_block]#~<br />The news block is like a bulletin board for this GEDCOM.<br />The site administrator can place important announcements or interesting news messages here.<br /><br />If you have something interesting to display, please contact the site administrator and he can put your message on the bulletin board.";
$pgv_lang["index_gedcom_news_adm_help"] = "#pgv_lang[gedcom_news_block]# accepte les marqueurs <b>HTML</b>.<br />Assurez-vous de bien refermer chaque balise.<br />Une bonne connaissance du langage HTML est recommandée.<br /><br />Ce programme utilise également les <b>feuilles de style (CSS)</b>. Il en existe une pour chaque thème, vous pouvez les utiliser.<br /><br />Le site PhpGedView comporte des exemples sur ce sujet, étudiez-les.<br />";
$pgv_lang["recent_changes_help"]        = "~#pgv_lang[recent_changes_block]#~<br />Ce bloc affiche les modifications les plus récentes suivant les marqueurs CHAN du fichier GEDCOM.";
#pgv_lang["gedcom_news_limit_help"]     = "You can limit the number of News articles displayed, thereby reducing the height of the GEDCOM News block.<br /><br />This option determines whether any limits should be applied or whether the limit should be according to the age of the article or according to the number of articles.<br /><br />";
#pgv_lang["gedcom_news_flag_help"]      = "Enter the limiting value here.<br /><br />If you have opted to limit the News article display according to age, any article older than the number of days entered here will be hidden from view.  If you have opted to limit the News article display by number, only the specified number of recent articles, ordered by age, will be shown.  The remaining articles will be hidden from view.<br /><br />Zeros entered here will disable the limit, causing all News articles to be shown.<br /><br />";
$pgv_lang["gedcom_news_archive_help"]   = "Afin de réduire la hauteur du bloc \"Nouvelles\", l'administrateur a caché certains articles. Vous pouvez les visualiser en cliquant sur <b>#pgv_lang[gedcom_news_archive]#</b> link.<br /><br />";
#pgv_lang["index_htmlplus_help"]        = "~ADVANCED HTML BLOCK~<br />This block lets the administrator add information to the Index or Portal page.  Its purpose is similar to the HTML, News, and GEDCOM Statistics blocks, but the administrator has more control over its appearance.<br /><br />";
#pgv_lang["index_htmlplus_title_help"]  = "This text should be blank or very brief.  When blank, the Advanced HTML block will show on the Index or Portal page as a plain block, just like the HTML block does.  When there is text, the Advanced HTML block will show like all the other blocks, complete with a block title bar containing the text you enter here.";
#pgv_lang["index_htmlplus_template_help"]= "To assist you in getting started with this block, we have created several standard templates.  When you select one of these templates, the text area will contain a copy that you can then alter to suit your site's requirements.";
#pgv_lang["index_htmlplus_content_help"]= "Unlike the HTML, News, and GEDCOM Statistics blocks, you have full control over the appearance of your block.  You can use HTML tags, and the block uses the CSS style sheets from the currently active theme.  References to information from the currently active genealogical database can be included in the text.<br /><br />Database references are signalled in the text by enclosing keywords within paired <b>&#35;</b> symbols.  For example, <b>&#35;TOTAL_FAM&#35;</b> represents the number of families in the database.  On occasion, you may wish to use a database reference as text instead of its true meaning.  To do so, you need to replace the <b>&#35;</b> symbols enclosing the keyword by their symbolic equivalent.  For example, if your text contains <b>&amp;&#35;35;TOTAL_FAM&amp;&#35;35;</b> it will print as <b>&#35;TOTAL_FAM&#35;</b> instead of becoming a database reference.<br /><br />The list of keywords follows:<br /><table><tr valign=\"top\"><td><ul><li>COMMON_SURNAMES </li><li>TOTAL_INDI </li><li>TOTAL_FAM </li><li>TOTAL_SOUR </li><li>TOTAL_OTHER </li><li>TOTAL_SURNAMES </li><li>TOTAL_MALES </li><li>TOTAL_FEMALES </li><li>TOTAL_UNKNOWN_SEX </li><li>TOTAL_EVENTS </li><li>TOTAL_EVENTS_BIRTH </li><li>TOTAL_EVENTS_DEATH </li><li>TOTAL_EVENTS_MARRIAGE </li><li>TOTAL_EVENTS_OTHER </li><li>TOTAL_USERS </li><li>FIRST_EVENT </li><li>FIRST_EVENT_TYPE </li><li>FIRST_EVENT_NAME </li><li>FIRST_EVENT_YEAR </li><li>LAST_EVENT </li><li>LAST_EVENT_TYPE </li><li>LAST_EVENT_NAME </li><li>LAST_EVENT_YEAR </li><li>FIRST_BIRTH </li><li>FIRST_BIRTH_NAME </li><li>FIRST_BIRTH_YEAR </li></ul></td><td><ul><li>LAST_BIRTH </li><li>LAST_BIRTH_NAME </li><li>LAST_BIRTH_YEAR </li><li>LONG_LIFE </li><li>LONG_LIFE_NAME </li><li>LONG_LIFE_AGE </li><li>TOP10_OLDEST </li><li>AVG_LIFE </li><li>MOST_CHILD </li><li>MOST_CHILD_NAME </li><li>MOST_CHILD_TOTAL </li><li>TOP10_BIGFAM </li><li>AVG_CHILD </li><li>HIGHLIGHT </li><li>GEDCOM </li><li>GEDCOM_ID </li><li>GEDCOM_TITLE </li><li>CREATED_SOFTWARE </li><li>CREATED_VERSION </li><li>CREATED_DATE </li><li>GEDCOM_UPDATED </li><li>GEDCOM_CONTACT </li><li>WEBMASTER_CONTACT </li></ul></td></tr></table><br />";

//-- Index-Page Help
$pgv_lang["help_help"]                  = "La plupart des fonctions peuvent s'utiliser sans explication.<br />Cependant, certains de nos visiteurs ne sont pas très familiers avec l'ordinateur et Internet. Nous leur offrons de l'aide à plusieurs endroits.<br />Dans le menu Aide, vous trouverez les chapitres suivants :<br />";
$pgv_lang["help_page_help"]             = "<dl><dt><b>#pgv_lang[help_for_this_page]#</b></dt><dd>Il existe un texte d'aide pour chaque page. En cliquant sur <b>#pgv_lang[page_help]#</b>, vous aurez une aide générale sur la page active.<br />Pour une aide plus détaillée, ou de l'aide  sur un champ, cliquer sur <B>#pgv_lang[qm]#</B> qui affichera l'aide contextuelle.</dd></dl>";
$pgv_lang["help_content_help"]          = "<dl><dt><b>Sommaire de l'aide</b></dt><dd>Ce menu affiche la liste de tous les textes d'aide disponibles.</dd></dl>";
#pgv_lang["help_faq_help"]              = "<dl><dt><b>FAQ List</b></dt><dd>#pgv_lang[text_faq_help]#</dd></dl>";
#pgv_lang["help_HS_help"]               = "<dl><dt><b>#pgv_lang[hs_title]#</b></dt><dd>#pgv_lang[hs_intro]#</dd></dl>";
$pgv_lang["help_qm_help"]               = "<dl><dt><b>#pgv_lang[show_context_help]#</b></dt><dd>L'aide contextuelle est la façon la plus confortable d'obtenir de l'aide.<br />Il suffit de cliquer sur le lien <B>#pgv_lang[qm]#</B> présent en de nombreux endroits.<br />Cette option est débrayable en choisissant <B>#pgv_lang[hide_context_help]#</B>.</dd></dl>";

//-- Index-page Definitions
$pgv_lang["def_help"]                   = "<div class=\"name_head\"><center><b>Définitions</b></center></div><br />Some definitions of words, used in this help text:<br />";
$pgv_lang["def_portal_help"]            = "~Portail~<br />Also on this web site a Portal is like a lobby of a restaurant. It is the place where you enter, but you can also find important information like explanations, menus etc..<br />";
$pgv_lang["def_gedcom_help"]            = "~Fichier GEDCOM~<br />The GEDCOM file is the file that contains all the information about the family.<br />All facts, dates, events, etc. are stored in the GEDCOM file.<br />A GEDCOM file has to follow strict rules, because it is exchangeable between many programs, independent of platforms and/or systems.<br />";
$pgv_lang["def_gedcom_date_help"]       = "~Dates GEDCOM~<br />Le format des enregistrements d'un fichier GEDCOM doit suivre les règles de cette norme, et il y a bien sùr une convention concernant les dates.<br><br> Le champ date est un champ libre (ce qui signifie que vous pourriez taper du texte libre), mais les conventions de saisie sont les suivantes:<br />La date entière est entrée dans le format JJ MM AAAA, comme ceci: <br /><b>01 Mar 1801</b> ou <b>14 Dec 1950</b><br />Si vous ne connaissez pas une partie de la date, vous pouvez l'omettre, ce qui donne:<br /><b>Mar 1801 </b> ou  <b>14 Dec</b><br />Si votre information est imprécise, vous pouvez indiquer :<br /><b>abt Mar 1801</b> (abt = about = environ)</b><br /><b>bef 20 Dec 1950</b> (bef = before = avant) ou <b>< 20 Dec 1950</b><br /><b>aft 1949</b> (aft = after = après) ou <b>>1949</b><br />Vous devez entrer ces informations en Anglais, car les fichiers GEDCOM sont échangeables et les programmes doivent traduire les dates dans les différentes langues.<br> Les programmes ont aussi à effectuer des calculs à partir de ces dates. Une date non conforme rendra son utilisation impossible ou donnera des résultats erronés.<br />Les abréviations sont les suivantes:<br />JAN janvier,<br />FEB fevrier,<br />MAR mars,<br />APR avril,<br />MAY mai,<br />JUN juin,<br />JUL juillet,<br />AUG aoùt,<br />SEP septembre,<br />OCT octobre,<br />NOV novembre,<br />DEC décembre.<br />bef ou < = avant,<br />abt = environ,<br />aft ou > = après.";
$pgv_lang["def_pgv_help"]               = "~PhpGedView~<br />PhpGedView (or PGV) is a program designed by <A HREF=\"https://sourceforge.net/users/yalnifj/\" TARGET=\"_blank\">John Finlay</A> to view GEDCOM files on line.<br />As you can see, PGV does not just put static pages on the web, but is dynamic and can be customized in many ways.<br />John started developing the program on his own, but an entire international team of developers and translators has since joined him and is working to improve the program.<br />Apart from just viewing GEDCOM files, PGV also allows adding and editing events on-line now.<br />";
$pgv_lang["def_theme_help"]             = "~#pgv_lang[heading_theme]#~<br />This site can have some different \"looks\", called Themes.<br />The site administrator chooses a Theme for startup.<br />Everybody who enters this site will see the same Look (Theme). When the site admin has set up the site in a way that logged in users can choose their own theme, they can find out for themselves what they like most.<br />If a user has chosen a different Theme, he/she will have that site layout, as soon as he/she is logged in.<br />";

//-- Index-page MyGEDCOM
$pgv_lang["mygedview_portal_help"]      = "~#pgv_lang[upper_mygedview]#~<br />This is your Personal #pgv_lang[mgv]# Page.<br />You may find here easy links to access your personal data, like <b>My Account, My Indi</b> (this is your Individual Page), <b>My Pedigree</b>.<br />Furthermore you can have a block with <b>Messages</b>, a <b>Journal</b> (like a Notepad) and many more.<br /><br />The layout of this page works the same as the Welcome Page.<br />But while the parts of the Welcome Page are selected by the site adminstrator, you select what parts to include on this page.<br /><br />In the Welcome Block on this page you will find the link to customize this page.<br />You can choose from the following blocks:<br /><br />";
$pgv_lang["mygedview_customize_help"]   = "~#pgv_lang[customize_page]#~<br />When you entered here for the first time, you already had some blocks on this page.<br />If you like, you can customize this Portal.<br />Clicking this link will bring you to a form in a pop up window, in which you can add, delete or move around blocks.<br />More explanation is available on that form.<br />";
$pgv_lang["mygedview_message_help"]     = "~#pgv_lang[user_messages_block]#~<br />In this block you will find the messages sent to you by other users or the admin.<br />Of course, you too can send messages to other users or admin.<br />The PhpGedView mail system is designed to help protect your privacy.  You don't have to leave your email address here and others will not be able to see your email address.<br />";
$pgv_lang["mygedview_favorites_help"]   = "~#pgv_lang[user_favorites_block]#~<br />My favorites works like bookmarks.<br />Suppose you have somebody in the family tree whose record you want to check regularly.<br />Just go to the person's individual page, and select the \"Add to My Favorites\" option from the favorites drop-down list. This person is now book marked and added to your list of Favorites.<br />Wherever you are on this site, you can click on a name in the \"My Favorites\" drop down list in the header.<br />This will forward you to the individual page of the person.<br /><br />To save space, the boxes are displayed with limited information. At the right side of the name box you see the magnifying glass to reveal some more information.<br />Clicking the name will forward you to the individual page of the person.<br />Also at the right side you will find a menu that can take you to pages with more information or charts.<br />";
$pgv_lang["mygedview_myjournal_help"]   = "~#pgv_lang[user_news_block]#~<br />You can use this journal to write notes (or reminders) for your own use.<br />Of course, when you make a note, it will still be there, the next time when you visit the site.<br /><br />These notes will not be visible for others.<br />";
$pgv_lang["mygedview_welcome_help"]     = "~#pgv_lang[welcome_block]#~<dt>This Welcome block shows you:</dt><dd>- The current GEDCOM file</dd><dd>- The date and time</dd><dd>- Links to:</dd><dd> - - #pgv_lang[myuserdata]#</dd><dd>- - #pgv_lang[my_pedigree]# (see remark)</dd><dd>- - #pgv_lang[my_indi]# (see remark)</dd><dd>- - #pgv_lang[customize_page]#</dd></dl><b>Remark</b><br />You will see the links to \"My Indi\" and \"My Pedigree\" only if you have a record in the current GEDCOM file.<br />So, it may be that in one GEDCOM file you have a record, and see the links \"My Indi\" and \"My Pedigree\", while in another GEDCOM file you do not have a record and \"My Indi\" and \"My Pedigree\" are not displayed.<br />";

//-- Pedigree-page
$pgv_lang["help_pedigree.php"]          = "~#pgv_lang[index_header]#.~<br /><br />L'arbre d'ascendance d'une personne est la liste de ses ancêtres : son père, sa mère, leurs parents, etc...<br />Les informations concernant chaque personne s'affichent dans des boîtes, et offrent des liens vers d'autres pages.<dl><dt>Boîtes</dt><dd>Avec l'option <a href=\"?help=show_full_help\">#pgv_lang[show_details]#</a>, les informations principales (naissance, mariage, décès) sont affichées.<br />Dans le cas contraire, seul le nom est indiqué.<br />En cliquant sur le nom, vous êtes redirigé vers la page <a href=\"?help=help_individual.php\">#pgv_lang[personal_facts]#</a> de l'individu.<br /></dd><dt>Sous-menu</dt><dd>Avec l'option <a href=\"?help=show_full_help\">#pgv_lang[show_details]#</a>, une première image dans la boîte affiche un sous-menu.<br />Ce sous-menu est similaire au <a href=\"?help=menu_charts_help\">#pgv_lang[menu]# «#pgv_lang[charts]#»</a>, sauf que l'#pgv_lang[root_person]# est remplacé par la personne indiquée dans la boîte.<br />D'autres liens permettent de naviguer vers conjoints et enfants.</dd><dt>Zoom</dt><dd>Une deuxième image offre un zoom donnant davantage de détails sur l'individu choisi.</dd><dt>Flèches</dt><dd>Aux extrêmes gauche et droite du graphique, des flèches facilitent la navigation par génération.</dd></dl>";
$pgv_lang["show_full_help"]             = "~#pgv_lang[show_details]#~<br /><br />Option pour afficher les détails de chaque individu sur le diagramme.<br /><br />Détails masqués, vous pouvez afficher davantage de personnes sur une page.<br />Pour voir les détails, il suffit alors soit de cliquer, soit de passer la souris sur la case. Cela dépend de la configuration choisie par l'administrateur.";
$pgv_lang["talloffset_help"]            = "~#pgv_lang[portrait]# / #pgv_lang[landscape]#~<br /><br />#pgv_lang[PEDIGREE_LAYOUT_help]#<br />Utile avec un écran pivotable, ou pour faire une impression d'écran (print-screen).";
$pgv_lang["rootid_help"]                = "~#pgv_lang[rootid]#~<br /><br />Pour démarrer d'une autre personne, entrez son code, appelé identifiant GEDCOM, ou plus simplement <b>ID</b>.<br />Par exemple <tt>I65</tt>.<br />Si vous ne le connaissez pas, utilisez le lien «#pgv_lang[find_id]#».";
$pgv_lang["PEDIGREE_GENERATIONS_help"]  = "~#pgv_lang[generations]#~<br /><br />#pgv_lang[generations]# à afficher sur cette page.<br />A règler en fonction de la taille de votre écran, et suivant que vous affichez les détails ou non.";

//-- LOGIN-page
$pgv_lang["login_page_help"]            = "~#pgv_lang[login]#~<br /><br />Sur cette page vous pouvez : vous connecter, #pgv_lang[requestaccount]# ou #pgv_lang[requestpassword]#.<br />";
$pgv_lang["username_help"]              = "~#pgv_lang[username]#~<br /><br />Entrer ici votre nom d'utilisateur.<br />Respecter majuscules/minuscules.";
$pgv_lang["password_help"]              = "~#pgv_lang[password]#~<br /><br />Entrer ici votre mot de passe.<br />Respecter majuscules/minuscules.";
$pgv_lang["login_buttons_help"]         = "~#pgv_lang[login]# / #pgv_lang[admin]#~<br /><br />Sur cette page, deux boutons vous sont proposés :<dl><dt>#pgv_lang[login]#</dt><dd>Ce bouton vous ramènera vers la page par laquelle vous êtes venu.</dd><dt>#pgv_lang[admin]#</dt><dd>Si vous avez les droits administrateur, vous pouvez utiliser ce bouton pour accéder directement à la page Administration.</dd></dl>";
$pgv_lang["login_buttons_aut_help"]     = "~AUTHENTICATION MODE LOGIN BUTTONS~<br /><br />Vous avez deux boutons pour vous connecter au système.<br /><br />La page vers laquelle vous serez dirigé après votre authentification dépend du bouton sur lequel vous cliquez.<br /><ul><li>Le bouton <b>#pgv_lang[login]#</b> <br /> En cliquant sur ce bouton, vous êtres dirigé vers votre page #pgv_lang[mygedview]#, où vous pourrez mettre à jour vos paramêtres personnels, vos favoris, envoyer et lire vos messages, etc.</li><br><li>Le bouton <b>#pgv_lang[admin]#</b> <br />Si vous cliquez sur ce bouton, et que vous avez les droits d'Administrateur, vous serez dirigé vers la page Administration.</li></ul><br />";
$pgv_lang["new_password_help"]          = "~#pgv_lang[requestpassword]#~<br />Si vous avez perdu votre mot de passe, cliquez sur ce lien.<br />Vous serez redirigé vers le formulaire de \"#pgv_lang[lost_pw_reset]#\".";
$pgv_lang["new_user_help"]              = "~#pgv_lang[requestaccount]#~<br /><br />Si vous souhaitez demander un compte d'accès personnel, cliquez sur ce lien.<br />Vous serez redirigé vers le formulaire de demande de compte.";
$pgv_lang["mygedview_login_help"]       = "Pour accéder au portail «Mon GedView», vous devez vous identifier.<br /><br />Avec le portail «Mon GedView» vous pourrez mémoriser vos préférences, conserver un journal, gérer vos messages, voir les autres utilisateurs connectés...<br /><br />Connectez-vous :";
$pgv_lang["new_user_firstname_help"]    = "~#pgv_lang[firstname]#~<br /><br />Entrez ici votre prénom.";
$pgv_lang["new_user_lastname_help"]     = "~#pgv_lang[lastname]#~<br /><br />Entrez ici votre nom de famille.<br /><br />C'est ce nom qui s'affichera aux autres utilisateurs connectés.<br /><br />Ce nom est nécessaire pour vérifier votre parenté et vous donner les droits appropriés.";
$pgv_lang["register_info_01"]           = "Respect de la vie privée : certaines informations sont en accès restreint.<br /><br />Pour obtenir l'accès, vous devez créer un compte . Enregistrez-vous en remplissant le formulaire. L'administrateur examinera votre demande.<br /><br />Une fois connecté, vous pourrez consulter les informations privées de tous les individus, ou uniquement de vos proches, selon le choix de l'administrateur. Il peut aussi vous accorder le droit d'ajouter ou modifier certaines informations.<br /><br />Note: vous devez justifier d'un lien de parenté pour obtenir un compte sur cette base.<br /><br />Dans le cas contraire, l'accès vous sera refusé.<br />Pour toute question, contacter l'administrateur (lien en bas de cette page).<br /><br />";
$pgv_lang["register_info_02"]           = "";
#pgv_lang["register_info_03"]           = "~REQUEST NEW USER ACCOUNT~<br /><br />The amount of data that can be publicly viewed on this website may be limited due to applicable law concerning privacy protection. Many people do not want their personal data publicly available on the Internet. Personal data could be misused for spam or identity theft.<br /><br />Access to this site is permitted to <u>family members only</u>. After the administrator has verified and approved your account application, you will be able to login and view the private data.<br /><br />If Relationship Privacy has been activated you will only be able to access your own close relatives' private information after logging in. The administrator can also allow database editing for certain users, so that they can change or add information.<br /><br />If you need any further support, please use the link below to contact the administrator.<br /><br />";


//-- Descendancy-page
$pgv_lang["help_descendancy.php"]       = "~#pgv_lang[descend_chart]#~<br /><br />L'arbre de descendance d'une personne est la liste de ses enfants, petits-enfants, etc... avec leurs conjoints.<br /><br />Fonctionnement des boutons, sous-menus et liens similaire à l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>.<br />Pour davantage de lisibilité, chaque branche peut s'ouvrir <img src=\"images/plus.gif\" /> ou se fermer <img src=\"images/minus.gif\" /> d'un simple clic.<br />La <a href=\"?help=box_width_help\">#pgv_lang[box_width]#</a> est également modifiable.<br /><br />En marge est indiqué le numéro de descendant selon le système d'Aboville.<br />Ainsi le 1.2.5 est le cinquième enfant du deuxième enfant de l'individu racine.";
$pgv_lang["desc_rootid_help"]           = "#pgv_lang[rootid_help]#";
$pgv_lang["desc_generations_help"]      = "#pgv_lang[PEDIGREE_GENERATIONS_help]#";

//-- Time line-page
$pgv_lang["help_timeline.php"]          = "~#pgv_lang[timeline_chart]#~<br /><br />Affiche les évènements d'une ou plusieurs personnes sur une même ligne de temps, permettant de les comparer.";
$pgv_lang["add_person_help"]            = "~#pgv_lang[add_another]#~<br /><br />Pour ajouter une personne, entrez son identifiant GEDCOM (exemple: <tt>I65</tt>).<br />Si vous ne le connaissez pas, utilisez le lien «#pgv_lang[find_id]#».";
$pgv_lang["remove_person_help"]         = "~#pgv_lang[remove_person]#~<br /><br />Pour retirer une personne du diagramme.<br />La fiche de cette personne n'est ni modifiée, ni supprimée.";
$pgv_lang["show_age_marker_help"]       = "~#pgv_lang[show_age]#~<br /><br />Option pour activer le marqueur d'âge, affichant l'âge de la personne à une année donnée.<br />Le marqueur se déplace sur la ligne de temps avec la souris.<br />Il existe un marqueur pour chacune des personnes sur le diagramme.";

//-- Relationship-page
$pgv_lang["help_relationship.php"]      = "~#pgv_lang[relationship_chart]#~<br /><br />Recherche du lien de parenté entre deux personnes.<br />Il peut s'agir d'un lien direct (de sang) ou d'un lien indirect (par mariage).";
$pgv_lang["relationship_id_help"]       = "~#pgv_lang[id]# #pgv_lang[person1]# #pgv_lang[person2]#~</b><br /><br />Si, sur la page précédente, vous avez cliqué «#pgv_lang[relationship_to_me]#», les deux champs sont déjà renseignés.<br />Sinon, sélectionnez deux individus en entrant leur ID, ou en cliquant sur «#pgv_lang[find_id]#»";
$pgv_lang["next_path_help"]             = "~#pgv_lang[next_path]#~<br /><br />Bouton pour afficher le prochain lien de parenté, s'il existe.<br />Pour réafficher un lien de parenté précédent, cliquer sur son numéro dans la liste.";
$pgv_lang["follow_spouse_help"]         = "~#pgv_lang[follow_spouse]#~<br /><br />Option pour élargir la recherche aux liens par mariage.<br />Sinon, seuls les liens de sang sont pris en compte.";
$pgv_lang["line_up_generations_help"]   = "~#pgv_lang[line_up_generations]#~<br /><br />Option pour afficher les personnes de même génération sur une ligne horizontale.<br/>Sinon, les individus sont affichés à la suite sur la page, sans tenir compte des générations.";
$pgv_lang["oldest_top_help"]            = "~#pgv_lang[oldest_top]#~<br /><br />Option pour afficher les résultats dans le sens parents-enfants du haut vers le bas.<br/>Par défaut, c'est l'inverse : les individus les plus jeunes sont affichés en premier.<br /><br />Ne fonctionne que si l'option <a href=\"?help=line_up_generations_help\">#pgv_lang[line_up_generations]#</a> est activée.";

//-- Ancestry-page
$pgv_lang["help_ancestry.php"]          = "~#pgv_lang[ancestry_chart]#~<br /><br />Cette page affiche les ancêtres d'une personne, comme l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mais d'une façon plus détaillée, et avec plusieurs choix de <a href=\"?help=chart_style_help\">#pgv_lang[chart_style]#</a>.<br /><br />A chaque ancêtre est attribué un numéro unique, selon le système <i>Sosa-Stradonitz</i>, le plus répandu dans le monde :<br /> - pair pour les hommes (double de celui de son enfant)<br /> - impair pour les femmes (numéro de son mari +1) avec une exception pour le <big>1</big><br /><br />Ainsi le <big>7</big> est la femme du <big>6</big>, la mère du <big>3</big>, et la fille des <big>14</big> et <big>15</big>.";
$pgv_lang["box_width_help"]             = "~#pgv_lang[box_width]#~</b><br /><br />Vous pouvez faire varier la largeur des boîtes entre 50% et 300%.<br />La valeur initiale est 100% : chaque boîte fait environ 270 pixels de large.";
$pgv_lang["chart_style_help"]           = "~#pgv_lang[chart_style]#~<br /><br />Choix entre :<dl><dt>#pgv_lang[ancestry_list]#</dt><dd>L'arbre, présenté verticalement, comporte autant de niveaux que de générations, avec à chaque fois deux branches : celle du père (numéro pair) et celle de la mère (numéro impair).</dd><dt>#pgv_lang[ancestry_booklet]#</dt><dd>Présentation d'une famille par page avec les parents, les grand-parents et la liste de tous les enfants connus. Ce format est idéal pour imprimer le récapitulatif d'une famille et l'offrir à vos proches</dd></dl>";

//-- Fan chart-page
$pgv_lang["help_fanchart.php"]          = "~#pgv_lang[fan_chart]#~<br /><br />Cette page affiche les ancêtres d'une personne, comme l'<a href=\"?help=help_pedigree.php\">#pgv_lang[index_header]#</a>, mais d'une façon plus visuelle : sous la forme d'une roue ou d'un éventail.<br />L'individu racine est au centre, ses parents sur la première couronne, les grand-parents sur la seconde ...<br /><br />Pour chaque personne, figurent son nom et ses dates de naissance et décès.";
$pgv_lang["fan_width_help"]             = "~#pgv_lang[fan_width]#~</b><br /><br />Vous pouvez faire varier la taille de la roue entre 50% et 300%.<br />La valeur initiale est 100% : l'image de la roue fait environ 640 pixels de large.";
$pgv_lang["fan_style_help"]             = "~#pgv_lang[chart_style]#~<br /><br /><dl><dt>1/2</dt><dd>Demi-roue (180°)</dd><dt>3/4</dt><dd>Trois-quarts de roue (270°) ou 'Roue du paon'</dd><dt>4/4</dt><dd>Roue entière (360°)</dd></dl>";

//-- Hourglass chart-page
$pgv_lang["help_hourglass.php"]         = "~#pgv_lang[hourglass_chart]#~<br /><br />Le \"sablier\" présente les ascendants et les descendants de la personne séléctionnée au sein d'un même diagramme. Ce graphe est une combinaison du diagramme 'ascendants' et du diagramme 'descendants'.<br /><br />La personne sélectionnée est au centre de la page, les descendants listés à gauche, les ascendants listés à droite, chaque génération alignée en colonne, partant de la plus récente pour finir à la plus ancienne.<br /><br />";

//-- Family Book chart-page
#pgv_lang["help_familybook.php"]        = "~#pgv_lang[familybook_chart]#~<br /><br />This chart is very similar to the Hourglass chart.  It will show the ancestors and descendants of the selected root person on the same chart.  It will also show the descendants of the root person in the same Hourglass format.<br /><br />The root person is centered in the middle of the page with his descendants listed to the left and his ancestors listed to the right.  In this view, each generation is lined up across the page starting with the earliest generation and ending with the latest.<br /><br />Each descendant of the root person will become the root person of an additional hourglass chart, printed on the same page.  This process repeats until the specified number of descendant generations have been printed.";
#pgv_lang["fambook_descent_help"]       = "~#pgv_lang[descent_steps]#~<br /><br />This value determines the number of descendant generations of the root person that will be printed in Hourglass format.<br /><br />";

//-- Indilist-page
$pgv_lang["help_indilist.php"]          = "~LISTE DES INDIVIDUS~<br /><br />Cette page permet de lister les individus. Les listes sont présentées par nom de famille et par ordre alphabétique.<br /><br />La liste de noms affichée dépend de:<ol><li>La lettre sur laquelle vous avez cliqué dans l'index alphabétique, ou si vous avez cliqué sur le bouton <b>Tous</b>. </li><li>Si vous avez choisi l'option <b>Afficher tous les noms</b> ou <b>Afficher la liste des noms</b> en bas de page.</li></ol>#pgv_lang[context_help]#<br /><br />";
$pgv_lang["alpha_help"]                 = "~INDEX ALPHABETIQUE~<br /><br />Cliquer sur une des lettres affichera la liste des noms (ou l'ensemble des personnes) dont le nom de famille commence par cette lettre.<br /><br />Si le choix <b>#pgv_lang[NN]#</b> apparait en avant dernière position de l'index, cela signifie qu'il y a dans la base au moins un individu dont le nom de famille n'est pas connu (c.a.d. vide). Les noms de familles inconnus sont souvent remplacés par un <b>?</b>, et ces noms seront reconnus comme inconnus (<b>#pgv_lang[NN]#</b>) par PhpGedView.<br /><br /><b>Note:</b><br />Les noms de famille enregistrés sous la forme, par exemple, <b>Nn</b>, <b>NN</b>, <b>Inconnu</b>, ou <b>N.N.</b> ne figureront <u>pas</u> dans la liste affichée en cliquant sur <b>#pgv_lang[NN]#</b>. Ils figureront dans les listes affichées en cliquant sur <b>N</b> ou <b>I</b> puisqu'il s'agit de leur 'initiale'. PhpGedView ne peut en effet pas prendre en compte toutes les possibilités d'enregistrer un nom inconnu. Il n'existe pas de convention pour cela.<br /><br />A la fin de l'index, vous avez le choix <b>Tous</b>. Lorsque vous cliquez sur cette case, vous affichez tous les noms de famille de la base.<br /><br /><b>Caractères manquants:</b><br />Si l'index alphabétique est incomplet, cela signifie qu'il n'y a pas dans la base de nom de famille commençant par les lettres manquantes.<br /><br />";
$pgv_lang["name_list_help"]             = "~NAME LIST~<br /><br />Cette boite affiche une liste des noms ou tous les noms (tous les individus) correspondants à l'initiale que vous avez cliquée dans l'index alphabétique, sauf si vous avez cliqué sur <b>Tous</b>.<br /><br /> L'affichage de la \"Liste des nom\" ou de \"Tous les noms\" dépend du statut <b>Afficher tous les noms / Afficher la liste des noms</b> du lien ci-dessous.<br /><br />";
$pgv_lang["skip_sublist_help"]          = "~SKIP SUBLIST~<br /><br />Par défaut, en cliquant sur un caractère alphabétique, vous faites apparaitre la liste des noms commençant par cette lettre, et pour chacun, le nombre d'individus ayant ce nom. Si vous cliquez sur ce lien, vous ferez apparaitre, de la même façon, tous les individus ayant un nom commençant par cette lettre.<br /><br />";

//-- Families-page
$pgv_lang["help_famlist.php"]           = "~LISTE DES FAMILLES~<br /><br />Cette page permet de lister les familles. Les listes sont présentées par nom de famille et par ordre alphabétique.<br /><br />La sélection dépend de:<ol><li>La lettre de l'index sur laquelle vous avez cliqué,</li><li>du choix entre <b>Afficher la liste des noms</b> ou <b>Afficher tous les noms</b> que vous aurez fait.</li></ol>Vous pouvez chercher sur le nom du mari ou de la femme, les deux sont inclus dans les listes.<br /><br /> #pgv_lang[context_help]#<br /><br />";
$pgv_lang["help_family.php"]            = "~DETAIL DE LA FAMILLE~<br /><br />Cette page vous présente une vue d'ensemble de la famille que vous avez sélectionnée sur une page précédente.<br /><br /> De haut en bas,  sont présentés le mari et ses parents, l'épouse et ses parents, les enfants. En bas à droite le bloc <b>Informations sur la famille</b> présente les évènements enregistrés sur cette famille, tels que mariage, contrats, leurs sources, ainsi que les notes, objets multimédias, etc...<br /><br />La présentation des membres de la famille est la même que les diagrammes d'ascendance ou de descendance, chaque individu étant présenté dans une 'boite', où figurent les détails le concernant.<br /><br /> A la droite des parents, une flèche apparaît si la génération supérieure existe dans la base. Quand vous cliquez sur cette flèche, vous faites apparaître une nouvelle famille dont l'époux et l'épouse sont les parents précédents.<br /><br /> Sur la droite des 'boites', vous avez une loupe qui vous permet de mieux voir le contenu de celle-ci. De même, un menu vous permet d'aller sur les pages de diagramme ou d'autre détails. Certains de ces menus disposent de sous-menus qui apparaissent lorsque votre pointeur passe sur les lignes du menu principal.  Dans les différentes 'boites', quand vous cliquez sur le nom d'une personne, vous êtes dirigés vers la page <b>#pgv_lang[indi_info]#</b> la concernant.<br /><br /> Dans le cadre <b>Informations sur la famille</b>, en cliquant<br> - sur un lieu, vous êtes dirigé vers la liste des lieux,  où tous les familles et individus reliés à ce lieu sont affichés. <br> - sur une date, vous êtes dirigés vers le calendrier, où tous les évènements arrivés ce jour ou ce mois sont affichés. <br> - sur un objet multimédia, vous ouvrez une fenêtre vous présentant celui-ci. <br> - sur une source, vous ouvrez la page source où celle-ci vous est présentée en détail.<br /><br /> Si vous en avez les autorisations, en bas de page, apparaît le lien <b>Ajouter un enfant à cette famille</b>. Apparaît aussi les liens d'édition de création et/ou modification dans les différentes parties du bloc <b>Information sur cette famille</b>. <br /><br />Comme sur la page <b>#pgv_lang[indi_info]#</b>, vous avez en haut à droite un menu, dont les entrées vous permettent différentes taches ou vous proposent d'autres informations concernant cette famille.<br>#pgv_lang[more_help]#";
$pgv_lang["add_child_help"]             = "~AJOUTER UN ENFANT A CETTE FAMILLE~<br /><br />Ce lien vous permet d'ajouter un enfant à cette famille.<br /><br />Ajouter un enfant est simple: cliquez sur le lien, remplissez les champs proposés par le formulaire, sauvegardez, c'est tout. Vos modifications seront définitives après validation par un administrateur de la base.<br /><br />";
$pgv_lang["show_fam_gedcom_help"]       = "~Voir les balises GEDCOM~<br /><br />Ce lien vous permet d'afficher l'information sur la famille, telle qu'elle est enregistrée dans le fichier GEDCOM.<br /><br />";
#pgv_lang["add_fam_clip_help"]          = "~ADD FAMILY TO CLIPPINGS CART~<br /><br />You can add all or some of this family's information to your #pgv_lang[clip_cart]#. On the next page you can choose precisely how much information you wish to add:<ol><li>#pgv_lang[just_family]#</li><li>#pgv_lang[parents_and_family]#</li><li>#pgv_lang[parents_and_child]#</li><li>#pgv_lang[parents_desc]#</li></ol><br />";
#pgv_lang["show_fam_timeline_help"]     = "~SHOW COUPLE ON TIMELINE CHART~<br /><br />When you click this link you will jump to the Timeline page, where all facts of the couple will be displayed on a timeline scale.<br /><br />";

//-- Source list-page
$pgv_lang["help_sourcelist.php"]        = "~LISTE DES SOURCES~<br /><br />Cette page affiche la liste des sources figurant dans la base.<br /><br />A la différence des pages \"Liste des individus\" et \"Liste des familles\", il n'y a pas d'index alphabétique.<br /><br />Une source peut être un archivage public, privé, une institution, une adresse Internet, etc... A cause de cette diversité, il n'est pas possible de décider d'un ordre de tri qui soit significatif pour l'ensemble des cas. Néanmoins, PhpGedView tri les sources sur le champ <u>\"Titre\"</u> de l'enregistrement \"Source\".<br /><br /><b>SOURCES</b><br />Une source peut être liée à plusieurs individus et/ou plusieurs évènements (par ex., un contrat de mariage, avec les mariés, les parents présents ou cités, les témoins, constitue une source possible pour l'ensemble de ces individus). <br />De même un individu peut être lié à plusieurs sources pour chaque évènement.<br /><br />";
#pgv_lang["sourcelist_listbox_help"]    = "~SOURCES LIST BOX~<br /><br />In this box you see the names of the sources as they are stored in the GEDCOM.<br /><br />The names are displayed in alphabetical order.  When you click on a name in the list, you will go to the Source page where a list is displayed.  This list shows you which individuals or families are linked to that source.<br /><br />";

//-- Sources-page
$pgv_lang["help_source.php"]            = "~DETAILS D'UNE SOURCE~<br /><br />Cette page présente le détail d'une source. Les sources sont principales en Généalogie, et permettent d'authentifier dans la mesure du possible  l'information qu'elles renseignent pour les autres généalogistes.<br /><br />Figurent les information \"Titre\", \"Abréviation\", \"Auteur\", \"Publication\", \"Dépositaire\" où la source est conservée. En fonction des différents types de source, les informations ne sont pas toujours les mêmes.<br /><br />Si un média, tel qu'une image, existe pour cette source, vous pouvez la voir en cliquant sur son nom ou sur la miniature.<br /><br />Au bas de la page figurent les individus et les familles reliées à cette sources. Cela vous permet d'identifier l'ensemble des informations obtenues ou validées à partir de cette source.<br /><br />Si l'administrateur l'a prévu, vous avez sur la page une ou deux icones supplémentaires: <ol><li><b>#pgv_lang[view_gedcom]#</b><br /> qui visualise l'enregistrement GEDCOM de cette source.</li><br /><li><b>#pgv_lang[add_to_cart]#</b><br /> qui vous permet de stocker cette information dans votre panier pour pouvoir la télécharger plus tard et l'importer dans votre logiciel de généalogie.</li></ol><br />#pgv_lang[context_help]#<br /><br />";
$pgv_lang["sources_listbox_help"]       = "~Autres enregistrements liés à cette source~<br /><br />Liste des individus et des familles qui sont liés à cette source.<br /><br />Les noms sont listés dans l'ordre alphabétique. En cliquant sur un nom, vous êtes dirigés sur la page de l'individu ou de la famille correspondant.<br /><br />";
$pgv_lang["show_source_gedcom_help"]    = "~VOIR L'ENREGISTREMENT GEDCOM~<br /><br />Ce lien vous permet de visualiser l'enregistrement du fichier GEDCOM correspondant à cette source.<br /><br />";
$pgv_lang["add_source_clip_help"]       = "~Ajouter au panier~<br /><br />En cliquant sur ce lien vous ajoutez l'enregistrement de cette source à votre panier,  pour pouvoir le télécharger et l'importer plus tard dans votre programme de généalogie.<br /><br />";
$pgv_lang["delete_source_help"]         = "~Supprimer cette source du fichier GEDCOM~<br /><br />Quand vous cliquez sur cette option, vous marquez cette source \"à supprimer\" de la base.<br /><br />Qu'est que cela signifie?<br />Supposons que vous ayez une bonne raison pour vouloir supprimer cette source. En cliquant sur le lien, vous aurez une demande de confirmation de votre suppresssion. En continuant, vous aurez confirmation (après quelques instants) de la suppression.<br /><br />En naviguant sur le site, vous pourrez voir que la suppression n'est pas effective et que la source est toujours utilisable.<br /><br /><b>Ce n'est <u>pas</u> une erreur.</b> Comme toute modification demandée dans la base, celle-ci doit être validée par un administrateur, qui peut accepter ou refuser la modification. <br />C'est seulement après cette validation que la modification sera définitive, irréversible et effective pour l'ensemble des utilisateurs. Si il y a un doute sur votre demande, un administrateur prendra contact avec vous.<br /><br />";

//-- Persons per Place-page
$pgv_lang["help_placelist.php"]         = "~HIERARCHIE DES LIEUX~<br /><br />Cette page vous liste les lieux connus dans la base, par niveau de lieux, et auquels les individus et les familles sont liés.<br /><br />La liste des individus et des familles liées à un lieu sont présentés en deux colonnes, les individus et les familles.<br /><br />#pgv_lang[more_help]#";
$pgv_lang["ppp_default_form_help"]      = "~ORDRE DES LIEUX~<br /><br /><b>ORDRE PAR DEFAUT</b><br />Ceci signifie qu'il n'y a pas de déclaration de hiérarchie des lieux dans le fichier GEDCOM de cette base. L'ordre employé est donc l'ordre par défaut. <br /><br />Si un format avait été déclaré dans le fichier GEDCOM, il aurait été présenté ici et utilisé.<br /><br />";
$pgv_lang["ppp_match_one_help"]         = "~ORDRE DES LIEUX~<br /><br />ORDRE DU GEDCOM<br />La hiérarchie des lieux est celle qui a été déclarée dans le fichier GEDCOM. Cette déclaration remplace l'ordre par défaut.<br /><br />";
#pgv_lang["ppp_numfound_help"]          = "~FOUND PLACE CONNECTIONS~<br /><br />The number of matches that are found is displayed here.  If you still see a list box with locations you have not yet reached the lowest level.<br /><br />You can choose to view all records connected to this place or you can refine your search by clicking another location.<br /><br />";
$pgv_lang["ppp_levels_help"]            = "~HIERARCHIE DES LIEUX~<br /><br />Dans un fichier GEDCOM, les lieux sont organisés de façon hiérarchique, du plus haut (en général le Pays) au plus bas (en général le lieux-dit, la rue...), chaque niveau étant composé des lieux du niveau inférieur. Vous voyez là le niveau dans les lieux auquel vous vous situez. La <b>Liste des lieux</b> ci-dessous correspond à tous les lieux contenus dans ce niveau  (le plus à gauche).<br /><br />EXEMPLE:<br />La hiérarchie par défaut (qui n'est peut être pas celle du fichier actuel) est #pgv_lang[default_form]#.<br />Si le niveau actuel est \"sommaire\", la liste présentera tous les Pays connus dans la base. <br />Si le niveau actuel est un département, la <b>Liste des lieux</b> présentera tous les lieux connus dans la base appartenant à ce département.<br />etc.<br /><br />En cliquant sur un lieu, vous afficherez tous les lieux en dépendant, descendant ainsi d'un niveau dans la hiérarchie des lieux.<br /><br />";
$pgv_lang["ppp_placelist_help"]         = "~LISTE DES LIEUX PAR NIVEAU~<br /><br />Cette liste vous présente tous les lieux contenus dans le niveau géographique que vous avez sélectionné et qui sont connus dans la base. Si vous n'avez pas sélectionné de niveau, c'est le niveau géographique le plus élevé qui est listé (c.a.d. les Pays).<br /><br />En cliquant sur un lieu, vous listerez tous les lieux connus y appartenant.<br /><br />";
#pgv_lang["ppp_placelist_help2"]        = "~PLACE LIST~<br /><br />In this list you can see the locations that have been found to this stage.<br /><br />The names of the locations in the list are clickable; clicking on a location works like a filter, you will be taken to the next level down.<br /><br />Only when you are in the top level will a name list not be displayed. At all subordinate levels you will get a list of families and individuals connected to that location.<br /><br />";
#pgv_lang["ppp_view_records_help"]      = "~VIEW ALL RECORDS~<br /><br />Clicking on this link will show you a list of all of the individuals and families that have events occurring in this place.  When you get to the end of a place hierarchy, which is normally a town or city, the name list will be shown automatically.<br /><br />";
#pgv_lang["ppp_name_list_help"]         = "~NAME LIST~<br /><br />This box will display a complete list of individuals and families that are connected to that location.<br /><br />The names in the list are clickable.  When you click a name, you will be taken to the relevant Detail page.  When you click on a location at the top of this list, you change your Location selection.<br /><br />";

//-- Multimedia-page
$pgv_lang["help_medialist.php"]         = "~LISTE DES OBJETS MULTIMEDIA~<br /><br />Cette page présente la liste des objets multimédia contenus dans cette base.<br /><br />Pour chacun, vous pouvez voir le titre ou le nom de fichier, les noms des individus et/ou des familles qui y sont raccordés,  ainsi que les notes le concernant.<br /><br />En cliquant sur le titre ou sur la miniature, vous ouvrez le média dans le visualisateur de PhpGedView ou dans celui spécifié dans votre configuration navigateur.<br /><br />Quand vous cliquez sur le lien individu ou famille, vous ouvrez la page correspondante.<br /><br />";

//-- Upload Media-page
$pgv_lang["help_uploadmedia.php"]       = "~CHARGEMENT DES FICHIERS MULTIMEDIA~<br /><br />Charger les fichiers média est simple. Voici ce qu'il faut savoir:<br /><br /><b>Miniatures</b><br />Les miniatures doivent avoir une largeur d'environ 100 px. La miniature <u>doit</u> avoir exactement le même nom (casse, c.a.d. minuscules/majuscules comprise) que le média principal. Si votre système peut générer les miniatures automatiquement, une information est affichée sur la page de chargement.<br /><br /><b>Chargement</b><br />Les fichiers sont chargés automatiquement dans le répertoire  ../media pour le média principal, et dans  ../media/thumbs/ pour les miniatures.<br /><br />#pgv_lang[readme_help]#";

//-- Anniversaries-page
#pgv_lang["help_calendar.php"]          = "~#pgv_lang[anniversary_calendar]#~<br /><br /><ul><li><a href=\"#calendar_general\"><b>General information</b></a></li><li><a href=\"#calendar_day\"><b>#pgv_lang[day]#</b></a></li><li><a href=\"#calendar_month\"><b>#pgv_lang[month]#</b></a></li><li><a href=\"#calendar_year\"><b>#pgv_lang[year]#</b></a></li><li><a href=\"#calendar_show\"><b>#pgv_lang[show]# / #pgv_lang[showcal]#</b></a></li><li><a href=\"#calendar_sex\"><b>#pgv_lang[sex]#</b></a></li><li><a href=\"#calendar_event\"><b>Event</b></a></li><li><a href=\"#calendar_button\"><b>View Day / View Month / View Year buttons</b></a></li><li><a href=\"#calendar_tip\"><b>Tip</b></a></li></ul><br /><a name=\"calendar_general\"></a>The #pgv_lang[anniversary_calendar]# shows the persons and families who are linked to an event at a certain day or month or during a certain period of time. It has an advanced filtering system to select the right date, period, and events for you.<dl><dt><b>View <a href=\"#calendar_day\">Day</a></b></dt><dd>This shows the events on a certain day, independent of the selected year. Output will be either a single list with the names of individuals or families, or a two-column list with individuals on one side and families on the other.</dd><dt><b>View <a href=\"#calendar_month\">Month</a></b></dt><dd>In this calendar the names of individuals and families are shown inside the Day boxes. The calendar is shown as it was in the year you entered into the Year box. All events that happened in the past up to that year are shown.<br /><br />In combination with the option <a href=\"#calendar_show\"><b>#pgv_lang[recent_events]#</b></a>, it will give a realistic view of what a calendar of your ancestors looked like.</dd><dt><b>View <a href=\"#calendar_year\">Year</a></b></dt><dd>This shows the events in a certain year or during a number of years. Output will be a list with the names of individuals or families, or a two-column list with individuals on one side and families on the other.</dd></dl>The currently shown day and month are highlighted in the calendar menu.<br /><br />All names and dates are clickable.  When you click on a name you will be taken to the relevant Details page. Clicking on a date will jump to \"Today\" or \"Year\" mode, which will display all events for the day and month in the clicked date.<br /><br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_day\"> </a>#pgv_lang[annivers_date_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_month\"> </a>#pgv_lang[annivers_month_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_year\"> </a>#pgv_lang[annivers_year_select_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_show\"> </a>#pgv_lang[annivers_show_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_sex\"> </a>#pgv_lang[annivers_sex_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_event\"> </a>#pgv_lang[annivers_event_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_button\"> </a>#pgv_lang[day_month_help]#<br /><a href=\"#top\">#pgv_lang[UpArrow]#</a><a name=\"calendar_tip\"> </a>#pgv_lang[annivers_tip_help]#";
$pgv_lang["annivers_date_select_help"]  = "~SELECTION DU JOUR~<br /><br />Le niveau le plus fin de la sélection de date est le <b>jour</b>. Sa fonction est évidente, vous sélectionnez un <b>jour</b> du mois. <br><br>En cliquant sur un jour, vous passez (ou vous restez) en mode jour,  et compte tenu du mois sélectionné, vous affichez tous les évènements qui figurent à ce jour et ce mois dans la base (par ex. tous les évènements qui se sont passés un 17 juin). En cliquant sur un mois différent, vous affichez tous les évènements du même jour mais de ce mois. <br /><br />A la droite de la liste des jours, vous pouvez voir un <b>lien</b> avec la date du jour. En cliquant sur ce <b>lien</b> vous affichez la liste de ce jour.";
$pgv_lang["annivers_month_select_help"] = "~SELECTION DU MOIS~<br /><br />EN cliquant sur un mois de la liste, le résultat dépend selon que vous êtes en mode <b>jour</b> ou en mode <b>mois</b>:<br /><dl><dt><b>Mode jour</b></dt><dd>Dans ce mode, les évènements qui se sont passés le jour et le mois sélectionné sont affichés (vous passez par exemple des évènements passés un 17 juin à ceux passés un 17 mars, en cliquant sur mars, si vous étiez en juin précedement);</dd><br /><dt><b>Mode mois</b></dt><dd>Le calendrier du mois figurant à l'écran est remplacé par celui du mois sélectionné.<br /><br />A la fin de la liste des mois, figure un <b>lien</b> avec le mois en-cours. En cliquant sur ce lien, vous affichez le calendrier du mois, (donc en mode mois) quel que soit le mode dans lequel vous êtes.</dd></dl>";
$pgv_lang["annivers_year_select_help"]  = "~SAISIE ANNEE~<br /><br />Cette case vous permet de changer l'année du calendrier.<br /><br /><b>Modes de saisie des années:</b> pour <b>#pgv_lang[viewyear]#<dl><dt>Série des années:</b></dt><dd>Vous pouvez chercher des dates sur une période recouvrant plusieurs années.<br /><br />Les dates sont inclusives, c'est à dire que la sélection part du 1er janvier de la première année jusqu'au 31 décembre de la dernière année. Par exemple:<br /><br /><b>1992-5</b> pour tous les évènements de1992 à 1995.<br /><b>1972-89</b>  tous les évènements de 1972 à 1989.<br /><b>1610-759</b> tous les évènements de 1610 à 1759.<br /><b>1880-1905</b> tous les évènements de 1880 à 1905.<br /><b>880-1105</b> tous les évènements de 880 à 1105.<br /><br />Vous pouvez omettre le dernier chiffre d'une année afin de sélectionner la décade concernée:<br /><br /><b>197</b> pour tous les évènements de 1970 à 1979.<br /><b>195-198</b> pour tous les évènements de 1950 à 1989.</dd><dt><br /><b>Dates approximatives:</b></dt><dd>Quelquefois, la date précise d'un événement n'est pas connue. Les termes « avant », « après », « environ » caractérisent ce type de date.<br /><br />De telles dates sont stockées dans la base avec les abréviations anglaises de ces termes. En mode <b>année</b>, vous pouvez utiliser ces termes. Voici quelques exemples::<br /><br /><b>abt</b> 1800 ( <b>abt</b>= about = environ )<br /><b>bet</b> 1950-1959 ( <b>bet</b> = between=entre ) entrez: bet 1950-59 ou juste: 1950-59<br /><b>bef</b> 1950 ( <b>bef</b> = before=avant )<br /><b>aft</b> 1900 ( <b>aft</b> = after=après )<br /><br /><b>Note:</b> PhpGedView cherchera exactement les termes de votre demande. Quand vous demandez <b>abt&nbsp;1850</b>, une date figurant dans la base comme <b>abt&nbsp;oct&nbsp;1850</b> ne sera  <u>pas</u> sélectionnée.<br /><br />Vous pouvez entrer seulement une abréviation, afin de chercher toutes les dates concernées. </dd></dl>L'écran n'est pas rafraîchi lors de la saisie d'une date, vous devez cliquer sur <b>#pgv_lang[viewmonth]#</b> ou <b>#pgv_lang[viewyear]#</b> afin d'afficher la nouvelle sélection.<br /><br />";
$pgv_lang["annivers_show_help"]         = "~MONTRER LES EVENEMENTS DE ...~<br />Les options suivantes sont disponibles:<br /><ol><li><b>Toutes les personnes</b><br />Avec cette option, tous les individus et toutes les familles figurant dans la base sont affichés.</li><br /><li><b>Evènements récents (-de 100 ans)</b><br />Les évènement vieux de plus de 100 ans ne seront pas affichés.</li><br /><li><b>Personnes vivantes seulement</b><br />Sauf si l'administrateur a autorisé à ce que les personnes vivantes soient visibles de tous, vous ne pouvez sélectionner cette option sans être connecté.<br /><br />Avec cette option, seules les personnes vivantes seront sélectionnées.</li></ol>Quand vous cliquez, les évènements correspondants à votre sélection sont affichés.<br /><br />Les sélections du jour, du mois et de l'année restent inchangés.<br /><br />";
#pgv_lang["annivers_sex_help"]          = "~SEX SELECTOR~<br />When you are logged in or when the admin has not enabled the Privacy option, you can select one of these options:<ol><li><b>All</b> icon<br />This is the default option. The events of all individuals and families are displayed.</li><li><b>Male</b> icon<br />Only events of male individuals are displayed. Only male members of families will be displayed with Family events.</li><li><b>Female</b> icon<br />Only events of female individuals are displayed. Only female members of families will be displayed with Family events.</li></ol>When you click on an option, the events of your choice will be displayed.<br /><br />The settings of day, month, and year, as well as <b>Day</b> or <b>Month</b> mode, remain as they were.<br /><br />";
#pgv_lang["annivers_event_help"]        = "~EVENT SELECTOR~<br />Here you choose whether you want all events for individuals and families displayed or just a selected event.  You cannot select more than one event category.<br /><br />When you click on an option, the events of your choice will be displayed.<br /><br />The settings of day, month, and year, as well as <b>Day</b> or <b>Month</b> mode, remain as they were.<br /><br />";
#pgv_lang["annivers_tip_help"]          = "~TIP~<br />Adjust the Date selector to any date in the past.<br /><br />When you click on one of the View buttons you will see a list or calendar for that date.  All the ages, anniversaries, etc. have been recalculated and now count from the date you set in the Date selector.  You are now seeing the calendar or list that your ancestor would have seen on that date, years ago.<br /><br />";
#pgv_lang["day_month_help"]             = "~VIEW DAY / VIEW MONTH / VIEW YEAR BUTTONS~<br /><ul><li>The <b>View Day</b> button will display the events of the chosen date in a list. All years are scanned, so only the day and month can be set here. Changing the year will have no effect.  You can reduce the list by choosing the option <b>Recent years</b> or <b>Living people</b>.<br /><br />Ages in the list will be calculated from the current year.</li><li>The <b>View Month</b> button will display a calendar diagram of the chosen month and year. Here too you can reduce the lists by choosing the option <b>Recent years</b> or <b>Living people</b>.<br /><br />You will get a realistic impression of what a calendar on the wall of your ancestors looked like by choosing a year in the past in combination with <b>Recent years</b>. All ages on the calendar are shown relative to the year in the Year box.</li><li>The <b>View Year</b> button will show you a list of events of the chosen year.  Here too you can reduce the list by choosing the option <b>Recent years</b> or <b>Living people</b>.<br /><br />You can show events for a range of years.  Just type the beginning and ending years of the range, with a dash <b>-</b> between them.  Examples:<br /><b>1992-4</b> for all events from 1992 to 1994<br /><b>1976-1984</b> for all events from 1976 to 1984<br /><br />You can also just enter the first numbers of the year to select all events that occurred in years starting with these numbers. For example, <b>197</b> for all events from 1970 to 1979.</li></ul>When you want to <b>change the year</b> you <b>have</b> to press one of these three buttons.  All other settings remain as they were.<br /><br />";

//-- Clippings Cart-page
$pgv_lang["help_clippings.php"]         = "~#pgv_lang[clippings_cart]#~<br />Cette fonction vous permet d'extraire certaines parties de l'arbre sous la forme d'un fichier au format GEDCOM, compatible avec d'autres logiciels de généalogie.<dl><dt>Comment choisir les parties à extraire ?</dt><dd>C'est très simple : sur la page détaillée d'un INDIvidu, d'une FAMille ou d'une SOURce, cliquer sur le bouton <b>#pgv_lang[add_to_cart]#</b></dd><dt>Comment enregistrer le panier ?</dt><dd>Pour récupérer le contenu de votre panier, ouvrir le menu <b>#pgv_lang[clippings_cart]#</b>, puis cliquer sur <b>#pgv_lang[download_now]#</b>.</dd></dl>";
$pgv_lang["clip_download_help"]         = "~#pgv_lang[download_now]#~<br /><br />By clicking this link, you will be forwarded to the next page.<br />If there are more option what to download, they will be displayed on that page.<br />Simply follow the instructions.";
$pgv_lang["empty_cart_help"]            = "~#pgv_lang[empty_cart]#~<br /><br />By clicking this link, your Clipping Cart will be totally emptied.<br /><br />If you don't want to remove all persons, families, etc. from the Clipping Cart, you can remove item by item by clicking the \"Remove\" link in the name boxes. ";

//-- GEDCOM Edit Utility
#pgv_lang["show_changes_help"]          = "~SHOW CHANGES TO THE GEDCOM~<br /><br />When you see this message, it means two things:<ol><li>Somebody has made changes to the GEDCOM<br />Records may have been added, deleted, or changed.</li><li>The changes have not yet been accepted by the administrator.<br />Once the changes have been accepted or rejected, you will no longer see this message.</li></ol>You can see what changes have been made when you click the link.  If you notice that a change is not correct, please notify the admin.<br /><br />";

//-- Search-page
#pgv_lang["help_search.php"]            = "~THE SEARCH PAGE~<br /><br />Although this page looks very simple, there is a very powerful and complicated search engine behind the two forms.  Most genealogy web sites just let you search for a name.  PhpGedView lets you search for almost anything.<br /><br />The Search box on the left of the screen is the same as the Search box in each page header.<br /><br />If you are looking for people in connection to a certain year, just type the year. The program will find all connections for you.<br /><br />Looking for a name, or place?  Just type in the name or place, completely or just a part of it, and PhpGedView does the rest.<br /><br /><b>Soundex search method</b><br />With the search boxes on the right, you can search for names of persons and places, even if you don't know precisely how to write the name.<br /><br />When there are several genealogical databases on one site and the administrator has enabled switching between them, your search will return the results for all of them.<br /><br />You will find more help about these two boxes by clicking the <b>?</b> above the boxes.<br /><br />";
$pgv_lang["search_enter_terms_help"]    = "~#pgv_lang[enter_terms]#~<br /><br />Vous pouvez faire une recherche par date, nom, prénom, lieu, etc.<dl><dt>Jokers</dt><dd>Les jokers (comme * ou ?), ne sont pas autorisés, mais le programme en tient compte.<br />Comment ?<br />Supposons que vous avez saisi : \"<b>Mar</b>\"<br />Le résultat donnera :<br />Jean-<b>Mar</b>c Durand<br /><b>Mar</b>cel Lebrin<br />Paul <b>Mar</b>tin<br />une personne née à <b>Mar</b>seille<br />etc..</dd><dt>Dates</dt><dd>En entrant une date, vous obtiendrez la liste de toutes les personnes liées à cette date.<br /><B>1950</B>, par exemple, vous donnera la liste des personnes, nées en 1950, ou mariées, ou décédées, ou....tout autre évènement de 1950.<br /><br />Avec <b>4 Dec</b>, toutes les personnes en rapport avec le 4 décembre de n'importe quelle année.<br />Mais aussi les évènements du 14 et du 24 décembre.<br />Encore une fois, les jokers ne sont pas nécessaires.</dd><dt>Dates exactes</dt><dd>Attention, le programme cherche les dates au format interne GEDCOM.<br />Ainsi, pour faire une recherche concernant le 14 décembre, il faut taper :<b>14 dec</b>.<br />Saisir <b>dec 14</b>, vous afficherait les évènements du 6 <b>dec</b>embre 19<b>14</b></dd></dl>.";
#pgv_lang["soundex_search_help"]        = "~#pgv_lang[soundex_search]#~<br /><br />Soundex is a method of coding words according to their pronunciation.  This allows you to search the database for names and places when you don't know precisely how they are written.  PhpGedView supports two different Soundex algorithms that produce vastly different results.<ul><li><b>Basic</b><br />This method, patented in 1918 by Russell, is very simple and can be done by hand.<br /><br />Because the Basic method retains the first letter of the name as part of the resultant code, it is not very helpful when you are unsure of that first letter.  The Basic algorithm is not well suited to names that were originally in languages other than English, and even with English names the results are very surprising.  For example, a Basic Soundex search for <b>Smith</b> will return not only <b>Smith, Smid, Smit, Schmidt, Smyth, Smithe, Smithee, Schmitt</b>, all of which are clearly variations of <b>Smith</b>, but also <b>Smead, Sneed, Smoote, Sammett, Shand,</b> and <b>Snoddy</b>.  <br /><br /></li><li><b>Daitch-Mokotoff</b><br />This method, developed in 1985, is much more complex than the Basic method and is not easily done by hand.<br /><br />A Soundex search using this method produces much more accurate results.</li></ul>For details on both Soundex algorithms, visit this <a href=\"http://www.jewishgen.org/infofiles/soundex.html\" target=_blank><b>Jewish Genealogical Society</b></a> web page.<br /><br />";

//-- Individual Information-page
#pgv_lang["help_individual.php"]        = "~#pgv_lang[indi_info]# PAGE~<br /><br />All details of a person are displayed on this page.<br /><br />If there is a picture available, you will see it at the top left side.  You will see the names of the person next to the picture.<br /><br />Names can have notes and sources attached to them. If any of the names have notes or sources, you will see them listed under the names they relate to.<br /><br />A person might have an AKA (maybe he's known under another name). If that is the case, it will be displayed.<br /><br />If you have Edit rights to this person, you will also see <b>Edit</b> and <b>Delete</b> links next to the items that you can edit.<br /><br />On this page you see tab sheets for <b>#pgv_lang[personal_facts]#</b>, <b>#pgv_lang[notes]#</b>, <b>#pgv_lang[ssourcess]#</b>, <b>#pgv_lang[media]#</b>, and <b>#pgv_lang[relatives]#</b>.  These tab sheets show you all the information about this individual that is stored in the database.<br /><ul><li>The <b>#pgv_lang[personal_facts]#</b> tab will show you the facts and details about this person and any fact from their marriages. Clicking on any date on this tab will take you to the #pgv_lang[anniversary_calendar]# for that date, so that you can see other events that happened on the same day. Clicking on a place will take you to the Place Hierarchy where you can view other people who had events in the same place. For marriage and other family related facts, the name of the person's spouse is available so that you can view the spouse and a link to the family record is also provided.</li><li>The <b>#pgv_lang[notes]#</b> tab will show you any general notes relating to this person.</li><li>The <b>#pgv_lang[ssourcess]#</b> tab will show you all of the <u>general</u> sources for this person. These sources are <u>not</u> linked to individual facts, not even the person's name; they are associated with the individual himself.  Clicking on the title of a source will take you to a more detailed Source Information page that will display other people who are also linked to the same source.</li><li>The <b>#pgv_lang[media]#</b> tab will list all of the pictures and other media items that are attached to this individual. Clicking on a thumbnail of the picture will open up a larger view of the image. Clicking on the picture caption will show you the picture on the #pgv_lang[media_list]# page.</li><li>The <b>#pgv_lang[relatives]#</b> tab lists this person's parents and siblings as well as all of the spouses and children that this person has had. These persons will be listed in boxes similar to the charts that you may have already seen.</li></ul>On the right of the screen you will find a box with links.  Many of the links in the box are the same as the links in the menus. For example, clicking on the <b>#pgv_lang[pedigree_chart]#</b> link on the side links will take you to the Pedigree chart for this person. This is different from the menu links, because clicking on the <b>#pgv_lang[pedigree_chart]#</b> link in the menu will take you back to the default Pedigree chart for this database.<br /><br />One of the links that might appear in this list if it has been enabled by the admin, is the <b>#pgv_lang[view_gedcom]#</b> link. This link will show you the raw GEDCOM record of this individual.<br /><br />If the #pgv_lang[clip_cart]# has been enabled by the site admin, you will also have a link that will allow you to add this person to your #pgv_lang[clip_cart]#.<br /><br />The <b>#pgv_lang[relationship_to_me]#</b> link will only appear if you are logged in and have been assigned an ID in the GEDCOM. This link will take you to the Pedigree chart and show you how you are related to this person.<br /><br />#pgv_lang[context_help]#<br /><br />";
#pgv_lang["delete_person_help"]         = "~DELETE PERSON FROM GEDCOM~<br /><br />When you click this option, you will mark this individual to be deleted from the database.<br /><br />What does that mean?<br />Let's suppose you have a good reason to remove this person from the database. You click the link.  You will be asked to confirm your deletion request.  If you decide to continue, it can take a little time before you see a message that the individual is deleted.<br /><br />When you continue with your visit, you will notice that the person is still visible and can be used as if the deletion had not occurred.<br /><br /><b>This is <u>not</u> an error.</b>  The site admin will get a message that a change has been made to the database, and that you removed the individual.<br />The administrator can accept or reject your change. Only after the administrator has accepted your change will the deletion actually occur <u>irreversibly</u>.  If there is any doubt about your change, the administrator will contact you.<br /><br />";
#pgv_lang["delete_name_help"]           = "~EDIT or DELETE NAME FROM GEDCOM~<br /><br /><b>EDIT NAME</b><br />When you click this link, another window will open.  There you can edit the name of the person.  Just type the changes into the boxes and click the button, close the window, and that's it.<br /><br /><b>DELETE NAME</b><br />By clicking this option you will mark this Name to be deleted from the database.  Note that deleting the name is completely different from deleting the individual.  Deleting the name just removes the name from the person. The person will <u>not</u> be deleted.  If it is an AKA that you want to delete, the person still has his other names.  If it is the <u>only</u> name that you want to remove, the person will still not be deleted, but will now be recorded as <b>#pgv_lang[NN]#</b>.  The person will also not be disconnected from any other to relatives, sources, notes, etc.<br /><br />How does it work?<br />You will be asked to confirm your deletion request.  If you decide to continue, it can take a little time before you see a message that the name is deleted.<br /><br />When you continue with your visit, you will notice that the name is still visible and can be used as if the deletion had not occurred.<br /><br /><b>This is <u>not</u> an error.</b>  The site admin will get a message that a change has been made to the database, and that you removed the name.<br />The administrator can accept or reject your change. Only after the administrator has accepted your change will the deletion actually occur <u>irreversibly</u>.  If there is any doubt about your change, the administrator will contact you.<br /><br />";
#pgv_lang["add_name_help"]              = "~ADD NEW NAME~<br /><br />This link will allow you to add another name to this individual.  Sometimes people are known by other names or aliases.  This link allows you to add new names to a person without changing the old name.<br /><br />";
#pgv_lang["add_sibling_help"]           = "~#pgv_lang[add_sibling]#~<br /><br />You can add a child to this family when you click this link.  \"This Family\", in this case, is the father and mother of the principal person of this screen.<br /><br />Keep in mind that you are going to add a sibling of that person.  Adding a brother or sister is simple: Just click the link, fill out the boxes in the pop up screen and that's all.<br /><br />If you have to add a son or daughter of the principal person, scroll down a little and click the link in \"#pgv_lang[as_spouse]#\".<br /><br />";
#pgv_lang["add_son_daughter_help"]      = "~#pgv_lang[add_son_daughter]#~<br /><br />You can add a child to this family when you click this link.  \"This Family\", in this case, is the principal person of this screen and his or her spouse.<br /><br />Keep in mind that you are going to add a son or daughter of that person.  Adding a son or daughter is simple: Just click the link, fill out the boxes in the popup screen and that's all.<br /><br />If you have to add a brother or sister of the principal person, scroll up a little and click the link in \"#pgv_lang[as_child]#\".<br /><br />";
#pgv_lang["link_child_help"]            = "~#pgv_lang[link_as_child]#~<br /><br />You can link this person as a child to an existing family when you click this link.<br /><br />Suppose that at one time the parents of the person were unknown, and you discovered later that the parents have a record in this database.<br /><br />Just click the link, enter the ID of the family, and you have competed the task.  If you don't know the family's ID, you can search for it.<br /><br />";
#pgv_lang["link_husband_help"]          = "~#pgv_lang[link_as_husband]#~<br /><br />This item will allow you to link the current individual as a husband to a family that is already in the database. By clicking this link you can add this person to an existing family, of which the husband was unknown until now. This person will take the place of the previously unknown husband. All events, marriage information, and children will keep their existing links to the family.<br /><br />Just click the link, enter the ID of the family, and you have competed the task. This is an advanced editing option that should only be used if the family you want to link to already exists.  If you want to add a <u>new</u> family to this individual, use the <b>#pgv_lang[add_new_wife]#</b> link.<br /><br />";
#pgv_lang["add_husband_help"]           = "~#pgv_lang[add_new_husb]#~<br /><br />By clicking this link, you can add a <u>new</u> male person and link this person to the principal individual as a new husband.<br /><br />Just click the link, and you will get a pop up window to add the new person.  Fill out as many boxes as you can and click the <b>Save</b> button.<br /><br />That's all.<br /><br />";
#pgv_lang["link_new_husb_help"]         = "~#pgv_lang[link_new_husb]#~<br />This will allow you to link another individual, who already exists, as a new husband to this person.  This will create a new family with the husband you select.  You will also have the option of specifying a marriage for this new family.<br /><br />";
#pgv_lang["link_wife_help"]             = "~#pgv_lang[link_as_wife]#~<br /><br />This item will allow you to link the current individual as a wife to a family that is already in the database.<br /><br />This is an advanced editing option that should only be used if the family you want to link to already exists.  If you want to add a <u>new</u> family to this individual, use the <b>#pgv_lang[add_new_husb]#</b> link.<br /><br />";
#pgv_lang["add_wife_help"]              = "~#pgv_lang[add_new_wife]#~<br /><br />By clicking this link, you can add a <u>new</u> female person and link this person to the principal individual as a new wife.<br /><br />Just click the link, and you will get a pop up window to add the new person.  Fill out as many boxes as you can and click the <b>Save</b> button.<br /><br />That's all.<br /><br />";
#pgv_lang["link_new_wife_help"]         = "~#pgv_lang[link_new_wife]#~<br />This will allow you to link another individual, who already exists, as a new wife to this person.  This will create a new family with the wife you select.  You will also have the option of specifying a marriage for this new family.<br /><br />";
#pgv_lang["add_new_parent_help"]        = "#pgv_lang[multiple_help]#<br />~ADD NEW FATHER or MOTHER~<br /><br />There are certainly many individuals in the GEDCOM without a record of a father or mother.<br /><br />In that case, on the <b>#pgv_lang[indi_info]#</b> page, tab sheet <b>#pgv_lang[relatives]#</b>, table <b>#pgv_lang[as_child]#</b>, you will find links to add a <u>new</u> father or mother to the individual.<br /><br />Please keep in mind that these links are for adding a <u>new</u> father or mother.  If the father or mother already has a record in this database, you have to use the link <b>#pgv_lang[link_as_child]#</b>, which you will find on that <b>#pgv_lang[indi_info]#</b> page below the last table.<br /><br />";

//-- Add Facts
#pgv_lang["add_facts_help"]             = "~ADD NEW FACTS~<br /><br />Here you can add a fact to the record being edited.<br /><br />First choose a fact from the drop-down list, then click the <b>Add</b> button.  All possible facts that you can add to the database are in that drop-down list.<br /><br />";
#pgv_lang["add_custom_facts_help"]      = "~Add custom fact~<br />If you can't find the fact that you want to add in the list of GEDCOM facts, you can enter a <b>custom fact</b> as well.<br /><br />Entering a custom fact is just as simple as entering one of the pre-defined ones.  The only difference is that you have to name the fact instead of picking its name from a list. You have to do this in the top field: <b>#pgv_lang[type]#</b><br /><br />";
$pgv_lang["add_note_help"]              = "#pgv_lang[multiple_help]#<br />~ADD NEW NOTE~<br />Si vous voulez ajouter une note sur cette personne, cliquez sur ce lien, qui ouvrira une fenêtre dans laquelle vous pouvez saisir ce que vous désirez. Quand vous avez fini votre saisie, cliquez sur le bouton <b>Ajouter</b> pour terminer.<br /><br />#pgv_lang[add_facts_general_help]#";
#pgv_lang["add_source_help"]            = "#pgv_lang[multiple_help]#<br />~ADD NEW SOURCE CITATION~<br />Here you can add a source <b>Citation</b> to this record.<br /><br />Just click the link, a window will open, and you can choose the source from the list (Find ID) or create a new source and then add the Citation.<br /><br />Adding sources is an important part of genealogy because it allows other researchers to verify where you obtained your information.<br /><br />#pgv_lang[add_facts_general_help]#";
$pgv_lang["add_media_help"]             = "~#pgv_lang[add_media]#~<br /><br />L'ajout de'OBJEts MultiMedia (MM) à votre base GEDCOM la rend très agréable à consulter.<dl><dt>Ce qu'il faut savoir sur les OBJEts MultiMedia.</dt><dd>De nombreux formats existent. PhpGedView en reconnaît la grande majorité</dd><dt>Formats</dt><dd>Les images peuvent s'enregistrer sous plusieurs formats (.jpg .png .bmp .gif ...)<br />Pour un affichage presque identique, la taille du fichier peut varier énormément selon le format choisi</dd><dt>Résolution</dt><dd>La résolution d'une image se mesure en \"dpi\" (dots per inch = points par pouce). Equivalent en photographie au grain du film 25ASA - 200ASA - 800ASA.<br />La qualité augmente avec la résolution, mais la taille du fichier aussi.<br />Pour une image web, 75 dpi est largement suffisant</dd><dt>Nombre de couleurs</dt><dd>L'autre moyen de diminuer la taille d'un fichier, c'est de réduire le nombre de couleurs utilisées.<br />Entre 8 couleurs et 65M de couleurs, le choix est large. 256 est suffisant</dd><dt>Pourquoi est-il important d'avoir des petits fichiers ?</dt><dd>D'abord parce que la place est limitée sur un serveur web, et l'augmenter coûte cher.<br />Ensuite parce que les gros fichiers sont longs à charger, pour vous et pour vos visiteurs.<br />Tout le monde ne dispose pas d'une connexion haut-débit</dd><dt>Comment ajouter un fichier MM ?</dt><dd>Pour toutes les raisons évoquées, seul l'administrateur possède les droits. Contactez-le. Il chargera le fichier sur le serveur.<br />Vous pourrez ensuite rattacher ce fichier à une personne ou un évènement</dd></dl>";
$pgv_lang["add_facts_general_help"]     = "~General info about adding~<br />Quand vous ajoutez un évènement, une note, une source ou un fichier multimédia à un individu de la base, cet ajout doit être approuvé par un utilisateur en ayant l'autorisation. <br /><br />Tant que ces modifications n'ont pas été approuvées, elles sont identifiées comme \"en attente\" par une couleur particulière de la bordure. Tous les utilisateurs ayant les autorisations de modifications peuvent voir ces modifications et l'information originale. Les utilisateurs n'ayant pas les droits de modification voient uniquement l'information originale. Quand la modification a été acceptée, les bords de couleur disparaissent et seule l'information modifiée est affichée normalement, remplaçant l'ancienne. A partir de là, cette information est visible par tous les utilisateurs.<br /><br />";

//-- Edit user
#pgv_lang["edituser_my_account_help"]   = "Here you can change your settings and preferences.<br /><br />You can change your user name, full name, password, language, email address, theme of the site, and preferred contact method.<br /><br />You cannot change the GEDCOM INDI record ID; that has to be done by an administrator.";
#pgv_lang["edituser_username_help"]     = "~#pgv_lang[username]#~<br /><br />In this box you can change your user name.  If you no longer like your user name or if have other reasons to change it, you can do so using this form.<br /><br />The username is <u>case sensitive</u>. That means that <b>John</b> is not the same as <b>john</b> or <b>JOHN</b>.<br /><br />You should <u>only</u> use characters from the alphabets that PhpGedView supports.  You may use uppercase and lower case letters with or without diacritical marks, numbers, dash (-), and underscore (_). Do <u>not</u> use punctuation marks or spaces.<br /><br />";
#pgv_lang["edituser_firstname_help"]    = "~#pgv_lang[firstname]#~<br /><br />In this box you can change your first name.  This is the name that other users see when you are logged in.<br /><br />Although the choice of what to put into this field is yours, you should inform the administrator when you change it.  When others see an unknown person on-line, they might wonder and ask questions.  The admin can find out without having received your notice, but you should save him that unnecessary work.<br /><br />";
#pgv_lang["edituser_lastname_help"]     = "~#pgv_lang[lastname]#~<br /><br />In this box you can change your last name.  This is the name that other users see when you are logged in.<br /><br />Although the choice of what to put into this field is yours, you should inform the administrator when you change it.  When others see an unknown person on-line, they might wonder and ask questions.  The admin can find out without having received your notice, but you should save him that unnecessary work.<br /><br />";
#pgv_lang["edituser_gedcomid_help"]     = "~#pgv_lang[gedcomid]#~<br /><br />This is an identification number that links you to your own data in the database.<br /><br />You cannot change this ID; it's set by the administrator.  If you think that this ID is not correct, you should contact the administrator to have it changed.<br /><br />";
#pgv_lang["edituser_rootid_help"]       = "~#pgv_lang[rootid]#~<br /><br />This is the starting (Root) person of all your charts.<br /><br />If, for example, you were to click the link to the Pedigree, you would see this root person in the leftmost box.  This root person does not have to be you; you can start with any person (your grandfather or your mother's aunt, for instance), as long you have the rights to see that person.<br /><br />The changes the default Root person for most charts.  You can change the Root person on many charts, but that is just for that page at that particular invocation.<br /><br />";
#pgv_lang["edituser_password_help"]     = "~#pgv_lang[password]#~<br /><br />It is a good practice to change your password regularly.  You have to keep in mind that anyone who knows your user name and your password will have access to your data.<br /><br />Make the password at least 6 characters long, the longer the better. You may use uppercase and lower case letters with or without diacritical marks, numbers, dash (-), and underscore (_). Do <u>not</u> use punctuation marks or spaces.  Use a combination of upper and lower case, numbers, and other characters. For example: <b>5Z_q\$P4=r9</b>.<br /><br />Like the user name, the password is <u>case sensitive</u>.  That means that <b>Secret.Password!#13</b> is not the same as <b>secret.password!#13</b> or <b>SECRET.PASSWORD!#13</b>.<br /><br />";
#pgv_lang["edituser_conf_password_help"]= "~#pgv_lang[confirm]#~<br /><br />If you have changed your password, you need to confirm it as well.  This is just to make sure that you did not make a typing error in the password field.<br /><br />If the password and its confirmation are not identical, you will get a suitable error message.  You will have to re-type both the original password and its confirmation.<br /><br />";
#pgv_lang["edituser_change_lang_help"]  = "~#pgv_lang[change_lang]#~<br /><br />Here you can change the language in which PhpGedview will display all its pages and messages after you have logged in.<br /><br />When you first access the site, PhpGedView assumes that you want to see everything in the language configured as the Preferred Language in your browser.  If that assumption is incorrect, you would override it here.  For example, your browser might be set to English because that is the most prevalent language on the Internet.  However, for genealogical purposes, you would prefer to see everything in Finnish or Hebrew.  Here's where you do that.<br /><br />The administrator controls what language choices are available to you.  If your preference isn't listed, you need to contact the administrator.<br /><br />Please remember that PhpGedView is very much a project staffed by an international team of unpaid volunteers.  Experts come and go.  Consequently, support for languages other than English is sometimes not as good as it should be.<br /><br />If you see something that has not been translated, has been translated incorrectly, or could be phrased better, let your administrator know.  The administrator will know how to get in touch with the PhpGedView developer team to have your concerns addressed.  Better still, volunteer some of your time.  We can use the help.<br /><br />";
#pgv_lang["edituser_email_help"]        = "~#pgv_lang[emailadress]#~<br /><br />Your correct email address is, important to us to keep in touch with you.<br /><br />If you get a new email address, as usually happens when you change your Internet provider, please do not forget to change the address here as well.  You won't get a confirmation message from this site when you change this address, but any future messages directed to you will go this new address.<br /><br />";
#pgv_lang["edituser_user_theme_help"]   = "~#pgv_lang[user_theme]#~<br /><br />This site can have several different looks or appearances.  Other programs may call them \"skins\", but here they're \"themes\".<br /><br />Every theme will display the same data, but its presentation or even its location on the screen may vary.  This is like putting a picture into a different frame and hanging it in a different room as well. The picture does not change, but the way you look at it is completely different.<br /><br />Just give it a try. Set it to another theme. Look at it, try another. Change back to the one that suits you the best. Whenever you log in, you will see the theme you last used; you don't even have to get to this configuration page to change your preferred theme.<br /><br />";
#pgv_lang["edituser_contact_meth_help"] = "~#pgv_lang[user_contact_method]#~<br />PhpGedView has several different contact methods.  The administrator determines which method will be used to contact him.  You have control over the method to be used to contact <u>you</u>.  Depending on site configuration, some of the listed methods may not be available to you.<br />";
#pgv_lang["mail_option1_help"]          = "With this option, the PhpGedView internal messaging system will be used and no emails will be sent.<br /><br />You will receive only <u>internal</u> messages from the other users.  When another site user sends you a message, that message will appear in the Message block on your personal #pgv_lang[mygedview]# page.  If you have removed this block from your #pgv_lang[mygedview]# page, you will not see any messages.  They will, however, show up as soon as you configure the #pgv_lang[mygedview]# page to again have the Message block.<br /><br />";
#pgv_lang["mail_option2_help"]          = "This option is like #pgv_lang[messaging]#, with one addition.  As an extra, a copy of the message will also be sent to the email address you configured on your Account page.<br /><br />This is the default contact method.<br /><br />";
$pgv_lang["mail_option3_help"]          = "Avec cette option, vous recevrez uniquement les messages vers votre adresse courriel.<br />Vous ne serez pas joignable par la messagerie interne.<br />";
$pgv_lang["mail_option4_help"]          = "Avec cette option, vous ne recevrez aucun message.<br />";

//-- Admin
#pgv_lang["admin_help"]                 = "On this page you will find links to the configuration pages, administration pages, documentation, and log files.<br /><br /><b>#pgv_lang[system_time]#</b>, just below the page title, shows the time of the server on which your site is hosted. This means that if the server is located in New York while you're in France, the time shown will be six hours less than your local time, unless, of course, the server is running on Greenwich Mean Time (GMT).  The time shown is the server time when you opened or refreshed this page.<br /><br /><b>WARNING</b><br />When you see a red warning message under the system time, it means that your <i>config.php</i> is still writeable.  After configuring your site, you should, for <b>security</b>, set the permissions of this file back to read-only.  You have to do this <u>manually</u>, since PhpGedView cannot do this for you.<br /><br />";

//-- User Admin
#pgv_lang["useradmin_help"]             = "~#pgv_lang[user_admin]#~<br /><br />On this page you can administer the current users and add new users.<br /><br /><b>#pgv_lang[current_users]#</b><br />In this table the current users, their status, and their rights are displayed.  You can <b>delete</b> or <b>edit</b> users.<br /><br /><b>#pgv_lang[add_user]#</b><br />This form is almost the same as the one users see on the  <b>#pgv_lang[editowndata]#</b> page.<br /><br />For several subjects we did not make special Help text for the administrator. In those cases you will see the following message:";
#pgv_lang["useradmin_gedcomid_help"]    = "~#pgv_lang[gedcomid]#~<br /><br />The #pgv_lang[gedcomid]# identifies the user.  It has to be set by the administrator.<br /><br />This ID is used as the ID on several pages such as <b>#pgv_lang[my_indi]#</b> and <b>#pgv_lang[my_pedigree]#</b>.<br /><br />You can set the user's GEDCOM ID separately for each GEDCOM.  If a user does not have a record in a GEDCOM, you leave that box empty.<br /><br />";
#pgv_lang["useradmin_rootid_help"]      = "~#pgv_lang[rootid]#~<br /><br />For each genealogical database, you can designate a <b>Root Person</b> for the user.<br /><br />This Root Person does not need to be the user himself; it can be anybody.  The user will probably want to start the Pedigree chart with himself.  You control that, as well as the default Root person on other charts, here.<br /><br />If the user has Edit rights to his own account information, he can change this setting himself.<br /><br />";
#pgv_lang["useradmin_can_admin_help"]   = "~#pgv_lang[can_admin]# CHECK BOX~<br /><br />If this box is checked, the user will have the same rights that you have.<dl><dt>These rights include:</dt><dd>Add / Remove / Edit Users</dd><dd>Broadcast messages to all users</dd><dd>Edit Welcome messages</dd><dd>Edit and configure language files</dd><dt></dt><dd>Upgrade PhpGedView</dd><dd>Change program and GEDCOM configurations</dd><dd>Administer the GEDCOMs</dd><dd>Change Privacy settings</dd><dd>And anything else that is not mentioned here.</dd></dl><br />The user <u>cannot</u> change anything on your server outside PhpGedView.";
#pgv_lang["useradmin_sync_gedcom_help"] = "~#pgv_lang[sync_gedcom]# CHECK BOX~<br /><br />If this box is checked and the user has a GEDCOM record ID assigned to them, their user account settings will automatically be synchronized with their GEDCOM data.  This means that when the user's GEDCOM record is edited, some of the information such as email address and name will be copied to the user's account.  When the user's account is edited, corresponding information will be copied to the GEDCOM record.";
#pgv_lang["useradmin_can_edit_help"]    = "~#pgv_lang[can_edit]#~<br /><br />The user can have different access and editing privileges for each genealogical database in the system.<ul><li><b>#pgv_lang[none]#:</b> The user cannot access the private data in this GEDCOM.</li><li><b>#pgv_lang[access]#:</b> The user cannot edit or accept data into the database but can see the private data.</li><li><b>#pgv_lang[edit]#:</b> The user can edit values but another user with <b>#pgv_lang[accept]#</b> privileges must approve the changes before they are added to the database and made public.</li><li><b>#pgv_lang[accept]#:</b> The user can edit.  He can also edit and approve changes made by other users.</li><li><b>#pgv_lang[admin_gedcom]#:</b> The user can edit configuration and privacy settings for <u>this</u> GEDCOM.</li></ul>System administrators, identified through the <b>#pgv_lang[can_admin]#</b> check box, are automatically given <b>#pgv_lang[admin_gedcom]#</b> privileges.<br /><br />";
#pgv_lang["useradmin_verified_help"]    = "~#pgv_lang[verified]#~<br /><br /><b>Self Registration</b><br />A user can apply for a new account by means of the <b>self registration</b> module.<br /><br />When he does so, he will receive an email message with a link to verify his application.  After the applicant has acted on the instructions in that email, you will see this box checked, and you can proceed with the next step, <b>#pgv_lang[verified_by_admin]#</b>.  You should wait with your approval as long as this box is not checked.<br /><br /><b>Add user manually</b><br />If you use this form to add a user manually, you will find this box checked already.<br /><br />";
#pgv_lang["useradmin_verbyadmin_help"]  = "~#pgv_lang[verified_by_admin]#~<br /><br />If a user has used the Self Registration module and has verified himself, the last step, before his account will become active, is your approval.<br /><br />After you have approved the user's application for a new account, the user will receive an email message.  The message will tell the user that his account is now active.  He can login with the user name and password that he supplied when he applied for the account.<br /><br />";
#pgv_lang["useradmin_edit_user_help"]   = "~#pgv_lang[update_user]#~<br /><br />This form is used by the administrator to change a user's account<br /><br />The form is very similar to the <b>#pgv_lang[add_user]#</b> and <b>#pgv_lang[update_myaccount]#</b> forms.<br /><br />";
$pgv_lang["useradmin_visibleonline_help"]= "~#pgv_lang[visibleonline]#~<br /><br />Option pour afficher le statut de connexion (en ligne / hors ligne) aux autres utilisateurs. Si la case est cochée, l'utilisateur sera visible. Sinon il restera caché.";
$pgv_lang["useradmin_editaccount_help"] = "~#pgv_lang[editaccount]#~<br /><br />Option pour autoriser la modification de certains paramètres du compte par l'utilisateur.<br /><br />Si la case n'est <b>pas</b> cochée, les modifications seront interdites.<br /><br />Cette fonction permet de créer un compte générique, utilisable par plusieurs personnes, mais en interdisant à chacun de le modifier.";
#pgv_lang["useradmin_relation_priv_help"]= "~#pgv_lang[user_relationship_priv]#~<br /><br />If this box is checked, the user will only be allowed access to living people that they are related to.  They will be able to see anyone who is within the relationship path length set by their <i>#pgv_lang[user_path_length]#</i> setting.  You can require relationship privacy for all of your users by turning on the global option in the GEDCOM privacy settings.<br /><br />This setting requires that the user be associated with a GEDCOM ID before they will be able to see any living people.<br /><br />";
#pgv_lang["useradmin_path_length_help"] = "~#pgv_lang[user_path_length]#~<br /><br />If <i>#pgv_lang[user_relationship_priv]#</i> is enabled, this user will only be able to see or edit living individuals within this number of relationship steps.<br /><br />";
#pgv_lang["useradmin_auto_accept_help"] = "~#pgv_lang[user_auto_accept]#~<br /><br />By checking this box you are allowing the system to automatically accept any edit changes made by this user.  The user must also have accept privileges on the GEDCOM in order for this setting to take effect.<br /><br />";

//-- Manage Sites
#pgv_lang["help_managesites"]           = "~MANAGE SITES~<br /><br />On this page you can add remote sites and ban IP addresses.<br /><br />Remote sites can be added by providing the site title, URL, database id(optional), username, and password for the remote web service.<br /><br />IP address banning is accomplished by supplying any valid IP address range. For example, 212.10.*.*  Remote sites within the IP address ranges in the Banned list will not be able to access your web service.  You can ban specific IP addresses too.";
//-- Adding Remote Links
#pgv_lang["help_remotesites"]           = "~Adding Remote Sites~<br /><br />To add a remote site, provide the site title, URL of the remote web service, database id(optional), and username and password. Click the Add button to complete the process.  If the remote server allows anonymous authentication, you should leave the username and password blank.";
//-- IP Address Banning
#pgv_lang["help_banning"]               = "~IP Address Banning~<br /><br />To ban remote sites from accessing your web service, provide a specific IP address or a valid IP address range, for example, 212.10.*.* and click the Submit button.";
#pgv_lang["help_manual_search_engines"] = "~Manual Search Engine Spider Marking~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />If a search engine is not automatically recognized and you wish to provide it data to index, you can list it here.  If you do not want to provide it data, you list it below in the banned IP section.<br /><br />If you wish to see what data is provided to search engines to index, list your own IP address here.  <font color=\"red\">WARNING:</font> This will lock you out of the admin interface, and you must remove the IP by logging in from a different machine or manually editing the <i>/index/search_engines.php</i> file.<br /><br />To manually mark a remote site as a search engine spider, provide a specific IP address or a valid IP address range, for example, 212.10.*.* and click the Submit button.  Many popular search engines like Google and Yahoo will be detected automatically.";

//-- Search_engines.php
#pgv_lang["search_engine_landing_page"] = "~Search Engine Detected~<br /><br />PhpGedView automatically provides search engines with smaller data files with fewer links.  The data is limited to the individual and immediate family, without adding information about grand parents or grand children.  Many reports and server-intensive pages like the calendar are off limits to the spiders.<br /><br />Attempts by the spiders to go to those pages result in showing this page.  If you are seeing this text, the software believes you are a search engine spider.  Below is the list of pages that are allowed to be spidered and will provide the abbreviated data.<br /><br />Real users who follow search engine links into this site will see the full pages and data, and not this page.";

//-- G E D C O M
$pgv_lang["add_upload_gedcom_help"]     = "~#pgv_lang[add_gedcom]# / #pgv_lang[upload_gedcom]#~<dl><dt>#pgv_lang[upload_gedcom]#</dt><dd>Le chargement d'un fichier sur le serveur peut se faire directement ici, sans programme de type <tt>ftp</tt>.</dd><dt>#pgv_lang[add_gedcom]#</dt><dd>Quand un GEDCOM est déjà présent sur le serveur, il suffit de le reconfigurer.</dd></dl>Les deux procédures se déroulent très simplement en 4 étapes, seule la première diffère.";
#pgv_lang["gedcom_configfile_help"]     = "~GEDCOM CONFIGURATION FILE~<br /><br />This is the file where all the basic settings related to the genealogical database are stored.  There is a separate file for each such database.<br /><br />You will find the path and name of each configuration file in the <b>#pgv_lang[current_gedcoms]#</b> table on the <b>#pgv_lang[gedcom_adm_head]#</b> page.<br /><br />";
$pgv_lang["default_gedcom_help"]        = "~GEDCOM par défaut~<br /><br />Si vous avez plusieurs GEDCOM en ligne, vous pouvez en désigner un comme GEDCOM par défaut pour les visiteurs du site ou les utilisateurs non encore connectés.<br /><br />Les utilisateurs autorisés peuvent modifier cette valeur par défaut en changeant les paramètres de leur compte.";
#pgv_lang["delete_gedcom_help"]         = "~DELETE GEDCOM~<br /><br />PhpGedView creates its database from a GEDCOM file that was previously uploaded. When you select <b>Delete</b>, that section of the database will be erased.  You have to confirm your Delete request.<br /><br />Unless you have deliberately removed it outside PhpGedView, the original GEDCOM file will remain in the directory into which it was uploaded.  If you later want to work with that GEDCOM file again, you don't have to upload it again. You can choose the <b>#pgv_lang[add_gedcom]#</b> function.<br /><br />";
$pgv_lang["add_gedcom_help"]            = "~#pgv_lang[add_gedcom]#~<br /><br />Cela suppose que le fichier GEDCOM a déjà été chargé sur le serveur, via <tt>ftp</tt> par exemple.<br /><br />Vous serez guidé tout au long de la procédure.";
#pgv_lang["add_new_gedcom_help"]        = "~#pgv_lang[add_new_gedcom]#~<br /><br />You can start a new genealogical database from scratch.<br /><br />This procedure requires only a few simple steps. Step 1 is different from what you know already about uploading and adding. The other steps will be familiar.<ol><li><b>Naming the new GEDCOM</b><br />Type the name of the new GEDCOM <u>without</u> the extension <b>.ged</b>. The new file will be created in the directory named above the box where you enter the name.  Click <b>Add</b>.</li><li><b>Configuration page</b><br />You already know this page;  you configure the settings for your new GEDCOM file.</li><li><b>Validate</b><br />You already know this page;  the new GEDCOM is checked.  Since there is nothing in it, it will be ok.</li><li><b>Importing Records</b><br />Since there will be only one record to import, this will be finished very fast.</li></ol>That's it.  Now you can go to the Pedigree chart to see your first person in the new GEDCOM. Click the name of the person and start editing. After that, you can link new individuals to the first person.<br /><br />";
#pgv_lang["download_gedcom_help"]       = "~#pgv_lang[download_gedcom]#~<br /><br />From this page you can download your genealogical database in GEDCOM format.  You may want to import the data into another genealogical program, or you may want to share its information with others.<br /><br />#pgv_lang[utf8_ansi_help]#<br /><br />#pgv_lang[remove_tags_help]#<br /><br />#pgv_lang[download_zipped_help]#";
#pgv_lang["edit_gedcoms_help"]          = "~#pgv_lang[gedcom_adm_head]#~<br /><br />The #pgv_lang[gedcom_adm_head]# page is the control center for administering all of your genealogical databases.<br /><br /><b>#pgv_lang[current_gedcoms]#</b><br />At the head of the <b>#pgv_lang[current_gedcoms]#</b> table, you see an action bar with four links.<ul><li>#pgv_lang[add_gedcom]#</li><li>#pgv_lang[upload_gedcom]#</li><li>#pgv_lang[add_new_gedcom]#</li><li>#pgv_lang[lang_back_admin]#</li></ul>In the <b>#pgv_lang[current_gedcoms]#</b> table each genealogical database is listed separately, and you have the following options for each of them:<ul><li>Import</li><li>Delete</li><li>Download</li><li>Edit configuration</li><li>Edit privacy</li><li>SearchLog files</li></ul>Edit privacy appears here because every GEDCOM has its own privacy file.<br /><br />Each line in this table should be self-explanatory.  PhpGedView can be configured to log all database searches.  The SearchLog files can be inspected through links found on this page.<br />#pgv_lang[more_help]#<br />";
#pgv_lang["edit_config_gedcom_help"]    = "~CONFIGURE GEDCOM~<br /><br />Every genealogical database used with PhpGedView has its own <b>Configuration file</b>.<br /><br />On this form you configure many options such as database title, language, calendar format, email options, logging of database searches, HTML META headers, removal of surnames from the database's Frequent Surnames list, etc.<br /><br />";
#pgv_lang["import_gedcom_help"]         = "~IMPORT GEDCOM~<br /><br />In most cases importing of an externally created GEDCOM file is one step in procedures that result in bulk changes to the genealogical database.<br /><br />These steps are in a logical sequence and need to be completed in the prescribed order so that the genealogical database is usable.<br /><br />If, for some reason, you did not complete these steps in the correct order, you will see a <u>warning</u> message that the GEDCOM is not yet imported. To correct the problem, click the <b>Import GEDCOM</b> link to import the file.<br /><br />Existing GEDCOM configuration settings will not change when you re-import a GEDCOM.  Existing data will, however, be overwritten.<br /><br />";
$pgv_lang["upload_gedcom_help"]         = "~#pgv_lang[upload_gedcom]#~<br /><br />Le chargement d'un fichier sur le serveur peut se faire directement ici, sans programme de type <tt>ftp</tt>.<br /><br />Il suffit de sélectionner un fichier GEDCOM sur votre poste, soit en entrant le chemin complet comme par exemple <tt>C:\\Program Files\\PAF\\famille.ged</tt>, soit en utilisant le sélecteur de fichier sur la page.<br /><br />D'autres textes d'aide seront disponibles pendant le déroulement de la procédure.";
#pgv_lang["validate_gedcom_help"]       = "~VALIDATE GEDCOM~<br /><br />This is the third step in the procedure to add externally created GEDCOM data to your genealogical database.<br /><br />PhpGedView will check the input file for the correct use of Date format, Place format, Character Set, etc.  Some deviations from the GEDCOM 5.5.1 Standard, to which PhpGedView adheres, can be corrected automatically. Examples are Macintosh line endings and incorrect use of Place format.  When this happens, you will see a message that the data has been changed.  For other abnormalities you will get a warning message with a recommended solution.<br /><br /><b>Optional Tools</b><br />At this moment there is only one additional tool:<br /><b>Change Individual ID to...</b>.<br />#pgv_lang[more_config_help]#<br />";
#pgv_lang["convert_ansi2utf_help"]      = "~CONVERT ANSI TO UTF-8~<br /><br />To ensure that the information in your input GEDCOM files is processed and displayed correctly, these files should be encoded in UTF-8.<br /><br />Some of the more modern genealogy programs can export their data to a GEDCOM file in UTF-8 encoding.  Older programs often don't have this capability.  If your program does not offer you this option, PhpGedView can convert the file for you.<br /><br />When PhpGedView validates the input file, it will detect the file's encoding and advise you accordingly.<br /><br />";
#pgv_lang["detected_ansi2utf_help"]     = "~ANSI ENCODING DETECTED~<br /><br />The GEDCOM file being validated now is encoded in the ANSI character set.  You are strongly advised to convert the file's encoding to UTF-8.<br /><br /><br />#pgv_lang[convert_ansi2utf_help]#";
#pgv_lang["detected_date_help"]         = "~WRONG DATE FORMAT DETECTED~<br /><br /><b>DATE FORMAT WILL BE CHANGED</b><br /><br />The date format that is standard for PhpGedView and also according to the GEDCOM 5.5.1 Standard is <b>DD&nbsp;MMM&nbsp;YYYY</b> (e.g. 01&nbsp;JAN&nbsp;2004)<br /><br />If, after your GEDCOM file has been validated, you see a message that a wrong date format has been detected, PhpGedView will convert the incorrectly formatted dates as prescribed by the Standard.<br /><br />You have, however, the option to choose either \"<b>day</b> before month\" (DD&nbsp;MMM&nbsp;YYYY), or \"<b>month</b> before day\" (MMM&nbsp;DD&nbsp;YYYY).<br /><br />We recommend that you use the first format (day before month).<br /><br />";
#pgv_lang["addmedia_tool_help"]         = "~ADD MEDIA TOOL~<br /><br /><b>DB mode only</b><br /><br />The Add Media Tool was designed for users whose genealogy programs do not export GEDCOMs with Media links. Family Tree Maker is one of these. <br /><br />The Add Media tool allows you to keep a list of media links outside of your GEDCOM file and separate from the normal PhpGedView tables. Because the data is kept in a separate table, you only have to enter it once. This makes it easy for administrators to work with the genealogical data in their desktop program, export a new GEDCOM file, and then run the Add Media tool on it as part of the import process to have the same image links added every time they make a new GEDCOM.<br /><br />To use the Add Media tool, first create a list of media items by filling the fields and clicking the Add Media button for each media item you want included in your GEDCOM.<ul><li>The <b>#pgv_lang[gedcomid]#</b> field contains the ID of the GEDCOM record you want the image added to, I100 for example.</li><li>Type the filename of the image you want to use into the <b>External File</b> field.</li><li>Enter the file's extension in the <b>#pgv_lang[extension]#</b> field.</li><li>Use the <b>#pgv_lang[highlighted]#</b> field to indicate whether or not this image is the highlighted or primary image for this individual. The first highlighted or primary image will be used on charts and highlighted on the individual page next to the person's name.</li><li>In the <b>#pgv_lang[title]#</b> field enter a descriptive title or caption for the image.</li><li>Use the <b>#pgv_lang[order]#</b> field to specify the order in which the images should appear on the individual's Media tab.</li><li>Finally, the <b>#pgv_lang[gedcom_file]#</b> field tells which genealogical database the media item is for. This allows you to use the tool with multiple databases.</li></ul><br />When the list is completed, click on the <b>#pgv_lang[click_to_add_media]#</b> button to have the changes stored in the database. The next time you update your database you only need to launch the Add Media tool and click this button.<br /><br />";
#pgv_lang["change_indi2id_help"]        = "~CHANGE INDIVIDUAL ID TO ....~<br /><br />This tool was designed for users whose Genealogy programs use a different GEDCOM ID for the individuals every time the GEDCOM is exported. For example, the first time the GEDCOM is exported some person's ID might be I100 but the next time the GEDCOM is exported that same person's ID is changed to I234. These changing IDs make it difficult to administer PhpGedView because the ID is how people are referenced.<br /><br />Most genealogy programs also use the RIN or REFN tag to give each person a unique identifier that can be used to reference the individual. This tool will replace all of the individual IDs in the GEDCOM file with the whatever field (RIN or REFN) you specify.<br /><br />";
#pgv_lang["edit_privacy_help"]          = "On this page you can make all the Privacy settings for the selected GEDCOM.<br /><br />You can check under the page title to see that you are editing the correct privacy file.  It is displayed like this: (path/nameofyourgedcom_priv.php)<br /><br />If you need more settings, you can make changes to the privacy file manually. You can read more about this on the PhpGedView web site.<br /><br />";
#pgv_lang["invalid_header_help"]        = "~INVALID GEDCOM HEADER~<br /><br />A GEDCOM file must begin with <b>0&nbsp;HEAD</b>. PhpGedView detected that the GEDCOM file you are importing does not have <b>0&nbsp;HEAD</b> as the first line. When you click the Cleanup button, any lines before the first <b>0&nbsp;HEAD</b> line will be removed.<br /><br />This error usually means that the program you used to create your GEDCOM did not create it properly or it is not a GEDCOM file. You should check to make sure that you uploaded the correct file, and that it starts with the line <b>0&nbsp;HEAD</b> and ends with the line <b>0&nbsp;TRLR</b>.<br /><br />";
$pgv_lang["macfile_detected_help"]      = "~Fichier au format Macintosh~<br />PhpGedView a détecté que votre fichier GEDCOM provient d'un ordinateur Macintosh. Les marqueurs de fin de ligne sont différents sur Macintosh (r), sur Unix (n) ou sur Windows (rn). Pour être utilisable par PhpGedView, ces caractères vont être modifiés.<br />";
#pgv_lang["cleanup_places_help"]        = "~CLEANUP PLACES~<br /><br />PhpGedView detected that your GEDCOM file uses places on GEDCOM tags that should not have places.<br /><br />Many genealogy programs, such as Family Tree Maker, will create this type of GEDCOM file. PhpGedView will work with these GEDCOM files, but some invalid places will show up in your place hierarchy. <br /><br />For example, your GEDCOM might have the following encoding<br />1 SSN<br />2 PLAC 123-45-6789<br />1 OCCU<br />2 PLAC Computer Programmer<br /><br />According to the GEDCOM 5.5.1 Standard this should really be shown as<br />1 SSN 123-45-6789<br />1 OCCU Computer Programmer<br /><br />If you select <b>Yes</b>, PhpGedView will automatically correct these encoding errors.<br /><br />";
#pgv_lang["empty_lines_detected_help"]  = "~EMPTY LINES DETECTED~<br /><br />PhpGedView has detected that there are empty lines in your input file. These lines may cause errors and will be removed from the file before it is imported.<br /><br />";
#pgv_lang["skip_cleanup_help"]          = "~SKIP CLEANUP~<br /><br />It is strongly recommended that you allow PhpGedView to clean up your file before it is imported, otherwise some of the functions may not work properly.<br /><br />If you insist on doing so, you may click this button to skip the cleanup step and continue importing the file unchanged.<br /><br /><b>Be aware that if you refuse permission for PhpGedView to clean up the input file, certain functions of PhpGedView may produce unpredictable results.</b><br /><br />";

//-- Edit Config
#pgv_lang["help_editconfig.php"]        = "~CONFIGURE PhpGedView~<br /><br />On this page you configure the global settings for PhpGedView.  You have to do this after you have installed PhpGedView and are running it for the first time.<br /><br />#pgv_lang[review_readme]#As these settings are <b>global</b>, they are for the whole program and for all genealogical databases you use with PhpGedView.<br /><br />Each genealogical database also has additional configuration options that you set after clicking the <b>#pgv_lang[admin_gedcoms]#</b> link on this page.<br /><br />You can also access the #pgv_lang[gedcom_adm_head]# function from the main Admin page, whose link is found under the #pgv_lang[mgv]# icon or in the header of most pages.  On the Admin page, the relevant link is called <b>#pgv_lang[manage_gedcoms]#.</b><br /><br />";

//-- merge records
#pgv_lang["help_edit_merge.php"]        = "~#pgv_lang[merge_records]#~<br /><br />This page will allow you to merge two GEDCOM records from the same GEDCOM file.<br /><br />This is useful for people who have merged GEDCOMs and now have many people, families, and sources that are the same.<br /><br />The page consists of three steps.<br /><ol><li>You enter two GEDCOM IDs.  The IDs <u>must</u> be of the same type.  You cannot merge an individual and a family or family and source, for example.<br />In the <b>#pgv_lang[merge_to]#</b> field enter the ID of the record you want to be the new record after the merge is complete.<br />In the <b>#pgv_lang[merge_from]#</b> field enter the ID of the record whose information will be merged into the #pgv_lang[merge_to]# record.  This record will be deleted after the Merge.</li><li>You select what facts you want to keep from the two records when they are merged.  Just click the checkboxes next to the ones you want to keep.</li><li>You inspect the results of the merge, just like with all other changes made online.</li></ol>Someone with Accept rights will have to authorize your changes to make them permanent.<br />";

//-- report engine
$pgv_lang["help_reportengine.php"]      = "~#pgv_lang[reports]#~<br />PhpGedView utilise un squelette XML pour générer automatiquement un rapport au format PDF.<br /><br />Choisir d'abord un type de rapport dans la liste. Cette liste est générée dynamiquement à partir du contenu du répertoire <tt>reports</tt>. Renseigner ensuite les quelques champs comme le code individu ou le code famille.<br /><br />Pour afficher le résultat dans votre navigateur, cliquer sur <b>#pgv_lang[run_report]#</b>. Pour l'enregistrer sur votre poste, cliquer sur <b>#pgv_lang[download_report]#</b>.<br /><br />Vous pouvez créer vous-même un nouveau modèle en vous inspirant de ceux existant. L'ajouter simplement dans le répertoire <i>'reports'</i> pour qu'il apparaisse dans la liste.";
#pgv_lang["def_pdf_format_help"]        = "~PDF FILE FORMAT~<br />The PhpGedView Reporting Engine produces downloadable reports in Adobe&reg; PDF format.  The GEDCOM 5.5.1 Standard specification, mentioned elsewhere in this Help file, is also downloadable as a PDF file.  PDF is an acronym for <b>P</b>ortable <b>D</b>ocument <b>F</b>ormat.<br /><br />PDF files are not viewable or printable by the standard software on your PC.  If you already have Acrobat Reader installed (it's often packaged with other softwares), you do not need to replace or upgrade it to deal with report files produced by PhpGedView.<br /><br />Acrobat Reader, the viewing and printing program for these files, is available free of charge from Adobe Systems Inc.  The free Adobe&reg; Acrobat Reader can be downloaded from the <a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Adobe Systems Inc.</b></a> web site.  You may find copies of \"Acrobat Reader\" available for download from other Internet sites, but we strongly advise you to trust <u>only</u> the Adobe Systems Inc. site.<br /><br />Acrobat Reader is available for many different systems, including Microsoft&reg; Windows and Apple&reg; Macintosh, in many languages other than English.  If you have a Windows 95 system, be sure to download Acrobat Reader version 5.0.5.  Versions more recent than this will not install correctly on Windows 95 systems.<br /><br /><a href=\"http://www.adobe.com/products/acrobat/readstep2.html\" target=\"_blank\"><b>Download Adobe Reader here</b></a><br /><br />";
#pgv_lang["help_ahnentafel.xml"]        = "~#pgv_lang[ahnentafel_report]#~<br />This is a report of the selected person and his ancestors, printed in booklet format.  It starts with the first person and then continues with his or her parents, grand-parents, etc.<br /><br />Note that the ahnentafel report is only available in English at this time.<br /><br />";
#pgv_lang["help_birthlist.xml"]         = "~#pgv_lang[birth_report]#~<br />With this report you can list all of the people who were born at a certain time or place.<br /><br />";
#pgv_lang["help_relativelist.xml"]      = "~#pgv_lang[relatives_report]#~<br />This report will list all of the relatives of the selected individual.  You can choose which of the person's relatives to show on the report.<ul><li><b>#pgv_lang[child-family]#</b> will show the selected person, his parents, and his brothers and sisters.</li><li><b>#pgv_lang[spouse-family]#</b> will list the person with his or her spouses and their children.</li><li><b>#pgv_lang[direct-ancestors]#</b> will list the person, his parents, grand-parents, great-grand-parents, and continue up the tree listing all of the people who are parents in the person's lineage.</li><li><b>#pgv_lang[ancestors]#</b> will list all of the people from the #pgv_lang[direct-ancestors]# list but also include aunts and uncles and great-aunts and great-uncles, so it will include the siblings of all of the ancestors in this person's family tree.  It will not list the children of the siblings (cousins).</li><li><b>#pgv_lang[descendants]#</b> will list all of this person's descendants (children, grand-children, great-grand children, etc).</li><li><b>#pgv_lang[all]#</b> this option is a combination of the #pgv_lang[descendants]# and the #pgv_lang[ancestors]# in a single report.</li></ul><br /><br />";
#pgv_lang["help_xml_reports"]           = "~Reporting Engine~<br />The PhpGedView Reporting Engine uses XML template files to automatically generate PDF reports.<br /><br />The reports available in the <b>#pgv_lang[select_report]#</b> list are generated from the report XML files found in the \"reports\" directory.  You can create your own reports by making a copy of any of the templates provided and modifying the template XML.  To add your custom report, just put it in the \"reports\" directory and PhpGedView will automatically detect it and make it available in the <b>#pgv_lang[select_report]#</b> drop-down list.<br /><br />";

//-- Help Contents
$pgv_lang["help_contents_head_help"]    = "<b>Sommaire de l'aide</b><br /><br />";
$pgv_lang["help_contents_gedcom_info"]  = "Informations du fichier GEDCOM";
$pgv_lang["help_contents_gedcom_places"]= "Lieux du fichier GEDCOM";

//-- Admin Help Contents Items
$pgv_lang["admin_help_contents_head_help"]= "<b>Sommaire<br /><br /><span class=\"error\"><small>Note : l'aide pour les fonctions <u>administrateur</u> est en début de liste.</small></span></b><br /><br />";
$pgv_lang["ah2_help"]                   = "_Configurer PhpGedView";
$pgv_lang["ah3_help"]                   = "_GEDCOM: Ajouter vs Charger";
$pgv_lang["ah4_help"]                   = "_GEDCOM: Fichier de Configuration";
$pgv_lang["ah5_help"]                   = "_GEDCOM: Fichier par Défaut";
$pgv_lang["ah6_help"]                   = "_GEDCOM: Suppression";
$pgv_lang["ah7_help"]                   = "_GEDCOM: Ajout";
$pgv_lang["ah8_help"]                   = "_GEDCOM: Création";
$pgv_lang["ah9_help"]                   = "_GEDCOM: Réception (download)";
$pgv_lang["ah10_help"]                  = "_GEDCOM: Administration";
$pgv_lang["ah11_help"]                  = "_GEDCOM: Configuration";
$pgv_lang["ah12_help"]                  = "_GEDCOM: Import";
$pgv_lang["ah13_help"]                  = "_GEDCOM: Envoi sur serveur (upload)";
$pgv_lang["ah14_help"]                  = "_GEDCOM: Validation";
$pgv_lang["ah15_help"]                  = "_GEDCOM: Conversion ANSI en UTF-8";
$pgv_lang["ah16_help"]                  = "_GEDCOM: Règles de confidentialité";
$pgv_lang["ah17_help"]                  = "_Gestion des utilisateurs";
$pgv_lang["ah18_help"]                  = "_Administration";
$pgv_lang["ah19_help"]                  = "_GEDCOM: Outils Media";
$pgv_lang["ah20_help"]                  = "_GEDCOM: Conversion ID en RIN";
$pgv_lang["ah21_help"]                  = "_Fichiers de langues";
// 22 is in the help_text_vars.php
#pgv_lang["ah23_help"]                  = "_Configure supported languages";
#pgv_lang["ah24_help"]                  = "_User Information migrate (Index --&gt;&gt; SQL)";
#pgv_lang["ah25_help"]                  = "_PhpGedView backup";
#pgv_lang["ah26_help"]                  = "_FAQ List: Edit";

//-- Find Media Help
#pgv_lang["manage_media_help"]          = "~#pgv_lang[manage_media]#~<br /><br />This is step two in managing uploaded media files if you have directory levels configured below the default media directory.<br /><br />As an admin user you can create the directory structure you require to keep your media files organized. Creating directories from this page ensures that the thumbnail directories are created as well as creating a suitable index.php in each directory.<br /><br />You can move files up and down the directory structure using the Move To --> link.  The thumbnail is also moved, thus keeping the file structure consistent.<br /><br />If you did not upload thumbnail files or forgot to check the <b>#pgv_lang[gen_thumb]#</b> checkbox during the upload you have the option to generate thumbnails from here. Check the <b>#pgv_lang[show_thumbnail]#</b> box;  if a thumbnail is not found you can click the <b>#pgv_lang[gen_thumb]#</b> link to create one.<br /><br />";
#pgv_lang["simple_filter_help"]         = "~#pgv_lang[filter]#~<br /><br />Simple search filter based on the characters entered, no wildcards are accepted.<br /><br />";
#pgv_lang["show_thumb_help"]            = "~#pgv_lang[show_thumbnail]#~<br /><br />Thumbnails will be shown if you check this box.<br /><br />";
#pgv_lang["new_dir_help"]               = "~#pgv_lang[add_directory]#~<br /><br />As an admin user you can create the directory structure you require to keep your media files organized. Creating directories from this page ensures that the thumbnail directories are created as well as creating a suitable index.php in each directory.<br /><br />Click on this link to enter the name of the directory you wish to create.<br /><br />";
#pgv_lang["find_media_help"]            = "~#pgv_lang[find_media]#~<br /><br />This allows you to search the file structure to find the media item you wish to link to.<br /><br />";

//-- Add / Edit Media Help
#pgv_lang["add_media_linkid"]           = "~Link ID~<br /><br />Each media item should be associated with one or more person, family, or source records in your database.<br /><br />To establish such a link, you can enter or search for the ID of the person, family, or source at the same time as you create the media item.  You can also establish the link later through editing options on the Manage Media page, or by adding media items through the Add Media link available on the Individual, Family, or Source Details pages.<br /><br />";
#pgv_lang["upload_server_file_help"]    = "~#pgv_lang[server_file]#~<br /><br />The media file you are uploading can be, and probably should be, named differently on the server than it is on your local computer.  This is so because often the local file name has meaning to you but is much less meaningful to others visiting this site.  Consider also the possibility that you and someone else both try to upload different files called \"granny.jpg\".<br /><br />In this field, you specify the new name of the file you are uploading.  The name you enter here will also be used to name the thumbnail, which can be uploaded separately or generated automatically.  You do not need to enter the file name extension (jpg, gif, pdf, doc, etc.)<br /><br />Leave this field blank to keep the original name of the file you have uploaded from your local computer.<br /><br />";
#pgv_lang["upload_server_folder_help"]  = "~#pgv_lang[server_folder]#~<br /><br />The administrator has enabled up to #GLOBALS[MEDIA_DIRECTORY_LEVELS]# folder levels below the default <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  This helps to organize the media files and reduces the possibility of name collisions.<br /><br />In this field, you specify the destination folder where the uploaded media file should be stored.  The matching thumbnail file, either uploaded separately or generated automatically, will be stored in a similar folder structure starting at <b>#GLOBALS[MEDIA_DIRECTORY]#thumbs/</b> instead of <b>#GLOBALS[MEDIA_DIRECTORY]#</b>.  You do not need to enter the <b>#GLOBALS[MEDIA_DIRECTORY]#</b> part of the destination folder name.<br /><br />If you are not sure about what to enter here, you should contact your site administrator for advice.<br /><br />";

//-- Alive in Year Help
#pgv_lang["alive_in_year_help"]         = "~#pgv_lang[alive_in_year]#~<br /><br />This will show the persons who should be living in the chosen year.<br /><br />When there are definite dates for birth and death the person is marked as alive if the search year falls in their lifetime.<br /><br />Enter a different year and click the <b>View</b> button to see who is alive in that year.  The rest of the page works just like the Individual list.<br /><br />";
#pgv_lang["year_help"]                  = "~#pgv_lang[alive_in_year]#~<br /><br />Enter the year for which you are looking for living people.<br /><br />";

//--Repository Help
#pgv_lang["help_repolist.php"]          = "~#pgv_lang[repo_list]#~<br /><br />A list of repositories is displayed on this page.<br /><br />The names of the repositories are sorted into alphabetical order.<br /><br /><b>REPOSITORIES</b><br />Without repositories we cannot build our database. There is a source for all information stored in the database, and that source is kept in a repository. Repositories can be the personal archive of a person, an institution, a public database, a government or church records office, an Internet resource, etc. To get access to a source we will want to know where and in what place it is. All necessary information to find a source should be stored in the Repository record.<br /><br />A repository can be linked to many sources.<br /><br />";
#pgv_lang["help_repo.php"]              = "~#pgv_lang[repo_info]#~<br /><br />The details of the Repository are displayed here. Together with Sources, Repositories are very important to genealogical researchers.  With accurate Source and Repository information, you can follow the trail another researcher used to find the information.  You should be able to find that same information again.<br /><br />On this page you may see information about the Repository's title, address, email and webpage.<br /><br />After the repository details, will be a list of all sources that are linked to this repository. This allows you to see all of the information that was obtained from a particular repository.<br /><br />If enabled by the site admin, you will have one or two more menu icons on this page:<br /><b>#pgv_lang[view_gedcom]#</b>, which shows the information in GEDCOM format.<br /><b>#pgv_lang[add_to_cart]#</b>, which enables you to store this information in your #pgv_lang[clip_cart]#. From there you can download the information in GEDCOM file format and import it into your own genealogy program.<br /><br />#pgv_lang[context_help]#<br /><br />";
#pgv_lang["delete_repo_help"]           = "~#pgv_lang[delete_repo]#~<br /><br />When you click this option you mark this Repository to be deleted from the database.<br /><br />What does that mean?<br />Let's suppose you have a good reason to remove this Repository from the database. You click the link.  You will be asked to confirm your deletion request.  If you decide to continue, it can take a little time before you see a message that the Repository is deleted.<br /><br />When you continue with your visit, you will notice that the Repository is still visible and can be used as if the deletion had not occurred.<br /><br /><b>This is <u>not</u> an error.</b>  The site admin will get a message that a change has been made to the database, and that you removed the Repository.<br />The administrator can accept or reject your change. Only after the administrator has accepted your change will the deletion actually occur <u>irreversibly</u>.  If there is any doubt about your change, the administrator will contact you.<br /><br />";
#pgv_lang["show_repo_gedcom_help"]      = "~#pgv_lang[view_gedcom]#~<br /><br />When you click this link, the information about the repository, as it is stored in the database, will be displayed in a popup window.<br /><br />";
#pgv_lang["add_repository_clip_help"]   = "~#pgv_lang[add_to_cart]#~<br /><br />When you click this link you can add the repository, as it is stored in the GEDCOM, to your #pgv_lang[clip_cart]#.<br /><br />";
#pgv_lang["repolist_listbox_help"]      = "~#pgv_lang[repo_list]#~<br /><br />In this box you see the names of the repositories as they are stored in the database.<br /><br />The names are displayed in alphabetical order.<br /><br />When you click on a name in the list, you will go to the #pgv_lang[repo_info]# page where you will see a list of the sources that are linked to that repository.<br /><br />";
#pgv_lang["repos_listbox_help"]         = "~#pgv_lang[other_repo_records]#~<br /><br />In this box you see the names of sources that are linked to the repository.<br /><br />The names are displayed in alphabetical order.<br /><br />When you click on a name in the list, you will go to the Detail page of that source.<br /><br />";

// Index-Edit
#pgv_lang["block_move_up_help"]         = "~Move list entries~<br /><br />Use these buttons to re-arrange the order of the entries within the list.  The blocks will be printed in the order in which they are listed.<br /><br />Highlight the entry to be moved, and then click a button to move that entry up or down.<br /><br />";
#pgv_lang["block_move_right_help"]      = "~Move list entries~<br /><br />Use these buttons to move an entry from one list to another.<br /><br />Highlight the entry to be moved, and then click a button to move or copy that entry in the direction of the arrow.  Use the <b>&raquo;</b> and <b>&laquo;</b> buttons to move the highlighted entry from the leftmost to the rightmost list or vice-versa.  Use the <b>&gt;</b> and <b>&lt;</b> buttons to move the highlighted entry between the #pgv_lang[available_blocks]# list and the list to its right or left.<br /><br />The entries in the #pgv_lang[available_blocks]# list do not change, regardless of what you do with the #pgv_lang[move_right]# and #pgv_lang[move_left]# buttons.  This is so because the same block can appear several times on the same page.  The HTML block is a good example of why you might want to do this.<br /><br />";
#pgv_lang["block_default_index"]        = "~Default blocks on #pgv_lang[welcome]# page~<br /><br />When you remove all entries from the #pgv_lang[main_section]# and #pgv_lang[right_section]# lists, or when you click the <b>#pgv_lang[reset_default_blocks]#</b> button, the block list will be set as follows:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[gedcom_stats_block]#<br />#pgv_lang[gedcom_news_block]#<br />#pgv_lang[gedcom_favorites_block]#<br />#pgv_lang[review_changes_block]#</td><td>#pgv_lang[gedcom_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[todays_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";
#pgv_lang["block_default_portal"]       = "~Default blocks on #pgv_lang[mygedview]# page~<br /><br />When you remove all entries from the #pgv_lang[main_section]# and #pgv_lang[right_section]# lists, or when you click the <b>#pgv_lang[reset_default_blocks]#</b> button, the block list will be set as follows:<br /><br /><center><table border=\"1\"><tr><td class=\"list_value\"><b>#pgv_lang[main_section]#</b></td><td class=\"list_value\"><b>#pgv_lang[right_section]#</b></td></tr><tr><td>#pgv_lang[todays_events_block]#<br />#pgv_lang[user_messages_block]#<br />#pgv_lang[user_favorites_block]#<br />&nbsp;</td><td>#pgv_lang[welcome_block]#<br />#pgv_lang[random_media_block]#<br />#pgv_lang[upcoming_events_block]#<br />#pgv_lang[logged_in_users_block]#</td></tr></table></center><br />";

// accesskey help
#pgv_lang["accesskey_viewing_advice_help"]= "~#pgv_lang[accesskeys]#~<br />Keyboard shortcuts are intended to help users who have difficulty with pointing devices such as a mouse.  Shortcut use differs according to your browser:<ul><li>Internet Explorer 5+: Hold down the ALT key while you strike the desired character, and then press ENTER.</li><li>Firefox and Netscape 6+: Hold down the ALT key while you strike the desired character.  Do not press ENTER afterwards.</li><li>Opera: Hold down the SHIFT and ESC keys while you strike the desired character.  Do not press ENTER afterwards.</li><li>Internet Explorer 5+ for Mac / Safari 1.2+: Hold down the CTRL key while you strike the desired character.  Do not press ENTER afterwards.</li></ul><br />The following keyboard shortcuts are available: <ul><li>All Pages <ul><li><b>zero</b> - Information about keyboard shortcuts</li><li><b>one</b> - #pgv_lang[welcome_page]#</li><li><b>#pgv_lang[accesskey_help_content]#</b> - #pgv_lang[help_contents]#</li><li><b>#pgv_lang[accesskey_help_current_page]#</b> - #pgv_lang[help_for_this_page]#</li><li><b>#pgv_lang[accesskey_contact]#</b> - Contact </li><li><b>#pgv_lang[accesskey_skip_to_content]#</b> - Skip to Content</li><li><b>#pgv_lang[accesskey_search]#</b> - #pgv_lang[search]# </li></ul></li><li>Individual Page<ul><li><b>#pgv_lang[accesskey_individual_details]#</b> - Show #pgv_lang[personal_facts]# tab</li><li><b>#pgv_lang[accesskey_individual_notes]#</b> - Show #pgv_lang[notes]# tab</li><li><b>#pgv_lang[accesskey_individual_sources]#</b> - Show #pgv_lang[ssourcess]# tab</li><li><b>#pgv_lang[accesskey_individual_media]#</b> - Show #pgv_lang[media]# tab</li><li><b>#pgv_lang[accesskey_individual_relatives]#</b> - Show #pgv_lang[relatives]# tab</li><li><b>#pgv_lang[accesskey_individual_research_log]#</b> - Show #pgv_lang[research_log]# tab</li><li><b>#pgv_lang[accesskey_individual_pedigree]#</b> - Show individual's #pgv_lang[pedigree_chart]#</li><li><b>#pgv_lang[accesskey_individual_descendancy]#</b> - Show individual's #pgv_lang[descend_chart]#</li><li><b>#pgv_lang[accesskey_individual_timeline]#</b> - Show individual's #pgv_lang[timeline_chart]#</li><li><b>#pgv_lang[accesskey_individual_relation_to_me]#</b> - Show individual's #pgv_lang[relationship_to_me]# chart</li><li><b>#pgv_lang[accesskey_individual_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li><li>Family Pages <ul><li><b>#pgv_lang[accesskey_family_parents_timeline]#</b> - #pgv_lang[parents_timeline]# tab</li><li><b>#pgv_lang[accesskey_family_children_timeline]#</b> - #pgv_lang[children_timeline]# tab</li><li><b>#pgv_lang[accesskey_family_timeline]#</b> - #pgv_lang[family_timeline]# tab</li><li><b>#pgv_lang[accesskey_family_gedcom]#</b> - #pgv_lang[view_gedcom]#</li></ul></li></ul><br />";

// FAQ page
#pgv_lang["help_faq.php"]               = "~Frequently Asked Questions~<br />#pgv_lang[text_faq_help]#<br />";
#pgv_lang["text_faq_help"]              = "The FAQ (Frequently Asked Questions) page can contain an overview or a list of questions and answers on the use of this genealogy site.<br /><br />The use to which the FAQ page is put is entirely up to the site administrator. The site administrator controls the content of each item and also the order in which the items are shown on the page.";

// Help search
#pgv_lang["hs_title_help"]              = "<center>~#pgv_lang[hs_title]#~</center><br />#pgv_lang[hs_intro]#<br /><br />#pgv_lang[hs_keyword_advice]#<br /><br />#pgv_lang[hs_searchhow_advice]#<br /><br />#pgv_lang[hs_searchin_advice]#";
#pgv_lang["hs_intro"]                   = "You can search PhpGedView's Help system.  The #pgv_lang[hs_title]# feature gives you a high degree of control over the way the search functions; you should be able to find what you are looking for easily.";
#pgv_lang["hs_keyword_advice"]          = "~#pgv_lang[hs_keyword]#~<br />You enter the words or the phrase you wish to find.<br /><br />The search does not pay attention to the case (upper or lower) of the search terms or the text being examined.  This means that if you search for <b>Individual</b>, you will find text containing <b>Individual</b>, <b>individual</b>, or <b>INDIVIDUAL</b>.  You will also find text containing <b>individuals</b>, etc. since the search is looking for sequences of characters rather than words.<br /><br />You can have the search look for several words at once.  Enter all of the words, separating each of them by a space, like this: <b>individual&nbsp;family&nbsp;child</b>.  When more than one word is entered, the meaning of what you have typed is clarified in the #pgv_lang[hs_searchhow]# field.<br />";
#pgv_lang["hs_searchin_advice"]         = "~#pgv_lang[hs_searchin]#~<br />You determine the scope of the search here.<br /><br />Administrators have the choice of searching User Help or Configuration Help or both.  Users do not have this choice; because they do not have access to any configuration features, they can only search the User Help file.<br /><br />The Help files contain not only Help text but also certain text strings used to build input forms and other material.  This option lets you control whether the entire Help file should be examined or whether only the Help text should be looked at.<br />";
#pgv_lang["hs_searchhow_advice"]        = "~#pgv_lang[hs_searchhow]#~<br />You clarify the meaning of what you have entered into the #pgv_lang[hs_keyword]# field by selecting among the possibilities presented here.<br /><dl><dt><b>#pgv_lang[hs_searchany]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains one of the words listed.  The order of the words doesn't matter.  The meaning of the search is: \"Find Help text containing <b>individual</b> <u>or</u> <b>family</b> <u>or</u> <b>child</b>\".</dd><dt><b>#pgv_lang[hs_searchall]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains all of the words listed.  The order of the words doesn't matter.  The meaning of the search is: \"Find Help text containing <b>individual</b> <u>and</u> <b>family</b> <u>and</u> <b>child</b>\".</dd><dt><b>#pgv_lang[hs_searchsentence]#</b></dt><dd>If you have entered <b>individual&nbsp;family&nbsp;child</b>, this option will find Help text that contains all of the words listed in the order given.  The meaning of the search is: \"Find Help text containing the words <b>individual&nbsp;family&nbsp;child</b> in exactly that order with no other words or characters between\".  You probably won't find this particular phrase in any Help text.<br /><br />There are a few limitations on this type of search.  Certain special characters such as <b>&quot; &lt; &gt;</b> etc. are contained within the Help text in symbolic form and won't be found if they form part of the text you enter.  Some Help text contains a special kind of Space character represented by <b>&amp;nbsp;</b> and you won't find phrases containing this character.</dd></dl>";

?>
