/***************************************************************************/
/* 		This code is part of WWW grabber called pavuk		   */
/*		Copyright (c) 1997 - 2001 Stefan Ondrejicka		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>

#include "config.h"
#include "decode.h"
#include "tools.h"

#ifdef HAVE_ZLIB
#include <zlib.h>
#endif

#define BUFSIZE	PATH_MAX

/********************************************************/
/* zapise obsah pamete na adrese buf s dlzkou len	*/
/* na deskriptor fd					*/
/********************************************************/
static int writerm(len , buf , fd)
int len;
char *buf;
int fd;
{
	char *p = buf;
	int fsize = BUFSIZE;


	while (p < (buf + len))
	{
		if ((p + BUFSIZE) > (buf + len)) fsize = buf + len - p;
		if (write(fd , p , fsize) < 0)
		{
			return -1;
		}
		p += BUFSIZE;
	}

	return 0;
}

/********************************************************/
/* vypis subor do deskriptora fd			*/
/********************************************************/
static int writerf(fname , fd)
char *fname;
int fd;
{
	char buf[BUFSIZE];
	int len;
	int fnfd;


	fnfd = open(fname , O_BINARY | O_RDONLY);
	if (fnfd < 0)
	{
		perror(fname);
		return -1;
	}

	while ((len = read(fnfd , buf, sizeof(buf))) > 0 || errno == EWOULDBLOCK)
	{
		if (write(fd , buf ,len) != len)
		{
			close(fnfd);
			return -1;
		}
	}

	close(fnfd);
	return 0;
}

int gzip_decode(inbuf , insize , outbuf , outsize , fname)
char *inbuf;
int insize;
char **outbuf;
int *outsize;
char *fname;
{
	int writepipe[2];
	pid_t pidg;
	char *out = NULL;
	int outcnt = 0,len;
	char buf[BUFSIZE];
	bool_t err = TRUE;
	int outf;

	strcpy(buf, "pavuk_decoder.tmp.XXXXXX");
 	outf = tl_mkstemp(buf);
	if (outf == -1)
	{
		xperror("tl_mkstemp");
		return -1;
	}
	unlink(buf);

	*outsize = 0;
	*outbuf = NULL;

	if (pipe(writepipe))
	{
		xperror("pipe");
		return -1;
	}

	pidg = fork();
	
	if (pidg < 0)
	{
		xperror("fork");
		close(writepipe[0]);
		close(writepipe[1]);
		return -1;		
	}
	if (pidg == 0)
	{
		close(0);
		dup(writepipe[0]);
		close(writepipe[0]);
		close(writepipe[1]);

#ifdef HAVE_ZLIB
		{
			gzFile gzfd;
			int ilen,olen;

			if (!(gzfd = gzdopen(0, "rb")))
			{
				perror("gzdopen");
				_exit(1);
			}

			while((ilen = gzread(gzfd, buf, sizeof(buf))) > 0)
			{
				olen = write(outf , buf , ilen);

				if (olen != ilen)
					break;
			}
			if (ilen < 0)
			{
				int err;
				printf("decode: %s\n", gzerror(gzfd, &err));
				_exit(1);
			}
			else if (ilen)
			{
				perror("decode");
				_exit(1);
			}
			gzclose(gzfd);
			close(outf);
			_exit(0);
		}
		_exit(0);
#else
		close(1);
		dup(outf);
		close(outf);
		execlp(GZIP_CMD , "gunzip" , "-cf" , NULL);
		xperror("gunzip exec");
		_exit(1);
#endif
	}
	
	close(writepipe[0]);

	err = fname ? writerf(fname , writepipe[1]) :
		writerm(insize , inbuf , writepipe[1]);	

	if (err) xperror(gettext("decode"));

	close(writepipe[1]);

	waitpid(pidg , NULL , 0);

	while((len = read(outf, buf, sizeof(buf))) > 0)
	{
		out = (char *) _realloc(out , outcnt + len + 1);
		memcpy(out + outcnt , buf , len);
		outcnt += len;
		*(out + outcnt) = '\0';
	}

	close(outf);

	*outsize = outcnt;
	*outbuf = out;
	return 0;
}
