/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: viewshape.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:25:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_VIEWSHAPE_HXX
#define _SLIDESHOW_VIEWSHAPE_HXX

#ifndef _CPPCANVAS_RENDERER_HXX
#include <cppcanvas/renderer.hxx>
#endif
#ifndef _CPPCANVAS_BITMAP_HXX
#include <cppcanvas/bitmap.hxx>
#endif

#ifndef _BGFX_RANGE_B2DRECTANGLE_HXX
#include <basegfx/range/b2drectangle.hxx>
#endif
#ifndef _BGFX_POLYGON_B2DPOLYGON_HXX
#include <basegfx/polygon/b2dpolygon.hxx>
#endif


#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <gdimtftools.hxx>
#include <shapeattributelayer.hxx>
#include <animatedsprite.hxx>
#include <viewlayer.hxx>
#include <doctreenode.hxx>

#include <vector>


namespace presentation
{
    namespace internal
    {
        /** This class is the viewable representation of a draw
            document's XShape, associated to a specific View

            The class is able to render the associated XShape on
            View implementations.
         */
        class ViewShape
        {
        public:
            /** Create a ViewShape for the given View

            	@param rView
                The associated View object.
             */
            explicit ViewShape( const ViewLayerSharedPtr& rViewLayer );

            ~ViewShape();

			/** Query the associated view layer of this shape
             */
            ViewLayerSharedPtr getViewLayer() const;

            /** Query dimension of a safety border around the shape for AA

            	If the view performs antialiasing, this method
            	calculates a safety border around the shape, in the
            	shape coordinate system, which is guaranteed to
            	include every pixel touched when rendering the shape.
             */
            ::basegfx::B2DSize getAntialiasingBorder() const;


            // animation methods
            //------------------------------------------------------------------

            /** Notify the ViewShape that an animation starts now

				This method enters animation mode on the associate
				target view. The shape can be animated in parallel on
				different views.

	            @return whether the mode change finished successfully.
             */
            bool enterAnimationMode();

            /** Notify the ViewShape that it is no longer animated

				This methods ends animation mode on the associate
				target view
             */
            void leaveAnimationMode();

            /** Query whether the ViewShape is currently animated

				This method checks whether the ViewShape is currently in
				animation mode.
             */
            bool isBackgroundDetached() const;

            // render methods
            //------------------------------------------------------------------

            enum UpdateFlags
            {
                NONE=			0,
                TRANSFORMATION=	1,
                CLIP=			2,
                ALPHA=			4,
                POSITION=		8,
                CONTENT=	    16,
                FORCE=			32
            };

            struct RenderArgs
            {
                /** Create render argument struct

                    @param rOrigBounds
                    The initial shape bounds

                    @param rUpdateBounds
                    The area covered by the shape
                    
                    @param rBounds
                    The current shape bounds

                    @param rAttr
                    The current shape attribute set. Can be NULL, for
                    default attributes. Attention: stored as a reference,
                    thus, parameter object must stay valid!

                    @param rSubsets
                    Vector of subset rendering ranges. Attention:
                    stored as a reference, thus, parameter object must
                    stay valid!
                */
                RenderArgs( const ::basegfx::B2DRectangle&		rOrigBounds,
                            const ::basegfx::B2DRectangle&		rUpdateBounds,
                            const ::basegfx::B2DRectangle&		rBounds,
                            const ::basegfx::B2DRectangle&		rUnitBounds,
                            const ShapeAttributeLayerSharedPtr&	rAttr,
                            const VectorOfDocTreeNodes&			rSubsets ) :
                    maOrigBounds( rOrigBounds ),
                    maUpdateBounds( rUpdateBounds ),
                    maBounds( rBounds ),
                    maUnitBounds( rUnitBounds ),
                    mrAttr( rAttr ),
                    mrSubsets( rSubsets )
                {
                }

                const ::basegfx::B2DRectangle		maOrigBounds;
                const ::basegfx::B2DRectangle		maUpdateBounds;
                const ::basegfx::B2DRectangle		maBounds;
                const ::basegfx::B2DRectangle		maUnitBounds;
                const ShapeAttributeLayerSharedPtr&	mrAttr;
                const VectorOfDocTreeNodes&			mrSubsets;
            };

            /** Update the ViewShape

				This method updates the ViewShape on the associated
				view. If the shape is currently animated, the render
				target is the sprite, otherwise the view's
				canvas. This method does not render anything, if the
				update flags are 0. 

                @param rMtf
                The metafile representation of the shape

                @param rArgs
                Parameter structure, containing all necessary arguments

                @param nUpdateFlags
                Bitmask of things to update. Use FORCE to force a repaint.

                @param bIsVisible
                When false, the shape is fully invisible (and possibly
                don't need to be painted)

	            @return whether the rendering finished successfully.
            */
            bool update( const GDIMetaFileSharedPtr&	rMtf,
                         const RenderArgs&				rArgs,
                         int							nUpdateFlags,
                         bool							bIsVisible ) const;

            /** Retrieve renderer for given canvas and metafile.

            	If necessary, the renderer is created or updated for
            	the metafile and attribute layer.

                @return a renderer that renders to the given
                destination canvas
             */
            ::cppcanvas::RendererSharedPtr getRenderer( const ::cppcanvas::CanvasSharedPtr&	rDestinationCanvas,
                                                        const GDIMetaFileSharedPtr&			rMtf,
                                                        const ShapeAttributeLayerSharedPtr&	rAttr ) const;


        private:
            // default: disabled copy/assignment
            ViewShape(const ViewShape&);
            ViewShape& operator=( const ViewShape& );

            struct RendererCacheEntry
            {
                RendererCacheEntry() :
                    mpDestinationCanvas(),
                    mpRenderer(),
                    mpMtf(),
                    mpLastBitmap(),
                    mpLastBitmapCanvas()
                {
                }

                ::cppcanvas::CanvasSharedPtr getDestinationCanvas()
                {
                    return mpDestinationCanvas;
                }

                ::cppcanvas::CanvasSharedPtr		mpDestinationCanvas;
                ::cppcanvas::RendererSharedPtr		mpRenderer;
                GDIMetaFileSharedPtr				mpMtf;
                ::cppcanvas::BitmapSharedPtr		mpLastBitmap;
                ::cppcanvas::BitmapCanvasSharedPtr	mpLastBitmapCanvas;
            };

            typedef ::std::vector< RendererCacheEntry >	RendererCacheVector;


            /** Prefetch Renderer for given canvas
             */
            bool prefetch( RendererCacheEntry&					io_rCacheEntry,
                           const ::cppcanvas::CanvasSharedPtr&	rDestinationCanvas,
                           const GDIMetaFileSharedPtr&			rMtf,
                           const ShapeAttributeLayerSharedPtr&	rAttr ) const;
            
            /** Draw with prefetched Renderer to stored canvas

            	This method draws prefetched Renderer to its
            	associated canvas (which happens to be mpLastCanvas).
             */
            bool draw( const ::cppcanvas::CanvasSharedPtr&	rDestinationCanvas,
                       const GDIMetaFileSharedPtr&			rMtf,
                       const ShapeAttributeLayerSharedPtr&	rAttr,
                       const ::basegfx::B2DHomMatrix&		rTransform,
                       const ::basegfx::B2DPolyPolygon&		rClip,
                       const VectorOfDocTreeNodes&			rSubsets ) const;

            /** Render shape to an active sprite
             */
            bool renderSprite( const ::cppcanvas::CanvasSharedPtr&	rDestinationCanvas,
                               const GDIMetaFileSharedPtr&			rMtf,
                               const ::basegfx::B2DRectangle&		rOrigBounds,
                               const ::basegfx::B2DRectangle&		rBounds,
                               const ::basegfx::B2DRectangle&		rUnitBounds,
                               int									nUpdateFlags,
                               const ShapeAttributeLayerSharedPtr&	pAttr,
                               const VectorOfDocTreeNodes&			rSubsets,
                               bool 								bIsVisible ) const;

            /** Render shape to given canvas
             */
            bool render( const ::cppcanvas::CanvasSharedPtr&	rDestinationCanvas,
                         const GDIMetaFileSharedPtr&			rMtf,
                         const ::basegfx::B2DRectangle&			rBounds,
                         const ::basegfx::B2DRectangle&			rUpdateBounds,
                         int									nUpdateFlags,
                         const ShapeAttributeLayerSharedPtr&	pAttr,
                         const VectorOfDocTreeNodes&			rSubsets,
                         bool 									bIsVisible ) const;

            /** Calc sprite size in pixel

            	Converts user coordinate system to device pixel, and
            	adds antialiasing border.

            	@param rUserSize
                Size of the sprite in user coordinate system (doc coordinates)
             */
            ::basegfx::B2DSize calcSpriteSizePixel( const ::basegfx::B2DSize& rUserSize ) const;
            
            enum{ MAX_RENDER_CACHE_ENTRIES=2 };

            /** Retrieve a valid iterator to renderer cache entry

            	This method ensures that an internal limit of
            	MAX_RENDER_CACHE_ENTRIES is not exceeded.

            	@param rDestinationCanvas
                Destination canvas to retrieve cache entry for

            	@return a valid iterator to a renderer cache entry for
            	the given canvas. The entry might be
            	default-constructed (if newly added)
             */
            RendererCacheVector::iterator getCacheEntry( const ::cppcanvas::CanvasSharedPtr& rDestinationCanvas ) const;
        
            void invalidateRenderer() const;

            /** The view layer this object is part of. 

                Needed for sprite creation
            */
            ViewLayerSharedPtr							mpViewLayer;

            /// A set of cached mtf/canvas combinations
            mutable RendererCacheVector					maRenderers;

            /// The sprite object
            mutable AnimatedSpriteSharedPtr				mpSprite;

            /// If true, render() calls go to the sprite
            mutable bool								mbAnimationMode;

            /// If true, shape needs full repaint (and the sprite a setup, if any)
            mutable bool								mbForceUpdate;
        };

        typedef ::boost::shared_ptr< ViewShape > ViewShapeSharedPtr;

    }
}

#endif /* _SLIDESHOW_VIEWSHAPE_HXX */
