/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: generateevent.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2006/07/26 07:35:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// must be first
#include "canvas/debug.hxx"
#include "canvas/verbosetrace.hxx"
#include "shape.hxx"
#include "slideshowcontext.hxx"
#include "delayevent.hxx"
#include "com/sun/star/drawing/XShape.hpp"
#include "com/sun/star/animations/XAnimationNode.hpp"
#include "com/sun/star/animations/Timing.hpp"
#include "com/sun/star/animations/EventTrigger.hpp"
#include "com/sun/star/animations/Event.hpp"

namespace presentation {
namespace internal {

using namespace com::sun::star;

EventSharedPtr generateEvent(
    uno::Any const& rEventDescription,
    Delay::FunctorT const& rFunctor,
    SlideShowContext const& rContext,
    double nAdditionalDelay )
{
    EventSharedPtr pEvent;
    
    if (! rEventDescription.hasValue())
        return pEvent;
    
    animations::Timing eTiming;
    animations::Event aEvent;
    uno::Sequence<uno::Any> aSequence;
    double nDelay;
    
    if (rEventDescription >>= eTiming) {
        switch (eTiming) {
        case animations::Timing_INDEFINITE:
            break; // don't schedule no event
        case animations::Timing_MEDIA:
            OSL_ENSURE( false, "MEDIA timing not yet implemented!" );
            break;
        default:
            ENSURE_AND_THROW( false, "unexpected case!" );
        }
    }
    else if (rEventDescription >>= aEvent) {
        
        // try to extract additional event delay
        double nDelay = 0.0;
        if (aEvent.Offset.hasValue() && !(aEvent.Offset >>= nDelay)) {
            OSL_ENSURE( false, "offset values apart from DOUBLE not "
                        "recognized in animations::Event!" );
        }
        
        // common vars used inside switch
        uno::Reference<animations::XAnimationNode> xNode;
        uno::Reference<drawing::XShape> xShape;
        ShapeSharedPtr pShape;
        
        // TODO(F1): Respect aEvent.Repeat value
        
        switch (aEvent.Trigger) {
        default:
            ENSURE_AND_THROW( false, "unexpected event trigger!" );
        case animations::EventTrigger::NONE:
            // no event at all
            break;
        case animations::EventTrigger::ON_BEGIN:
            OSL_ENSURE( false, "event trigger ON_BEGIN not yet implemented!" );
            break;
        case animations::EventTrigger::ON_END:
            OSL_ENSURE( false, "event trigger ON_END not yet implemented!" );
            break;
        case animations::EventTrigger::BEGIN_EVENT:
            // try to extract XAnimationNode event source
            if (aEvent.Source >>= xNode) {
                pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
                rContext.mrUserEventQueue.registerAnimationStartEvent( 
                    pEvent, xNode );
            }
            else {
                OSL_ENSURE(false, "could not extract source XAnimationNode "
                           "for BEGIN_EVENT!" );
            }
            break;
        case animations::EventTrigger::END_EVENT:
            // try to extract XAnimationNode event source
            if (aEvent.Source >>= xNode) {
                pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
                rContext.mrUserEventQueue.registerAnimationEndEvent( 
                    pEvent, xNode );
            }
            else {
                OSL_ENSURE( false, "could not extract source XAnimationNode "
                            "for END_EVENT!" );
            }
            break;
        case animations::EventTrigger::ON_CLICK:
            // try to extract XShape event source
            if ((aEvent.Source >>= xShape) &&
                (pShape = rContext.mpLayerManager->lookupShape(xShape)).get())
            {
                pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
                rContext.mrUserEventQueue.registerShapeClickEvent(
                    pEvent, pShape );
            }
            else {
                OSL_ENSURE( false, "could not extract source XAnimationNode "
                            "for ON_CLICK!" );
            }
            break;
        case animations::EventTrigger::ON_DBL_CLICK:
            // try to extract XShape event source
            if ((aEvent.Source >>= xShape) &&
                (pShape = rContext.mpLayerManager->lookupShape(xShape)).get())
            {
                pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
                rContext.mrUserEventQueue.registerShapeDoubleClickEvent( 
                    pEvent, pShape );
            }
            else {
                OSL_ENSURE( false, "could not extract source XAnimationNode "
                            "for ON_DBL_CLICK!" );
            }
            break;    
        case animations::EventTrigger::ON_MOUSE_ENTER:
            // try to extract XShape event source
            if ((aEvent.Source >>= xShape) &&
                (pShape = rContext.mpLayerManager->lookupShape(xShape)).get())
            {
                pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
                rContext.mrUserEventQueue.registerMouseEnterEvent( 
                    pEvent, pShape );
            }
            else {
                OSL_ENSURE( false, "could not extract source XAnimationNode "
                            "for ON_MOUSE_ENTER!" );
            }
            break;
        case animations::EventTrigger::ON_MOUSE_LEAVE:
            // try to extract XShape event source
            if ((aEvent.Source >>= xShape) &&
                (pShape = rContext.mpLayerManager->lookupShape(xShape)).get())
            {
                pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
                rContext.mrUserEventQueue.registerMouseLeaveEvent( 
                    pEvent, pShape );
            }
            else {
                OSL_ENSURE( false, "could not extract source XAnimationNode "
                            "for ON_MOUSE_LEAVE!" );
            }
            break;
        case animations::EventTrigger::ON_PREV:
            OSL_ENSURE( false, "event trigger ON_PREV not yet implemented, "
                        "mapped to ON_NEXT!" );
            // FALLTHROUGH intended
        case animations::EventTrigger::ON_NEXT:
            pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
            rContext.mrUserEventQueue.registerNextEffectEvent( pEvent );
            break;
        case animations::EventTrigger::ON_STOP_AUDIO:
            // try to extract XAnimationNode event source
            if (aEvent.Source >>= xNode) {
                pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
                rContext.mrUserEventQueue.registerAudioStoppedEvent(
                    pEvent, xNode );
            }
            else {
                OSL_ENSURE( false, "could not extract source XAnimationNode "
                            "for ON_STOP_AUDIO!" );
            }
            break;
        case animations::EventTrigger::REPEAT:
            OSL_ENSURE( false, "event trigger REPEAT not yet implemented!" );
            break;
        }
    }
    else if (rEventDescription >>= aSequence) {
        OSL_ENSURE( false, "sequence of timing primitives "
                    "not yet implemented!" );
    }
    else if (rEventDescription >>= nDelay) {
        pEvent = makeDelay( rFunctor, nDelay + nAdditionalDelay );
        // schedule delay event
        rContext.mrEventQueue.addEvent( pEvent );
    }
    
    return pEvent;
}

} // namespace internal
} // namespace presentation

