/*
 * This file is part of the WebKit open source project.
 * This file has been generated by generate-bindings.pl. DO NOT MODIFY!
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#import "config.h"
#import "DOMInternal.h"

#import "DOMTestNondeterministic.h"

#import "DOMNodeInternal.h"
#import "DOMTestNondeterministicInternal.h"
#import "ExceptionHandlers.h"
#import "JSMainThreadExecState.h"
#import "TestNondeterministic.h"
#import "ThreadCheck.h"
#import "URL.h"
#import "WebCoreObjCExtras.h"
#import "WebScriptObjectPrivate.h"
#import <wtf/GetPtr.h>

#define IMPL reinterpret_cast<WebCore::TestNondeterministic*>(_internal)

@implementation DOMTestNondeterministic

- (void)dealloc
{
    if (WebCoreObjCScheduleDeallocateOnMainThread([DOMTestNondeterministic class], self))
        return;

    if (_internal)
        IMPL->deref();
    [super dealloc];
}

- (int)nondeterministicReadonlyAttr
{
    WebCore::JSMainThreadNullState state;
    return IMPL->nondeterministicReadonlyAttr();
}

- (NSString *)nondeterministicWriteableAttr
{
    WebCore::JSMainThreadNullState state;
    return IMPL->nondeterministicWriteableAttr();
}

- (void)setNondeterministicWriteableAttr:(NSString *)newNondeterministicWriteableAttr
{
    WebCore::JSMainThreadNullState state;
    IMPL->setNondeterministicWriteableAttr(newNondeterministicWriteableAttr);
}

- (NSString *)nondeterministicExceptionAttr
{
    WebCore::JSMainThreadNullState state;
    return IMPL->nondeterministicExceptionAttr();
}

- (void)setNondeterministicExceptionAttr:(NSString *)newNondeterministicExceptionAttr
{
    WebCore::JSMainThreadNullState state;
    IMPL->setNondeterministicExceptionAttr(newNondeterministicExceptionAttr);
}

- (NSString *)nondeterministicGetterExceptionAttr
{
    WebCore::JSMainThreadNullState state;
    WebCore::ExceptionCode ec = 0;
    NSString *result = IMPL->nondeterministicGetterExceptionAttr(ec);
    WebCore::raiseOnDOMError(ec);
    return result;
}

- (void)setNondeterministicGetterExceptionAttr:(NSString *)newNondeterministicGetterExceptionAttr
{
    WebCore::JSMainThreadNullState state;
    IMPL->setNondeterministicGetterExceptionAttr(newNondeterministicGetterExceptionAttr);
}

- (NSString *)nondeterministicSetterExceptionAttr
{
    WebCore::JSMainThreadNullState state;
    return IMPL->nondeterministicSetterExceptionAttr();
}

- (void)setNondeterministicSetterExceptionAttr:(NSString *)newNondeterministicSetterExceptionAttr
{
    WebCore::JSMainThreadNullState state;
    WebCore::ExceptionCode ec = 0;
    IMPL->setNondeterministicSetterExceptionAttr(newNondeterministicSetterExceptionAttr, ec);
    WebCore::raiseOnDOMError(ec);
}

- (BOOL)nondeterministicZeroArgFunction
{
    WebCore::JSMainThreadNullState state;
    return IMPL->nondeterministicZeroArgFunction();
}

@end

WebCore::TestNondeterministic* core(DOMTestNondeterministic *wrapper)
{
    return wrapper ? reinterpret_cast<WebCore::TestNondeterministic*>(wrapper->_internal) : 0;
}

DOMTestNondeterministic *kit(WebCore::TestNondeterministic* value)
{
    WebCoreThreadViolationCheckRoundOne();
    if (!value)
        return nil;
    if (DOMTestNondeterministic *wrapper = getDOMWrapper(value))
        return [[wrapper retain] autorelease];
    DOMTestNondeterministic *wrapper = [[DOMTestNondeterministic alloc] _init];
    wrapper->_internal = reinterpret_cast<DOMObjectInternal*>(value);
    value->ref();
    addDOMWrapper(wrapper, value);
    return [wrapper autorelease];
}
