/nologo /MLd /W3 /Gm /GX /ZI /Od /D "WIN32" /D "_DEBUG" /D "_CONSOLE" /D "_MBCS" /FR"Debug/" /Fp"Debug/myNbdServerWin.pch" /YX /Fo"Debug/" /Fd"Debug/" /FD /GZ /c 
"C:\hqxie\RA\mynbdserver0930\myNbdServerWin.cpp"
                                                                                                                                                                                                                                                                                                          xtern long long llseek(unsigned int, long long, unsigned int);
#endif


void die(const char* s) {
 printf("%s\n", s);
 exit(1);
}


//function used to delete padding so that the nbd_request will
//have the same length with in Linux
/*void unpadNbdrequest(char* src,char* des)
{
	memcpy(des,src,28);
}
*/


//function used to add pad so that the nbd_request will
//have the 32 byte in windows
//Be care,now len!=request.len, because the last 4 bytes is added by us
//and the useful data is only first 4 bytes
void addpadNbdrequest(char* src,void* des)
{
	void* dummy=NULL;
	memcpy(des,src,28);
//	memcpy(des+28,dummy,4);
}

//inline void readit(int f, void *buf, int len)
//declaration been alterd by Hongqiang Xie
inline void readit(int f, char *buf, int len)
{
	int res;
	while (len > 0) {
		DEBUG("*");

		if ((res = recv(f, buf, len,0))== SOCKET_ERROR)
		{
			int errorCode=WSAGetLastError ();
			printf("\nsocket error code is \n%d\n",errorCode);
			_err("Read failed: %m");
		}
		len -= res;
		buf += res;
	}
}

//inline void writeit(int f, void *buf, int len)
//declaration been alterd by Hongqiang Xie
/*inline void writeit(int f, char *buf, int len)
{
	int res;
	while (len > 0) {
		DEBUG("+");
		if ((res = send(f, buf, len,MSG_OOB)) == SOCKET_ERROR)
			_err("Write failed: %m");
		len -= res;
		buf += res;
	}
}
*/


int port;			/* Port I'm listening at */
char *exportname;		/* File I'm exporting */
u64 exportsize = ~0, hunksize = ~0;	/* ...and its length */
int flags = 0;
int export[1024];
HANDLE hDevice;
DWORD bytesread;
#define F_READONLY 1
#define F_MULTIFILE 2 

void cmdline(int argc, char *argv[])
{
	int i;

	if (argc < 3) {
		printf("This is nbd-server version " VERSION "\n");	
		printf("Usage: port file_to_export [size][kKmM] [-r]\n"
		       "	-r read only\n"
		       "	if port is set to 0, stdin is used (for running from inetd)\n"
		       "	if file_to_export contains '%%s', it is substituted with IP\n"
		       "		address of machine trying to connect\n" );
		exit(0);
	}
	port = atoi(argv[1]);
	for (i = 3; i < argc; i++) {
		if (*argv[i] == '-') {
			switch (argv[i][1]) {
			case 'r':
				flags |= F_READONLY;
				break;
			case 'm':
				flags |= F_MULTIFILE;
				hunksize = 1*GIGA;
				break;
			}
		} else {
			u64 es;
			int last = strlen(argv[i])-1;
			char suffix = argv[i][last];
			if (suffix == 'k' || suffix == 'K' ||
			    suffix == 'm' || suffix == 'M')
				argv[i][last] = '\0';
			es = (u64)atol(argv[i]);
			switch (suffix) {
				case 'm':
				case 'M':  es <<= 10;
				case 'k':
				case 'K':  es <<= 10;
				default :  break;
			}
			exportsize = es;
		}
	}

	exportname = argv[2];
}

int connectme(int port)
{
	struct sockaddr_in addrin;
	int addrinlen = sizeof(addrin);
	int net, sock;

	if ((sock = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP)) == INVALID_SOCKET)
		_err("socket: %m");

	DEBUG("Waiting for connections... bind, ");
	addrin.sin_family = AF_INET;
	addrin.sin_port = htons(port);
	addrin.sin_addr.s_addr = 0;
	if (bind(sock, (const struct sockaddr *) &addrin, addrinlen) == SOCKET_ERROR)
		_err("bind: %m");
	DEBUG("listen, ");
	if (listen(sock, 1) == SOCKET_ERROR)
		_err("listen: %m");
	DEBUG("accept, ");
	if ((net = accept(sock, (struct sockaddr *) &addrin, &addrinlen)) == INVALID_SOCKET)
		_err("accept: %m");

	return net;
}

#define SEND send( net, (char*)(&reply), sizeof( reply )+1,MSG_OOB);
#define _ERROR { reply.error = htonl(-1); SEND; reply.error = 0; lastpoint = -1; }

u64 lastpoint = -1;

void maybeseek(int handle, u64 a)
{
	if (a > exportsize)
		_err("Can not happen\n");
	if (lastpoint != a) {
#ifdef HAVE_LLSEEK
		if (llseek(handle, a, SEEK_SET) < 0)
#else
		if (lseek(handle, (long)a, SEEK_SET) < 0)
#endif
			_err("Can not seek locally!\n");
		lastpoint = a;
	} else {
		DEBUG("@");
	}
}

int expread(u64 a, char *buf, int len)
{
	maybeseek(export[a/hunksize], a%hunksize);
	return (read(export[a/hunksize], buf, len) != len);
}


int expwrite(u64 a, char *buf, int len)
{
	maybeseek(export[a/hunksize], a%hunksize);
	return (write(export[a/hunksize], buf, len) != len);
}

int mainloop(int net)
{
	struct nbd_request request;
	struct nbd_reply reply;
	char zeros[300];
	int i = 0;
	u64 size_host;

	for(int ind=0;ind<290;ind++)
		zeros[ind]=0;
/*	if (write(net, INIT_PASSWD, 8) < 0)
		_err("Negotiation failed: %m");
	cliserv_magic = htonll(cliserv_magic);
	if (write(net, &cliserv_magic, sizeof(cliserv_magic)) < 0)
		_err("Negotiation failed: %m");
	size_host = htonll(exportsize);
	if (write(net, &size_host, 8) < 0)
		_err("Negotiation failed: %m");
	if (write(net, zeros, 128) < 0)
		_err("Negotiation failed: %m");
*/
	int tempcount=-1;
	void* tempBuf;	
	if ((tempcount=send(net, INIT_PASSWD, 9,MSG_OOB)) == SOCKET_ERROR)
		_err("Negotiation failed: %m");
	cliserv_magic = htonll(cliserv_magic);
//	_i64toa(cliserv_magic,tempBuf,10);
	tempBuf=(&cliserv_magic);
	if ((tempcount=send(net, (char*)tempBuf, sizeof(cliserv_magic)+1,MSG_OOB)) == SOCKET_ERROR)
		_err("Negotiation failed: %m");
	size_host = htonll(exportsize);
//	_i64toa(size_host,tempBuf,10);
//	tempBuf=&size_host;
	if ((tempcount=send(net, (char*)&size_host, 8+1,MSG_OOB)) == SOCKET_ERROR)
		_err("Negotiation failed: %m");
	if ((tempcount=send(net, zeros, 128+1,MSG_OOB))  == SOCKET_ERROR)
		_err("Negotiation failed: %m");


	DEBUG("Entering request loop!\n");
	reply.magic = htonl(NBD_REPLY_MAGIC);
	reply.error = 0;
	while (1) {
#define BUFSIZE 102400
		char buf[BUFSIZE];
		int len;

#ifdef DODBG
		i++;
		printf("%d: ", i);
#endif

//		readit(net, (char *)(&request), sizeof(request));
		char p_nopadRequest[28];
		
		readit(net, p_nopadRequest, 28);
		addpadNbdrequest(p_nopadRequest,&request);

		request.from = ntohll(request.from);
		request.type = ntohl(request.type);
//		char temp[4];
//		memcpy(temp,p_nopadRequest+24,4);
//		u32 tempLen=u32(temp);
		len = ntohl(request.len );

		if (request.magic != htonl(NBD_REQUEST_MAGIC))
			_err("Not enough magic.");
		if (len > BUFSIZE)
			_err("Request too big!");
#ifdef DODBG
		printf("%s from %d (%d) len %d, \n", (request.type ? "WRITE" : "READ"),
		       (int) request.from, (int) request.from / 512, len);
#endif
		memcpy(reply.handle, request.handle, sizeof(reply.handle));
		if (((request.from + len) > exportsize) ||
		    ((flags & F_READONLY) && request.type)) {
			DEBUG("[RANGE!]");
			_ERROR;
			continue;
		}
		if (request.type) {	/* WRITE */
			DEBUG("wr: net->buf, ");
			readit(net, buf, len);
			DEBUG("buf->exp, ");
#ifdef PARTITION
			SetFilePointer(hDevice,(request.from%hunksize),NULL,FILE_BEGIN);
			if (!WriteFile(hDevice,buf,DWORD(len),&bytesread,NULL)) {
#else
			if (expwrite(request.from, buf, len)) {
#endif
				DEBUG("Write failed: %m" );
				_ERROR;
				continue;
			}
			lastpoint += len;
			//SEND;
			send( net, (char*)(&reply), sizeof( reply )+1,MSG_OOB);
			continue;
		}
		/* READ */

		DEBUG("exp->buf, ");
#ifdef PARTITION
		SetFilePointer(hDevice,(request.from%hunksize),NULL,FILE_BEGIN);
		if (!ReadFile(hDevice,buf,DWORD(len),&bytesread,NULL)) {
#else
		if (expread(request.from, buf, len)) {
#endif
		 	lastpoint = -1;
			DEBUG("Read failed: %m");
			_ERROR;
			continue;
		}
		lastpoint += len;

		DEBUG("buf->net, ");
//		memcpy(buf, &reply, sizeof(struct nbd_reply));
//		writeit(net, buf, len + sizeof(struct nbd_reply));
		send( net, (char*)(&reply), sizeof( reply )+1,MSG_OOB);
		send(net,buf,len+1,MSG_OOB);
		DEBUG("OK!\n");

	}
}

char exportname2[1024];

void set_peername(int net)
{
	struct sockaddr_in addrin;
	int addrinlen = sizeof( addrin );
	char *peername;

	if (getpeername( net, (struct sockaddr *) &addrin, &addrinlen ) == SOCKET_ERROR)
		_err("getsockname failed: %m");
	peername = inet_ntoa(addrin.sin_addr);
	sprintf(exportname2, exportname, peername);

	printf("connect from %s, assigned file is %s", peername, exportname2);
}

u64 size_autodetect(int export)
{
	u64 es;
	DEBUG("looking for export size with lseek SEEK_END\n");
	if ((es = lseek(export, 0, SEEK_END)) == -1 || es == 0) {
		struct stat stat_buf = { 0, } ;
		int error;
		DEBUG("looking for export size with fstat\n");
		if ((error = fstat(export, &stat_buf)) == -1 || stat_buf.st_size == 0 ) {
			DEBUG("looking for export size with ioctl BLKGETSIZE\n");
#ifdef BLKGETSIZE
			if(ioctl(export, BLKGETSIZE, &es) || es == 0) {
#else
			if(1){
#endif
				_err("Could not find size of exported block device: %m");
			} else {
				es *= 512; /* assume blocksize 512 */
			}
		} else {
			es = stat_buf.st_size;
		}
	}
	return es;
}


u64 get_partition_size(HANDLE hd)
{
	u64 es;
	char* deviceName="A:";
	if(!GetDiskFreeSpaceEx(deviceName,NULL,(PULARGE_INTEGER)&es,NULL))
	{
		_err("Could not find size of exported block device: %m");
	} 
	return es;
}



int main(int argc, char *argv[])
{
	argc=3;
	argv[1]="6666";
	argv[2]="\\\\.\\A:";


#ifdef _WIN32
    WSADATA wsadata;
	int rc;
    rc = WSAStartup(2, &wsadata);
    if(rc) {
        printf("WSAStartup FAILED: err=%d\n", GetLastError());
        return 1;
    }
#endif

	int net;
	u64 i;
	if (sizeof( struct nbd_request )!=32)
		//I change it from 28 to 32. strange that plus size of each part not equal the size of the struct

		die("Bad size of structure. Alignment problems?");

	logging();
	cmdline(argc, argv);

	printf("Port number = %d ",port);
	if (port)
		net = connectme(port);
	else
		net = 0;
	set_peername(net);

	for (i=0; i<exportsize; i+=hunksize) {
		char exportname3[1024];

		sprintf(exportname3, exportname2, i/hunksize);
		printf( "Opening %s\n", exportname3 );
#ifdef PARTITION
/*		if((hDevice = CreateFile(exportname3, 
						GENERIC_READ , FILE_SHARE_READ | FILE_SHARE_WRITE, 
						NULL, OPEN_EXISTING, 0, NULL))==NULL)*/
		if((hDevice = CreateFile(exportname3, 
						GENERIC_READ | GENERIC_WRITE, 0, 
						NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL | FILE_FLAG_OVERLAPPED, NULL))==NULL)
#else
		if ((export[i/hunksize] = open(exportname3, ((flags & F_READONLY) ? _O_RDONLY : _O_RDWR) | O_BINARY)) == -1) {
#endif
			_err("Could not open exported file");
		};

	if (exportsize == ~0) {
#ifndef PARTITION
		exportsize = size_autodetect(export[0]);
#else
		exportsize = get_partition_size(hDevice);
#endif
	}
	if (exportsize > (~0UL >> 1))
#ifdef HAVE_LLSEEK
		if ((exportsize >> 10) > (~0UL >> 1))
			printf("size of exported file/device is %luMB\n",
				       (unsigned long)(exportsize >> 20));
		else
			printf("size of exported file/device is %luKB\n",
			       (unsigned long)(exportsize >> 10));
#else
		_err("Size of exported file is too big\n");
#endif
	else
		printf("size of exported file/device is %lu\n",
		       (unsigned long)exportsize);
	setmysockopt(net);

	mainloop(net);
#ifdef _WIN32
	WSACleanup();
#endif
	return 0;
}



