/*!================================================================

  module:       vpi01Libpcrl.h

 -------------------------------------------------------------------

  responsible:  BurkhardD

  special area: Dynamic Runtime Loader

  description:                 
                Laedt die Interface Runtime aus dem versionsabhaengigen 
		Verzeichniss. 


  see also:

  -------------------------------------------------------------------------





    ========== licence begin  GPL
    Copyright (c) 1998-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



 ===================================================================*/

#ifndef __VPI01_LIBPCRL_H__
#define __VPI01_LIBPCRL_H__

/*==================================================================*
 *  INCLUDES                                                        *
 *==================================================================*/

#include "gip00.h"
#ifndef WIN32
#include <limits.h>
#endif
#include "SAPDBCommon/SAPDB_Names.h"

/*==================================================================*
 *  DECLARATIONS                                                    *
 *==================================================================*/
#ifdef __cplusplus
extern "C" {                         /* Assume C declarations for C++ */
#endif  /* __cplusplus */
  
#define LIBNAME_PI01 "libpcr"
#define COMP_NAME_CPC_DRV_IP01 "CPC Driver"
#ifdef WIN32
#define PI01_SAPDB_KEY "SAP DBTech"
#else
#define PI01_SAPDB_KEY SAPDB_RUNTIMES_INI_FILE
#endif
  
#define PI01_RUNTIME_KEY SAPDB_RUNTIME_SECTION
#ifdef WIN32
#define PI01_GLOBALS_KEY ""
#else
#define PI01_GLOBALS_KEY SAPDB_GLOBALS_SECTION
#endif
#define PI01_INDEPDATA_KEY SAPDB_INDEPDATA_KEY
#define PI01_LDRDIAG_KEY "LdrDiagEnabled"

#define TRACE_FILE_NAME "ldrdiag.pct"
#define TRACE_FILE_NAME_SUFFIX ".old"
  
#ifndef PATH_MAX
#ifdef WIN32
#define PATH_MAX _MAX_PATH
#else
#define PATH_MAX (1024)
#endif 
#endif
  typedef char tpi01_PathC[PATH_MAX];
  

#define PI01_VERSION_FMT "%u.%u.%u.%u,%s"

#define VersionDigits_cpi01 (4)  
typedef struct tpi01_VersionID {
  unsigned char No[VersionDigits_cpi01];
  tpi01_PathC szKey;
} tpi01_VersionID;

typedef struct tpi01_VersionInfo {
  tpi01_VersionID version;
  tpi01_PathC szPath;
} tpi01_VersionInfo;
  
typedef char VersionStr_tpi01[100+sizeof(tpi01_PathC)];
  
/*==================================================================*
 *  EXTERNAL PROTOTYPES                                             *
 *==================================================================*/
  
void pi01VersionS2B(char *szVersion, tpi01_VersionID *version);
void pi01VersionB2S(tpi01_VersionID *version, char *szVersion);
int  pi01IsEqualVersion(tpi01_VersionID *p1, tpi01_VersionID *p2);
char *pi01UnpackVersion(char *szVersion, char *szCompactVersion);

/*==================================================================*
 *  EXTERNAL VARIABLES                                              *
 *==================================================================*/

#ifdef __cplusplus
}                                    /* End of extern "C" { */
#endif  /* __cplusplus */
#endif /* __VPI01_LIBPCRL__ */
