/*!
 * \file    OMS_VarObj.hpp
 * \author  IvanS, MarkusSi, PeterG
 * \brief   Classes to handle variable sized persistent objects
 */
/*

    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/


#ifndef __OMS_VAROBJ_HPP
#define __OMS_VAROBJ_HPP

#include "Oms/OMS_Oid.hpp"
//#include "Oms/OMS_VarOid.hpp"
#include "ggg00.h"

enum OMS_VarObjLockType {
  VarObjNoLock,
  VarObjShareLock,
  VarObjExclusiveLock
};

//#define VAR_OBJ_CHUNK_SIZE (MAX_RECLEN_GG00 - cgg_rec_key_offset - sizeof(OmsObjectId) - sizeof(tgg00_ObjFileNo) - 4 - sizeof (OmsVarOid) - sizeof (tsp00_Uint4))
#define VAR_OBJ_CHUNK_SIZE (MAX_RECLEN_GG00 - cgg_rec_key_offset - sizeof(OmsObjectId) - sizeof(tgg00_ObjFileNo) - 4 - sizeof (OmsObjectId) - sizeof (tsp00_Uint4))

class OMS_VarObjContainer 
{
public:
  unsigned char vobjInfo[VAR_OBJ_CHUNK_SIZE];
  tsp00_Uint4 m_vobjSize;
  //OmsVarOid   m_vobjNext;
  OmsObjectId m_vobjNext;
};

class OMS_VarObjChunk 
{
public:
  tgg91_PageRef            m_seq;
  OmsObjectId              m_oid;
  tsp00_Uint4              m_containerHandle;
  OMS_VarObjContainer m_container;
  void Clear() {
    m_oid.setNil();
  }
};

#endif // __OMS_VAROBJ_HPP
