/*!
 * \file    OMS_Exceptions.cpp
 * \author  MarkusS, PeterG
 * \brief   Exceptions
 */

/*
    ========== licence begin  GPL
    Copyright (c) 2003-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end
*/


#include "Oms/OMS_Exceptions.hpp"
#include "ggg00.h"
#include "ggg01.h" // OMS errors

/*----------------------------------------------------------------------*/
/* Implementation of class OmsDuplicateKey                              */
/*----------------------------------------------------------------------*/

OmsDuplicateKey::OmsDuplicateKey(long e, const OmsObjectId& oid, const char* pFileName, unsigned int line) : 
  DbpError(DbpError::DB_ERROR, e, "Duplicate Key", oid, pFileName, line) 
{
}

OmsDuplicateKey::OmsDuplicateKey(long e, const OmsObjectId& oid, const char* msg, const char* pFileName, unsigned int line) : 
  DbpError(DbpError::DB_ERROR, e, msg, oid, pFileName, line) 
{
}


/*----------------------------------------------------------------------*/
/* Implementation of OmsLockTimeout                                     */
/*----------------------------------------------------------------------*/

OmsLockTimeout::OmsLockTimeout(const OmsObjectId& oid, const char* pFileName, unsigned int line) :
  DbpError(DbpError::DB_ERROR, -51, "Lock Request Timeout", oid, pFileName, line)
{
}

OmsLockTimeout::OmsLockTimeout(const OmsObjectId& oid, const char* msg, const char* pFileName, unsigned int line) :
  DbpError(DbpError::DB_ERROR, -51, msg, oid, pFileName, line)
{
}

/*----------------------------------------------------------------------*/
/* Implementation of OmsOutOfDate                                       */
/*----------------------------------------------------------------------*/

OmsOutOfDate::OmsOutOfDate(const OmsObjectId& oid, const char* pFileName, unsigned int line) :
  DbpError(DbpError::DB_ERROR, e_object_dirty, "Object out of date", oid, pFileName, line) 
{
}

OmsOutOfDate::OmsOutOfDate(const char* pFileName, unsigned int line) :
  DbpError(DbpError::DB_ERROR, e_object_dirty, "Object out of date", pFileName, line) 
{
}

OmsOutOfDate::OmsOutOfDate(const OmsObjectId& oid, const char* msg, const char* pFileName, unsigned int line) :
  DbpError(DbpError::DB_ERROR, e_object_dirty, msg, oid, pFileName, line) 
{
}


/*----------------------------------------------------------------------*/
/* Implementation of class OmsObjectNotFound                            */
/*----------------------------------------------------------------------*/

OmsObjectNotFound::OmsObjectNotFound(long e, const OmsObjectId& oid, const char* pFileName, unsigned int line) : 
  DbpError(DbpError::DB_ERROR, e, "Object not found", oid, pFileName, line) 
{
}

OmsObjectNotFound::OmsObjectNotFound(long e, const OmsObjectId& oid, const char* msg, const char* pFileName, unsigned int line) : 
  DbpError(DbpError::DB_ERROR, e, msg, oid, pFileName, line) 
{
}


/*----------------------------------------------------------------------*/
/* Implementation of class OmsKeyInUse                                  */
/*----------------------------------------------------------------------*/

OmsKeyInUse::OmsKeyInUse(long e, const OmsObjectId& oid, const char* pFileName, unsigned int line) :
  OmsLockTimeout(oid, pFileName, line),
  OmsDuplicateKey(e, oid, pFileName, line),
  DbpError(DbpError::DB_ERROR, e, "Key already in use", oid, pFileName, line) 
{
}

OmsKeyInUse::OmsKeyInUse(long e, const OmsObjectId& oid, const char* msg, const char* pFileName, unsigned int line) :
  OmsLockTimeout(oid, pFileName, line),
  OmsDuplicateKey(e, oid, pFileName, line),
  DbpError(DbpError::DB_ERROR, e, msg, oid, pFileName, line) 
{
}
