// Copyright 2017 PDFium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// Original code copyright 2014 Foxit Software Inc. http://www.foxitsoftware.com

#include "xfa/fxfa/parser/cxfa_float.h"

#include "fxjs/xfa/cjx_float.h"
#include "third_party/base/ptr_util.h"

namespace {

const CXFA_Node::AttributeData kFloatAttributeData[] = {
    {XFA_Attribute::Id, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Name, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Use, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Usehref, XFA_AttributeType::CData, nullptr},
    {XFA_Attribute::Unknown, XFA_AttributeType::Integer, nullptr}};

constexpr wchar_t kFloatName[] = L"float";

}  // namespace

CXFA_Float::CXFA_Float(CXFA_Document* doc, XFA_PacketType packet)
    : CXFA_Node(doc,
                packet,
                (XFA_XDPPACKET_Template | XFA_XDPPACKET_Form),
                XFA_ObjectType::ContentNode,
                XFA_Element::Float,
                nullptr,
                kFloatAttributeData,
                kFloatName,
                pdfium::MakeUnique<CJX_Float>(this)) {}

CXFA_Float::~CXFA_Float() {}
