#include "Python.h"
#include <musicbrainz/mb_c.h>
#include "pymusicbrainz.h"

#define PY_TRM(x) (((py_trm *)x)->trm)
#define PY_SIG(x) (((py_trm *)x)->sig)
#define PY_ASCII_SIG(x) (((py_trm *)x)->ascii_sig)

typedef struct {
  PyObject_HEAD
  trm_t *trm;
  char sig[17];
  char ascii_sig[37];
} py_trm;
    
/* functions used as python interfaces */
static PyObject * py_trm_SetProxy (PyObject *self, PyObject *args);
static PyObject * py_trm_SetPCMDataInfo (PyObject *self, PyObject *args);
static PyObject * py_trm_GenerateSignature (PyObject *self, PyObject *args);
static PyObject * py_trm_FinalizeSignature (PyObject *self, PyObject *args);
static PyObject * py_trm_SetSongLength (PyObject *self, PyObject *args);

static PyObject* py_trm_getattr(PyObject *self, char *name);
static void py_trm_destructor (PyObject *self);

char TRM_Doc[] =
"To be written.\n\
";

PyTypeObject py_trm_type = {
  PyObject_HEAD_INIT(&PyType_Type)
  0,
  "TRM",
  sizeof(py_trm),
  0,

  /* Standard Methods */
  /* destructor */ py_trm_destructor,
  /* printfunc */ 0,
  /* getattrfunc */ py_trm_getattr,
  /* setattrfunc */ 0,
  /* cmpfunc */ 0,
  /* reprfunc */ 0,
  
  /* Type Categories */
  0, /* as number */
  0, /* as sequence */
  0, /* as mapping */
  0, /* hash */
  0, /* binary */
  0, /* repr */
  0, /* getattro */
  0, /* setattro */
  0, /* as buffer */
  0, /* tp_flags */
  TRM_Doc,
};

/* python methods declared by this module */
static PyMethodDef TRM_Methods[] = {
  {"SetProxy",             py_trm_SetProxy, METH_VARARGS},
  {"SetPCMDataInfo",       py_trm_SetPCMDataInfo, METH_VARARGS},
  {"GenerateSignature",    py_trm_GenerateSignature, METH_VARARGS},
  {"FinalizeSignature",    py_trm_FinalizeSignature, METH_VARARGS},
  {"SetSongLength",        py_trm_SetSongLength, METH_VARARGS},
  {NULL,      NULL}        /* Sentinel */
};

PyObject * 
py_trm_new (PyObject *notused, PyObject *args) 
{
  py_trm *self;
  
  self = PyObject_NEW(py_trm, &py_trm_type);
  if (self == NULL)
    return NULL;
  self->trm = trm_New();
  return (PyObject *)self;  
}

static PyObject*
py_trm_getattr(PyObject *self, char *name)
{
  return Py_FindMethod(TRM_Methods, self, name);
}
  
static void
py_trm_destructor (PyObject *self)
{
  if (PY_TRM(self))
    trm_Delete(PY_TRM(self));
      
  PyMem_DEL(self);
}

static PyObject * 
py_trm_SetProxy (PyObject *self, PyObject *args)
{
  char *proxyAddr;
  short proxyPort;
  int retval;

  if (!PyArg_ParseTuple(args, "sh", &proxyAddr, &proxyPort))
    return NULL;
        
  retval = trm_SetProxy (PY_TRM(self), proxyAddr, proxyPort);

  /* TODO: handle retval of 1 with an exception */
  Py_INCREF(Py_None); 
  return Py_None;
}

static PyObject * 
py_trm_SetPCMDataInfo (PyObject *self, PyObject *args)
{
  int samplesPerSecond;
  int numChannels;
  int bitsPerSample;

  if (!PyArg_ParseTuple(args, "iii", &samplesPerSecond, &numChannels, &bitsPerSample))
    return NULL;

  
  trm_SetPCMDataInfo (PY_TRM(self), samplesPerSecond, numChannels, bitsPerSample);

  Py_INCREF(Py_None); 
  return Py_None;
}

static PyObject * 
py_trm_GenerateSignature (PyObject *self, PyObject *args)
{
  char *data;
  int size;
  
  int retval;
  
  if (!PyArg_ParseTuple(args, "s#", &data, &size))
    return NULL;

  Py_BEGIN_ALLOW_THREADS
  retval = trm_GenerateSignature (PY_TRM(self), data, size);
  Py_END_ALLOW_THREADS
  
  return PyInt_FromLong((long)retval);
}

static PyObject * 
py_trm_FinalizeSignature (PyObject *self, PyObject *args)
{
  if (!PyArg_ParseTuple(args, ""))
    return NULL;
        
  Py_BEGIN_ALLOW_THREADS
  trm_FinalizeSignature(PY_TRM(self), PY_SIG(self), NULL);
  Py_END_ALLOW_THREADS
  trm_ConvertSigToASCII(PY_TRM(self), PY_SIG(self), PY_ASCII_SIG(self));
  return PyString_FromString(PY_ASCII_SIG(self));
}

static PyObject * 
py_trm_SetSongLength (PyObject *self, PyObject *args)
{
  long seconds;
  
  if (!PyArg_ParseTuple(args, "l", &seconds))
    return NULL;
        
  trm_SetSongLength(PY_TRM(self), seconds);

  Py_INCREF(Py_None); 
  return Py_None;
}

