/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <goffioul@imec.be>
 *
 *  $Id: kpcopiespage.h,v 1.3 2001/07/13 17:45:00 goffioul Exp $
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 **/

#ifndef KPCOPIESPAGE_H
#define KPCOPIESPAGE_H

#include "kprintdialogpage.h"
#include <kdeprint/kpreloadobject.h>

class QRadioButton;
class QLineEdit;
class QComboBox;
class QCheckBox;
class QSpinBox;
class QLabel;
class KPrinter;

class KPCopiesPage : public KPrintDialogPage, public KPReloadObject
{
	Q_OBJECT
public:
	KPCopiesPage(KPrinter *prt = 0, QWidget *parent = 0, const char *name = 0);
	~KPCopiesPage();

	void setFlags(int f, KPrinter *prt = 0);

	void setOptions(const QMap<QString,QString>& opts);
	void getOptions(QMap<QString,QString>& opts, bool incldef = false);

protected slots:
	void slotRangeEntered();
	void slotCollateClicked();

protected:
	void initialize();
	void reload();

protected:
	QRadioButton	*m_all, *m_current, *m_range;
	QLineEdit	*m_rangeedit;
	QComboBox	*m_pageset;
	QCheckBox	*m_collate, *m_order;
	QSpinBox	*m_copies;
	QLabel		*m_collatepix;

	KPrinter	*m_printer;
};

#endif
