/*****************************************************************

Copyright (c) 1996-2001 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __fittslawframe_h__
#define __fittslawframe_h__

#include <qframe.h>

class FittsLawFrame : public QFrame
{
    Q_OBJECT

public:
    FittsLawFrame( QWidget* parent = 0, const char* name = 0, WFlags f = 0 );
    ~FittsLawFrame() {;}

    enum Position { Nowhere, Top, Bottom, Left, Right, Center };

    void enableX11EventFilter( bool );
    void enableResizeHandle( bool );
    void setResizePosition( Position );

    /**
     * Helper function. The distance between the point formed by
     * @x and @y and its projection onto @rect is returned in @dx and @dy.
     */
    static void projectOntoRect( int x, int y, const QRect& rect, int& dx, int& dy );

signals:
    void resizeRequest( int dx, int dy );

protected:
    bool x11Event( XEvent* );
    Position mousePosition( const QPoint& ) const;
    void setMouseCursor( Position m );

private:
    WId windowAt( int x, int y );
    WId _activeWindow;
    bool _x11EventFilterEnabled;
    bool _resizeHandleEnabled;
    bool mousedown, haveoldline;
    int pos_x, pos_y;
    Position resizePos;
    QPoint old1, old2;
};

inline void FittsLawFrame::enableX11EventFilter( bool enable )
{
    _x11EventFilterEnabled = enable;
}

inline void FittsLawFrame::projectOntoRect(int x, int y, const QRect& rect,
                                           int& dx, int& dy)
{
    dx = QMAX( 0, rect.left() - x ) ;
    dy = QMAX( 0, rect.top()  - y );
    if (dx == 0)
        dx = QMIN( 0, rect.right()  - x );
    if (dy == 0)
        dy = QMIN( 0, rect.bottom() - y );
}

#endif
