<?php

/*
 
 File: contacts.php3
 $Author: rkrusty $
 $Revision: 2.6.2.21 $
 $Date: 2000/11/20 10:44:17 $
 
 IMP: Copyright 1999, 2000 Charles J. Hagenbuch <chuck@horde.org>
 
 You should have received a copy of the GNU Public
 License along with this package; if not, write to the
 Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 Boston, MA 02111-1307, USA.
 
 */


$need_horde_db = 1;
require '../lib/horde.lib';
require './lib/imp.lib';              /* IMPlib is the IMP function library  */
require './config/defaults.php3';     /* Defaults Configuration File */
require './config/lang.php3';
if ($default->use_ldap_search) include './config/ldap.php3';
require './config/html.php3';
$language = select_lang();
require './lib/postconf.php3';
require "./locale/$language/contacts.lang";
require './locale/local/contacts.lang';
/* Setup the this_client object */
$this_client = new WebClient;

error_reporting($default->error_level);  /* set error level from imp.lib   */

/* retrieve authentication information from session */
page_open(array('sess' => 'HordeSession'));
page_close();
if (!isset($imp) || !is_object($imp)) { echo '<script language="JavaScript">window.close()</script>'; exit; }
$imp->unpickle();
$imp->authenticate(OP_READONLY);

/* doctype */
require("$default->include_dir/doctype.inc");


/* Run through the action handlers */
if (isset($actionID)) {
	if (strcspn($actionID, '0123456789')) { $actionID = $actions[$actionID]; }
  
	switch($actionID) {
	case NO_ACTION:
		break;
    
	case ADD_CONTACT:
		if ($imp->mailbox && $index) {
			$h = imap_header($imp->stream, imap_msgno($imp->stream, $index));
			if (isset($h->reply_toaddress)) { $new_address = decode_mime_string($h->reply_toaddress); }
			elseif (isset($h->fromaddress)) { $new_address = decode_mime_string($h->fromaddress); }
			else $new_address = '';
			
			
			if (preg_match('|(.*)<(.*)>|', $new_address, $regs)) {
				$new_fullname = $regs[1];
				$new_fullname = str_replace('"', '', $new_fullname); // remove " characters
				$new_fullname = str_replace("'", '', $new_fullname); // remove ' characters
				$new_address = $regs[2];
				if (preg_match('|(.*)@(.*)|', $new_address, $nregs)) {
					$new_nickname = $nregs[1];
				} else {
					$new_nickname = '';
				}
			} else {
				if (preg_match('|(.*)@(.*)|', $new_address, $nregs)) {
					$new_nickname = $nregs[1];
					$new_fullname = $nregs[1];
				} else {
					$new_nickname = '';
					$new_fullname = '';
				}
			}
			$new_address = chop(htmlspecialchars($new_address));
		}
		break;
    
	case ADD_CONTACT_OBJECT:
		if (isset($object)) {
			$address = @unserialize($object);
			if (is_array($address)) {
				if (isset($address['personal']))
					$new_fullname = htmlSpecialChars(decode_mime_string($address['personal']));
	
				if (isset($address['mailbox']) && isset($address['host']))
					$new_address = $address['mailbox'] . '@' . $address['host'];
	
				if (isset($address['mailbox']))
					$new_nickname = $address['mailbox'];
			}
		}
		break;
    
	case ADD_ADDR:
		if ($new_address && $new_nickname && $new_fullname) {
			// escape/quote special characters as necessary
			$nickname = addslashes($new_nickname);
			$clean_nickname = imap_rfc822_write_address('', '', $nickname);
			$clean_nickname = substr($clean_nickname, 0, strlen($clean_nickname)-4);
		        
			if ($new_fullname[0] == '"' && $new_fullname[strlen($new_fullname) - 1] == '"') {
			    $new_fullname = substr($new_fullname, 1, strlen($new_fullname) - 2);
			}
			$fullname = $new_fullname;
			$clean_fullname = imap_rfc822_write_address('', '', $fullname);
			$clean_fullname = substr($clean_fullname, 0, strlen($clean_fullname)-4);
		        $clean_fullname = str_replace("'", "\\'", $clean_fullname);
		        
			$clean_address = addslashes($new_address);
			
			$errormsg = '';
			if ($clean_address != $new_address)   $errormsg .= $lang->error_address_chars;
			if (!(imp_add_address($clean_address, $clean_nickname, $clean_fullname, $imp->user, $imp->server))) {
				$errormsg .= $lang->error_create_address;
			} else {
				$new_address= '';
				echo '<script language="JavaScript">self.close();</script></body></html>';
			}
		}
		break;
	}
}

$title = $lang->addressbook_title;
$sidebar = false;
require "$default->include_dir/generic-header.inc";

if (!isset($new_address)) { $new_address = ''; }

$addresses = imp_get_addresses($imp->user, $imp->server);
$options = '';
if (isset($addresses) && is_array($addresses)) {
  for ($i = 0; $i < count($addresses); $i++) {
    if (is_array($addresses[$i]) && sizeof($addresses[$i] > 1)) {
      $options .= '    <option value="' . $addresses[$i][0] . '">' . $addresses[$i][1] . ' &lt;' . $addresses[$i][0] . "&gt;\n";
    }
  }
}

require "$default->include_dir/contacts/add-contact-php3.inc";
require "$default->include_dir/generic-footer.inc";
require "$default->include_dir/contacts/javascript.inc";
?>
