#ifdef RCS
static char rcsid[]="$Id: setup.c,v 1.10 1999/09/21 04:20:06 kent Exp $";
#endif

#include <string.h>
#include <stdlib.h>

#include <ctype.h>

#include "hypermail.h"
#include "setup.h"
#include "struct.h"
#include "setup.h"


char *set_language;
char *set_htmlsuffix;
char *set_mbox;
char *set_archives;
char *set_about;
char *set_dir;
char *set_defaultindex;

bool set_overwrite;
bool set_inlinehtml;
bool set_increment;
bool set_readone;
bool set_reverse;
bool set_showprogress;
bool set_showheaders;
bool set_showhtml;
bool set_showbr;
bool set_showhr;
bool set_showreplies;
bool set_show_msg_links;
bool set_usetable;
bool set_indextable;
bool set_iquotes;
bool set_eurodate;
bool set_require_msgids;
bool set_discard_dup_msgids;
bool set_usemeta;
bool set_uselock;

int set_thrdlevels;
int set_dirmode;
int set_filemode;

int set_locktime;

char *set_mailcommand;
char *set_mailto;
char *set_hmail;
char *set_domainaddr;
char *set_htmlbody;

char *set_label;

char *set_dateformat;

struct hmlist *set_text_types;
struct hmlist *set_inline_types;
struct hmlist *set_prefered_types;
struct hmlist *set_ignore_types;
struct hmlist *set_show_headers;

char *set_ihtmlheader;
char *set_ihtmlfooter;
char *set_mhtmlheader;
char *set_mhtmlfooter;
char *set_attachmentlink;

struct Config cfg[] =
{
  {"language",      &set_language,   LANGUAGE,   CFG_STRING,
   "# A two-letter string specifying the language to use!\n"
   "# For example 'en' for English\n"},

  {"htmlsuffix",    &set_htmlsuffix,  HTMLSUFFIX, CFG_STRING,
   "# Use this to specify the html file suffix to be used\n"
   "# when Hypermail generates the html files. This is depen-\n"
   "# dent on local needs. Do not put a '.' in the value. It\n"
   "# would result in \"file..html\", probably not what you want.\n"},

  {"mbox",          &set_mbox,    MBOX, CFG_STRING,
   "# This is the mailbox to read messages in from. Set this with \n"
   "# a value of NONE to read from standard input.\n"},

  {"archives",      &set_archives, NULL, CFG_STRING,
   "# This will create a link in the archived index pages\n"
   "# labeled 'Other mail archives' to the specified URL. Set\n"
   "# this to NONE to omit such a link.\n"},

  {"about",         &set_about,    NULL, CFG_STRING,
   "# This will create a link in the archived index pages\n"
   "# labeled 'About this archive' to the specified URL. Set\n"
   "# this to NONE to omit such a link.\n"},

  {"label",         &set_label,    NULL, CFG_STRING,
   "# Define this as the label to put in archives.\n"},

  {"dir",           &set_dir,      NULL, CFG_STRING,
   "# This is the directory that Hypermail will look for when\n"
   "# creating  and updating archives. If defined as NONE the\n"
   "# directory will have the same name as the input mailbox.\n"},

  {"defaultindex",  &set_defaultindex, DEFAULTINDEX, CFG_STRING,
   "# This specifies the default index that  users can view when\n"
   "# entering the archive. Valid types are date, thread, author,\n"
   "# and subject.\n"},

  {"overwrite",     &set_overwrite,    BTRUE,    CFG_SWITCH,
   "# Set this to On to make Hypermail overwrite existing archives.\n"},

  {"inlinehtml",    &set_inlinehtml,   BTRUE,    CFG_SWITCH,
   "# Define to On to make text/html parts to get inlined with the mails.\n"
   "# If set to Off, HTML-parts will be stored as separate files.\n"},

  {"increment",     &set_increment,     BFALSE,    CFG_SWITCH,
   "# Set this to On to append the input to existing archive.\n"},

  {"readone",       &set_readone,       BFALSE,    CFG_SWITCH,
   "# Set this to On to specify there is only one message in the input.\n"},

  {"reverse",       &set_reverse,        INT(REVERSE),    CFG_SWITCH,
   "# Setting this variable to On will reverse-sort the article\n"
   "# entries in the date and thread index files by the\n"
   "# date they were received. That is, the most recent messages\n"
   "# will appear at the top of the index rather than the other\n"
   "# way around.\n"},

  {"progress",      &set_showprogress,   INT(PROGRESS),    CFG_INTEGER,
   "# Set this to 1 or 2 to always show a progress report  as\n"
   "# Hypermail works. With a setting of 1, hypermail\n"
   "# overwrites the progress information relating to attachment\n"
   "# creation. With a setting of 2, attachment creation information\n"
   "# is listed individually with the number of the message the\n"
   "# attachments relate to. This is written to stdout.\n"},

  {"showheaders",   &set_showheaders,   INT(SHOWHEADERS), CFG_SWITCH,
   "# Set this to On to show the article header lines in the archived HTML\n"
   "# files.  These lines typically include the To:, From:, and Subject:\n"
   "# information found in most email messages.\n"},

  {"showhtml",      &set_showhtml,   BTRUE,    CFG_SWITCH,
   "# Set this to On to show the articles in a proportionally-spaced\n"
   "# font rather than a fixed-width (monospace) font.\n"},

  {"showbr",        &set_showbr,   BTRUE,    CFG_SWITCH,
   "# Set this to On to place <br> tags at the end of article lines.\n"
   "# Otherwise, all non-quoted article lines will word wrap. This\n"
   "# only takes effect if hm_showhtml is enabled.\n"},

  {"showhr",        &set_showhr,   BTRUE,    CFG_SWITCH,
   "# Set this to On to place horizontal rules before and after articles.\n"},

  {"showreplies",   &set_showreplies,   BTRUE,    CFG_SWITCH,
   "# Set this to On to show all replies to a message as links\n"
   "# in article files.\n"},

  {"show_msg_links", &set_show_msg_links,   BTRUE,    CFG_SWITCH,
   "# Set this to On to put the individual message links at the top\n"
   "# of the individual message pages. Set this to Off to produce pages\n"
   "# without the Next, Previous, Reply, In-Reply-To, etc. links.\n"},

  {"usetable",      &set_usetable,    BFALSE,   CFG_SWITCH,
   "# Setting this variable to On will tell Hypermail to generate\n"
   "# an index menu at the top and bottom of each page in a table\n"
   "# format. Set to Off if you want the standard Hypermail page look\n"
   "# and feel\n"},

  {"indextable",      &set_indextable,    INT(INDEXTABLE),   CFG_SWITCH,
   "# Setting this variable to On will tell Hypermail to generate\n"
   "# message index Subject/Author/Date listings using a nice table\n"
   "# format. Set to Off if you want the original Hypermail index look.\n"},

  {"iquotes",       &set_iquotes,     BTRUE,    CFG_SWITCH,
   "# Set this to On to italicize quoted lines.\n"},

  {"eurodate",      &set_eurodate,    BFALSE,    CFG_SWITCH,
   "# Set this to On to display article received dates with\n"
   "# days before months instead of months before days.\n"},

  {"discard_dup_msgids",      &set_discard_dup_msgids,    BTRUE,    CFG_SWITCH,
   "# Set this to Off to accept messages with a Message-ID matching\n"
   "# that of a message already  in this archive.\n"
   "# By default such messages are discarded.\n"},

  {"require_msgids",      &set_require_msgids,    BTRUE,    CFG_SWITCH,
   "# Set this to Off to accept messages without a Message-ID header.\n"
   "# By default such messages are discarded.\n"},

  {"usemeta",      &set_usemeta,  BFALSE,    CFG_SWITCH,
   "# Set this to On to store the content type of a MIME attachment in "
   "a metadata file."},
 
  {"uselock",  &set_uselock,  BTRUE,    CFG_SWITCH,
   "# Set this to On to use hypermail's internal locking mechanism."},

  {"thrdlevels",    &set_thrdlevels,  INT(4),    CFG_INTEGER,
   "# This specifies the number of thread levels to outline\n"
   "# in the thread index.\n"},

  {"dirmode",       &set_dirmode,     INT(0755),    CFG_OCTAL,
   "# This is an octal number  representing  the  permissions\n"
   "# that new directories are set to when they are created.\n"},

  {"filemode",      &set_filemode,    INT(0644),    CFG_OCTAL,
   "# This is an octal number representing the file permissions\n"
   "# that new files are set to when they are created.\n"},

  {"mailcommand",   &set_mailcommand, NULL,    CFG_STRING,
   "# This specifies the mail command to use when  converting\n"
   "# email  addresses to links. The variables $TO, $SUBJECT,\n"
   "# and $ID can be used in constructing the command string.\n"},

  {"mailto",        &set_mailto,      NULL,    CFG_STRING,
   "# The address of the contact point that is put in the HTML header\n"
   "# line <LINK REV=made HREF=mailto:MAILTO>. Setting this to NONE\n"
   "# disables <LINK...> header generation.\n"},

  {"hmail",         &set_hmail,       NULL,    CFG_STRING,
   "# Set this to the list's submission address.\n"},

  {"domainaddr",    &set_domainaddr,  NULL,    CFG_STRING,
   "# Set this to the domainname you want added to a mail address\n"
   "# appearing in the RFC822 field which lack a hostname.\n"},

  {"body",          &set_htmlbody,    BODY, CFG_STRING,
   "# This is the <BODY> line to use when generating the HTML pages.\n"},

  {"text_types",   &set_text_types,   NULL,    CFG_LIST,
   "# This is a list of MIME types that you want hypermail to treat\n"
   "# exactly as if they were text/plain.\n"},

  {"inline_types",   &set_inline_types,   NULL,    CFG_LIST,
   "# This is the list of MIME types that you want <img> tags to as\n"
   "# opposed to simply <a href> to from the message.\n"},

  {"prefered_types", &set_prefered_types, NULL,    CFG_LIST,
   "# When mails using multipart/mixed types are scanned, this list of\n"
   "# MIME types defines which part you want presented in the result.\n"},

  {"ignore_types",   &set_ignore_types,   NULL,    CFG_LIST,
   "# This is the list of MIME attachment types that  you  do\n"
   "# not want to do anything with.\n"},

  {"show_headers",   &set_show_headers,   NULL,    CFG_LIST,
   "# This is the list of headers to be displayed if 'showheaders'\n"
   "# is set to On). They can be listed comma or space separated\n"
   "# all on a single line.\n"},

  {"ihtmlheaderfile", &set_ihtmlheader,   NULL,    CFG_STRING,
   "# Define path as the path to a template  file  containing\n"
   "# valid  HTML  formatting  statements  that  you  wish to\n"
   "# included at the top of every index page.\n"},

  {"ihtmlfooterfile", &set_ihtmlfooter,   NULL,    CFG_STRING,
   "# Define path as the path to a template  file  containing\n"
   "# valid  HTML  formatting  statements  that  you  wish to\n"
   "# included at the bottom of every index  page.\n"},

  {"mhtmlheaderfile", &set_mhtmlheader,   NULL,    CFG_STRING,
   "# Define path as the path to a template  file  containing\n"
   "# valid  HTML  formatting statements that you wish to use\n"
   "# at the top of every message page.\n"},

  {"mhtmlfooterfile", &set_mhtmlfooter,   NULL,    CFG_STRING,
   "# Define path as the path to a template  file  containing\n"
   "# valid HTML formatting statements you wish to use at the\n"
   "# bottom of every message page.\n"},

  {"locktime",    &set_locktime,  INT(3600),    CFG_INTEGER,
   "# Specify number of seconds to wait for a lock before we\n"
   "# override it! .\n"},

  {"dateformat", &set_dateformat,   NULL,    CFG_STRING,
   "# Format (see strftime(3)) for displaying dates.\n"},

  {"attachmentlink", &set_attachmentlink,   NULL,    CFG_STRING,
   "# Format of the attachment links.\n"
   "# %p for the full path to the attachment\n"
   "# %f for the file name part only\n"
   "# %d for the directory name only\n"
   "# %n for the message number\n"
   "# %c for the content type string\n"},
};

/* ---------------------------------------------------------------- */

void MakeConfig(bool comments)
{
  int i;
  time_t now = time(NULL);
  if(comments) {
    fprintf(stdout,
            "#################################################################\n"
            "# This is an automatically generated config file done by\n"
            "# Hypermail "VERSION " patchlevel " PATCHLEVEL " - %s",
            ctime(&now));
  }
  for (i=0; i<sizeof(cfg)/sizeof(cfg[0]); i++) {
    if(cfg[i].verbose) {
      if(comments) {
        fputs("\n", stdout);
        fputs(cfg[i].verbose, stdout);
      }
      switch(cfg[i].flags) {
      case CFG_STRING:
	if(cfg[i].changed && *(char **)cfg[i].value)
	  /* they differ, show the actual contents */
	  fprintf(stdout, "%s = %s\n", cfg[i].label, *(char **)cfg[i].value);
	else if(comments)
	  /* show the default value, but commented */
	  fprintf(stdout, "#%s = %s\n", cfg[i].label,
		  cfg[i].def?(char *)cfg[i].def:"");
	break;
      case CFG_LIST:
	if(cfg[i].changed) {
	  print_list(cfg[i].label, *(struct hmlist **)cfg[i].value);
	}
	else if(comments) {
	  /* show the default value, but commented */
	  fprintf(stdout, "#%s = %s\n", cfg[i].label,
		  cfg[i].def?(char *)cfg[i].def:"");
	}
	break;
      case CFG_OCTAL:
	if(cfg[i].changed)
	  /* they differ, show the actual contents */
	  fprintf(stdout, "%s = %lo\n", cfg[i].label, *(long *)(cfg[i].value));
	else if(comments)
	  /* show the default value, but commented */
	  fprintf(stdout, "#%s = %lo\n", cfg[i].label, (long)cfg[i].def);
	break;	
      case CFG_INTEGER:
	if(cfg[i].changed)
	  /* they differ, show the actual contents */
	  fprintf(stdout, "%s = %ld\n", cfg[i].label, *(long *)(cfg[i].value));
	else if(comments)
	  /* show the default value, but commented */
	  fprintf(stdout, "#%s = %ld\n", cfg[i].label, (long)cfg[i].def);
	break;
      case CFG_SWITCH:
	if(cfg[i].changed)
	  /* they differ, show the actual contents */
	  fprintf(stdout, "%s = %s\n",
		  cfg[i].label, *(long *)(cfg[i].value)?"On":"Off");
	else if(comments)
	  fprintf(stdout, "#%s = %s\n",
		  cfg[i].label, cfg[i].def?"On":"Off");
	break;
      default:
	break;
      } /* end of switch() */
    } /* end of if() */
  } /* end of for() */
} /* end of function */

static bool inited = FALSE;

void PreConfig(void)
{
  int i;
  char name[128]="HM_";
  char *labp;
  int ind;
  void *defval;

  for (i=0; i<sizeof(cfg)/sizeof(cfg[0]); i++) {
    cfg[i].changed = FALSE;

    /* build environment variable to read from */
    for(ind=3, labp = cfg[i].label;
	*labp;
	labp++) {
      name[ind++]=toupper(*labp);
    }
    name[ind]=0;

    /* we try to get a default value from an environment variable */
    defval = getenv(name);
    if(!defval)
      /* get the built-in default instead */
      defval = cfg[i].def;

    switch(cfg[i].flags) {
    case CFG_STRING:
      if(defval)
	*(char **)cfg[i].value = strsav(defval);
      else
	*(char **)cfg[i].value = NULL;
      break;
    case CFG_SWITCH:
    case CFG_INTEGER:
    case CFG_OCTAL:
      *(int *)cfg[i].value = (int)defval;
      break;
    case CFG_LIST:
      if(defval)
	*(struct hmlist **)cfg[i].value=
	  (void *)add_list((struct hmlist *)cfg[i].value, (char *)defval);
      else
	*(struct hmlist **)cfg[i].value = NULL;
      break;
    default:
      break;
    }
  }
  inited = TRUE;
}

void PostConfig(void)
{
  return; /* nothing currently */
}

int ConfigAddItem(char *line)
{
  char keyword[256];
  char towhat[501];
  char *keywp;
  int i;

  if (2 <= sscanf(line, " %255[a-zA-Z0-9._] %*[=: ] %500[^\n]",
                  keyword, towhat)) {

    if('\"' == towhat[0]) {
      /* we have a quote as the first character, then we assume we have a
	 "string" to parse instead of just string. */
      sscanf(line, " %255[a-zA-Z0-9._] %*[=: ] \"%500[^\"]",
	     keyword, towhat);
    }
    else {
      /* no quotes, we eat all trailing white spaces */
      i=strlen(towhat);
      if(i--) {
	while((i >= 0) && isspace(towhat[i]))
	  towhat[i--]=0;
      }
    }

    if(!strncasecmp(keyword, "hm_", 3))
      /* if there is a hm_ prefix, skip it! */
      keywp = keyword+3;
    else
      keywp = keyword;

    for(i=0; i<sizeof(cfg)/sizeof(cfg[0]); i++) {

      if(!strcasecmp(keywp, cfg[i].label)) {  /* match */

        switch(cfg[i].flags) {
        case CFG_STRING:
          *(char **)cfg[i].value=strsav(towhat);
          break;
        case CFG_SWITCH:
          if(atoi(towhat) ||
             !strcasecmp("ON", towhat) ||
             !strcasecmp("YES", towhat))
            *(int *)cfg[i].value = (int)TRUE;
          else
            *(int *)cfg[i].value = (int)FALSE;
          break;
        case CFG_INTEGER:
	  /* get an integer using any base */
          *(int *)cfg[i].value = strtol(towhat, NULL, 0);
          break;
        case CFG_OCTAL:
	  /* get an octal number */
          *(int *)cfg[i].value = strtol(towhat, NULL, 8);
          break;
        case CFG_LIST:
	  *(struct hmlist **)cfg[i].value=
	    (void *)add_list(*(struct hmlist **)cfg[i].value, towhat);
	  break;
#if 0
	case CFG_FUNCTION:
	  (*(void (*)(char *, char*))cfg[i].value)(cfg[i].def, towhat);
	  break;
#endif
        default:
          break;
        }
	cfg[i].changed = TRUE;
        return 0;
      }
    }
  }
  return 1;
}

int ConfigInit(char *filename)
{
  FILE *f;
  char line[MAXLINE];

  PreConfig();

  if(filename && *filename) {
    f = fopen(filename, "r");
    if (f) {
      while ( fgets(line, MAXLINE, f) )
	if ( (line[0] != '#') &&
	     (line[0] != '\n') )
	  ConfigAddItem(line);
      fclose(f);
    }
    else
      return FALSE;
  }

  PostConfig();

  return TRUE;
}

void ConfigCleanup(void)
{
  int i;
  for (i=0; i<sizeof(cfg)/sizeof(cfg[0]); i++) {
    switch(cfg[i].flags) {
    case CFG_LIST:
      if(cfg[i].value) {
	if(*(struct hmlist **)cfg[i].value)
	  free(*(struct hmlist **)cfg[i].value);
      }
      break;
    case CFG_STRING:
      if(cfg[i].value) {
	if(*(char **)cfg[i].value)
	  free(*(char **)cfg[i].value);
      }
      break;
    default:
      break;
    }
  }
}
