/* 
 *	HT Editor
 *	htne.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "htapp.h"
#include "htne.h"
#include "htneent.h"
#include "htnehead.h"
#include "htnenms.h"
#include "htneobj.h"
#include "htnewexe.h"
#include "nestruct.h"

format_viewer_if *htne_ifs[] = {
	&htneheader_if,
	&htnesegments_if,
	&htnenames_if,
	&htneentrypoints_if,
	0
};

ht_view *htne_init(bounds *b, ht_streamfile *file, ht_format_group *format_group)
{
	byte nemagic[2];
	FILEOFS h=get_newexe_header_ofs(file);
	file->seek(h);
	file->read(nemagic, 2);
	if ((nemagic[0]!=NE_MAGIC0) || (nemagic[1]!=NE_MAGIC1))
		return 0;

	ht_ne *g=new ht_ne();
	g->init(b, file, htne_ifs, format_group, h);
	return g;
}

format_viewer_if htne_if = {
	htne_init,
	0
};

void ht_ne::init(bounds *b, ht_streamfile *file, format_viewer_if **ifs, ht_format_group *format_group, FILEOFS h)
{
	ht_format_group::init(b, VO_BROWSABLE | VO_SELECTABLE | VO_RESIZE, DESC_NE, file, false, true, 0, format_group);
	VIEW_DEBUG_NAME("ht_ne");

	LOG("%s: NE: found header at %08x", file->get_filename(), h);

	ht_ne_shared_data *ne_shared = (ht_ne_shared_data*)malloc(sizeof (ht_ne_shared_data));
	shared_data = ne_shared;

	ne_shared->hdr_ofs = h;

	file->seek(h);
	file->read(&ne_shared->hdr, sizeof ne_shared->hdr);

	ht_format_group::init_ifs(ifs);
}

void ht_ne::done()
{
	free(shared_data);
	ht_format_group::done();
}

void ht_ne::loc_enum_start()
{
	loc_enum=true;
}

bool ht_ne::loc_enum_next(ht_format_loc *loc)
{
	ht_ne_shared_data *sh=(ht_ne_shared_data*)shared_data;
	if (loc_enum) {
		loc->name="ne";
		loc->start=sh->hdr_ofs;
		loc->length=file->get_size()-loc->start;	/* FIXME: ENOTOK */
		
		loc_enum=false;
		return true;
	}
	return false;
}
