/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "main.h"
#include "utils.h"
#include "widgets.h"
#include "configure.h"
#include "interface.h"
#include "about.h"
#include "diskfree.h"
#include "options.h"
#include "mount.h"
#include "pixmap.h"

gint tree_current_index = 0;

/* Color selection window's */

void
color_window_update (GtkWidget *wdg, ui_colorsel_t *win)
{
	gint i;
	gdouble c[4];
	GdkWindow *window;
	
	window = gtk_widget_get_parent_window(win->pixmap);
	gtk_color_selection_get_color(GTK_COLOR_SELECTION(win->colorsel), c);
	
	for (i = 0 ; i < 3 ; i++)
		win->color[i] = c[i];
	
	widget_pixmap_set_color(win->pixmap, window, PREVIEW_W,
				PREVIEW_H, win->color);
	gtk_widget_destroy(win->window);
	
	return;
}

ui_colorsel_t *
colorsel_window_new (void)
{
	ui_colorsel_t *win;
	
	win = g_malloc(sizeof(ui_colorsel_t));
	
	return win;
}

void
colorsel_window_free (ui_colorsel_t *win)
{
	if (win != NULL)
		g_free(win);
	
	return;
}

gboolean
colorsel_window_destroy (ui_colorsel_t **win)
{
	colorsel_window_free(*win);
	*win = NULL;
	
	return TRUE;
}

void
colorsel_window_create (ui_colorsel_t **wind, gchar *title)
{
	ui_colorsel_t *win = *wind;
	GtkWidget *button;
	
	win->window = gtk_dialog_new();
	gtk_window_resize(GTK_WINDOW(win->window), TRUE, TRUE);
	gtk_window_set_resizable(GTK_WINDOW(win->window), FALSE);
	gtk_window_set_title(GTK_WINDOW(win->window), title);
	g_signal_connect_swapped(G_OBJECT(win->window), "destroy",
				 G_CALLBACK(colorsel_window_destroy),
				 (gpointer)wind);
	
	win->colorsel = gtk_color_selection_new();
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->vbox),
				    GTK_WIDGET(win->colorsel));
	gtk_color_selection_set_color(GTK_COLOR_SELECTION(win->colorsel),
				      win->color);
	gtk_widget_show(GTK_WIDGET(win->colorsel));
	
	button = gtk_button_new_with_label(_("OK"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(color_window_update),
			 (gpointer)win);
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->action_area),
				    button);
	gtk_widget_show(button);
	
	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect_swapped(G_OBJECT(button), "clicked",
				 G_CALLBACK(gtk_widget_destroy),
				 G_OBJECT(win->window));
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->action_area),
				    button); 
	gtk_widget_show(button);
	gtk_widget_grab_default(button);
	
	gtk_widget_show(win->window);
	
	return;
}

void
colorsel_window1_create (GtkWidget *button)
{
	static ui_colorsel_t *win = NULL;
	
	if (win != NULL) {
		gdk_window_raise(win->window->window);
		
		return;
	}
	win = colorsel_window_new();
	
	win->pixmap = g_object_get_data(G_OBJECT(button), "pixmap");
       	win->color = g_object_get_data(G_OBJECT(button), "color");
	colorsel_window_create(&win, _("Choose first color"));
	
	return;
}

void
colorsel_window2_create (GtkWidget *button)
{
	static ui_colorsel_t *win = NULL;
	
	if (win != NULL) {
		gdk_window_raise(win->window->window);
		
		return;
	}
	win = colorsel_window_new();
	
	win->pixmap = g_object_get_data(G_OBJECT(button), "pixmap");
	win->color = g_object_get_data(G_OBJECT(button), "color");
	colorsel_window_create(&win, _("Choose second color"));
	
	return;
}

void
colorsel_windowtext_create (GtkWidget *button)
{
	static ui_colorsel_t *win = NULL;
	
	if (win != NULL) {
		gdk_window_raise(win->window->window);
		
		return;
	}
	win = colorsel_window_new();
	
	win->pixmap = g_object_get_data(G_OBJECT(button), "pixmap");
	win->color = g_object_get_data(G_OBJECT(button), "color");
	colorsel_window_create(&win, _("Choose the text color"));
	
	return;
}


void
options_window_get_entrys (ui_options_t *win)
{
	gint i;
	prefs_t *prefs = win->prefs;
	
	for (i = 0 ; i < 2 ; i++) {
		widget_entry_get_chars(win->mounts_cmd[i],
				       &prefs->mount_cmds[i]);
		widget_entry_get_chars(win->mounts_cmd[i + 2],
				       &prefs->smbmount_cmds[i]);
	}
	
	return;
}

void
options_ok_button_clicked (ui_options_t *win)
{
	gui_color_update = TRUE;
	options_window_get_entrys(win);
	cfg_cpy(options, win->prefs);
	
	gtk_widget_destroy(win->window);
	
	gui_list_columns_disp_update();
	gui_main_window_disp_update();
	gui_main_window_resize();
	gui_statusbar_update_block();
	gui_statusbar_timeout_update(NULL, UPDATE);
	
	return;
}

void
options_apply_button_clicked (ui_options_t *win)
{
	gui_color_update = TRUE;
	options_window_get_entrys(win);
	cfg_cpy(options, win->prefs);
	
	gui_list_columns_disp_update();
	gui_main_window_disp_update();
	gui_main_window_resize();
	gui_statusbar_update_block();
	gui_statusbar_timeout_update(NULL, UPDATE);
	
	return;
}

void
options_save_button_clicked (ui_options_t *win)
{
	options_window_get_entrys(win);
	cfgfil_write(win->prefs);
  
	return;
}

ui_options_t *
options_new (void)
{
	ui_options_t *win;
	
	win = g_malloc(sizeof(ui_options_t));
	
	return win;
}

void
options_free (ui_options_t *win)
{
	if (win != NULL)
		g_free(win);
	
	return;
}

gboolean
ui_options_destroy (ui_options_t **win)
{
	ui_options_t *tmp = *win;
	
	cfg_free(tmp->prefs);
	options_free(tmp);
	*win = NULL;
	
	return TRUE;
}

void
ui_widget_tree_clicked (GtkTreeSelection *selection, GtkNotebook *notebook)
{
	gint index;
	GtkTreeIter iter;
	GtkTreeView *treeview = gtk_tree_selection_get_tree_view(selection);
	GtkTreeModel *model = gtk_tree_view_get_model(treeview);
	
	if (!gtk_tree_selection_get_selected(selection, NULL, &iter))
		return;
	
	gtk_tree_model_get(model, &iter, NUMBER_COLUMN, &index, -1);
	gtk_notebook_set_page(notebook, index);
	tree_current_index = index;
	
	return;
}


GtkWidget *
ui_widget_tree_add_row (GtkTreeView *view, GtkTreeIter *parent,
			GtkTreeIter *child, gchar *name,
			gint index, GtkNotebook *notebook)
{
	GtkTreeStore *store = GTK_TREE_STORE(gtk_tree_view_get_model(view));
	GtkTreeSelection *selection = gtk_tree_view_get_selection(view);
     	GtkWidget *bvbox, *vbox;
	GtkWidget *frame;
	GtkWidget *label;
	
	/* Tree filling */
	gtk_tree_store_append(store, child, parent);
	gtk_tree_store_set(store, child, OPTION_COLUMN, name,
			   NUMBER_COLUMN, index, -1);
	
	/* Notebook filling */
	bvbox = gtk_vbox_new(FALSE, 0);
	gtk_notebook_append_page(notebook, bvbox, NULL);
	gtk_widget_show(bvbox);
	
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_OUT);
	gtk_box_pack_start(GTK_BOX(bvbox), frame, FALSE, TRUE, 0);
	gtk_widget_show(frame);
	
	label = gtk_label_new(name);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_misc_set_padding(GTK_MISC(label), 2, 1);
	gtk_container_add(GTK_CONTAINER(frame), label);
	gtk_widget_show(label);
	
	vbox = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start_defaults(GTK_BOX(bvbox), vbox);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), 3);
	
	if (tree_current_index  == index)
		gtk_tree_selection_select_iter(selection, child);
	
	return vbox;
}

void
ui_options_window_create (void)
{
	gint index;
	
	static ui_options_t *win = NULL;
	prefs_t *prefs = NULL;
	GtkWidget *h_box;
	GtkWidget *button;
	
	GtkTreeIter child, parent;
	GtkTreeModel *treemodel;
	GtkTreeSelection *selection;
	GtkWidget *treeview;
	
	GtkTreeViewColumn *column;
	GtkCellRenderer *render;
	
	GtkWidget *frame;
	GtkWidget *notebook;
	GtkWidget *p_box;
	
	GtkWidget *vbox1;
	GtkWidget *hbox_columns, *vbox_color_levels, *vbox_degrade_colors;
	
	GtkWidget *check_button, *radio_button;
	
	GtkWidget *src;
	
	if (win != NULL) {
		gdk_window_raise(win->window->window);
		
		return;
	}
	
	win = options_new();
	win->prefs = cfg_new();
	cfg_cpy(win->prefs, options);
	prefs = win->prefs;
	
	
	win->window = gtk_dialog_new();
	gtk_window_set_resizable(GTK_WINDOW(win->window), FALSE);
	gtk_window_set_title(GTK_WINDOW(win->window), _("Properties"));
	gtk_widget_realize(GTK_WIDGET(win->window));
	gtk_container_set_border_width(GTK_CONTAINER(win->window), 5);
	g_signal_connect_swapped(G_OBJECT(win->window), "destroy",
				   G_CALLBACK(ui_options_destroy),
				   (gpointer)(&win));
	
	h_box = gtk_hbox_new(FALSE, 6);
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->vbox), h_box);
	gtk_widget_show(h_box);
	
	treemodel = GTK_TREE_MODEL(gtk_tree_store_new(2, G_TYPE_STRING, G_TYPE_INT));
	treeview = gtk_tree_view_new_with_model(treemodel);
	g_object_unref(treemodel);
	
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(treeview), FALSE);
	gtk_box_pack_start_defaults(GTK_BOX(h_box), treeview);
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	gtk_widget_show(treeview);
	
	render = gtk_cell_renderer_text_new();
	column = gtk_tree_view_column_new_with_attributes("", render, "text", 0, NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(treeview), column);
	gtk_tree_view_column_set_resizable(column, FALSE);
	gtk_tree_view_column_set_sizing(column, GTK_TREE_VIEW_COLUMN_GROW_ONLY);
	
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(h_box), frame, TRUE, TRUE, 0);
	gtk_widget_show(frame);
	
	notebook = gtk_notebook_new();
	gtk_notebook_set_show_tabs(GTK_NOTEBOOK(notebook), FALSE);
	gtk_notebook_set_show_border(GTK_NOTEBOOK(notebook), FALSE);
	gtk_container_add(GTK_CONTAINER(frame), notebook);
	gtk_widget_show(notebook);
	g_signal_connect(G_OBJECT(selection), "changed",
			 G_CALLBACK(ui_widget_tree_clicked), G_OBJECT(notebook));
	
	index = 0;
	p_box = ui_widget_tree_add_row(GTK_TREE_VIEW(treeview), NULL, &child,
				       _("Rows"), index, GTK_NOTEBOOK(notebook));
	index++;
	
	frame = widget_frame_add(p_box, _("Filesystems to display"));
	widget_check_add(frame, &prefs->blocks[1],
			 _("Include filesystems contain 0 blocks"));
	widget_check_add(frame, &prefs->blocks[2],
			 _("Include not mounted filesystems"));
	widget_check_add(frame, &prefs->blocks[3],
			 _("Display a filesystem which is the total of all filesystems"));
	
	frame = widget_frame_add(p_box, _("Blocks size"));
	radio_button = widget_radio_add(frame, NULL, AUTOSIZE, &prefs->blocks[0],
					_("Human readable"));
	radio_button = widget_radio_add(frame, radio_button, GIGABYTE, &prefs->blocks[0],
					_("Gigabytes"));
	radio_button = widget_radio_add(frame, radio_button, MEGABYTE, &prefs->blocks[0],
					_("Megabytes"));
	radio_button = widget_radio_add(frame, radio_button, KILOBYTE, &prefs->blocks[0],
					_("Kilobytes"));
	
	frame = widget_frame_add(p_box, _("Update Interval"));
	widget_spin_add_float(frame, &prefs->update_interval,
			      100, 0.100, 0.100, _("Update Interval :"));
	gtk_widget_show(p_box);
	
	
	p_box = ui_widget_tree_add_row(GTK_TREE_VIEW(treeview), NULL, &child,
				      _("Columns"), index, GTK_NOTEBOOK(notebook));
	index++;
	
	hbox_columns = gtk_hbox_new(FALSE, 0);
	
	check_button = widget_check_add(p_box, &prefs->show_columns_all,
					_("Show all columns"));
	g_signal_connect_swapped(G_OBJECT(check_button), "toggled",
				 G_CALLBACK(widget_set_sensitivity_invert),
				 G_OBJECT(hbox_columns));
	
	widget_vhseparator_add(p_box, HORIZONTAL);
	
	gtk_box_pack_start(GTK_BOX(p_box), hbox_columns, FALSE, FALSE, 0);
	gtk_widget_show(hbox_columns);
	
	if (prefs->show_columns_all)
		gtk_widget_set_sensitive(hbox_columns, FALSE);
	
	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_columns), vbox1, FALSE, FALSE, 0);
	gtk_widget_show(vbox1);
	
	widget_check_add(vbox1, &prefs->show_columns[FILESYSTEM_COLUMN],
			 _("Filesystem"));
	widget_check_add(vbox1, &prefs->show_columns[SIZE_COLUMN],
			 _("Size"));
	widget_check_add(vbox1, &prefs->show_columns[USED_SPACE_COLUMN],
			 _("Used space"));
	widget_check_add(vbox1, &prefs->show_columns[FREE_SPACE_COLUMN],
			 _("Free space"));
	widget_check_add(vbox1, &prefs->show_columns[USED_PERCENT_COLUMN],
			 _("Used percent"));
	
	widget_vhseparator_add(hbox_columns, VERTICAL);
	
	vbox1 = gtk_vbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(hbox_columns), vbox1, FALSE, FALSE, 0);
	gtk_widget_show(vbox1);
	
	widget_check_add(vbox1, &prefs->show_columns[FREE_PERCENT_COLUMN],
			 _("Free percent"));
	widget_check_add(vbox1, &prefs->show_columns[FILESYSTEM_TYPE_COLUMN],
			 _("Filesystem type"));
	widget_check_add(vbox1, &prefs->show_columns[MOUNT_OPTIONS_COLUMN],
			 _("Mount option's"));
	widget_check_add(vbox1, &prefs->show_columns[MOUNT_POINT_COLUMN],
			 _("Mount point"));
	widget_check_add(vbox1, &prefs->show_columns[CAPACITY_COLUMN],
			 _("Capacity"));
	gtk_widget_show(p_box);
  
	
	p_box = ui_widget_tree_add_row(GTK_TREE_VIEW(treeview), NULL, &child,
				       _("GUI style"), index, GTK_NOTEBOOK(notebook));
	index++;
	
	frame = widget_frame_add(p_box, _("Main window style"));
	widget_check_add(frame, &prefs->gui_style[0], _("Show menubar"));
	widget_check_add(frame, &prefs->gui_style[1], _("Show toolbar"));
	widget_check_add(frame, &prefs->gui_style[2], _("Show statusbar"));
	widget_check_add(frame, &prefs->gui_style[3], _("Auto resize main window"));
	
	frame = widget_frame_add(p_box, _("Clist Style"));
	widget_check_add(frame, &prefs->clist_style[0], _("Optimal column resize"));
	widget_check_add(frame, &prefs->clist_style[1], _("Allow columns resizing"));
	widget_check_add(frame, &prefs->clist_style[2], _("Show clist titles"));
	widget_check_add(frame, &prefs->clist_style[3], _("Use rules hint"));
	gtk_widget_show(p_box);
	
	
	p_box = ui_widget_tree_add_row(GTK_TREE_VIEW(treeview), NULL, &child,
				       _("Capacity"), index, GTK_NOTEBOOK(notebook));
	index++;
	
	vbox_color_levels = gtk_vbox_new(FALSE, 0);
	vbox_degrade_colors = gtk_vbox_new(FALSE, 0);
	
	widget_check_add(p_box, &prefs->capacity_style[1],
			 _("Show percent in capacity column"));
	check_button = widget_check_add(p_box, &prefs->capacity_style[0],
					_("Display gradients"));
	
	g_signal_connect_swapped(G_OBJECT(check_button), "toggled",
				 G_CALLBACK(widget_set_sensitivity_invert),
				 G_OBJECT(vbox_color_levels));
	g_signal_connect_swapped(G_OBJECT(check_button), "toggled",
				 G_CALLBACK(widget_set_sensitivity_invert),
				 G_OBJECT(vbox_degrade_colors));
	
	widget_vhseparator_add(p_box, HORIZONTAL);
	
	gtk_box_pack_start(GTK_BOX(p_box), vbox_color_levels, FALSE, FALSE, 0);
	gtk_widget_show(vbox_color_levels);
	gtk_box_pack_start(GTK_BOX(p_box), vbox_degrade_colors, FALSE, FALSE, 0);
	gtk_widget_show(vbox_degrade_colors);
	
	if (prefs->capacity_style[0])
		gtk_widget_set_sensitive(vbox_color_levels, FALSE);
	else
		gtk_widget_set_sensitive(vbox_degrade_colors, FALSE);
	
	widget_scale_add(vbox_color_levels, &prefs->color_levels[0],
			 _("Level for the green color"));
	widget_scale_add(vbox_color_levels, &prefs->color_levels[1],
			 _("Level for the red color"));
	
	widget_vhseparator_add(p_box, HORIZONTAL);
	
	button = widget_button_color_add(vbox_degrade_colors, win->window->window,
					 prefs->color1, _("First Color :"));
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(colorsel_window1_create),
			 NULL);
	button = widget_button_color_add(vbox_degrade_colors, win->window->window,
					 prefs->color2, _("Second Color :"));
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(colorsel_window2_create),
			 NULL);
	widget_vhseparator_add(p_box, HORIZONTAL);
	
	button = widget_button_color_add(p_box, win->window->window,
					 prefs->color_text, _("Text Color :"));
	g_signal_connect(G_OBJECT(button), "clicked",
			 G_CALLBACK(colorsel_windowtext_create),
			 NULL);
	
	widget_vhseparator_add(p_box, HORIZONTAL);
	
	button = widget_check_add(p_box, &prefs->capacity_style[2],
				  _("Use scaled capacity"));
	
	vbox_color_levels = widget_spin_add_int(p_box, &prefs->capacity_style[3],
						1000, 6, 1, _("Capacity width :"));
	
	if (prefs->capacity_style[2])
		gtk_widget_set_sensitive(vbox_color_levels, FALSE);
	else
		gtk_widget_set_sensitive(vbox_color_levels, TRUE);
	
	g_signal_connect_swapped(G_OBJECT(button), "toggled",
				 G_CALLBACK(widget_set_sensitivity_invert),
				 G_OBJECT(vbox_color_levels));
	
	gtk_widget_show(p_box);
	
	
	p_box = ui_widget_tree_add_row(GTK_TREE_VIEW(treeview), NULL, &child,
				       _("Mount/umount"), index, GTK_NOTEBOOK(notebook));
	index++;
	
	frame = widget_frame_add(p_box, _("General mount/umount commands"));
	win->mounts_cmd[0] = widget_entry_add_chars(frame,
						    &prefs->mount_cmds[0], 255,
						    _("Mount command :"));
        win->mounts_cmd[1] = widget_entry_add_chars(frame,
						    &prefs->mount_cmds[1], 255,
						    _("Umount command :"));
	
	frame = widget_frame_add(p_box, _("Samba mount/umount commands"));
	win->mounts_cmd[2] = widget_entry_add_chars(frame,
						    &prefs->smbmount_cmds[0], 255,
						    _("Mount command :"));
	win->mounts_cmd[3] = widget_entry_add_chars(frame,
						    &prefs->smbmount_cmds[1], 255,
						    _("Umount command :"));
	gtk_widget_show(p_box);
	
	
	
	p_box = ui_widget_tree_add_row(GTK_TREE_VIEW(treeview), NULL, &parent,
				       _("Information"), index, GTK_NOTEBOOK(notebook));
	index++;
	
	gui_about_gtkdiskfree(win->window, p_box);
	gtk_widget_show(p_box);
	
	
	p_box = ui_widget_tree_add_row(GTK_TREE_VIEW(treeview), &parent, &child,
				       _("Legal"), index, GTK_NOTEBOOK(notebook));
	index++;
	
	src = gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(src), GTK_POLICY_NEVER,
				       GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start_defaults(GTK_BOX(p_box), src);
	gtk_widget_show(src);
	
	gui_legal_gtkdiskfree(src);
	gtk_widget_show(p_box);
	
	
	button = gtk_button_new_with_label(_("OK"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect_swapped(G_OBJECT(button), "clicked",
				 G_CALLBACK(options_ok_button_clicked),
				 (gpointer)win);
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->action_area),
				    button);
	gtk_widget_show(button);
	
	button = gtk_button_new_with_label(_("Apply"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect_swapped(G_OBJECT(button), "clicked",
				  G_CALLBACK(options_apply_button_clicked),
				  (gpointer)win);
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->action_area),
				    button); 	
	gtk_widget_show(button);
	
	button = gtk_button_new_with_label(_("Save"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect_swapped(G_OBJECT(button), "clicked",
				 G_CALLBACK(options_save_button_clicked),
				 (gpointer)win);
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->action_area),
				    button);
	gtk_widget_show(button);
	
	button = gtk_button_new_with_label(_("Cancel"));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	g_signal_connect_swapped(G_OBJECT(button), "clicked",
				 G_CALLBACK(gtk_widget_destroy),
				 G_OBJECT(win->window));
	gtk_box_pack_start_defaults(GTK_BOX(GTK_DIALOG(win->window)->action_area),
				    button);
	gtk_widget_show(button);
	gtk_widget_grab_default(button);
	
	
	gtk_notebook_set_page(GTK_NOTEBOOK(notebook), tree_current_index);
	gtk_widget_show(win->window);
	
	return;
}
