/*Written with Emacs.*/
/*
  GtkDiskFree shows free space on your mounted partitions.  Copyright
  (C) 2001-2002 Dj-Death (Landwerlin Lionel)
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful, but
  WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
  USA */

#include "main.h"
#include "widgets.h"
#include "about.h"

#include "icons/atr_logo.xpm"

void
gui_about_window (void)
{  
	gchar *texte_onglet;
	
	static GtkWidget *window = NULL;
	GtkWidget *notebook, *label_onglet;
	GtkWidget *about_notebook_vbox;
	GtkWidget *cadre, *box;
	
	
	GtkWidget *bouton;
	
	if (window != NULL) {
		gdk_window_raise(window->window);
		
		return;
	}
	
	window = gtk_dialog_new();
	gtk_window_set_policy(GTK_WINDOW(window), 0, 0, 0);
	gtk_window_set_title(GTK_WINDOW(window), _("About"));
	gtk_container_set_border_width(GTK_CONTAINER(window), 5);
	g_signal_connect(GTK_OBJECT(window), "destroy",
			 GTK_SIGNAL_FUNC(gtk_widget_destroyed),
			 (gpointer)(&window));
	gtk_widget_realize(window);
	
	notebook = gtk_notebook_new();
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->vbox),
			   notebook, TRUE, TRUE, 0);
	
	about_notebook_vbox = gtk_vbox_new(TRUE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(about_notebook_vbox), 10);
	
	texte_onglet = g_strdup_printf(_("Information"));
	label_onglet = gtk_label_new(texte_onglet);
	g_free(texte_onglet);
	
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), about_notebook_vbox, label_onglet);
	
	gui_about_gtkdiskfree(window, about_notebook_vbox);
	/**/
	
	about_notebook_vbox = gtk_vbox_new(TRUE, 0);
	gtk_container_set_border_width(GTK_CONTAINER(about_notebook_vbox), 5);
	
	texte_onglet = g_strdup_printf(_("Help"));
	label_onglet = gtk_label_new(texte_onglet);
	g_free(texte_onglet);
	
	gtk_notebook_append_page(GTK_NOTEBOOK(notebook), about_notebook_vbox, label_onglet);
	
	cadre = gtk_frame_new(_("Legal"));
	gtk_box_pack_start(GTK_BOX(about_notebook_vbox), cadre, TRUE, TRUE, 0);
	
	box = gtk_vbox_new(TRUE, 0);
	gtk_container_add(GTK_CONTAINER(cadre), box);
	
	gui_legal_gtkdiskfree(box);
	
	/*-------------------------------------------------*/
	
	bouton = gtk_button_new_with_label(_("OK"));
	g_signal_connect_swapped(G_OBJECT(bouton), "clicked",
				 G_CALLBACK(gtk_widget_destroy),
				 G_OBJECT(window));
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(window)->action_area),
			   bouton, TRUE, TRUE, 0);
	GTK_WIDGET_SET_FLAGS(bouton, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(bouton);
	
	gtk_widget_show_all(window);
	
	return;
}

void
gui_legal_gtkdiskfree (GtkWidget *box)
{
	gchar *text = {
		_("  GtkDiskFree is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by Free Software Foundation; either version2 of the License, or (at your options) any later version.\n\n  GtkDiskFree is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.\n\n  You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc., 56 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n\n  For many more details or help, visit http://gtkdiskfree.tuxfamily.org\n")
	};
	GtkWidget *label;
	
	label = gtk_label_new(text);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
	if (GTK_IS_SCROLLED_WINDOW(box))
		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(box), label);
	else
		gtk_box_pack_start(GTK_BOX(box), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	
	return;
}

void
gui_about_gtkdiskfree (GtkWidget *window, GtkWidget *box)
{
	gchar *info = {_("\nGtkDiskFree\nGTK+ implementation of the GNU df shell command. \n Version")};
	gchar *authors = {_("\nDj-Death (Lionel Landwerlin).\n")};
	gchar *translators = {_("French : Dj-Death (Lionel Landwerlin)\n"
				"Polish : Zbigniew M. Kempczyn'ski\n"
				"Russian : Vyacheslav Dikonov\n")};
	gchar *version;
	
	GtkWidget *frame;
	GtkWidget *cadre, *label;
	GtkWidget *logo_hbox;
	GtkWidget *pixmap;
	
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(box), frame, FALSE, FALSE, 0);
	gtk_widget_show(frame);
	
	logo_hbox = gtk_hbox_new(TRUE, 0);
	gtk_container_add(GTK_CONTAINER(frame), logo_hbox);
	gtk_widget_show(logo_hbox);
	
	/**/
	pixmap = widget_pixmap_create_from_data(window->window,
						atr_logo_xpm);
	gtk_box_pack_start(GTK_BOX(logo_hbox),
			   pixmap, FALSE, FALSE, 0);
	gtk_widget_show(pixmap);
	
	/**/
	cadre = gtk_frame_new(_("GtkDiskFree"));
	gtk_box_pack_start(GTK_BOX(box), cadre, FALSE, FALSE, 0); 
	gtk_widget_show(cadre);
	
	version = g_strdup_printf("%s %s .\n", info, VERSION);
	label = gtk_label_new(version);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
	gtk_container_add(GTK_CONTAINER(cadre), label);
	g_free(version);
	gtk_widget_show(label);
	
	cadre = gtk_frame_new(_("Author"));
	gtk_box_pack_start(GTK_BOX(box), cadre, FALSE, FALSE, 0);
	gtk_widget_show(cadre);
	
	label = gtk_label_new(authors);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
	gtk_container_add(GTK_CONTAINER(cadre), label);
	gtk_widget_show(label);
	
	cadre = gtk_frame_new(_("Translators"));
	gtk_box_pack_start(GTK_BOX(box), cadre, FALSE, FALSE, 0);
	gtk_widget_show(cadre);
	
	label = gtk_label_new(translators);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_CENTER);
	gtk_container_add(GTK_CONTAINER(cadre), label);
	gtk_widget_show(label);
	
	return;
}
