/* GSAMBAD, an easy to use GTK+ frontend for the SAMBA file and print server.
 * Copyright (C) 2006 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307, USA.
 *
*/



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_buttons.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_checkbuttons.h"
#include "create_user_settings.h"
#include "populate_shell_combo.h"
#include "add_change_user.h"
#include "delete_user.h"
#include "functions.h"




void create_user_settings(struct w *widgets)
{
    GtkTooltips *tooltips;
//    gchar *utf8 = NULL;

    GtkWidget *hbuttonbox;
    GtkWidget *delete_user_button;
    GtkWidget *add_user_button;
    GtkWidget *apply_user_button;
    GtkWidget *acclock_label;

    int a = 0;
    int b = 1;
    int ent  = 0;
    int comb = 0;
    int check = 0;

    tooltips = gtk_tooltips_new();

    /* Account locked checkbutton and label */
    widgets->user_set_checkbutton[check] = gtk_check_button_new();
    acclock_label = gtk_label_new(_("Account locked:"));

    /* The delete and apply user settings buttons */
    delete_user_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    add_user_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    apply_user_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);

    hbuttonbox = gtk_hbutton_box_new();

    gtk_box_pack_start(GTK_BOX(hbuttonbox), acclock_label, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbuttonbox), widgets->user_set_checkbutton[check], TRUE, TRUE, 0);
    check++;

    gtk_box_pack_start(GTK_BOX(hbuttonbox), delete_user_button, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbuttonbox), add_user_button, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbuttonbox), apply_user_button, TRUE, TRUE, 0);

    gtk_table_attach(GTK_TABLE(widgets->usr_set_table), hbuttonbox, 0, 3, a, b, 0, 0, 5, 5);
    a++; b++;


    g_signal_connect_swapped(G_OBJECT(delete_user_button), "clicked",
			     G_CALLBACK(delete_user), widgets);

    /* These 2 are the same... */
    g_signal_connect_swapped(G_OBJECT(apply_user_button), "clicked",
			     G_CALLBACK(add_change_user), widgets);

    g_signal_connect_swapped(G_OBJECT(add_user_button), "clicked",
			     G_CALLBACK(add_change_user), widgets);
			     


//    gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox), GTK_BUTTONBOX_SPREAD);




    /* Username */	     /* Max length and input 350 chars */
    GtkWidget *username_button;
    widgets->user_set_entry[ent] = gtk_entry_new();
    username_button = make_button_with_entry(GTK_TABLE(widgets->usr_set_table),
                        		     widgets->user_set_entry[ent],
                    			     "gtk-refresh",
					     "Username:",  // fixme, utf8
					     "Crate a randomized username",  // fixme, utf8
					     0,1,a,b,350);
    a++; b++; ent++;

    g_signal_connect_swapped(G_OBJECT(username_button), "clicked",
			     G_CALLBACK(randomize_username), widgets);

    /* Password  */
    GtkWidget *password_button;
    widgets->user_set_entry[ent] = gtk_entry_new();
    password_button = make_button_with_entry(GTK_TABLE(widgets->usr_set_table),
                        		     widgets->user_set_entry[ent],
                    			     "gtk-refresh",
					     "Password:",  // fixme, utf8
					     "Create a randomized password",  // fixme, utf8
					     0,1,a,b,350);
    a++; b++; ent++;

    g_signal_connect_swapped(G_OBJECT(password_button), "clicked",
			     G_CALLBACK(randomize_password), widgets);


    /* Group */
    widgets->user_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->usr_set_table), _(" Group: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->user_set_entry[ent], "The group the user belongs to", NULL);
    a++; b++; ent++;


    /* Comment */
    widgets->user_set_entry[ent] = make_entry_with_label(GTK_TABLE(widgets->usr_set_table), _(" Comment: "), 0,1,a,b,350);
    gtk_tooltips_set_tip(tooltips, widgets->user_set_entry[ent], "A comment about the user", NULL);
    a++; b++; ent++;


    /* Home directory */
    GtkWidget *homedir_button;
    widgets->user_set_entry[ent] = gtk_entry_new();
    homedir_button = make_button_with_entry(GTK_TABLE(widgets->usr_set_table),
                        		     widgets->user_set_entry[ent],
                    			     "gtk-refresh",
					     "Home directory:",  // fixme, utf8
					     "Choose a home directory for this user",  // fixme, utf8
					     0,1,a,b,350);
    a++; b++; ent++;
    
    
    widgets->user_set_combo[comb] = make_label_textcombo_label(GTK_TABLE(widgets->usr_set_table), _(" Shell: "), 0,1,a,b, 80);
    populate_shell_combo(widgets->user_set_combo[comb]);
    a++; b++; comb++;



    gtk_widget_show_all(widgets->main_window);
}
