/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 8; tab-width: 8 -*- */
/* chaninfo-dialog.cpp
 *
 * Copyright (C) 2005 Takuo KITAME.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of version 2 of the GNU General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * Author: Takuo KITAME.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "gnome-peercast.h"
#include "utils.h"
#include "broadcast-dialog.h"
#include "setting-dialog.h"
#include "callbacks.h"


gboolean
gp_quit_app (GtkWidget * widget, gpointer data)
{
	GnomePeercastApp *app = (GnomePeercastApp *)peercastApp;

	if (app->hasTrayIcon()) {
		gtk_widget_hide (widget);
	} else {
		gtk_main_quit ();
	}
	return TRUE;
}

void
menu_new_cb (GtkMenuItem *i, gpointer data)
{
	GnomePeercastApp *app = (GnomePeercastApp *)peercastApp;
	BroadcastDialog * bd;
	
	bd = new BroadcastDialog (GTK_WINDOW (app->getWidget ("main_app")));
}

void
menu_yp_cb (GtkMenuItem *i, gpointer data)
{
	GError *e = NULL;
	Host lh (ClientSocket::getIP (NULL),0);
	gchar ipStr[64];
	lh.IPtoStr (ipStr);
	gchar *url;

	url = g_strdup_printf ("http://%s/?host=%s:%d", servMgr->rootHost.cstr(), ipStr, servMgr->serverHost.port);
	LOG_DEBUG("open URL: %s", url);

	gnome_url_show (url, &e);
	g_free (url);
}

void
menu_web_cb (GtkMenuItem *i, gpointer data)
{
	GError *e = NULL;
	Host lh (ClientSocket::getIP (NULL),0);
	gchar ipStr[64];
	lh.IPtoStr (ipStr);
	gchar *url;

	url = g_strdup_printf ("http://%s:%d", ipStr, servMgr->serverHost.port);
	LOG_DEBUG("open URL: %s", url);

	gnome_url_show (url, &e);
	g_free (url);
}

void
menu_quit_cb (GtkMenuItem *i, gpointer data)
{
	gtk_main_quit ();
}

void
menu_pref_cb (GtkToolButton *tb, gpointer data)
{
	GnomePeercastApp *app = (GnomePeercastApp *)peercastApp;
	SettingDialog *sd;

	sd = new SettingDialog (GTK_WINDOW (app->getWidget ("main_app")));
}

void
menu_about_cb (GtkMenuItem *i, gpointer data)
{
	GnomePeercastApp *app = (GnomePeercastApp *)peercastApp;
	GdkPixbuf *p = NULL;
	gchar *filename = NULL;
	gchar copyright[1024];
	const gchar *authors[] = {
		/* Authors Name. He is japanese, so this ID is only for ja.po */
		N_("Takuo KITAME"),
		N_("PeerCast.ORG"),
		NULL };
	const gchar *documentors[] = { NULL };
	/* TRANSLATORS: Replace this string with your names, one name per line. */
	const gchar *translator_credits = _("translator_credits");


	g_snprintf (copyright, sizeof (copyright),
		    "Copyright \xc2\xa9 2005 %s", "Takuo KITAME");
	filename = g_build_filename (PIXMAPS_DIR, "small-logo.png", NULL);
	if (filename != NULL) {
		p = gdk_pixbuf_new_from_file (filename, NULL);
		g_free (filename);
	}

        gtk_show_about_dialog (GTK_WINDOW (app->getWidget ("main_app")),
                               "name", "GNOME PeerCast",
                               "logo", p,
                               "authors", authors,
                               "documenters", documentors,
                               "version", VERSION,
                               "copyright", copyright,
                               "comments", _("Graphical user interface for PeerCast"),
                               "translator-credits", strcmp (translator_credits, "translator_credits") != 0 ? translator_credits : NULL,
                               NULL);

	if (p != NULL) g_object_unref (p);
}

void
log_clear_cb (GtkWidget *w, gpointer data)
{
	LogView *log = (LogView *)data;
	log->clearLog ();
}
void
log_scroll_toggled (GtkWidget *w, gpointer data)
{
	LogView *log = (LogView *)data;

	if (gtk_toggle_tool_button_get_active (GTK_TOGGLE_TOOL_BUTTON(w)))
		log->scrollToEnd();
}

void
con_stop_cb (GtkToolButton *tb, gpointer data)
{
	ConnectionList *con = (ConnectionList *)data;

	con->stopSelected ();
}

void
con_selection_changed_cb (GtkTreeSelection *sel, gpointer data)
{
	GtkWidget *w = GTK_WIDGET (data);
	if (gtk_tree_selection_count_selected_rows (sel) > 0)
		gtk_widget_set_sensitive (w, TRUE);
	else
		gtk_widget_set_sensitive (w, FALSE);
}

void
chan_selection_changed_cb (GtkTreeSelection *sel, gpointer data)
{
	GnomePeercastApp *gapp = (GnomePeercastApp *)data;
	GtkWidget *toolbar;
	GnomeAppBar *bar = gapp->appbar;

	Channel *ch;
	gchar ti[1024];

	toolbar = gapp->getWidget ("main_toolbar");
	gnome_appbar_pop (bar);

	ch = gapp->cl->selectedChannel();

	if (!ch) {
		gtk_widget_set_sensitive (toolbar, FALSE);
		return;
	}

	gtk_widget_set_sensitive (gapp->getWidget ("cl_url"), ! ch->info.url.isEmpty ());

	gtk_widget_set_sensitive (toolbar, TRUE);
	if (! ch->info.track.artist.isEmpty () &&
	    ! ch->info.track.title.isEmpty ())
		g_snprintf (ti, sizeof(ti), _("Playing: %s - %s"),
			    ch->info.track.artist.cstr(),
			    ch->info.track.title.cstr());
	else if (! ch->info.track.artist.isEmpty ())
		g_snprintf (ti, sizeof(ti), _("Playing: %s "),
			    ch->info.track.artist.cstr());
	else if (! ch->info.track.title.isEmpty ())
		g_snprintf (ti, sizeof(ti), _("Playing: %s "),
			    ch->info.track.title.cstr());
	else
		g_snprintf (ti, sizeof(ti), _("Channel: %s "),
			    ch->info.name.cstr());
	gnome_appbar_push (bar, ti);
}

void
chan_play_stream_url_cb (GtkWidget *w, ChannelList *cl)
{
	cl->playSelected (FALSE);
}

void
chan_copy_peercast_url_cb (GtkWidget *w, ChannelList *cl)
{
	GtkClipboard *cb = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	gchar *tmp;
	Channel *ch = cl->selectedChannel();

	tmp = gen_peercast_url (ch->info);
	gtk_clipboard_set_text (cb, tmp, -1);
	g_free (tmp);
}

void
chan_copy_local_url_cb (GtkWidget *w, ChannelList *cl)
{
	GtkClipboard *cb = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	gchar *tmp;
	Channel *ch = cl->selectedChannel();

	tmp = gen_local_url (ch->info, FALSE);
	gtk_clipboard_set_text (cb, tmp, -1);
	g_free (tmp);
}

void
chan_copy_global_url_cb (GtkWidget *w, ChannelList *cl)
{
	GtkClipboard *cb = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	gchar *tmp;
	Channel *ch = cl->selectedChannel();

	tmp = gen_global_url (ch->info, FALSE);
	gtk_clipboard_set_text (cb, tmp, -1);
	g_free (tmp);
}

void
chan_copy_channel_id_cb (GtkWidget *w, ChannelList *cl)
{
	GtkClipboard *cb = gtk_clipboard_get (GDK_SELECTION_PRIMARY);
	gchar tmp[64];
	Channel *ch = cl->selectedChannel();

	ch->info.id.toStr(tmp);
	gtk_clipboard_set_text (cb, tmp, -1);
}
