/*
	CVSNT Generic API
    Copyright (C) 2005 Tony Hoyle and March-Hare Software Ltd

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef ODBCCONNECTION__H
#define ODBCCONNECTION__H

#include "../SqlConnection.h"
#include "OdbcRecordset.h"

#include <vector>
#include <map>

class COdbcConnection : public CSqlConnection
{
	friend class COdbcRecordset;
public:
	COdbcConnection();
	virtual ~COdbcConnection();

	virtual bool Create(const char *host, const char *database, const char *username, const char *password);
	virtual bool Open(const char *host, const char *database, const char *username, const char *password);
	virtual bool Close();
	virtual bool IsOpen();
	virtual bool Bind(int variable, CSqlVariant value);
	virtual CSqlRecordsetPtr Execute(const char *string, ...);
	virtual bool Error() const;
	virtual const char *ErrorString();
	virtual unsigned GetInsertIdentity(const char *table_hint);
	virtual bool BeginTrans();
	virtual bool CommitTrans();
	virtual bool RollbackTrans();

protected:
	HENV m_hEnv;
	HDBC m_hDbc;
	SQLRETURN m_lasterror;
	union valStruct
	{
		char c;
		short s;
		long l;
#ifdef _WIN32
		__int64 ll;
#else
		long long ll;
#endif
		const char *cs;
		const wchar_t *ws;
	};

	cvs::string m_lasterrorString;
	cvs::string m_lastrsError;
	std::map<int,CSqlVariant> m_bindVars;
	std::map<int,SQLINTEGER> m_sqli;
	std::map<int,valStruct> m_sqlv;
};

#endif


