/*
** Copyright 2000 Double Precision, Inc.
** See COPYING for distribution information.
**
*/

#include	"config.h"
#include	"unicode.h"
#include	<string.h>
#include	<stdlib.h>

static const char rcsid[]="$Id: utf7imap.c,v 1.2 2000/12/24 03:26:43 mrsam Exp $";

static const char mbase64[]="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+,";

static char mbase64_lookup[256];
static int mbase64_lookup_init=0;

unicode_char *unicode_modutf7touc(const char *s, int *err)
{
	size_t l=strlen(s), i;
	unicode_char *uc=malloc(sizeof(unicode_char)*(l+1));
	/* That's the worst case scenario, that's all. */

	if (!uc)
		return (NULL);

	if (err)
		*err= -1;

	/* First time through - initialize fast lookup table */

	if (!mbase64_lookup_init)
	{
		mbase64_lookup_init=1;

		for (i=0; i<256; i++)
			mbase64_lookup[i]= (char)-1;

		for (i=0; mbase64[i]; i++)
			mbase64_lookup[(int)mbase64[i]]=i;
	}
	i=0;

	for (l=0; s[l]; l++)
	{
		unicode_char uu;
		int bitcount;

		if ( s[l] < 0x20 || s[l] >= 0x7F )
		{
			free(uc);
			if (err) *err=l;
			return (NULL);
		}

		if ( s[l] != '&' )
		{
			uc[i++]= (int)(unsigned char)s[l];
			continue;
		}

		if ( s[++l] == '-' )
		{
			uc[i++]='&';
			continue;
		}

		bitcount=0;
		uu=0;

		for ( ; s[l] != '-'; l++)
		{
			int bits;

			if ((char)(bits=
				   mbase64_lookup[s[l] & 255]) == (char)-1)
			{
				free(uc);
				if (err) *err=l;
				return (0);
			}

			if (bitcount + 6 >= 16)
				/* These six more bits are enough for UCS2 */
			{
				int n=bitcount + 6 - 16;	/* Leftover */

				uu = (uu << (6-n)) | (bits >> n);
				uc[i++] = (uu & 0xFFFF);

				uu = bits;	/* The leftovers */
				bitcount=n;
			}
			else
			{
				uu = (uu << 6) | bits;
				bitcount += 6;
			}
		}
	}
	uc[i]=0;
	return (uc);
}

static size_t uctoutf7_pass(const unicode_char *, char *);

char *unicode_uctomodutf7(const unicode_char *p)
{
	size_t n=uctoutf7_pass(p, NULL);
	char *s=malloc(n);

	if (s)
		uctoutf7_pass(p, s);
	return (s);
}

static size_t uctoutf7_pass(const unicode_char *uc, char *p)
{
	size_t n=0;

	while (*uc)
	{
		unsigned bits, bitcount;

		if (*uc >= 0x20 && *uc < 0x7F)
		{
			/* Straightforward deal for straightforward ASCII */

			if (p)
				*p++ = (char)*uc;
			++n;

			if (*uc++ == '&')
			{
				if (p) *p++ = '-';
				++n;
			}
			continue;
		}

		if (p) *p++ = '&'; /* Begin modified base64 */
		++n;

		bits=bitcount=0;
		while ( *uc && (*uc < 0x20 || *uc >= 0x7F))
		{
			unicode_char uu= *uc++ & 0xFFFF;
			int counter=16;

			if (!uu) uu=0xFFFD;

			/* Process 16 bits */

			while (counter)
			{
				int x;

				if (counter + bitcount < 6)
				{
					/* Add these bits, then we're done */

					bits = (bits << counter) |
						(uu >> (16-counter));
					bitcount += counter;
					break;
				}

				/* Have enough bits to encode */

				x= 6 - bitcount;

				bits = (bits << x) | (uu >> (16-x));
				uu = (uu << x) & 0xFFFF;
				counter -= x;

				if (p)
					*p++ = mbase64[bits];
				++n;
				bits=bitcount=0;
			}
		}

		if (bitcount)	/* Leftovers */
		{
			bits <<= (6-bitcount);
			if (p)
				*p++ = mbase64[bits];
			++n;
		}

		if (p)
			*p++ = '-';
		++n;
		/* End modified base64 */
	}

	if (p)
		*p=0;
	++n;
	return (n);
}
